/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.captcha;

import com.ofpay.rex.captcha.CaptchaControl;
import com.ofpay.rex.captcha.ICaptchaControl;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CaptchaControlHelp {
    protected static final String CCH_KEY = "OFCaptchaControlHelp";
    protected static final int SSO_TIME_OUT = 5;
    private static Logger logger = LoggerFactory.getLogger(CaptchaControlHelp.class);

    public static boolean checkCaptcha(String captchaText, HttpSession session) {
        if (session == null) {
            return false;
        }
        ICaptchaControl ic = CaptchaControlHelp.getInstance(session);
        if (ic.isTimeout()) {
            return false;
        }
        boolean ret = ic.checkCaptcha(captchaText);
        if (ret) {
            session.removeAttribute("OFCaptchaControl");
        }
        return ret;
    }

    public static boolean checkCaptcha(String captchaText, MemcachedClient memCache, Cookie[] cookies) {
        return CaptchaControlHelp.checkCaptcha(captchaText, memCache, CaptchaControlHelp.getCaptchaCookieValue(cookies));
    }

    public static boolean checkCaptcha(String captchaText, MemcachedClient memCache, String captchaCookieValue) {
        if (memCache == null || StringUtils.isEmpty((String)captchaCookieValue)) {
            return false;
        }
        ICaptchaControl ic = CaptchaControlHelp.getInstance(memCache, captchaCookieValue);
        if (ic.isTimeout()) {
            return false;
        }
        boolean ret = ic.checkCaptcha(captchaText);
        if (ret) {
            try {
                memCache.delete(captchaCookieValue);
            }
            catch (TimeoutException e) {
                logger.debug("TimeoutException:", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.debug("InterruptedException:", (Throwable)e);
            }
            catch (MemcachedException e) {
                logger.debug("MemcachedException:", (Throwable)e);
            }
        }
        return ret;
    }

    public static ICaptchaControl getInstance(HttpSession session) {
        if (null == session) {
            return null;
        }
        Object obj = session.getAttribute("OFCaptchaControl");
        ICaptchaControl cc = null;
        if (null == obj || !(obj instanceof ICaptchaControl)) {
            cc = new CaptchaControl();
            logger.debug("new captcha control in session method.");
        } else {
            cc = (ICaptchaControl)obj;
        }
        return cc;
    }

    public static ICaptchaControl getInstance(MemcachedClient memCache, Cookie[] cookies) {
        return CaptchaControlHelp.getInstance(memCache, CaptchaControlHelp.getCaptchaCookieValue(cookies));
    }

    public static ICaptchaControl getInstance(MemcachedClient memCache, String captchaCookieValue) {
        if (null == memCache) {
            return null;
        }
        Object obj = null;
        if (!StringUtils.isEmpty((String)captchaCookieValue)) {
            try {
                obj = memCache.get(captchaCookieValue);
            }
            catch (TimeoutException e) {
                logger.debug("TimeoutException:", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.debug("InterruptedException:", (Throwable)e);
            }
            catch (MemcachedException e) {
                logger.debug("MemcachedException:", (Throwable)e);
            }
        }
        ICaptchaControl cc = null;
        if (null == obj || !(obj instanceof ICaptchaControl)) {
            cc = new CaptchaControl();
            logger.debug("new captcha control in memcache method.");
        } else {
            cc = (ICaptchaControl)obj;
        }
        return cc;
    }

    public static String getCaptchaCookieValue(Cookie[] cookies) {
        Cookie cookie = CaptchaControlHelp.getCookiesByKey(cookies, "OFCaptchaControl");
        String captchaKey = "";
        if (null != cookie) {
            captchaKey = cookie.getValue();
        }
        return captchaKey;
    }

    public static void setSession(HttpSession session, ICaptchaControl cc) {
        if (null == session) {
            return;
        }
        session.setAttribute("OFCaptchaControl", (Object)cc);
    }

    public static String setCookie(HttpServletResponse response, Cookie[] cookies, int expSeconds) {
        Cookie cookie = CaptchaControlHelp.getCookiesByKey(cookies, "OFCaptchaControl");
        String captchaKey = "";
        if (null != cookie) {
            captchaKey = cookie.getValue();
        }
        if (null == cookie || StringUtils.isEmpty((String)captchaKey)) {
            captchaKey = "OFCaptchaControl" + UUID.randomUUID().toString();
            cookie = new Cookie("OFCaptchaControl", captchaKey);
        }
        cookie.setPath("/");
        cookie.setMaxAge(31536000);
        response.addCookie(cookie);
        return captchaKey;
    }

    public static void setMemCache(MemcachedClient memCache, ICaptchaControl cc, String captchaKey) {
        try {
            memCache.set(captchaKey, cc.getExpSeconds(), (Object)cc);
        }
        catch (TimeoutException e) {
            logger.debug("TimeoutException:", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.debug("InterruptedException:", (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.debug("MemcachedException:", (Throwable)e);
        }
    }

    public static String getSSOKey(MemcachedClient memCache, String saltKey) {
        return CaptchaControlHelp.getSSOKey(memCache, saltKey, 5);
    }

    public static String getSSOKey(MemcachedClient memCache, String saltKey, int expTime) {
        if (null == memCache || StringUtils.isEmpty((String)saltKey)) {
            return null;
        }
        if (expTime <= 0) {
            expTime = 5;
        }
        String strRet = CCH_KEY + UUID.randomUUID();
        boolean bException = true;
        try {
            memCache.set(strRet, expTime, (Object)saltKey);
            bException = false;
        }
        catch (TimeoutException e) {
            logger.debug("TimeoutException:", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.debug("InterruptedException:", (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.debug("MemcachedException:", (Throwable)e);
        }
        return bException ? null : strRet;
    }

    public static boolean checkSSOKey(MemcachedClient memCache, String ssoKey, String saltKey) {
        if (null == memCache) {
            return false;
        }
        boolean bResult = false;
        try {
            String value = (String)memCache.get(ssoKey);
            if (!StringUtils.isEmpty((String)value) && value.equals(saltKey)) {
                memCache.delete(ssoKey);
                bResult = true;
            }
        }
        catch (TimeoutException e) {
            logger.debug("TimeoutException:", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.debug("InterruptedException:", (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.debug("MemcachedException:", (Throwable)e);
        }
        return bResult;
    }

    protected static Cookie getCookiesByKey(Cookie[] cookies, String keyName) {
        if (null == cookies) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie c = cookies[i];
            if (!c.getName().equalsIgnoreCase(keyName)) continue;
            return c;
        }
        return null;
    }
}

