/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.ucp.common.Clock;

class ConnectionCreationBroker {
    private static final long MIN_INTERVAL = 1000L;
    private static final long MAX_INTERVAL = 10000L;
    private long recentAttemptTimestamp = 0L;
    private long retryInterval = 0L;
    private final Lock lock = new ReentrantLock();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    ConnectionCreationBroker() {
    }

    void markOperable() {
        this.lock.lock();
        try {
            this.recentAttemptTimestamp = 0L;
            this.retryInterval = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }

    void markInoperable() {
        this.lock.lock();
        try {
            if (0L == this.recentAttemptTimestamp) {
                this.recentAttemptTimestamp = Clock.clock();
                this.retryInterval = 1000L;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long appointNextAttempt() {
        this.lock.lock();
        try {
            if (0L == this.recentAttemptTimestamp) {
                long l = 0L;
                return l;
            }
            long now = Clock.clock();
            long timeToWait = Math.max(0L, this.recentAttemptTimestamp + this.retryInterval - now);
            if (0L == timeToWait) {
                this.recentAttemptTimestamp = now;
                this.retryInterval = Math.min(10000L, 2L * this.retryInterval);
                long l = 0L;
                return l;
            }
            long l = timeToWait;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "recentAttemptTimestamp=" + this.recentAttemptTimestamp + ", retryInterval=" + this.retryInterval;
    }

    static {
        try {
            $$$methodRef$$$4 = ConnectionCreationBroker.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ConnectionCreationBroker.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ConnectionCreationBroker.class.getDeclaredMethod("appointNextAttempt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ConnectionCreationBroker.class.getDeclaredMethod("markInoperable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ConnectionCreationBroker.class.getDeclaredMethod("markOperable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

