/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.sql.SQLUtil;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.ChunkEventHandler;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.ListShardingKeys;
import oracle.ucp.routing.ListSuperShardingKeys;
import oracle.ucp.routing.RangeShardingKeys;
import oracle.ucp.routing.RangeSuperShardingKeys;
import oracle.ucp.routing.RoutingKey;
import oracle.ucp.routing.ShardRoutingCacheBase;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.routing.SuperShardingKeys;
import oracle.ucp.util.MappedLongAdder;
import oracle.ucp.util.Pair;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.routing")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public abstract class ShardRoutingCache
extends ShardRoutingCacheBase
implements DataDependentRoutingCache {
    static final String loggerName = "oracle.ucp.jdbc.routing";
    private static final Logger logger;
    protected final ChunkEventHandler chunkEventHandler = this.prepareChunkEventHandler();
    protected final AtomicReference<ShardingMetadata> shardingMetadata = new AtomicReference<Object>(null);
    private final MappedLongAdder<String> shardConnectionCounter = new MappedLongAdder();
    private final MappedLongAdder<String> shardPendingConnectionCounter = new MappedLongAdder();
    private final Map<String, String> currentActiveShards = new ConcurrentHashMap<String, String>();
    protected static final short DB_VERSION_19c = 19000;
    public static final int ORAERROR_INVALIDATE_INSTANCE = 45582;
    public static final int ORAERROR_INVALIDATE_CHUNK = 45583;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;

    private RoutingKey routingKeysForVersionedChunk(String chunkName) {
        Optional keys = this.keyForChunk(chunkName).stream().findFirst();
        return keys.isPresent() ? (RoutingKey)keys.get() : null;
    }

    protected boolean hasKeyMapped(OracleShardingKey shardingKey, OracleShardingKey superKey) {
        return !this.chunks(superKey, shardingKey).isEmpty();
    }

    private Chunk update(RoutingKey routingKey, String chunkName) {
        if (routingKey == null || chunkName == null || chunkName.equals("")) {
            return null;
        }
        Chunk newChunk = new Chunk(chunkName);
        Chunk cachedChunk = this.get(routingKey);
        if (cachedChunk != null && !cachedChunk.name().equals(chunkName)) {
            ClioSupport.ilogFinest(null, null, null, null, "Replace chunk for key:" + routingKey + " with new Chunk:" + chunkName + " , (old chunk:" + cachedChunk.name() + ")");
            this.replace(routingKey, cachedChunk, newChunk);
            return newChunk;
        }
        if (cachedChunk == null) {
            Chunk chunkToCheck;
            RoutingKey chunkRoutingKey = this.routingKeysForVersionedChunk(chunkName);
            if (this.putIfAbsent(routingKey, newChunk) == null && chunkRoutingKey != null && !routingKey.equals(chunkRoutingKey) && null != (chunkToCheck = this.get(chunkRoutingKey))) {
                int maxVersion = ((Chunk)this.chunks(chunkName).stream().max((o1, o2) -> o1.version() - o2.version()).get()).version();
                chunkToCheck.setVersion(maxVersion + 1);
                ClioSupport.ilogFinest(null, null, null, null, "Chunk keys:" + chunkRoutingKey + " has split,hence updated chunk name to:" + chunkToCheck.name());
            }
        }
        return this.get(routingKey);
    }

    @Override
    public void onConnectionBorrow(Connection connection, ConnectionRetrievalInfo cri) throws SQLException {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey key = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        OracleConnection oConn = (OracleConnection)connection;
        if (oConn != null && jdbcCri.getShardingKey() != null) {
            String chunk = this.getChunkNameForKey(jdbcCri);
            oConn.setChunkInfo(key, superKey, chunk);
        }
    }

    protected void clearCache() {
        super.clear();
    }

    protected boolean isMaxPerShardReached(ServiceMember member) {
        String shardUniqueId = member.dbUniqueId();
        if (shardUniqueId == null || shardUniqueId.equals("")) {
            return false;
        }
        int maxPerShard = this.service().connectionSource().limits().getMaxPerShard();
        return this.shardConnectionCounter.get(shardUniqueId).sum() + this.shardPendingConnectionCounter.get(shardUniqueId).sum() >= (long)maxPerShard;
    }

    @Override
    public void onConnectionRequest(ServiceMember instance) {
        String shardUniqueId = instance.dbUniqueId();
        if (shardUniqueId == null || shardUniqueId.equals("")) {
            return;
        }
        this.shardPendingConnectionCounter.get(shardUniqueId).increment();
    }

    @Override
    public void onConnectionRequestComplete(ServiceMember instance) {
        String shardUniqueId = instance.dbUniqueId();
        if (shardUniqueId == null || shardUniqueId.equals("")) {
            return;
        }
        this.shardPendingConnectionCounter.get(shardUniqueId).decrement();
    }

    @Override
    public ServiceMember getBestInstanceToGrow(ConnectionRetrievalInfo cri) {
        return this.instancesToGrow(cri).stream().sorted((i1, i2) -> i1.activeCount.get() - i2.activeCount.get()).findFirst().orElse(null);
    }

    @Override
    public void onConnectionCreation(Connection connection, ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        try {
            Chunk connChunk;
            String serviceName = this.service().connectionSource().defaultServiceName();
            this.shardingMetadata.getAndUpdate(m -> {
                if (null == m) {
                    try {
                        return this.fetchShardingMetadata(connection, serviceName);
                    }
                    catch (SQLException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                        return m;
                    }
                }
                return m;
            });
            ServiceMember connInstance = this.getConnectionInstance(connection);
            String shardUniqueId = connInstance.dbUniqueId();
            String shardName = ShardRoutingCache.getShardNameFromConnection(connection);
            if (this.isMaxPerShardReached(connInstance)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(389);
            }
            this.shardConnectionCounter.get(shardUniqueId).increment();
            this.currentActiveShards.putIfAbsent(shardUniqueId, shardName);
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            ClioSupport.ilogFinest(null, null, null, null, String.format("Created connection with OracleShardingKey (%s,%s) to instance (%s)", jdbcCri.getShardingKey(), jdbcCri.getSuperShardingKey(), connInstance != null ? connInstance.name() : ""));
            if (!this.allInstances(jdbcCri).contains(connInstance)) {
                this.buildTopologyForInstance(connection, serviceName);
                if (logger.getLevel() == Level.FINEST) {
                    ClioSupport.ilogFinest(null, null, null, null, "connection is created to a new instance, updated routing topology is \n" + this.cacheEntries());
                }
                return;
            }
            if (jdbcCri.getShardingKey() == null) {
                return;
            }
            String connChunkName = ShardRoutingCache.fetchDatabaseChunkName(connection);
            String topoChunkName = this.getChunkNameForKey(jdbcCri);
            if (topoChunkName == null) {
                this.buildTopologyForInstance(connection, serviceName);
                if (logger.getLevel() == Level.FINEST) {
                    ClioSupport.ilogFinest(null, null, null, null, "matching chunk not found for borrow CRI sharding key, updated routing topology is \n" + this.cacheEntries());
                }
                return;
            }
            if (connChunkName == null) {
                return;
            }
            RoutingKey routingKey = this.routingKeysForVersionedChunk(connChunkName);
            Chunk.Metadata metadata = null;
            if (routingKey == null) {
                metadata = this.fetchChunkMetadata(connection, connChunkName, serviceName);
                if (metadata == null) {
                    return;
                }
                routingKey = this.makeRoutingKey(metadata);
            }
            if ((connChunk = this.update(routingKey, connChunkName)) != null && !connChunk.hasInstance(connInstance)) {
                if (metadata == null) {
                    metadata = this.fetchChunkMetadata(connection, connChunkName, serviceName);
                }
                connChunk.addInstanceWithPriority(connInstance, metadata.priority);
                this.addToInstanceRelatedCaches(connChunk, connInstance);
                connChunk.setAffinitizedInstId(metadata.affinitizedInstId);
                connChunk.setId(metadata.chunkId);
                connChunk.setUniqueId(metadata.chunkUniqueId);
                connChunk.addShardInfo(metadata.shardName, metadata.priority);
                this.populateChunkIdToChunkCache();
            }
            if (logger.getLevel() == Level.FINEST) {
                ClioSupport.ilogFinest(null, null, null, null, "routing topology sync-up done on create connection, updated routing topology is \n" + this.cacheEntries());
            }
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
    }

    private static String getShardNameFromConnection(Connection conn) throws SQLException {
        return ((OracleConnection)conn).getServerSessionInfo().getProperty("AUTH_DBNAME", "");
    }

    protected ServiceMember getConnectionInstance(Connection conn) {
        ServiceMember member = null;
        try {
            Properties props = ((OracleConnection)conn).getServerSessionInfo();
            if (this.service() != null) {
                member = this.service().getMember(props.getProperty("INSTANCE_NAME"), props.getProperty("DATABASE_NAME"), props.getProperty("SERVER_HOST"), props.getProperty("SERVICE_NAME"));
            }
            if (member == null) {
                member = new ServiceMember(props, this.service());
            }
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        return member;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fetchDatabaseChunkName(Connection oConn) {
        if (oConn == null) {
            return null;
        }
        String sql = "select sys_context('userenv', 'chunk_id') from dual";
        try (Statement stmt = oConn.createStatement();
             ResultSet rs = stmt.executeQuery("select sys_context('userenv', 'chunk_id') from dual");){
            if (!rs.next()) return null;
            String dbChunk = rs.getString(1);
            String string = dbChunk != null ? dbChunk.toLowerCase() : null;
            return string;
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        return null;
    }

    private String getChunkNameForKey(ConnectionRetrievalInfo cri) {
        List<Chunk> chunks = this.chunks(cri);
        if (chunks == null || chunks.size() == 0) {
            return null;
        }
        return chunks.get(0).absoluteName();
    }

    @Override
    public void onConnectionClosure(Connection connection) {
        String shardUniqueId = this.getConnectionInstance(connection).dbUniqueId();
        this.shardConnectionCounter.get(shardUniqueId).decrement();
    }

    protected void buildTopologyForInstance(Connection connection, String serviceName) {
        try {
            ServiceMember connInstance = this.getConnectionInstance(connection);
            ClioSupport.ilogFinest(null, null, null, null, "Building topo for Instance " + connInstance.name());
            List<Chunk.Metadata> chunkInfoList = this.fetchInstanceChunksMetadata(connection, serviceName);
            for (Chunk.Metadata chunkInfo : chunkInfoList) {
                String chunkName = chunkInfo.chunkName;
                RoutingKey key = this.makeRoutingKey(chunkInfo);
                if (this.update(key, chunkName) == null) continue;
                Chunk connChunk = this.get(key);
                connChunk.addInstanceWithPriority(connInstance, chunkInfo.priority);
                this.addToInstanceRelatedCaches(connChunk, connInstance);
                connChunk.setAffinitizedInstId(chunkInfo.affinitizedInstId);
                connChunk.setId(chunkInfo.chunkId);
                connChunk.setUniqueId(chunkInfo.chunkUniqueId);
                if (chunkInfo.shardName != null) {
                    connChunk.addShardInfo(chunkInfo.shardName, chunkInfo.priority);
                }
                this.populateChunkIdToChunkCache();
            }
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
    }

    protected abstract Service service();

    protected ShardingMetadata shardingMetadata() {
        return this.shardingMetadata.get();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RoutingKey makeRoutingKey(Chunk.Metadata chunkInfo) throws SQLException {
        void var6_9;
        SuperShardingKeys superShardingKeys;
        ShardingMetadata sm = this.shardingMetadata();
        ShardingMetadata.ShardingType ssType = this.shardingMetadata().getSuperShardingType();
        if (ssType != ShardingMetadata.ShardingType.NONE) {
            if (ssType == ShardingMetadata.ShardingType.LIST) {
                superShardingKeys = new ListSuperShardingKeys(OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.superKeyHigh, (ShardingMetadata)sm, (boolean)true, (boolean)true));
            } else {
                if (ssType != ShardingMetadata.ShardingType.RANGE) throw new IllegalStateException("Super Shard Type in database not recognized");
                superShardingKeys = new RangeSuperShardingKeys((OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.superKeyHigh, (ShardingMetadata)sm, (boolean)true, (boolean)true).get(0), (OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.superKeyLow, (ShardingMetadata)sm, (boolean)true, (boolean)false).get(0));
            }
        } else {
            superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
        }
        ShardingMetadata.ShardingType sType = this.shardingMetadata().getShardingType();
        if (sType == ShardingMetadata.ShardingType.LIST) {
            ListShardingKeys listShardingKeys = new ListShardingKeys(OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true));
            return new RoutingKey((ShardingKeys)var6_9, superShardingKeys);
        } else if (sType == ShardingMetadata.ShardingType.RANGE) {
            RangeShardingKeys rangeShardingKeys = new RangeShardingKeys((OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true).get(0), (OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyLow, (ShardingMetadata)sm, (boolean)false, (boolean)false).get(0));
            return new RoutingKey((ShardingKeys)var6_9, superShardingKeys);
        } else {
            if (sType != ShardingMetadata.ShardingType.HASH) throw new IllegalStateException("Shard Type in database not recognized");
            HashRangeShardingKeys hashRangeShardingKeys = new HashRangeShardingKeys((OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true).get(0), (OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyLow, (ShardingMetadata)sm, (boolean)false, (boolean)false).get(0));
        }
        return new RoutingKey((ShardingKeys)var6_9, superShardingKeys);
    }

    @Override
    public void startEventHandler(ONSDriver onsDriver) {
        if (onsDriver != null) {
            this.chunkEventHandler.start(onsDriver);
        }
    }

    private Chunk matchingChunk(String chunkName, ServiceMember instance) {
        Optional chunks = this.chunks(instance, chunkName).stream().findFirst();
        return chunks.isPresent() ? (Chunk)chunks.get() : null;
    }

    ChunkEventHandler prepareChunkEventHandler() {
        return new ChunkEventHandler(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            private static Executable $$$methodRef$$$11;
            private static Logger $$$loggerRef$$$11;
            private static Executable $$$methodRef$$$12;
            private static Logger $$$loggerRef$$$12;
            private static Executable $$$methodRef$$$13;
            private static Logger $$$loggerRef$$$13;
            private static Executable $$$methodRef$$$14;
            private static Logger $$$loggerRef$$$14;

            @Override
            protected void onEvent(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                String eType = event.eventType();
                if (eType.equalsIgnoreCase("routing")) {
                    ShardRoutingCache.this.clearCache();
                    return;
                }
                if (!eType.equalsIgnoreCase("chunk")) {
                    throw new ChunkEventHandler.EventProcessingException("Not chunk event, ignoring it");
                }
                switch (event.status()) {
                    case ADD: {
                        this.doAdd(event);
                        break;
                    }
                    case ADDVALUES: {
                        this.doAddValues(event);
                        break;
                    }
                    case DROP: 
                    case INVALIDATE: {
                        this.doDrop(event);
                        break;
                    }
                    case DROPVALUES: {
                        this.doDropValues(event);
                        break;
                    }
                    case UP: {
                        this.doUp(event);
                        break;
                    }
                    case READONLY: {
                        if (ShardRoutingCache.this.service().connectionSource().isReadOnlyInstanceAllowed()) break;
                        this.doDown(event);
                        break;
                    }
                    case DOWN: {
                        this.doDown(event);
                        break;
                    }
                    case MERGE: {
                        this.doMerge(event);
                        break;
                    }
                    case SPLIT: {
                        this.doSplit(event);
                        break;
                    }
                    default: {
                        throw new ChunkEventHandler.EventProcessingException("unknown event status " + (Object)((Object)event.status()));
                    }
                }
                if (logger.getLevel() == Level.FINEST) {
                    ClioSupport.ilogFinest(null, null, null, null, "routing topology after processing chunk event \n" + ShardRoutingCache.this.cacheEntries());
                }
            }

            private void doAdd(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                ShardingMetadata.ShardingType st = ShardRoutingCache.this.shardingMetadata().getShardingType();
                if (ShardingMetadata.ShardingType.LIST != st && ShardingMetadata.ShardingType.RANGE != st) {
                    throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                }
                String chunkName = event.chunkName();
                Chunk chunk = ShardRoutingCache.this.update(this.decodeUserShardingKeys(event.keys()), chunkName);
                if (Objects.isNull(chunk)) {
                    throw new ChunkEventHandler.EventProcessingException("unable to update a chunk");
                }
                ServiceMember inst = this.probeServiceMember(event);
                if (Objects.isNull(inst)) {
                    inst = ShardRoutingCache.this.service().insertMember(new ServiceMember(event.instanceName(), event.database(), event.host(), ShardRoutingCache.this.service().name(), ShardRoutingCache.this.service()));
                }
                chunk.addInstanceWithPriority(inst, event.priority());
                ShardRoutingCache.this.addToInstanceRelatedCaches(chunk, inst);
            }

            private void doAddValues(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                ShardingMetadata.ShardingType st = ShardRoutingCache.this.shardingMetadata().getShardingType();
                if (ShardingMetadata.ShardingType.LIST != st) {
                    throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                }
                String chunkName = event.chunkName();
                ServiceMember inst = this.resolveServiceMember(event);
                Chunk chunk = this.resolveChunk(chunkName, inst);
                ShardRoutingCache.this.putIfAbsent(this.decodeUserShardingKeys(event.keys()), chunk);
            }

            private void doDrop(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                ShardingMetadata.ShardingType st = ShardRoutingCache.this.shardingMetadata().getShardingType();
                if (ShardingMetadata.ShardingType.LIST != st && ShardingMetadata.ShardingType.RANGE != st) {
                    throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                }
                String chunkName = event.chunkName();
                Chunk chunk = this.resolveChunk(chunkName);
                ServiceMember inst = this.resolveServiceMember(event);
                ShardRoutingCache.this.remove(chunk);
                chunk.removeInstance(inst);
                ShardRoutingCache.this.removeFromInstanceRelatedCaches(chunk, inst);
            }

            private void doDropValues(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                ShardingMetadata.ShardingType st = ShardRoutingCache.this.shardingMetadata().getShardingType();
                if (ShardingMetadata.ShardingType.LIST != st) {
                    throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                }
                String chunkName = event.chunkName();
                RoutingKey key = this.decodeUserShardingKeys(event.keys());
                Set<RoutingKey> routingKeys = ShardRoutingCache.this.keyForChunk(chunkName);
                routingKeys.remove(key);
                Chunk chunk = this.resolveChunk(chunkName);
                ShardRoutingCache.this.remove(chunk);
                for (RoutingKey routingKey : routingKeys) {
                    ShardRoutingCache.this.putIfAbsent(routingKey, chunk);
                }
            }

            private void doUp(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                Chunk chunk = this.resolveChunk(event.chunkName());
                ServiceMember inst = this.resolveServiceMember(event);
                chunk.addInstanceWithPriority(inst, event.priority());
                ShardRoutingCache.this.addToInstanceRelatedCaches(chunk, inst);
            }

            private void doDown(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                ServiceMember inst = this.resolveServiceMember(event);
                Chunk chunk = this.resolveChunk(event.chunkName(), inst);
                chunk.removeInstance(inst);
                ShardRoutingCache.this.removeFromInstanceRelatedCaches(chunk, inst);
            }

            private void doMerge(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                RoutingKey mergedKey;
                String chunkName = event.chunkName();
                RoutingKey key = ShardRoutingCache.this.routingKeysForVersionedChunk(chunkName);
                String toChunkName = event.toChunkName();
                RoutingKey toKey = ShardRoutingCache.this.routingKeysForVersionedChunk(toChunkName);
                ServiceMember inst = this.resolveServiceMember(event);
                Chunk chunk = this.resolveChunk(chunkName, inst);
                Chunk toChunk = this.resolveChunk(toChunkName, inst);
                int priority = chunk.instancePriority(inst);
                switch (ShardRoutingCache.this.shardingMetadata().getShardingType()) {
                    case LIST: {
                        ArrayList<OracleShardingKeyImpl> combinedList = new ArrayList<OracleShardingKeyImpl>();
                        for (Pair<OracleShardingKey, OracleShardingKey> keyPair : key.getShardingKeys().getKeys()) {
                            combinedList.add((OracleShardingKeyImpl)keyPair.get1st());
                        }
                        for (Pair<OracleShardingKey, OracleShardingKey> keyPair : toKey.getShardingKeys().getKeys()) {
                            combinedList.add((OracleShardingKeyImpl)keyPair.get1st());
                        }
                        mergedKey = new RoutingKey(new ListShardingKeys(combinedList), key.superShardingKeys);
                        break;
                    }
                    case RANGE: {
                        OracleShardingKeyImpl keyLow = (OracleShardingKeyImpl)key.getShardingKeys().getKeys().get(0).get1st();
                        OracleShardingKeyImpl keyHigh = (OracleShardingKeyImpl)toKey.getShardingKeys().getKeys().get(0).get2nd();
                        mergedKey = new RoutingKey(new RangeShardingKeys((OracleShardingKey)keyHigh, (OracleShardingKey)keyLow), key.superShardingKeys);
                        break;
                    }
                    case HASH: {
                        throw new ChunkEventHandler.EventProcessingException("wrong sharding type for merge");
                    }
                    default: {
                        throw new ChunkEventHandler.EventProcessingException("unknown sharding type");
                    }
                }
                String newChunkName = event.newChunkName();
                chunk.removeInstance(inst);
                ShardRoutingCache.this.removeFromInstanceRelatedCaches(chunk, inst);
                toChunk.removeInstance(inst);
                ShardRoutingCache.this.removeFromInstanceRelatedCaches(toChunk, inst);
                ShardRoutingCache.this.remove(chunk);
                ShardRoutingCache.this.remove(toChunk);
                Chunk mergedChunk = ShardRoutingCache.this.update(mergedKey, toChunkName);
                if (!Objects.nonNull(mergedChunk)) {
                    throw new ChunkEventHandler.EventProcessingException("unable to update routingKey=" + mergedKey + " for chunk=" + toChunkName);
                }
                mergedChunk.addInstanceWithPriority(inst, priority);
                ShardRoutingCache.this.addToInstanceRelatedCaches(mergedChunk, inst);
                ClioSupport.ilogFinest(null, null, null, null, " Added Routing key: " + mergedKey + " for chunk:" + toChunkName);
            }

            private void doSplit(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                RoutingKey splitKey2;
                RoutingKey splitKey1;
                String chunkName = event.chunkName();
                RoutingKey oldRoutingKey = ShardRoutingCache.this.routingKeysForVersionedChunk(chunkName);
                ServiceMember inst = this.resolveServiceMember(event);
                Chunk chunk = this.resolveChunk(chunkName, inst);
                int priority = chunk.instancePriority(inst);
                String newChunkName = event.newChunkName();
                chunk.removeInstance(inst);
                ShardRoutingCache.this.removeFromInstanceRelatedCaches(chunk, inst);
                String hashSplitBoundary = event.hashSplitBoundary();
                switch (ShardRoutingCache.this.shardingMetadata().getShardingType()) {
                    case RANGE: 
                    case HASH: {
                        if (null != hashSplitBoundary) {
                            long oraHash = Long.parseLong(hashSplitBoundary);
                            OracleShardingKeyImpl oracleShardingKeyImpl = new OracleShardingKeyBuilderImpl().oraHash(oraHash).subkey((Object)hashSplitBoundary, (SQLType)OracleType.NUMBER).build();
                            List<ShardingKeys> splitKeys = ((HashRangeShardingKeys)oldRoutingKey.shardingKeys).split((OracleShardingKey)oracleShardingKeyImpl);
                            if (splitKeys.size() != 2) {
                                throw new ChunkEventHandler.EventProcessingException("Hash boundary could not be used to split the chunk");
                            }
                            splitKey1 = new RoutingKey(splitKeys.get(0), oldRoutingKey.superShardingKeys);
                            splitKey2 = new RoutingKey(splitKeys.get(1), oldRoutingKey.superShardingKeys);
                            break;
                        }
                        RoutingKey splitRoutingKey = this.decodeUserShardingKeys(event.splitvalue());
                        OracleShardingKey splitKey = splitRoutingKey.getShardingKeys().getKeys().get(0).get1st();
                        OracleShardingKeyImpl oracleShardingKeyImpl = (OracleShardingKeyImpl)oldRoutingKey.getShardingKeys().getKeys().get(0).get1st();
                        OracleShardingKeyImpl key2 = (OracleShardingKeyImpl)oldRoutingKey.getShardingKeys().getKeys().get(0).get2nd();
                        splitKey1 = new RoutingKey(new RangeShardingKeys(splitKey, (OracleShardingKey)oracleShardingKeyImpl), oldRoutingKey.superShardingKeys);
                        splitKey2 = new RoutingKey(new RangeShardingKeys((OracleShardingKey)key2, splitKey), oldRoutingKey.superShardingKeys);
                        break;
                    }
                    case LIST: {
                        splitKey2 = this.decodeUserShardingKeys(event.splitvalue());
                        ArrayList<OracleShardingKeyImpl> remainingList = new ArrayList<OracleShardingKeyImpl>();
                        for (Pair pair : oldRoutingKey.getShardingKeys().getKeys()) {
                            OracleShardingKeyImpl k = (OracleShardingKeyImpl)pair.get1st();
                            if (splitKey2.getShardingKeys().contains((OracleShardingKey)k)) continue;
                            remainingList.add(k);
                        }
                        splitKey1 = new RoutingKey(new ListShardingKeys(remainingList), oldRoutingKey.superShardingKeys);
                        break;
                    }
                    default: {
                        throw new ChunkEventHandler.EventProcessingException("unknown sharding type");
                    }
                }
                ShardRoutingCache.this.remove(chunk);
                Chunk splittedChunk1 = ShardRoutingCache.this.update(splitKey1, chunkName);
                if (!Objects.nonNull(splittedChunk1)) {
                    throw new ChunkEventHandler.EventProcessingException("unable to update routingKey=" + splitKey1 + " for chunk=" + chunkName);
                }
                splittedChunk1.addInstanceWithPriority(inst, priority);
                ShardRoutingCache.this.addToInstanceRelatedCaches(splittedChunk1, inst);
                ClioSupport.ilogFinest(null, null, null, null, " Added Routing key: " + splitKey1 + " for chunk:" + chunkName);
                Chunk splittedChunk2 = ShardRoutingCache.this.update(splitKey2, newChunkName);
                if (!Objects.nonNull(splittedChunk2)) {
                    throw new ChunkEventHandler.EventProcessingException("unable to update routingKey=" + splitKey2 + " for chunk=" + newChunkName);
                }
                splittedChunk2.addInstanceWithPriority(inst, priority);
                ShardRoutingCache.this.addToInstanceRelatedCaches(splittedChunk2, inst);
                ClioSupport.ilogFinest(null, null, null, null, " Added Routing key: " + splitKey2 + " for chunk:" + newChunkName);
            }

            private ServiceMember probeServiceMember(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                if (Objects.isNull(event)) {
                    throw new ChunkEventHandler.EventProcessingException("no event to process");
                }
                return ShardRoutingCache.this.service().getMember(event.instanceName(), event.database(), ShardRoutingCache.this.service().name());
            }

            private ServiceMember resolveServiceMember(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                ServiceMember eventInst = this.probeServiceMember(event);
                if (Objects.isNull(eventInst)) {
                    throw new ChunkEventHandler.EventProcessingException("wrong instance in the event");
                }
                return eventInst;
            }

            private Chunk resolveChunk(String chunkName) throws ChunkEventHandler.EventProcessingException {
                return this.resolveChunk(chunkName, null);
            }

            private Chunk resolveChunk(String chunkName, ServiceMember inst) throws ChunkEventHandler.EventProcessingException {
                if (Objects.isNull(chunkName) || chunkName.length() == 0) {
                    throw new ChunkEventHandler.EventProcessingException("no chunk name");
                }
                Chunk chunk = ShardRoutingCache.this.matchingChunk(chunkName, inst);
                if (Objects.isNull(chunk)) {
                    throw new ChunkEventHandler.EventProcessingException("no matching chunk for name=" + chunkName);
                }
                return chunk;
            }

            private RoutingKey decodeUserShardingKeys(String[] sKeys) throws ChunkEventHandler.EventProcessingException {
                ShardingKeys shardingKeys;
                SuperShardingKeys superShardingKeys;
                block12: {
                    ShardingMetadata.ShardingType sType;
                    block14: {
                        ArrayList<byte[]> bKeys;
                        OracleShardingKeyImpl.Decoder decoder;
                        block13: {
                            List keys;
                            superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
                            ShardingMetadata sm = ShardRoutingCache.this.shardingMetadata();
                            sType = sm.getShardingType();
                            decoder = new OracleShardingKeyImpl.Decoder(sm);
                            bKeys = new ArrayList<byte[]>();
                            for (String sKey : sKeys) {
                                bKeys.add(Base64.getDecoder().decode(sKey));
                            }
                            if (ShardingMetadata.ShardingType.LIST != sType) break block13;
                            try {
                                keys = decoder.buildShardKeys(bKeys, false, false);
                            }
                            catch (SQLException e) {
                                ClioSupport.ilogThrowing(null, null, null, null, e);
                                throw new ChunkEventHandler.EventProcessingException(e);
                            }
                            shardingKeys = new ListShardingKeys(keys);
                            break block12;
                        }
                        if (ShardingMetadata.ShardingType.RANGE != sType) break block14;
                        switch (bKeys.size()) {
                            case 1: {
                                List keys;
                                try {
                                    keys = decoder.buildShardKeys(bKeys, false, false);
                                }
                                catch (SQLException e) {
                                    ClioSupport.ilogThrowing(null, null, null, null, e);
                                    throw new ChunkEventHandler.EventProcessingException(e);
                                }
                                shardingKeys = new ListShardingKeys(keys);
                                break block12;
                            }
                            case 2: {
                                try {
                                    List keysLow = decoder.buildShardKeys(Arrays.asList(new byte[][]{(byte[])bKeys.get(0)}), false, false);
                                    List keysHigh = decoder.buildShardKeys(Arrays.asList(new byte[][]{(byte[])bKeys.get(1)}), false, false);
                                    shardingKeys = new RangeShardingKeys((OracleShardingKey)keysHigh.get(0), (OracleShardingKey)keysLow.get(0));
                                    break block12;
                                }
                                catch (SQLException e) {
                                    ClioSupport.ilogThrowing(null, null, null, null, e);
                                    throw new ChunkEventHandler.EventProcessingException(e);
                                }
                            }
                            default: {
                                throw new ChunkEventHandler.EventProcessingException("wrong range keys/splitvalue");
                            }
                        }
                    }
                    if (ShardingMetadata.ShardingType.HASH == sType) {
                        throw new ChunkEventHandler.EventProcessingException("hash range is not allowed for user-defined sharding");
                    }
                    throw new ChunkEventHandler.EventProcessingException("improper shard type");
                }
                return new RoutingKey(shardingKeys, superShardingKeys);
            }

            static {
                try {
                    $$$methodRef$$$14 = 1.class.getDeclaredConstructor(ShardRoutingCache.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$13 = 1.class.getDeclaredMethod("decodeUserShardingKeys", String[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$12 = 1.class.getDeclaredMethod("resolveChunk", String.class, ServiceMember.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$11 = 1.class.getDeclaredMethod("resolveChunk", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$10 = 1.class.getDeclaredMethod("resolveServiceMember", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 1.class.getDeclaredMethod("probeServiceMember", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 1.class.getDeclaredMethod("doSplit", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 1.class.getDeclaredMethod("doMerge", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 1.class.getDeclaredMethod("doDown", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 1.class.getDeclaredMethod("doUp", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 1.class.getDeclaredMethod("doDropValues", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredMethod("doDrop", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("doAddValues", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("doAdd", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("onEvent", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public void onHAEvent(FailoverDriver.Event haEvent) {
        ServiceMember eventInst;
        if ((haEvent.status() == FailoverDriver.Event.Status.DOWN || haEvent.status() == FailoverDriver.Event.Status.NODEDOWN) && (eventInst = this.service().getMember(haEvent.instance(), haEvent.database(), haEvent.host(), haEvent.serviceName())) != null) {
            this.remove(eventInst);
        }
    }

    @Override
    public boolean selected(CoreConnection connection, Set<ServiceMember> instanceSet) {
        if (instanceSet == null || instanceSet.size() <= 0) {
            return false;
        }
        return instanceSet.contains(connection.serviceMember());
    }

    private List<Chunk> chunks(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return new ArrayList<Chunk>();
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey key = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        if (Objects.isNull(key) || Objects.isNull(this.shardingMetadata())) {
            return null;
        }
        return this.chunks(superKey, key);
    }

    @Override
    protected long getShardkeyOraHash(OracleShardingKey key) {
        if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
            return ((OracleShardingKeyImpl)key).shardKeyOraHash(this.shardingMetadata());
        }
        return -1L;
    }

    @Override
    public boolean validateCri(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (jdbcCri.getShardingKey() == null) {
            return true;
        }
        if (this.shardingMetadata.get() == null) {
            return false;
        }
        OracleShardingKey shardKey = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        ShardingMetadata metadata = this.shardingMetadata.get();
        if (!((OracleShardingKeyImpl)shardKey).isValid(metadata)) {
            throw new IllegalArgumentException("Sharding Keys provided do not match the sharded database metadata");
        }
        if (superKey != null && !((OracleShardingKeyImpl)superKey).isValid(metadata)) {
            throw new IllegalArgumentException("Super Sharding Keys provided do not match the sharded database metadata");
        }
        return this.hasKeyMapped(shardKey, superKey);
    }

    @Override
    public Set<ServiceMember> instancesToGrow(ConnectionRetrievalInfo cri) {
        Set<ServiceMember> instances = this.allPriorityInstances(cri);
        if (instances != null && instances.size() >= 0) {
            return instances.stream().filter(e -> !this.isMaxPerShardReached((ServiceMember)e)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasInstanceToGrow(ConnectionRetrievalInfo cri) {
        Set<ServiceMember> instances = this.allPriorityInstances(cri);
        if (instances != null && instances.size() == 0) {
            return true;
        }
        return instances.stream().anyMatch(sm -> !this.isMaxPerShardReached((ServiceMember)sm));
    }

    @Override
    public Set<ServiceMember> allPriorityInstances(ConnectionRetrievalInfo cri) {
        List<Chunk> reqChunks = this.chunks(cri);
        HashSet<ServiceMember> allInstances = new HashSet<ServiceMember>();
        if (reqChunks != null) {
            reqChunks.stream().forEach(c -> {
                Set<ServiceMember> priorityInstances = c.priorityInstances();
                if (priorityInstances != null && priorityInstances.size() > 0) {
                    allInstances.addAll(priorityInstances);
                }
            });
        }
        return allInstances;
    }

    @Override
    public Set<ServiceMember> allInstances(ConnectionRetrievalInfo cri) {
        List<Chunk> reqChunks = this.chunks(cri);
        HashSet<ServiceMember> allInstances = new HashSet<ServiceMember>();
        if (reqChunks != null) {
            reqChunks.stream().forEach(c -> {
                Set<ServiceMember> instanceSet = c.instances();
                if (instanceSet != null && instanceSet.size() > 0) {
                    allInstances.addAll(instanceSet);
                }
            });
        }
        return allInstances;
    }

    @Override
    @DisableTrace
    public String cacheEntries() {
        return this.routingTableToHumanReadableString();
    }

    @Override
    @DisableTrace
    public String metadataInfo() {
        ShardingMetadata sm = this.shardingMetadata();
        return null == sm ? "" : "[superType=" + sm.getSuperShardingType() + ", type=" + sm.getShardingType() + "]";
    }

    @Override
    public void destroy() {
        this.clear();
        this.chunkEventHandler.stop();
    }

    @Override
    public void onError(int oraErrorNumber, ConnectionRetrievalInfo cri, ServiceMember instance) {
        String chunkName = this.getChunkNameForKey(cri);
        Chunk chunk = this.matchingChunk(chunkName, instance);
        if (chunk != null) {
            if (oraErrorNumber == 45582) {
                chunk.removeInstance(instance);
                this.removeFromInstanceRelatedCaches(chunk, instance);
            } else if (oraErrorNumber == 45583) {
                this.remove(chunk);
            }
        }
        if (cri instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            ClioSupport.ilogFinest(null, null, null, null, String.format("Got ORA-%d error for OracleShardingKey = (%s,%s), chunk name = (%s), instance name = (%s)", oraErrorNumber, jdbcCri.getShardingKey(), jdbcCri.getSuperShardingKey(), chunkName, instance != null ? instance.name() : ""));
        }
    }

    private List<Chunk.Metadata> fetchInstanceChunksMetadata(Connection oConn, String serviceName) throws SQLException {
        if (oConn == null) {
            return null;
        }
        ArrayList<Chunk.Metadata> chunkInfoList = new ArrayList<Chunk.Metadata>();
        boolean isMultipleTableFamilySupported = this.multipleTableFamilySupported(oConn);
        String sql = isMultipleTableFamilySupported ? "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?) and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL" : "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS WHERE SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL";
        try (PreparedStatement stmt = oConn.prepareStatement(sql);){
            if (isMultipleTableFamilySupported) {
                stmt.setString(1, serviceName);
            }
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Chunk.Metadata chunkInfo = new Chunk.Metadata();
                    chunkInfo.chunkName = rs.getString("CHUNK_NAME").toLowerCase();
                    Blob shardKeyLowBlob = rs.getBlob("SHARD_KEY_LOW");
                    chunkInfo.shardKeyLow = shardKeyLowBlob != null ? shardKeyLowBlob.getBinaryStream() : null;
                    Blob shardKeyHighBlob = rs.getBlob("SHARD_KEY_HIGH");
                    chunkInfo.shardKeyHigh = shardKeyHighBlob != null ? shardKeyHighBlob.getBinaryStream() : null;
                    Blob superKeyLow = rs.getBlob("GROUP_KEY_LOW");
                    chunkInfo.superKeyLow = superKeyLow != null ? superKeyLow.getBinaryStream() : null;
                    Blob superKeyHigh = rs.getBlob("GROUP_KEY_HIGH");
                    chunkInfo.superKeyHigh = superKeyHigh != null ? superKeyHigh.getBinaryStream() : null;
                    chunkInfo.priority = rs.getInt("PRIORITY");
                    chunkInfo.affinitizedInstId = rs.getInt("INST_ID");
                    chunkInfo.chunkId = rs.getInt("CHUNK_ID");
                    chunkInfo.shardName = rs.getString("SHARD_NAME");
                    chunkInfo.chunkUniqueId = rs.getInt("CHUNK_UNIQUE_ID");
                    chunkInfoList.add(chunkInfo);
                }
            }
        }
        return chunkInfoList;
    }

    private Chunk.Metadata fetchChunkMetadata(Connection oConn, String chunkName, String serviceName) throws SQLException {
        Chunk.Metadata chunkInfo;
        if (oConn == null) {
            return null;
        }
        boolean isMultipleTableFamilySupported = this.multipleTableFamilySupported(oConn);
        String sql = isMultipleTableFamilySupported ? "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS where lower(CHUNK_NAME) like '" + chunkName.toLowerCase() + "' and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)" : "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS where lower(CHUNK_NAME) like '" + chunkName.toLowerCase() + "' and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL";
        try (PreparedStatement stmt = oConn.prepareStatement(sql);){
            if (isMultipleTableFamilySupported) {
                stmt.setString(1, serviceName);
            }
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    chunkInfo = new Chunk.Metadata();
                    chunkInfo.chunkName = rs.getString("CHUNK_NAME").toLowerCase();
                    chunkInfo.shardKeyLow = rs.getBlob("SHARD_KEY_LOW") != null ? rs.getBlob(2).getBinaryStream() : null;
                    InputStream inputStream = chunkInfo.shardKeyHigh = rs.getBlob("SHARD_KEY_HIGH") != null ? rs.getBlob(3).getBinaryStream() : null;
                    if (rs.getBlob(4) != null) {
                        chunkInfo.superKeyLow = rs.getBlob("GROUP_KEY_LOW").getBinaryStream();
                    }
                    if (rs.getBlob(5) != null) {
                        chunkInfo.superKeyHigh = rs.getBlob("GROUP_KEY_HIGH").getBinaryStream();
                    }
                    chunkInfo.priority = rs.getInt("PRIORITY");
                    chunkInfo.affinitizedInstId = rs.getInt("INST_ID");
                    chunkInfo.chunkId = rs.getInt("CHUNK_ID");
                    chunkInfo.shardName = rs.getString("SHARD_NAME");
                    chunkInfo.chunkUniqueId = rs.getInt("CHUNK_UNIQUE_ID");
                } else {
                    chunkInfo = null;
                }
            }
        }
        return chunkInfo;
    }

    protected ShardingMetadata fetchShardingMetadata(Connection oConn, String serviceName) throws SQLException {
        ShardingMetadata shardingMetadata;
        block58: {
            String sqlColTypes;
            String sqlTypes;
            if (oConn == null) {
                return null;
            }
            boolean isMultipleTableFamilySupported = this.multipleTableFamilySupported(oConn);
            if (isMultipleTableFamilySupported) {
                sqlTypes = "select GROUP_TYPE, GROUP_COL_NUM, SHARD_TYPE, SHARD_COL_NUM, DEF_VERSION from LOCAL_CHUNK_TYPES  WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)";
                sqlColTypes = "select SHARD_LEVEL, COL_NAME, COL_IDX_IN_KEY, EFF_TYPE , CHARACTER_SET from LOCAL_CHUNK_COLUMNS  WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)";
            } else {
                sqlTypes = "select GROUP_TYPE, GROUP_COL_NUM, SHARD_TYPE, SHARD_COL_NUM, DEF_VERSION from LOCAL_CHUNK_TYPES ";
                sqlColTypes = "select SHARD_LEVEL, COL_NAME, COL_IDX_IN_KEY, EFF_TYPE , CHARACTER_SET from LOCAL_CHUNK_COLUMNS ";
            }
            try (PreparedStatement stmt = oConn.prepareStatement(sqlTypes);){
                if (isMultipleTableFamilySupported) {
                    stmt.setString(1, serviceName);
                }
                try (ResultSet rsTypes = stmt.executeQuery();){
                    if (rsTypes.next()) {
                        String superTypeStr = rsTypes.getString("GROUP_TYPE");
                        ShardingMetadata.ShardingType superType = ShardingMetadata.ShardingType.valueOf((String)superTypeStr);
                        String shardTypeStr = rsTypes.getString("SHARD_TYPE");
                        ShardingMetadata.ShardingType shardType = ShardingMetadata.ShardingType.valueOf((String)shardTypeStr);
                        int metaVersion = rsTypes.getInt("DEF_VERSION");
                        ArrayList<ShardingMetadata.SubKeyMetadata> colInfos = new ArrayList<ShardingMetadata.SubKeyMetadata>();
                        ArrayList<ShardingMetadata.SubKeyMetadata> colGrpInfos = new ArrayList<ShardingMetadata.SubKeyMetadata>();
                        try (PreparedStatement stmt1 = oConn.prepareStatement(sqlColTypes);){
                            if (isMultipleTableFamilySupported) {
                                stmt1.setString(1, serviceName);
                            }
                            try (ResultSet rsCols = stmt1.executeQuery();){
                                while (rsCols.next()) {
                                    int shardLevel = rsCols.getInt("SHARD_LEVEL");
                                    ShardingMetadata.SubKeyMetadata subKeyMetadata = new ShardingMetadata.SubKeyMetadata(rsCols.getInt("COL_IDX_IN_KEY"), SQLUtil.getExternalType((int)rsCols.getInt("EFF_TYPE")), rsCols.getInt("CHARACTER_SET"));
                                    if (shardLevel == 0) {
                                        colGrpInfos.add(subKeyMetadata);
                                        continue;
                                    }
                                    if (shardLevel == 1) {
                                        colInfos.add(subKeyMetadata);
                                        continue;
                                    }
                                    throw new IllegalStateException("Invalid Shard Key Level in database");
                                }
                            }
                        }
                        shardingMetadata = new ShardingMetadata(metaVersion, shardType, superType, colInfos, colGrpInfos);
                        break block58;
                    }
                    shardingMetadata = null;
                }
            }
        }
        return shardingMetadata;
    }

    protected boolean multipleTableFamilySupported(Connection conn) throws SQLException {
        short dbVersion = ((OracleConnection)conn).getVersionNumber();
        return dbVersion >= 19000;
    }

    public Map<String, Long> getShardConnectionStats() {
        HashMap<String, Long> connectionStatsMap = new HashMap<String, Long>();
        Set<Map.Entry<String, String>> currentActiveShardsSet = this.currentActiveShards.entrySet();
        for (Map.Entry<String, String> shardEntry : currentActiveShardsSet) {
            connectionStatsMap.put(shardEntry.getValue(), this.shardConnectionCounter.get(shardEntry.getKey()).longValue());
        }
        return connectionStatsMap;
    }

    static {
        try {
            $$$methodRef$$$51 = ShardRoutingCache.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$50 = ShardRoutingCache.class.getDeclaredMethod("access$300", ShardRoutingCache.class, String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$49 = ShardRoutingCache.class.getDeclaredMethod("access$200", ShardRoutingCache.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$48 = ShardRoutingCache.class.getDeclaredMethod("access$100", ShardRoutingCache.class, RoutingKey.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$47 = ShardRoutingCache.class.getDeclaredMethod("access$000", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$46 = ShardRoutingCache.class.getDeclaredMethod("lambda$update$0", Chunk.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$45 = ShardRoutingCache.class.getDeclaredMethod("lambda$getBestInstanceToGrow$1", ServiceMember.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$44 = ShardRoutingCache.class.getDeclaredMethod("lambda$onConnectionCreation$2", Connection.class, String.class, ShardingMetadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$43 = ShardRoutingCache.class.getDeclaredMethod("lambda$instancesToGrow$3", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$42 = ShardRoutingCache.class.getDeclaredMethod("lambda$hasInstanceToGrow$4", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$41 = ShardRoutingCache.class.getDeclaredMethod("lambda$allPriorityInstances$5", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$40 = ShardRoutingCache.class.getDeclaredMethod("lambda$allInstances$6", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$39 = ShardRoutingCache.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$38 = ShardRoutingCache.class.getDeclaredMethod("getShardConnectionStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$37 = ShardRoutingCache.class.getDeclaredMethod("multipleTableFamilySupported", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$36 = ShardRoutingCache.class.getDeclaredMethod("fetchShardingMetadata", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = ShardRoutingCache.class.getDeclaredMethod("fetchChunkMetadata", Connection.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = ShardRoutingCache.class.getDeclaredMethod("fetchInstanceChunksMetadata", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = ShardRoutingCache.class.getDeclaredMethod("onError", Integer.TYPE, ConnectionRetrievalInfo.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = ShardRoutingCache.class.getDeclaredMethod("destroy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = ShardRoutingCache.class.getDeclaredMethod("metadataInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = ShardRoutingCache.class.getDeclaredMethod("cacheEntries", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = ShardRoutingCache.class.getDeclaredMethod("allInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = ShardRoutingCache.class.getDeclaredMethod("allPriorityInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = ShardRoutingCache.class.getDeclaredMethod("hasInstanceToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = ShardRoutingCache.class.getDeclaredMethod("instancesToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = ShardRoutingCache.class.getDeclaredMethod("validateCri", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = ShardRoutingCache.class.getDeclaredMethod("getShardkeyOraHash", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = ShardRoutingCache.class.getDeclaredMethod("chunks", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = ShardRoutingCache.class.getDeclaredMethod("selected", CoreConnection.class, Set.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = ShardRoutingCache.class.getDeclaredMethod("onHAEvent", FailoverDriver.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = ShardRoutingCache.class.getDeclaredMethod("prepareChunkEventHandler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = ShardRoutingCache.class.getDeclaredMethod("matchingChunk", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = ShardRoutingCache.class.getDeclaredMethod("startEventHandler", ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = ShardRoutingCache.class.getDeclaredMethod("makeRoutingKey", Chunk.Metadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = ShardRoutingCache.class.getDeclaredMethod("shardingMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = ShardRoutingCache.class.getDeclaredMethod("buildTopologyForInstance", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = ShardRoutingCache.class.getDeclaredMethod("onConnectionClosure", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = ShardRoutingCache.class.getDeclaredMethod("getChunkNameForKey", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = ShardRoutingCache.class.getDeclaredMethod("fetchDatabaseChunkName", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = ShardRoutingCache.class.getDeclaredMethod("getConnectionInstance", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = ShardRoutingCache.class.getDeclaredMethod("getShardNameFromConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = ShardRoutingCache.class.getDeclaredMethod("onConnectionCreation", Connection.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = ShardRoutingCache.class.getDeclaredMethod("getBestInstanceToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = ShardRoutingCache.class.getDeclaredMethod("onConnectionRequestComplete", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = ShardRoutingCache.class.getDeclaredMethod("onConnectionRequest", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ShardRoutingCache.class.getDeclaredMethod("isMaxPerShardReached", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ShardRoutingCache.class.getDeclaredMethod("clearCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ShardRoutingCache.class.getDeclaredMethod("onConnectionBorrow", Connection.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ShardRoutingCache.class.getDeclaredMethod("update", RoutingKey.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ShardRoutingCache.class.getDeclaredMethod("hasKeyMapped", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ShardRoutingCache.class.getDeclaredMethod("routingKeysForVersionedChunk", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        logger = Logger.getLogger(loggerName);
    }
}

