/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.Certificate;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.Entity;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.SPKAC;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.cert.ext.KeyUsageExtension;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.Signature;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509
extends Certificate
implements ASN1Object {
    private ASN1Sequence tbsCert;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private BigInteger serialNo;
    private X500Name issuer;
    private Date notBeforeDate;
    private Date notAfterDate;
    private X509ExtensionSet extensions = null;
    private PrivateKey issuerPrivateKey;
    private CRL issuerCRL;
    private X509 issuerCertificate;
    protected boolean isDecoded = false;
    private ASN1Sequence contents = null;
    private transient MessageDigest md5 = null;

    public X509() {
    }

    public X509(InputStream is) throws IOException {
        this.input(is);
    }

    public X509(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        this.input(is);
        ((InputStream)is).close();
    }

    public X509(URL url) throws IOException {
        InputStream is = url.openStream();
        this.input(is);
        is.close();
    }

    public X509(byte[] data) throws IOException {
        this((InputStream)new UnsyncByteArrayInputStream(data));
    }

    public X509(CertificateRequest cr, X509 issuerCertificate, PrivateKey issuerPrivateKey, BigInteger serial, int days) throws SignatureException {
        this(cr, issuerCertificate, issuerPrivateKey, serial, days, null);
    }

    public X509(CertificateRequest cr, X509 issuerCertificate, PrivateKey issuerPrivateKey, BigInteger serial, int days, AlgorithmIdentifier signAlg) throws SignatureException {
        this();
        this.holder = cr.getSubject();
        this.key = cr.getPublicKey();
        this.setIssuerCertificate(issuerCertificate);
        this.issuer = (X500Name)issuerCertificate.getHolder();
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.setValidity(days);
        if (signAlg != null) {
            this.setSigAlgID(signAlg);
        }
        this.sign();
    }

    public X509(X500Name subject, SPKAC spkac, X509 issuerCertificate, PrivateKey issuerPrivateKey, BigInteger serial, int days) throws SignatureException {
        this();
        this.holder = subject;
        this.key = spkac.getPublicKey();
        this.setIssuerCertificate(issuerCertificate);
        this.issuer = (X500Name)issuerCertificate.getHolder();
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.setValidity(days);
        this.sign();
    }

    public X509(X500Name subject, PublicKey subjectKey, X500Name issuer, PrivateKey issuerPrivateKey, BigInteger serial, int days) throws SignatureException {
        this(subject, subjectKey, issuer, issuerPrivateKey, serial, days, (AlgorithmIdentifier)null);
    }

    public X509(X500Name subject, PublicKey subjectKey, X500Name issuer, PrivateKey issuerPrivateKey, BigInteger serial, int days, AlgorithmIdentifier signAlg) throws SignatureException {
        this();
        this.holder = subject;
        this.key = subjectKey;
        this.issuer = issuer;
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.setValidity(days);
        if (signAlg != null) {
            this.setSigAlgID(signAlg);
        }
        this.sign();
    }

    public X509(X500Name subject, PublicKey subjectKey, X500Name issuer, PrivateKey issuerPrivateKey, BigInteger serial, Date notBefore, Date notAfter) throws SignatureException {
        this(subject, subjectKey, issuer, issuerPrivateKey, serial, notBefore, notAfter, null);
    }

    public X509(X500Name subject, PublicKey subjectKey, X500Name issuer, PrivateKey issuerPrivateKey, BigInteger serial, Date notBefore, Date notAfter, AlgorithmIdentifier signAlg) throws SignatureException {
        this();
        this.holder = subject;
        this.key = subjectKey;
        this.issuer = issuer;
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.notBeforeDate = notBefore;
        this.notAfterDate = notAfter;
        if (signAlg != null) {
            this.setSigAlgID(signAlg);
        }
        this.sign();
    }

    protected void decode() {
        this.isDecoded = true;
    }

    public void sign() throws SignatureException {
        this.sign(RandomBitsSource.getDefault());
    }

    public void sign(RandomBitsSource rbs) throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerPrivateKey == null) {
            throw new SignatureException("Cannot sign certificate, no issuer private key set");
        }
        ASN1Sequence tbs = this.getTBSCert();
        try {
            Signature sig = Signature.getInstance((PrivateKey)this.issuerPrivateKey);
            if (this.sigAlgID == null) {
                throw new SignatureException("Cannot sign certificate, no signature algorithm set");
            }
            sig.setAlgID(this.sigAlgID);
            sig.setRandomBitsSource(rbs);
            sig.setDocument(Utils.toBytes((Streamable)tbs));
            this.sigBytes = sig.sign();
        }
        catch (AlgorithmIdentifierException ex) {
            throw new SignatureException(ex.toString());
        }
        this.reset();
    }

    public byte[] getSigBytes() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.tbsCert = new ASN1Sequence((InputStream)sis);
        this.sigAlgID = new AlgorithmIdentifier((InputStream)sis);
        this.sigBytes = ASN1BitString.inputValue((InputStream)sis);
        sis.terminate();
        ASN1SequenceInputStream tbs = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.tbsCert));
        if (tbs.getCurrentTag() == 0) {
            ASN1ConstructedInputStream ver = new ASN1ConstructedInputStream((InputStream)tbs);
            BigInteger version = ASN1Integer.inputValue((InputStream)ver);
            ver.terminate();
        }
        this.serialNo = ASN1Integer.inputValue((InputStream)tbs);
        AlgorithmIdentifier tbsSigAlgID = new AlgorithmIdentifier((InputStream)tbs);
        if (!tbsSigAlgID.equals((Object)this.sigAlgID)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name issuer2 = new X500Name((InputStream)tbs);
        if (this.issuer == null) {
            this.issuer = issuer2;
        } else if (!this.issuer.equals(issuer2)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + issuer2 + "}");
        }
        ASN1SequenceInputStream val = new ASN1SequenceInputStream((InputStream)tbs);
        this.notBeforeDate = ASN1Date.inputValue((InputStream)val);
        this.notAfterDate = ASN1Date.inputValue((InputStream)val);
        val.terminate();
        this.holder = new X500Name((InputStream)tbs);
        this.key = CryptoUtils.inputSPKI((InputStream)tbs);
        if (tbs.getCurrentTag() == 1) {
            tbs.setCurrentTag(3);
            byte[] issuerID = ASN1BitString.inputValue((InputStream)tbs);
        }
        if (tbs.getCurrentTag() == 2) {
            tbs.setCurrentTag(3);
            byte[] subjectID = ASN1BitString.inputValue((InputStream)tbs);
        }
        if (tbs.getCurrentTag() == 3) {
            ASN1ConstructedInputStream ext = new ASN1ConstructedInputStream((InputStream)tbs);
            this.extensions = new X509ExtensionSet((InputStream)ext);
            ext.terminate();
        } else {
            this.extensions = null;
        }
        tbs.terminate();
        this.reset();
    }

    private ASN1Sequence getTBSCert() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.tbsCert == null) {
            ASN1Sequence s = new ASN1Sequence();
            if (this.extensions != null && this.extensions.size() > 0) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Integer(2L), 0));
            }
            s.addElement((ASN1Object)new ASN1Integer(this.serialNo));
            if (this.sigAlgID == null && this.issuerPrivateKey != null) {
                this.sigAlgID = Signature.getInstance((PrivateKey)this.issuerPrivateKey).getAlgID();
            }
            if (this.sigAlgID == null) {
                throw new SignatureException("Cannot build to-be-signed certificate, no signature algorithm set");
            }
            s.addElement((ASN1Object)this.sigAlgID);
            s.addElement((ASN1Object)this.issuer);
            ASN1Sequence v = new ASN1Sequence();
            Calendar bef = Calendar.getInstance();
            bef.setTime(this.notBeforeDate);
            Calendar aft = Calendar.getInstance();
            aft.setTime(this.notAfterDate);
            v.addElement((ASN1Object)new ASN1Date(this.notBeforeDate, bef.get(1) > 2049));
            v.addElement((ASN1Object)new ASN1Date(this.notAfterDate, aft.get(1) > 2049));
            s.addElement((ASN1Object)v);
            s.addElement((ASN1Object)((X500Name)this.holder));
            s.addElement((ASN1Object)CryptoUtils.subjectPublicKeyInfo((PublicKey)this.key));
            if (this.extensions != null && this.extensions.size() > 0) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.extensions, 3));
            }
            this.tbsCert = s;
        }
        return this.tbsCert;
    }

    private ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)this.getTBSCert());
            seq.addElement((ASN1Object)this.sigAlgID);
            seq.addElement((ASN1Object)new ASN1BitString(this.getSigBytes()));
            this.contents = seq;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    private void resetAll() {
        this.reset();
        this.tbsCert = null;
        this.sigBytes = null;
    }

    public void output(OutputStream os) throws IOException {
        try {
            this.toASN1Sequence().output(os);
        }
        catch (SignatureException ex) {
            throw new OutputGenerationException(ex.toString());
        }
    }

    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes((Streamable)this.toASN1Sequence());
        }
        catch (SignatureException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean verify() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyCertDate()) {
            return false;
        }
        if (this.issuerCertificate != null) {
            if (!this.verifyCertSigner()) {
                return false;
            }
            if (!this.issuer.equals(this.issuerCertificate.getSubject())) {
                return false;
            }
            if (!this.verifyCertSignature()) {
                return false;
            }
        }
        return this.issuerCRL == null || this.verifyCertCRL();
    }

    private boolean verifyCertSigner() {
        BasicConstraintsExtension bc;
        if (!this.isDecoded) {
            this.decode();
        }
        if ((bc = (BasicConstraintsExtension)this.issuerCertificate.getExtension(PKIX.id_ce_basicConstraints)) != null && !bc.getCA()) {
            return false;
        }
        KeyUsageExtension ku = (KeyUsageExtension)this.issuerCertificate.getExtension(PKIX.id_ce_keyUsage);
        return ku == null || !ku.getCritical() || ku.hasUsageFlag(5);
    }

    public boolean verifyCertDate() {
        Date now;
        if (!this.isDecoded) {
            this.decode();
        }
        return !(now = new Date()).before(this.notBeforeDate) && !now.after(this.notAfterDate);
    }

    public boolean verifyCertSignature() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerCertificate == null) {
            throw new IllegalStateException("Issuer certificate not set");
        }
        try {
            Signature sigObj = Signature.getInstance((AlgorithmIdentifier)new AlgorithmIdentifier(this.getSigAlgOID()));
            sigObj.setPublicKey(this.issuerCertificate.getPublicKey());
            sigObj.setDocument(Utils.toBytes((Streamable)this.getTBSCert()));
            sigObj.setSigBytes(this.getSigBytes());
            return sigObj.verify();
        }
        catch (AuthenticationException ex) {
            return false;
        }
        catch (AlgorithmIdentifierException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (StreamableOutputException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (SignatureException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    public boolean verifyCertCRL() {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerCRL == null) {
            throw new IllegalStateException("Issuer CRL not set");
        }
        return !this.issuerCRL.isRevoked(this.serialNo);
    }

    public Entity getHolder() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.holder;
    }

    public void setHolder(X500Name holder) {
        this.holder = holder;
        this.resetAll();
    }

    public PublicKey getPublicKey() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.key;
    }

    public void setPublicKey(PublicKey key) {
        this.key = key;
        this.resetAll();
    }

    public Date getNotBeforeDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.notBeforeDate;
    }

    public void setNotBeforeDate(Date nbd) {
        this.notBeforeDate = nbd;
        this.resetAll();
    }

    public Date getNotAfterDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.notAfterDate;
    }

    public void setNotAfterDate(Date nad) {
        this.notAfterDate = nad;
        this.resetAll();
    }

    public void setValidity(int days) {
        this.notBeforeDate = new Date();
        this.notAfterDate = Utils.daysFrom((Date)this.notBeforeDate, (int)days);
        this.resetAll();
    }

    public X500Name getSubject() {
        if (!this.isDecoded) {
            this.decode();
        }
        return (X500Name)this.holder;
    }

    public void setSubject(X500Name subject) {
        this.holder = subject;
        this.resetAll();
    }

    public X500Name getIssuer() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.issuer;
    }

    public void setIssuer(X500Name issuer) {
        this.issuer = issuer;
        if (this.issuerCRL != null && !issuer.equals(this.issuerCRL.getIssuer())) {
            throw new IllegalStateException("Certificate issuer does not match CRL issuer");
        }
        this.resetAll();
    }

    public void setIssuerCertificate(X509 ic) {
        this.issuerCertificate = ic;
        if (this.issuer == null) {
            this.setIssuer(ic.getSubject());
        }
    }

    public void setIssuerPrivateKey(PrivateKey ik) {
        this.setIssuerPrivateKey(ik, null);
    }

    public void setIssuerPrivateKey(PrivateKey ik, AlgorithmIdentifier sigAlgID) {
        this.issuerPrivateKey = ik;
        this.setSigAlgID(sigAlgID);
    }

    public void setSigAlgID(AlgorithmIdentifier sigAlgID) {
        this.sigAlgID = sigAlgID;
        this.resetAll();
    }

    public void setIssuerCRL(CRL crl) {
        if (!this.isDecoded) {
            this.decode();
        }
        this.issuerCRL = crl;
        if (this.issuer != null && !this.issuer.equals(crl.getIssuer())) {
            throw new IllegalStateException("CRL issuer does not match certificate issuer");
        }
    }

    public BigInteger getSerialNo() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.serialNo;
    }

    public void setSerialNo(BigInteger sn) {
        this.serialNo = sn;
        this.resetAll();
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions != null && this.extensions.hasUnrecognizedCriticalExtension();
    }

    public X509ExtensionSet getExtensionSet() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions;
    }

    public X509Extension getExtension(ASN1ObjectID oid) {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions != null ? this.extensions.getExtension(oid) : null;
    }

    public void setExtensions(X509ExtensionSet exts) {
        this.extensions = exts;
        this.resetAll();
    }

    public void addExtension(X509Extension ext) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(ext);
        this.resetAll();
    }

    public byte[] getFingerprint() {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            if (this.md5 == null) {
                this.md5 = MessageDigest.getInstance((AlgorithmIdentifier)AlgID.md5);
            }
            return this.md5.computeDigest(Utils.toBytes((Streamable)this.toASN1Sequence()));
        }
        catch (AlgorithmIdentifierException algEx) {
            throw new IllegalStateException("MD5 class not found. " + algEx.toString());
        }
        catch (SignatureException ex) {
            throw new IllegalStateException(ex.toString());
        }
    }

    public static byte[] getCertID(X500Name issuer, BigInteger serial, MessageDigest md) {
        md.init();
        md.updateASCII(issuer.toString());
        md.updateASCII(serial.toString());
        md.computeCurrent();
        return md.getDigestBits();
    }

    public byte[] getCertID(MessageDigest md) {
        if (!this.isDecoded) {
            this.decode();
        }
        return X509.getCertID(this.issuer, this.serialNo, md);
    }

    public ASN1ObjectID getSigAlgOID() {
        try {
            this.getTBSCert();
        }
        catch (SignatureException ex) {
            throw new IllegalStateException(ex.toString());
        }
        if (this.sigAlgID != null) {
            return this.sigAlgID.getOID();
        }
        throw new IllegalStateException("Signature algorithm not defined");
    }

    public String getSigAlgString() {
        return this.getSigAlgOID().toStringCompact();
    }

    public boolean verifySignature(byte[] docBytes, byte[] sigBytes, AlgorithmIdentifier sigAlgID) throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            Signature sig = Signature.getInstance((AlgorithmIdentifier)sigAlgID);
            sig.setPublicKey(this.key);
            sig.setDocument(docBytes);
            sig.setSigBytes(sigBytes);
            return sig.verify();
        }
        catch (AlgorithmIdentifierException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    public boolean equals(Object o) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (o != null && o instanceof X509) {
            return this.equals((X509)o);
        }
        return false;
    }

    private boolean equals(X509 c) {
        if (!this.isDecoded) {
            this.decode();
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)c));
    }

    public int hashCode() {
        if (!this.isDecoded) {
            this.decode();
        }
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decode();
        }
        String s = "";
        s = s + "{ fingerprint = " + Utils.toHexString((byte[])this.getFingerprint());
        s = s + ", notBefore = " + this.notBeforeDate;
        s = s + ", notAfter = " + this.notAfterDate;
        s = s + ", holder = " + this.holder;
        s = s + ", issuer = " + this.issuer;
        s = s + ", serialNo = " + this.serialNo;
        s = s + ", sigAlgOID = " + this.getSigAlgString();
        s = s + ", key = " + this.key;
        if (this.extensions != null && this.extensions.size() > 0) {
            s = s + ", extensions = {";
            boolean mid = false;
            Enumeration e = this.extensions.getExtensions().elements();
            while (e.hasMoreElements()) {
                if (mid) {
                    s = s + ", ";
                }
                s = s + (X509Extension)e.nextElement();
                mid = true;
            }
            s = s + " }";
        }
        s = s + " }";
        return s;
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

