/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509PolicyInformation
implements ASN1Object,
Externalizable {
    private ASN1ObjectID id;
    private Vector policyQualifiers;
    private ASN1Sequence contents;

    public X509PolicyInformation() {
    }

    public X509PolicyInformation(ASN1ObjectID id) {
        this.id = id;
    }

    public X509PolicyInformation(ASN1ObjectID id, Vector policyQualifiers) {
        this.id = id;
        this.policyQualifiers = policyQualifiers;
    }

    public X509PolicyInformation(InputStream is) throws IOException {
        this.input(is);
    }

    public void addPolicyQualifier(ASN1ObjectID qualifierID, ASN1Object qualifier) {
        if (this.id.equals((Object)PKIX.anyPolicy) && !qualifierID.equals((Object)PKIX.id_qt_cps) && !qualifierID.equals((Object)PKIX.id_qt_unotice)) {
            throw new IllegalArgumentException("Illegal qualifier type for anyPolicy policy");
        }
        ASN1Sequence pq = new ASN1Sequence();
        pq.addElement((ASN1Object)qualifierID);
        pq.addElement(qualifier);
        if (this.policyQualifiers == null) {
            this.policyQualifiers = new Vector();
        }
        this.policyQualifiers.addElement(pq);
        this.reset();
    }

    public void addCPSPointer(String uri) {
        this.addPolicyQualifier(PKIX.id_qt_cps, (ASN1Object)new ASN1String(uri, 22));
    }

    public void addUserNotice(String organization, int[] noticeNumbers, String explicitText) {
        if (organization == null ^ noticeNumbers == null) {
            throw new IllegalArgumentException("Both or neither of organization and noticeNumbers must be present");
        }
        if (organization == null && explicitText == null) {
            throw new IllegalArgumentException("No user notice content given");
        }
        ASN1Sequence userNotice = new ASN1Sequence();
        if (organization != null) {
            ASN1Sequence noticeRef = new ASN1Sequence();
            noticeRef.addElement((ASN1Object)new ASN1String(organization));
            ASN1Sequence noticeNos = new ASN1Sequence();
            int len = noticeNumbers.length;
            for (int i = 0; i < len; ++i) {
                noticeNos.addElement((ASN1Object)new ASN1Integer((long)noticeNumbers[i]));
            }
            noticeRef.addElement((ASN1Object)noticeNos);
            userNotice.addElement((ASN1Object)noticeRef);
        }
        if (explicitText != null) {
            userNotice.addElement((ASN1Object)new ASN1String(explicitText));
        }
        this.addPolicyQualifier(PKIX.id_qt_unotice, (ASN1Object)userNotice);
    }

    public ASN1ObjectID getID() {
        return this.id;
    }

    public Vector getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.id = new ASN1ObjectID((InputStream)sis);
        this.policyQualifiers = sis.hasMoreData() ? new ASN1Sequence((InputStream)sis).elements() : null;
        sis.terminate();
        this.reset();
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.id);
            if (this.policyQualifiers != null) {
                s.addElement((ASN1Object)new ASN1Sequence(this.policyQualifiers));
            }
            this.contents = s;
        }
        return this.contents;
    }

    public int length() {
        return this.outputASN1().length();
    }

    private void reset() {
        this.contents = null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("id = " + this.id);
        if (this.policyQualifiers != null) {
            s.append(", policyQualifiers = " + Utils.toHexString((byte[])Utils.toBytes((Streamable)new ASN1Sequence(this.policyQualifiers))));
        }
        return s.toString();
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

