/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.rest;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.paypal.api.payments.Error;
import com.paypal.base.exception.HttpErrorException;
import com.paypal.base.rest.JSONFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayPalRESTException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(PayPalRESTException.class);
    private static final long serialVersionUID = 1L;
    private int responsecode;
    private Error details;

    public PayPalRESTException(String message) {
        super(message);
    }

    public PayPalRESTException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public PayPalRESTException(Throwable throwable) {
        super(throwable);
    }

    public int getResponsecode() {
        return this.responsecode;
    }

    public void setResponsecode(int responsecode) {
        this.responsecode = responsecode;
    }

    public Error getDetails() {
        return this.details;
    }

    public void setDetails(Error details) {
        this.details = details;
    }

    protected static PayPalRESTException createFromHttpErrorException(HttpErrorException httpErrorException) {
        PayPalRESTException ppre = new PayPalRESTException(httpErrorException.getMessage(), httpErrorException);
        ppre.setResponsecode(httpErrorException.getResponsecode());
        if (httpErrorException.getResponsecode() >= 400 && httpErrorException.getErrorResponse() != null && PayPalRESTException.isJSONValid(httpErrorException.getErrorResponse())) {
            try {
                Error details = JSONFormatter.fromJSON(httpErrorException.getErrorResponse(), Error.class);
                ppre.setDetails(details);
            }
            catch (Exception e) {
                log.error("Exception thrown while parsing error response: " + httpErrorException.getErrorResponse(), (Throwable)e);
            }
        }
        return ppre;
    }

    @Override
    public String toString() {
        return "response-code: " + this.responsecode + "\tdetails: " + this.details;
    }

    private static boolean isJSONValid(String jsonInString) {
        try {
            new Gson().fromJson(jsonInString, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }
}

