/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.config;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.pig4cloud.plugin.datav.config.DatavBeanImportSelector;
import com.pig4cloud.plugin.datav.config.GlobalBizExceptionHandler;
import com.pig4cloud.plugin.datav.config.InitDataSourceInitRunner;
import com.pig4cloud.plugin.datav.config.SqlFilterArgumentResolver;
import com.pig4cloud.plugin.datav.config.datasource.support.ClearDbWebRequestInterceptor;
import com.pig4cloud.plugin.datav.config.properties.DatavProperties;
import com.pig4cloud.plugin.datav.config.runner.CheckDatavVersionUpdateRunner;
import com.pig4cloud.plugin.datav.plugin.core.YamlPropertySourceFactory;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.filter.OrderedCharacterEncodingFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DatavProperties.class})
@ComponentScan(value={"com.pig4cloud.plugin.datav"})
@Import(value={DatavBeanImportSelector.class})
@PropertySource(value={"classpath:datav.yml"}, factory=YamlPropertySourceFactory.class)
public class DatavAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DatavAutoConfiguration.class);
    private static final String ASIA_SHANGHAI = "Asia/Shanghai";

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addWebRequestInterceptor((WebRequestInterceptor)new ClearDbWebRequestInterceptor());
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOriginPatterns(new String[]{"*"}).allowedHeaders(new String[]{"*"}).allowedMethods(new String[]{"*"}).maxAge(3600L).allowCredentials(true);
    }

    @Bean
    @ConditionalOnMissingBean
    public Jackson2ObjectMapperBuilderCustomizer customizer() {
        return builder -> {
            builder.locale(Locale.CHINA);
            builder.timeZone(TimeZone.getTimeZone(ASIA_SHANGHAI));
            builder.serializerByType(Long.class, (JsonSerializer)ToStringSerializer.instance);
        };
    }

    @Bean
    public OrderedCharacterEncodingFilter characterEncodingFilter() {
        OrderedCharacterEncodingFilter filter = new OrderedCharacterEncodingFilter();
        filter.setEncoding(StandardCharsets.UTF_8.name());
        filter.setForceEncoding(true);
        filter.setOrder(Integer.MIN_VALUE);
        return filter;
    }

    @Bean
    public InitDataSourceInitRunner initDataSourceInitRunner() {
        return new InitDataSourceInitRunner();
    }

    @Bean
    public CheckDatavVersionUpdateRunner checkDatavVersionUpdateRunner(DatavProperties datavProperties) {
        return new CheckDatavVersionUpdateRunner(datavProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public GlobalBizExceptionHandler globalBizExceptionHandler() {
        return new GlobalBizExceptionHandler();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new SqlFilterArgumentResolver());
    }
}

