/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.config;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ServiceLoaderUtil;
import com.pig4cloud.plugin.datav.config.MybatisAutoConfiguration;
import com.pig4cloud.plugin.datav.config.datasource.DynamicDatavDataSourceAutoConfiguration;
import com.pig4cloud.plugin.datav.config.magic.MagicApiConfiguration;
import com.pig4cloud.plugin.datav.plugin.core.IDatavPluginService;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

public class DatavBeanImportSelector
implements ImportSelector {
    private static final Logger log = LoggerFactory.getLogger(DatavBeanImportSelector.class);

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        ArrayList<String> beanList = new ArrayList<String>();
        beanList.add(MybatisAutoConfiguration.class.getName());
        beanList.add(DynamicDatavDataSourceAutoConfiguration.class.getName());
        beanList.add(MagicApiConfiguration.class.getName());
        ServiceLoader pluginServices = ServiceLoaderUtil.load(IDatavPluginService.class);
        for (IDatavPluginService pluginService : pluginServices) {
            beanList.add(pluginService.getClass().getName());
            log.info("DataV {} \u63d2\u4ef6\u52a0\u8f7d\u6210\u529f", (Object)pluginService.copyright());
        }
        return (String[])ArrayUtil.toArray(beanList, String.class);
    }
}

