/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.config;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.pig4cloud.plugin.datav.entity.DataVisual;
import com.pig4cloud.plugin.datav.entity.DataVisualCategory;
import com.pig4cloud.plugin.datav.entity.DataVisualConfig;
import com.pig4cloud.plugin.datav.entity.DataVisualMap;
import com.pig4cloud.plugin.datav.mapper.DataVisualCategoryMapper;
import com.pig4cloud.plugin.datav.mapper.DataVisualConfigMapper;
import com.pig4cloud.plugin.datav.mapper.DataVisualMapMapper;
import com.pig4cloud.plugin.datav.mapper.DataVisualMapper;
import com.pig4cloud.plugin.datav.util.enums.DataVisualStatusEnum;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.annotation.Async;

public class InitDataSourceInitRunner {
    private static final Logger log = LoggerFactory.getLogger(InitDataSourceInitRunner.class);
    @Autowired
    private DataVisualConfigMapper visualConfigMapper;
    @Autowired
    private DataVisualCategoryMapper categoryMapper;
    @Autowired
    private DataVisualMapper visualMapper;
    @Autowired
    private DataVisualMapMapper mapMapper;

    @Async
    @EventListener(value={WebServerInitializedEvent.class})
    public void initData() {
        Long count = this.categoryMapper.selectCount((Wrapper)Wrappers.emptyWrapper());
        if (count != 0L) {
            log.debug("\u6570\u636e\u5e93\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u6267\u884c\u9ed8\u8ba4\u6570\u636e\u6a21\u677f\u521d\u59cb\u5316");
            return;
        }
        this.initCategory();
        this.initVisual();
        this.initConfig();
        this.initMap();
        log.info(">>> \u521d\u59cb\u5316\u53ef\u89c6\u5316\u6a21\u677f\u6570\u636e\u5b8c\u6210 <<<");
    }

    private void initVisual() {
        CsvData csvData = this.getCsvRows("init-data/data_visual.csv");
        if (csvData == null) {
            return;
        }
        List csvRows = csvData.getRows();
        csvRows.stream().map(row -> {
            DataVisual visual = new DataVisual();
            visual.setId(Long.parseLong(row.get(0)));
            visual.setTitle(row.get(1));
            visual.setBackgroundUrl(row.get(2));
            visual.setCategory(Long.parseLong(row.get(3)));
            visual.setStatus(DataVisualStatusEnum.PUBLISHED.getStatus());
            return visual;
        }).forEach(visual -> this.visualMapper.insert(visual));
    }

    private void initConfig() {
        CsvData csvData = this.getCsvRows("init-data/data_visual_config.csv");
        if (csvData == null) {
            return;
        }
        List csvRows = csvData.getRows();
        csvRows.stream().map(row -> {
            DataVisualConfig config = new DataVisualConfig();
            config.setId(Long.parseLong(row.get(0)));
            config.setVisualId(Long.parseLong(row.get(0)));
            config.setDetail(row.get(2));
            config.setComponent(row.get(3));
            return config;
        }).forEach(config -> this.visualConfigMapper.insert(config));
    }

    private void initMap() {
        CsvData csvData = this.getCsvRows("init-data/data_visual_map.csv");
        if (csvData == null) {
            return;
        }
        List csvRows = csvData.getRows();
        csvRows.stream().map(row -> {
            DataVisualMap map = new DataVisualMap();
            map.setId(Long.parseLong(row.get(0)));
            map.setName(row.get(1));
            map.setData(Base64.decodeStr((CharSequence)row.get(2)));
            return map;
        }).forEach(map -> this.mapMapper.insert(map));
    }

    private void initCategory() {
        CsvData csvData = this.getCsvRows("init-data/data_visual_category.csv");
        if (csvData == null) {
            return;
        }
        List csvRows = csvData.getRows();
        csvRows.stream().map(row -> {
            DataVisualCategory category = new DataVisualCategory();
            category.setId(Long.parseLong(row.get(0)));
            category.setCategoryKey(row.get(1));
            category.setCategoryValue(row.get(2));
            return category;
        }).forEach(category -> this.categoryMapper.insert(category));
    }

    private CsvData getCsvRows(String path) {
        ClassPathResource classPathResource = new ClassPathResource(path);
        CsvReader reader = CsvUtil.getReader();
        CsvData data = null;
        if (classPathResource.exists()) {
            InputStream inputStream = classPathResource.getInputStream();
            data = reader.readFromStr(IoUtil.read((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
        } else {
            try {
                byte[] bytes = HttpUtil.downloadBytes((String)("https://minio.pigx.top/datav/" + path));
                data = reader.readFromStr(StrUtil.str((byte[])bytes, (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25,\u8bf7\u624b\u52a8\u521d\u59cb\u5316", (Throwable)e);
            }
        }
        return data;
    }
}

