/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.config.datasource;

import com.baomidou.dynamic.datasource.provider.AbstractJdbcDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.pig4cloud.plugin.datav.config.properties.DataSourceProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDynamicDataSourceProvider
extends AbstractJdbcDataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(JdbcDynamicDataSourceProvider.class);
    private final DataSourceProperties properties;

    public JdbcDynamicDataSourceProvider(DataSourceProperties properties) {
        super(properties.getDriverClassName(), properties.getUrl(), properties.getUsername(), properties.getPassword());
        this.properties = properties;
    }

    protected Map<String, DataSourceProperty> executeStmt(Statement statement) throws SQLException {
        HashMap<String, DataSourceProperty> map = new HashMap<String, DataSourceProperty>(8);
        try {
            ResultSet rs = statement.executeQuery(this.properties.getQueryDsSql());
            while (rs.next()) {
                String name = rs.getString("name");
                String username = rs.getString("username");
                String password = rs.getString("password");
                String url = rs.getString("url");
                DataSourceProperty property = new DataSourceProperty();
                property.setUsername(username);
                property.setLazy(Boolean.valueOf(true));
                property.setPassword(password);
                property.setUrl(url);
                map.put(name, property);
            }
        }
        catch (Exception rs) {
            // empty catch block
        }
        DataSourceProperty property = new DataSourceProperty();
        property.setUsername(this.properties.getUsername());
        property.setPassword(this.properties.getPassword());
        property.setUrl(this.properties.getUrl());
        property.setLazy(Boolean.valueOf(true));
        map.put("master", property);
        return map;
    }
}

