/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.config.magic;

import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.pig4cloud.plugin.datav.config.datasource.DynamicDatavDataSourceAutoConfiguration;
import com.pig4cloud.plugin.datav.plugin.core.YamlPropertySourceFactory;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.ssssssss.magicapi.core.resource.DatabaseResource;
import org.ssssssss.magicapi.core.resource.Resource;
import org.ssssssss.magicapi.datasource.model.MagicDynamicDataSource;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={DynamicDatavDataSourceAutoConfiguration.class})
@PropertySource(value={"classpath:magic/magic.yml"}, factory=YamlPropertySourceFactory.class)
public class MagicApiConfiguration
implements InitializingBean {
    private final MagicDynamicDataSource magicDynamicDataSource;
    private final List<DynamicDataSourceProvider> providers;

    @Bean
    public Resource databaseResource(JdbcTemplate jdbcTemplate) {
        return new DatabaseResource(jdbcTemplate, "data_visual_api_file");
    }

    public void afterPropertiesSet() {
        for (DynamicDataSourceProvider provider : this.providers) {
            provider.loadDataSources().forEach((arg_0, arg_1) -> ((MagicDynamicDataSource)this.magicDynamicDataSource).add(arg_0, arg_1));
        }
    }

    public MagicApiConfiguration(MagicDynamicDataSource magicDynamicDataSource, List<DynamicDataSourceProvider> providers) {
        this.magicDynamicDataSource = magicDynamicDataSource;
        this.providers = providers;
    }
}

