/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.config.runner;

import cn.hutool.http.HttpRequest;
import com.pig4cloud.plugin.datav.config.properties.DatavProperties;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class CheckDatavVersionUpdateRunner {
    private static final Logger log = LoggerFactory.getLogger(CheckDatavVersionUpdateRunner.class);
    private static final String url = "http://version.pig4cloud.com";
    private static final String versionFile = "/META-INF/maven/com.pig4cloud.plugin/datav-spring-boot-starter/pom.properties";
    private final DatavProperties datavProperties;

    @Async
    @EventListener(value={WebServerInitializedEvent.class})
    public void check() {
        if (!this.datavProperties.isCheckUpdate()) {
            return;
        }
        Properties properties = new Properties();
        InputStream resourceAsStream = this.getClass().getResourceAsStream(versionFile);
        if (resourceAsStream != null) {
            properties.load(resourceAsStream);
        }
        try {
            String remoteVersion = HttpRequest.get((String)url).timeout(5000).execute().body();
            log.info(">>> \u5f53\u524dDataV\u7248\u672c {}, \u6700\u65b0\u7248\u672c {} <<<", (Object)properties.getProperty("version"), (Object)remoteVersion);
        }
        catch (Exception exception) {}
    }

    public CheckDatavVersionUpdateRunner(DatavProperties datavProperties) {
        this.datavProperties = datavProperties;
    }
}

