/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.controller;

import cn.hutool.core.util.StrUtil;
import com.pig4cloud.plugin.datav.dto.ApiInfoDTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.ssssssss.magicapi.core.model.ApiInfo;
import org.ssssssss.magicapi.core.model.Group;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.service.MagicResourceService;

@RestController
@RequestMapping(value={"/api"})
@Tag(name="\u6570\u636e\u96c6\u7ba1\u7406")
public class DataVisualApiController {
    private final MagicResourceService resourceService;

    @GetMapping(value={"/list"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8\u6570\u636e\u96c6\u63a5\u53e3")
    public List<ApiInfoDTO> list() {
        ArrayList<ApiInfoDTO> apiInfoDTOList = new ArrayList<ApiInfoDTO>();
        List files = this.resourceService.files("api");
        List groupList = files.stream().map(MagicEntity::getGroupId).distinct().map(arg_0 -> ((MagicResourceService)this.resourceService).getGroup(arg_0)).collect(Collectors.toList());
        for (Group group : groupList) {
            List<ApiInfo> collect = files.stream().filter(file -> file.getGroupId().equalsIgnoreCase(group.getId())).map(magicEntity -> {
                ApiInfo apiInfo = (ApiInfo)magicEntity;
                StringBuilder path = new StringBuilder();
                if (StrUtil.startWith((CharSequence)group.getPath(), (CharSequence)"/")) {
                    path.append(group.getPath());
                } else {
                    path.append("/").append(group.getPath());
                }
                if (StrUtil.startWith((CharSequence)apiInfo.getPath(), (CharSequence)"/")) {
                    path.append(apiInfo.getPath());
                } else {
                    path.append("/").append(apiInfo.getPath());
                }
                apiInfo.setPath(path.toString());
                return apiInfo;
            }).collect(Collectors.toList());
            ApiInfoDTO apiInfoDTO = new ApiInfoDTO();
            apiInfoDTO.setGroupId(group.getId());
            apiInfoDTO.setGroupName(group.getName());
            apiInfoDTO.setApis(collect);
            apiInfoDTOList.add(apiInfoDTO);
        }
        return apiInfoDTOList;
    }

    public DataVisualApiController(MagicResourceService resourceService) {
        this.resourceService = resourceService;
    }
}

