/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.pig4cloud.plugin.datav.dto.DataVisualDTO;
import com.pig4cloud.plugin.datav.entity.DataVisual;
import com.pig4cloud.plugin.datav.service.DataVisualService;
import com.pig4cloud.plugin.datav.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/visual"})
@Tag(name="\u5927\u5c4f\u8bbe\u8ba1\u7ba1\u7406")
public class DataVisualController {
    private final DataVisualService dataVisualService;

    @GetMapping(value={"/list"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8\u5927\u5c4f")
    public R getDataVisualPage(Page<DataVisual> page, DataVisual dataVisual) {
        return R.ok((Page)this.dataVisualService.page((IPage)page, (Wrapper)Wrappers.query((Object)((Object)dataVisual)).orderByDesc((Object)"id")));
    }

    @GetMapping(value={"/detail"})
    @Operation(summary="\u67e5\u8be2\u6307\u5b9a\u5927\u5c4f\u8be6\u60c5")
    public R<DataVisualDTO> getById(Long id) {
        return R.ok(this.dataVisualService.getDataVisualDTOById(id));
    }

    @PostMapping(value={"/save"})
    @Operation(summary="\u65b0\u589e\u5927\u5c4f")
    public R save(@Valid @RequestBody DataVisualDTO visual) {
        DataVisual temp = this.dataVisualService.saveVisual(visual);
        if (temp.getId() != null) {
            return R.ok(temp);
        }
        return R.ok(false);
    }

    @PostMapping(value={"/update"})
    @Operation(summary="\u7f16\u8f91\u5927\u5c4f")
    public R update(@Valid @RequestBody DataVisualDTO visual) {
        return R.ok(this.dataVisualService.updateVisual(visual));
    }

    @PostMapping(value={"/remove"})
    @Operation(summary="\u5220\u9664\u5927\u5c4f")
    public R<Boolean> removeById(Long ids) {
        return R.ok(this.dataVisualService.removeVisual(ids));
    }

    @PostMapping(value={"/copy"})
    @Operation(summary="\u590d\u5236\u5927\u5c4f")
    public R copy(@RequestParam Long id) {
        return R.ok(this.dataVisualService.copy(id));
    }

    public DataVisualController(DataVisualService dataVisualService) {
        this.dataVisualService = dataVisualService;
    }
}

