/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.pig4cloud.plugin.datav.dto.SqlDto;
import com.pig4cloud.plugin.datav.entity.DataVisualDb;
import com.pig4cloud.plugin.datav.service.DataVisualDbService;
import com.pig4cloud.plugin.datav.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/db"})
@Tag(name="\u6570\u636e\u6e90\u7ba1\u7406")
public class DataVisualDbController {
    private final DataVisualDbService dataVisualDbService;

    @GetMapping(value={"/list"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8\u6570\u636e\u6e90")
    public R getDataVisualDbPage(Page page, DataVisualDb dataVisualDb) {
        return R.ok((Page)this.dataVisualDbService.page((IPage)page, (Wrapper)Wrappers.query((Object)((Object)dataVisualDb))));
    }

    @GetMapping(value={"/detail"})
    @Operation(summary="\u67e5\u8be2\u6570\u636e\u6e90\u8be6\u60c5")
    public R getById(Long id) {
        return R.ok((DataVisualDb)((Object)this.dataVisualDbService.getById(id)));
    }

    @PostMapping(value={"/submit"})
    @Operation(summary="\u65b0\u589e\u7f16\u8f91\u6570\u636e\u6e90")
    public R updateById(@RequestBody DataVisualDb dataVisualDb) {
        return R.ok(this.dataVisualDbService.submitDb(dataVisualDb));
    }

    @PostMapping(value={"/remove"})
    @Operation(summary="\u5220\u9664\u6570\u636e\u6e90")
    public R removeById(Long ids) {
        return R.ok(this.dataVisualDbService.removeById(ids));
    }

    @PostMapping(value={"/db-test"})
    @Operation(summary="\u6570\u636e\u6e90\u53ef\u7528\u6027\u68c0\u6d4b")
    public R dbTest(@RequestBody DataVisualDb db) {
        return this.dataVisualDbService.dbTest(db);
    }

    @GetMapping(value={"/db-list"})
    @Operation(summary="\u67e5\u8be2\u6570\u636e\u6e90\u5217\u8868")
    public R<List<DataVisualDb>> dbList() {
        return R.ok(this.dataVisualDbService.list());
    }

    @PostMapping(value={"/dynamic-query"})
    @Operation(summary="\u52a8\u6001\u6267\u884cSQL")
    public R dynamicQuery(@Valid @RequestBody SqlDto sql) {
        List<LinkedHashMap<String, Object>> linkedHashMaps = this.dataVisualDbService.dynamicQuery(sql);
        return R.ok(linkedHashMaps);
    }

    public DataVisualDbController(DataVisualDbService dataVisualDbService) {
        this.dataVisualDbService = dataVisualDbService;
    }
}

