/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.pig4cloud.plugin.datav.entity.DataVisualFile;
import com.pig4cloud.plugin.datav.service.DataVisualFileService;
import com.pig4cloud.plugin.datav.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/file"})
@Tag(name="\u6587\u4ef6\u7ba1\u7406")
public class DataVisualFileController {
    private static final Logger log = LoggerFactory.getLogger(DataVisualFileController.class);
    private final DataVisualFileService dataVisualFileService;

    @GetMapping(value={"/list"})
    @Operation(summary="\u67e5\u8be2\u5df2\u4e0a\u4f20\u6587\u4ef6")
    public R list(String type) {
        List dataVisualFileList = this.dataVisualFileService.list((Wrapper)Wrappers.lambdaQuery().eq(StrUtil.isNotBlank((CharSequence)type), DataVisualFile::getType, (Object)type));
        List list = dataVisualFileList.stream().distinct().map(file -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("label", file.getName());
            map.put("value", file.getUrl());
            return map;
        }).collect(Collectors.toList());
        return R.ok(list);
    }

    @GetMapping(value={"/page"})
    public R page(DataVisualFile file, Page page) {
        return R.ok((Page)this.dataVisualFileService.page((IPage)page, (Wrapper)Wrappers.lambdaQuery().eq(StrUtil.isNotBlank((CharSequence)file.getType()), DataVisualFile::getType, (Object)file.getType())));
    }

    @PostMapping(value={"/remove"})
    public R remove(Long id) {
        return R.ok(this.dataVisualFileService.deleteFile(id));
    }

    @PostMapping(value={"/put-file"})
    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6")
    public R putFile(@RequestPart(value="file") MultipartFile file, String type) {
        return this.dataVisualFileService.uploadFile(file, type);
    }

    @Operation(summary="\u4e0b\u8f7d\u6587\u4ef6")
    @GetMapping(value={"/get-file/{fileName}"})
    public ResponseEntity<byte[]> getFile(@PathVariable String fileName) {
        HttpHeaders headers = new HttpHeaders();
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(fileName).build();
        headers.setContentDisposition(contentDisposition);
        try {
            return new ResponseEntity((Object)FileCopyUtils.copyToByteArray((File)this.dataVisualFileService.getFile(fileName)), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
            return null;
        }
    }

    public DataVisualFileController(DataVisualFileService dataVisualFileService) {
        this.dataVisualFileService = dataVisualFileService;
    }
}

