/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.pig4cloud.plugin.datav.entity.DataVisualMap;
import com.pig4cloud.plugin.datav.service.DataVisualMapService;
import com.pig4cloud.plugin.datav.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/map"})
@Tag(name="\u5730\u56fe\u7ba1\u7406")
public class DataVisualMapController {
    private final DataVisualMapService dataVisualMapService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u5730\u56fe")
    @GetMapping(value={"/page"})
    public R getDataVisualMapPage(Page page, DataVisualMap dataVisualMap) {
        return R.ok((Page)this.dataVisualMapService.page((IPage)page, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(StrUtil.isNotBlank((CharSequence)dataVisualMap.getName()), DataVisualMap::getName, (Object)dataVisualMap.getName())).orderByAsc(DataVisualMap::getId)));
    }

    @Operation(summary="\u67e5\u8be2\u5730\u56fe")
    @GetMapping(value={"/list"})
    public R getDataVisualMapList(DataVisualMap dataVisualMap) {
        List collect = this.dataVisualMapService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(StrUtil.isNotBlank((CharSequence)dataVisualMap.getName()), DataVisualMap::getName, (Object)dataVisualMap.getName())).orderByAsc(DataVisualMap::getId)).stream().map(map -> {
            DataVisualMap visualMap = new DataVisualMap();
            visualMap.setName(map.getName());
            visualMap.setId(map.getId());
            return visualMap;
        }).collect(Collectors.toList());
        return R.ok(collect);
    }

    @Operation(summary="\u67e5\u8be2\u5730\u56fe\u6570\u636e")
    @GetMapping(value={"/data"})
    public String data(Long id) {
        DataVisualMap detail = (DataVisualMap)((Object)this.dataVisualMapService.getById(id));
        return detail.getData();
    }

    @Operation(summary="\u67e5\u8be2\u5730\u56fe\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public R getById(Long id) {
        return R.ok((DataVisualMap)((Object)this.dataVisualMapService.getById(id)));
    }

    @Operation(summary="\u65b0\u589e\u5730\u56fe")
    @PostMapping(value={"/save"})
    public R save(@RequestBody DataVisualMap dataVisualMap) {
        return R.ok(this.dataVisualMapService.saveOrUpdate((Object)dataVisualMap));
    }

    @Operation(summary="\u7f16\u8f91\u5730\u56fe")
    @PostMapping(value={"/update"})
    public R update(@RequestBody DataVisualMap dataVisualMap) {
        return R.ok(this.dataVisualMapService.saveOrUpdate((Object)dataVisualMap));
    }

    @Operation(summary="\u5220\u9664\u5730\u56fe")
    @PostMapping(value={"/remove"})
    public R removeById(Long ids) {
        return R.ok(this.dataVisualMapService.removeById(ids));
    }

    public DataVisualMapController(DataVisualMapService dataVisualMapService) {
        this.dataVisualMapService = dataVisualMapService;
    }
}

