/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.controller;

import com.pig4cloud.plugin.datav.config.properties.DatavProperties;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.license.client.License;
import org.smartboot.license.client.LicenseEntity;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping
@Tag(name="\u53ef\u89c6\u5316\u9875\u9762")
public class DatavPageController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DatavPageController.class);
    private static boolean expire = false;
    private final DatavProperties datavProperties;

    @GetMapping(value={"/", "/create/**", "/build/*", "/view/*", "/db/**", "/apis/**", "/category/**", "/map/**", "/components/**", "/materials/**"})
    public String index() {
        return expire ? "expire" : "index";
    }

    public void afterPropertiesSet() {
        if (!StringUtils.hasText((String)this.datavProperties.getLicense())) {
            log.error("\u6570\u636e\u53ef\u89c6\u5316\u7ec4\u4ef6\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bf7\u8bbf\u95ee https://pig4cloud.com \u83b7\u53d6");
        }
        License license = new License();
        try {
            String text = this.datavProperties.getLicense();
            LicenseEntity licenseEntity = license.loadLicense((InputStream)new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
            LocalDateTime applyTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(licenseEntity.getApplyTime()), ZoneOffset.of("+8"));
            LocalDateTime expireTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(licenseEntity.getExpireTime()), ZoneOffset.of("+8"));
            log.info("\u8bc1\u4e66\u52a0\u8f7d\u6210\u529f \u7533\u8bf7\u65f6\u95f4 {} ,\u8fc7\u671f\u65f6\u95f4 {}", (Object)applyTime, (Object)expireTime);
        }
        catch (Exception e) {
            expire = true;
        }
    }

    public DatavPageController(DatavProperties datavProperties) {
        this.datavProperties = datavProperties;
    }
}

