/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.service.impl;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pig4cloud.plugin.datav.dto.SqlDto;
import com.pig4cloud.plugin.datav.entity.DataVisualDb;
import com.pig4cloud.plugin.datav.mapper.DataVisualDbMapper;
import com.pig4cloud.plugin.datav.service.DataVisualDbService;
import com.pig4cloud.plugin.datav.util.R;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.ssssssss.magicapi.datasource.model.MagicDynamicDataSource;

@Service
public class DataVisualDbServiceImpl
extends ServiceImpl<DataVisualDbMapper, DataVisualDb>
implements DataVisualDbService {
    private static final Logger log = LoggerFactory.getLogger(DataVisualDbServiceImpl.class);
    private final DataVisualDbMapper dataVisualDbMapper;
    private final DynamicRoutingDataSource dynamicRoutingDataSource;
    private final MagicDynamicDataSource magicDynamicDataSource;
    private final List<DynamicDataSourceProvider> providers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R dbTest(DataVisualDb db) {
        R r;
        block9: {
            Connection conn = null;
            try {
                Class.forName(db.getDriverClass());
                conn = DriverManager.getConnection(db.getUrl(), db.getUsername(), db.getPassword());
                conn.setAutoCommit(Boolean.FALSE);
                r = R.success();
                if (Collections.singletonList(conn).get(0) == null) break block9;
            }
            catch (Exception ex) {
                R<String> r2;
                block10: {
                    try {
                        log.error("\u6570\u636e\u5e93\u68c0\u67e5\u5931\u8d25", (Throwable)ex);
                        r2 = R.failed(ex.getLocalizedMessage());
                        if (Collections.singletonList(conn).get(0) == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(conn).get(0) != null) {
                            conn.close();
                        }
                        throw throwable;
                    }
                    conn.close();
                }
                return r2;
            }
            conn.close();
        }
        return r;
    }

    @Override
    public List<LinkedHashMap<String, Object>> dynamicQuery(SqlDto sql) {
        DynamicDataSourceContextHolder.clear();
        DataVisualDb dataVisualDb = (DataVisualDb)((Object)this.dataVisualDbMapper.selectById(sql.getId()));
        DynamicDataSourceContextHolder.push((String)dataVisualDb.getName());
        List<LinkedHashMap<String, Object>> linkedHashMaps = this.dataVisualDbMapper.dynamicQuerySql(sql.getSql());
        DynamicDataSourceContextHolder.clear();
        return linkedHashMaps;
    }

    @Override
    public Boolean submitDb(DataVisualDb dataVisualDb) {
        this.saveOrUpdate((Object)dataVisualDb);
        this.dynamicRoutingDataSource.afterPropertiesSet();
        for (DynamicDataSourceProvider provider : this.providers) {
            provider.loadDataSources().forEach((arg_0, arg_1) -> ((MagicDynamicDataSource)this.magicDynamicDataSource).add(arg_0, arg_1));
        }
        return true;
    }

    public DataVisualDbServiceImpl(DataVisualDbMapper dataVisualDbMapper, DynamicRoutingDataSource dynamicRoutingDataSource, MagicDynamicDataSource magicDynamicDataSource, List<DynamicDataSourceProvider> providers) {
        this.dataVisualDbMapper = dataVisualDbMapper;
        this.dynamicRoutingDataSource = dynamicRoutingDataSource;
        this.magicDynamicDataSource = magicDynamicDataSource;
        this.providers = providers;
    }
}

