/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pig4cloud.plugin.datav.config.properties.DatavProperties;
import com.pig4cloud.plugin.datav.entity.DataVisualFile;
import com.pig4cloud.plugin.datav.mapper.DataVisualFileMapper;
import com.pig4cloud.plugin.datav.service.DataVisualFileService;
import com.pig4cloud.plugin.datav.util.R;
import java.io.File;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DataVisualFileServiceImpl
extends ServiceImpl<DataVisualFileMapper, DataVisualFile>
implements DataVisualFileService {
    private final DatavProperties datavProperties;

    @Override
    public R uploadFile(MultipartFile file, String type) {
        File dest = new File(this.datavProperties.getImgPath() + file.getOriginalFilename());
        file.transferTo(dest);
        HashMap<String, CallSite> map = new HashMap<String, CallSite>(4);
        String url = StrUtil.isNotBlank((CharSequence)this.datavProperties.getHost()) ? this.datavProperties.getHost() + "/file/get-file/" + file.getOriginalFilename() : "/file/get-file/" + file.getOriginalFilename();
        map.put("link", (CallSite)((Object)url));
        if (StrUtil.isNotBlank((CharSequence)type)) {
            DataVisualFile visualFile = new DataVisualFile();
            visualFile.setName(file.getOriginalFilename());
            visualFile.setType(type);
            visualFile.setUrl(url);
            visualFile.setCreateTime(LocalDateTime.now());
            this.saveOrUpdate((Object)visualFile, (Wrapper)Wrappers.lambdaQuery().eq(DataVisualFile::getUrl, (Object)url));
        }
        return R.ok(map);
    }

    @Override
    public File getFile(String fileName) {
        return new File(this.datavProperties.getImgPath() + fileName);
    }

    @Override
    public boolean deleteFile(Long id) {
        DataVisualFile file = (DataVisualFile)((Object)this.getById(id));
        FileUtil.del((File)this.getFile(file.getName()));
        this.removeById(id);
        return Boolean.TRUE;
    }

    public DataVisualFileServiceImpl(DatavProperties datavProperties) {
        this.datavProperties = datavProperties;
    }
}

