/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pig4cloud.plugin.datav.dto.DataVisualDTO;
import com.pig4cloud.plugin.datav.entity.DataVisual;
import com.pig4cloud.plugin.datav.entity.DataVisualConfig;
import com.pig4cloud.plugin.datav.mapper.DataVisualConfigMapper;
import com.pig4cloud.plugin.datav.mapper.DataVisualMapper;
import com.pig4cloud.plugin.datav.service.DataVisualService;
import com.pig4cloud.plugin.datav.util.enums.DataVisualStatusEnum;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataVisualServiceImpl
extends ServiceImpl<DataVisualMapper, DataVisual>
implements DataVisualService {
    private static final Logger log = LoggerFactory.getLogger(DataVisualServiceImpl.class);
    private final DataVisualConfigMapper configMapper;

    @Override
    public DataVisualDTO getDataVisualDTOById(Long id) {
        DataVisualDTO visualDTO = new DataVisualDTO();
        DataVisual visual = (DataVisual)((Object)((DataVisualMapper)this.baseMapper).selectById(id));
        DataVisualConfig dataVisualConfig = (DataVisualConfig)((Object)this.configMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(DataVisualConfig::getVisualId, (Object)id)));
        visualDTO.setVisual(visual);
        visualDTO.setConfig(dataVisualConfig);
        return visualDTO;
    }

    @Override
    public Boolean removeVisual(Long id) {
        ((DataVisualMapper)this.baseMapper).deleteById(id);
        this.configMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(DataVisualConfig::getVisualId, (Object)id));
        return true;
    }

    @Override
    public Long copy(Long id) {
        DataVisual visual = (DataVisual)((Object)((DataVisualMapper)this.baseMapper).selectById(id));
        visual.setId(null);
        ((DataVisualMapper)this.baseMapper).insert((Object)visual);
        DataVisualConfig dataVisualConfig = (DataVisualConfig)((Object)this.configMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(DataVisualConfig::getVisualId, (Object)id)));
        dataVisualConfig.setVisualId(visual.getId());
        dataVisualConfig.setId(null);
        this.configMapper.insert((Object)dataVisualConfig);
        return visual.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DataVisual saveVisual(DataVisualDTO dto) {
        DataVisual visual = dto.getVisual();
        DataVisualConfig visualConfig = dto.getConfig();
        visual.setStatus(DataVisualStatusEnum.PUBLISHED.getStatus());
        this.save((Object)visual);
        visualConfig.setVisualId(visual.getId());
        this.configMapper.insert((Object)visualConfig);
        return visual;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateVisual(DataVisualDTO dto) {
        DataVisual visual;
        DataVisualConfig visualConfig = dto.getConfig();
        if (Objects.nonNull((Object)visualConfig) && Objects.nonNull(visualConfig.getId())) {
            this.configMapper.updateById((Object)visualConfig);
        }
        if (Objects.nonNull((Object)(visual = dto.getVisual())) && Objects.nonNull(visual.getId())) {
            DataVisual dataVisual = (DataVisual)((Object)this.getById(visual.getId()));
            dataVisual.setBackgroundUrl(visual.getBackgroundUrl());
            if (Objects.nonNull(visual.getTitle())) {
                this.updateById((Object)visual);
            } else {
                this.updateById((Object)dataVisual);
            }
        }
        return true;
    }

    public DataVisualServiceImpl(DataVisualConfigMapper configMapper) {
        this.configMapper = configMapper;
    }
}

