/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.pig4cloud.plugin.datav.entity.DataVisualApiBackupFile;
import com.pig4cloud.plugin.datav.mapper.DataVisualApiBackupFileMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.ssssssss.magicapi.backup.model.Backup;
import org.ssssssss.magicapi.backup.service.MagicBackupService;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.event.FileEvent;
import org.ssssssss.magicapi.core.event.GroupEvent;
import org.ssssssss.magicapi.core.model.Group;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.magicapi.utils.WebUtils;

@Service
public class MagicFileBackupServiceImpl
implements MagicBackupService {
    private static final Logger log = LoggerFactory.getLogger(MagicFileBackupServiceImpl.class);
    private final DataVisualApiBackupFileMapper dataVisualApiBackupFileMapper;

    public void doBackupAll(String name, String createBy) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MagicConfiguration.getMagicResourceService().export(null, null, (OutputStream)baos);
        Backup backup = new Backup();
        backup.setId("full");
        backup.setType("full");
        backup.setName(name);
        backup.setCreateBy(createBy);
        backup.setContent(baos.toByteArray());
        this.doBackup(backup);
    }

    public void doBackup(Backup backup) {
        try {
            if (backup.getCreateDate() == 0L) {
                backup.setCreateDate(Long.valueOf(System.currentTimeMillis()));
            }
            if (backup.getCreateBy() == null) {
                backup.setCreateBy(WebUtils.currentUserName());
            }
            DataVisualApiBackupFile file = new DataVisualApiBackupFile();
            BeanUtils.copyProperties((Object)backup, (Object)((Object)file), (String[])new String[]{"content"});
            file.setContent(new String(backup.getContent()));
            this.dataVisualApiBackupFileMapper.insert((Object)file);
        }
        catch (Exception e) {
            log.warn("\u5907\u4efd\u5931\u8d25", (Throwable)e);
        }
    }

    public List<Backup> backupList(long timestamp) {
        return this.dataVisualApiBackupFileMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(DataVisualApiBackupFile::getCreateDate, (Object)timestamp)).stream().map(file -> {
            Backup backup = new Backup();
            BeanUtils.copyProperties((Object)file, (Object)backup, (String[])new String[]{"content"});
            backup.setContent(StrUtil.bytes((CharSequence)file.getContent()));
            return backup;
        }).collect(Collectors.toList());
    }

    public List<Backup> backupById(String id) {
        return this.dataVisualApiBackupFileMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(DataVisualApiBackupFile::getId, (Object)id)).stream().map(file -> {
            Backup backup = new Backup();
            BeanUtils.copyProperties((Object)file, (Object)backup, (String[])new String[]{"content"});
            backup.setContent(StrUtil.bytes((CharSequence)file.getContent()));
            return backup;
        }).collect(Collectors.toList());
    }

    public Backup backupInfo(String id, long timestamp) {
        return this.dataVisualApiBackupFileMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataVisualApiBackupFile::getId, (Object)id)).or()).eq(DataVisualApiBackupFile::getCreateDate, (Object)timestamp)).stream().map(file -> {
            Backup backup = new Backup();
            BeanUtils.copyProperties((Object)file, (Object)backup, (String[])new String[]{"content"});
            backup.setContent(StrUtil.bytes((CharSequence)file.getContent()));
            return backup;
        }).findAny().get();
    }

    public List<Backup> backupByTag(String tag) {
        return this.dataVisualApiBackupFileMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(DataVisualApiBackupFile::getTag, (Object)tag)).stream().map(file -> {
            Backup backup = new Backup();
            BeanUtils.copyProperties((Object)file, (Object)backup, (String[])new String[]{"content"});
            backup.setContent(StrUtil.bytes((CharSequence)file.getContent()));
            return backup;
        }).collect(Collectors.toList());
    }

    public long removeBackup(String id) {
        return this.dataVisualApiBackupFileMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(DataVisualApiBackupFile::getId, (Object)id));
    }

    public long removeBackupByTimestamp(long timestamp) {
        try {
            return this.dataVisualApiBackupFileMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(DataVisualApiBackupFile::getCreateBy, (Object)timestamp));
        }
        catch (Exception e) {
            log.warn("\u5220\u9664\u5907\u4efd\u5931\u8d25", (Throwable)e);
            return -1L;
        }
    }

    @EventListener(condition="#event.source != T(org.ssssssss.magicapi.core.config.Constants).EVENT_SOURCE_NOTIFY")
    public void onFileEvent(FileEvent event) {
        switch (event.getAction()) {
            case SAVE: 
            case CREATE: 
            case MOVE: {
                break;
            }
            default: {
                return;
            }
        }
        MagicEntity entity = event.getEntity();
        this.doBackup(entity.getId(), JsonUtils.toJsonBytes((Object)entity), entity.getName(), event.getType());
    }

    @EventListener(condition="#event.source != T(org.ssssssss.magicapi.core.config.Constants).EVENT_SOURCE_NOTIFY")
    public void onFolderEvent(GroupEvent event) {
        switch (event.getAction()) {
            case SAVE: 
            case CREATE: 
            case MOVE: {
                break;
            }
            default: {
                return;
            }
        }
        Group group = event.getGroup();
        this.doBackup(group.getId(), JsonUtils.toJsonBytes((Object)group), group.getName(), group.getType() + "-group");
    }

    private void doBackup(String id, byte[] content, String name, String type) {
        Backup backup = new Backup();
        backup.setName(name);
        backup.setId(id);
        backup.setContent(content);
        backup.setType(type);
        this.doBackup(backup);
    }

    public MagicFileBackupServiceImpl(DataVisualApiBackupFileMapper dataVisualApiBackupFileMapper) {
        this.dataVisualApiBackupFileMapper = dataVisualApiBackupFileMapper;
    }
}

