/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.datav.util;

import com.pig4cloud.plugin.datav.util.CommonConstants;
import java.io.Serializable;

public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int code;
    private String msg;
    private boolean success;
    private T data;

    public static <T> R<T> success() {
        R<Object> objectR = R.restResult(null, CommonConstants.SUCCESS, null);
        objectR.setSuccess(true);
        return objectR;
    }

    public static <T> R<T> ok() {
        return R.restResult(null, CommonConstants.SUCCESS, null);
    }

    public static <T> R<T> ok(T data) {
        return R.restResult(data, CommonConstants.SUCCESS, null);
    }

    public static <T> R<T> ok(T data, String msg) {
        return R.restResult(data, CommonConstants.SUCCESS, msg);
    }

    public static <T> R<T> failed() {
        return R.restResult(null, CommonConstants.FAIL, null);
    }

    public static <T> R<T> failed(String msg) {
        return R.restResult(null, CommonConstants.FAIL, msg);
    }

    public static <T> R<T> failed(T data) {
        return R.restResult(data, CommonConstants.FAIL, null);
    }

    public static <T> R<T> failed(T data, String msg) {
        return R.restResult(data, CommonConstants.FAIL, msg);
    }

    private static <T> R<T> restResult(T data, int code, String msg) {
        R<T> apiResult = new R<T>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", msg=" + this.getMsg() + ", success=" + this.isSuccess() + ", data=" + this.getData() + ")";
    }

    public R() {
    }

    public R(int code, String msg, boolean success, T data) {
        this.code = code;
        this.msg = msg;
        this.success = success;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public R<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public R<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public R<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public R<T> setData(T data) {
        this.data = data;
        return this;
    }
}

