/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.retry;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import java.util.HashSet;
import java.util.Set;

public class RetryUtils {
    static final Set<Integer> RETRYABLE_STATUS_CODES = new HashSet<Integer>(4);
    static final Set<String> RETRYABLE_CLIENT_ERROR_CODES = new HashSet<String>(1);

    public static boolean isRetryableServiceException(Exception exception) {
        return exception instanceof CosServiceException && RetryUtils.isRetryableServiceException((CosServiceException)exception);
    }

    public static boolean isRetryableServiceException(CosServiceException exception) {
        return RETRYABLE_STATUS_CODES.contains(exception.getStatusCode());
    }

    public static boolean isRetryableClientException(Exception exception) {
        return exception instanceof CosClientException && RetryUtils.isRetryableClientException((CosClientException)exception);
    }

    public static boolean isRetryableClientException(CosClientException exception) {
        return RETRYABLE_CLIENT_ERROR_CODES.contains(exception.getErrorCode());
    }

    static {
        RETRYABLE_STATUS_CODES.add(500);
        RETRYABLE_STATUS_CODES.add(502);
        RETRYABLE_STATUS_CODES.add(503);
        RETRYABLE_STATUS_CODES.add(504);
        RETRYABLE_CLIENT_ERROR_CODES.add("ConnectionTimeout");
        RETRYABLE_CLIENT_ERROR_CODES.add("HostConnect");
        RETRYABLE_CLIENT_ERROR_CODES.add("UnknownHost");
        RETRYABLE_CLIENT_ERROR_CODES.add("SocketTimeout");
        RETRYABLE_CLIENT_ERROR_CODES.add("ClientProtocolException");
    }
}

