/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.express.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.wl.domain.WlExporgDomain;
import com.qjsoft.laser.controller.facade.wl.domain.WlExporgExpReDomain;
import com.qjsoft.laser.controller.facade.wl.domain.WlExporgReDomain;
import com.qjsoft.laser.controller.facade.wl.domain.WlTraceDomain;
import com.qjsoft.laser.controller.facade.wl.domain.WlTraceReDomain;
import com.qjsoft.laser.controller.facade.wl.repository.WlExporgServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlExpressServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlThirdServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlTraceServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wl/exporg"}, name="\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
public class ExporgCon
extends SpringmvcController {
    private static String CODE = "wl.exporg.con";
    @Autowired
    private WlExporgServiceRepository wlExporgServiceRepository;
    @Autowired
    private WlThirdServiceRepository wlThirdServiceRepository;
    @Autowired
    private WlTraceServiceRepository wlTraceServiceRepository;
    @Autowired
    private WlExpressServiceRepository wlExpressServiceRepository;

    protected String getContext() {
        return "exporg";
    }

    @RequestMapping(value={"saveExporg.json"}, name="\u589e\u52a0\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExporg(HttpServletRequest request, WlExporgDomain wlExporgDomain) {
        if (null == wlExporgDomain) {
            this.logger.error(CODE + ".saveExporg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExporgDomain.setTenantCode(this.getTenantCode(request));
        return this.wlExporgServiceRepository.saveExporg(wlExporgDomain);
    }

    @RequestMapping(value={"getExporg.json"}, name="\u83b7\u53d6\u7269\u6d41\u63a5\u53e3\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public WlExporgReDomain getExporg(Integer exporgId) {
        if (StringUtils.isBlank((Integer)exporgId)) {
            this.logger.error(CODE + ".getExporg", (Object)"param is null");
            return null;
        }
        return this.wlExporgServiceRepository.getExporg(exporgId);
    }

    @RequestMapping(value={"updateExporg.json"}, name="\u66f4\u65b0\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateExporg(HttpServletRequest request, WlExporgDomain wlExporgDomain) {
        if (null == wlExporgDomain) {
            this.logger.error(CODE + ".updateExporg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExporgDomain.setTenantCode(this.getTenantCode(request));
        return this.wlExporgServiceRepository.updateExporg(wlExporgDomain);
    }

    @RequestMapping(value={"deleteExporg.json"}, name="\u5220\u9664\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteExporg(Integer exporgId) {
        if (StringUtils.isBlank((Integer)exporgId)) {
            this.logger.error(CODE + ".deleteExporg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExporgServiceRepository.deleteExporg(exporgId);
    }

    @RequestMapping(value={"queryExpressInfo.json"}, name="\u67e5\u8be2\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean queryExpressInfo(HttpServletRequest request, String expressType, String expressNo) {
        return this.queryExpInfo(request, expressType, expressNo);
    }

    @RequestMapping(value={"queryExpressInfoForC.json"}, name="\u67e5\u8be2\u7269\u6d41\u4fe1\u606f-C\u7aef")
    @ResponseBody
    public HtmlJsonReBean queryExpressInfoForC(HttpServletRequest request, String expressType, String expressNo) {
        return this.queryExpInfo(request, expressType, expressNo);
    }

    private HtmlJsonReBean queryExpInfo(HttpServletRequest request, String expressType, String expressNo) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExporgServiceRepository.queryExpInfo(expressType, expressNo, this.getTenantCode(request));
    }

    @RequestMapping(value={"updateExporgState.json"}, name="\u66f4\u65b0\u7269\u6d41\u63a5\u53e3\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateExporgState(String exporgId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)exporgId)) {
            this.logger.error(CODE + ".updateExporgState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExporgServiceRepository.updateExporgState(Integer.valueOf(exporgId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryExporgPage.json"}, name="\u67e5\u8be2\u7269\u6d41\u63a5\u53e3\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExporgReDomain> queryExporgPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExporgServiceRepository.queryExporgPage(param);
    }

    @RequestMapping(value={"queryExpressInfoKdniao.json"}, name="\u901a\u8fc7\u5feb\u9012\u9e1f\u67e5\u8be2\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public WlTraceReDomain queryExpressInfoKdniao(HttpServletRequest request, String expressType, String expressNo) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        HashMap<String, Object> paramExp = new HashMap<String, Object>();
        paramExp.put("fuzzy", false);
        paramExp.put("expressCode", expressType);
        paramExp.put("exporgCode", "kdniao");
        paramExp.put("tenantCode", this.getTenantCode(request));
        SupQueryResult exporgExpReDomain = this.wlExporgServiceRepository.queryExporgExpPage(paramExp);
        String exporgExpCode = ((WlExporgExpReDomain)exporgExpReDomain.getList().get(0)).getExporgExpCode();
        param.put("expressCode", exporgExpCode);
        param.put("traceBillno", expressNo);
        WlTraceReDomain wlTrace = this.wlTraceServiceRepository.getTraceByCode(param);
        if (null == wlTrace) {
            wlTrace = new WlTraceReDomain();
            wlTrace.setExpressCode(exporgExpCode);
            wlTrace.setTraceBillno(expressNo);
            wlTrace.setExpressName((String)param.get("expressName"));
            UserSession userSession = this.getUserSession(request);
            wlTrace.setUserCode(userSession.getUserCode());
            wlTrace.setTraceRMobile((String)param.get("traceRMobile"));
            wlTrace.setTenantCode(this.getTenantCode(request));
            this.wlTraceServiceRepository.insertTrace((WlTraceDomain)wlTrace);
            WlTraceReDomain wlTraceResult = this.wlThirdServiceRepository.orderKdniao(exporgExpCode, expressNo, this.getTenantCode(request));
            try {
                BeanUtils.copyAllPropertysNotNull((Object)wlTrace, (Object)wlTraceResult);
            }
            catch (Exception e) {
                this.logger.error("queryExpressInfoKdniao---copyAllPropertysNotNull", (Throwable)e);
            }
            return wlTrace;
        }
        if (wlTrace.getDataState() != 2) {
            WlTraceReDomain wlTraceResult = this.wlThirdServiceRepository.orderKdniao(exporgExpCode, expressNo, this.getTenantCode(request));
            try {
                BeanUtils.copyAllPropertysNotNull((Object)wlTrace, (Object)wlTraceResult);
            }
            catch (Exception e) {
                this.logger.error("queryExpressInfoKdniao---copyAllPropertysNotNull", (Throwable)e);
            }
            return wlTrace;
        }
        return wlTrace;
    }
}

