/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.controller;

import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthLoginServiceRepository;
import com.qjsoft.laser.controller.facade.rd.repository.RdRandomListServiceRepository;
import com.qjsoft.laser.controller.facade.tm.domain.TmProappEnvBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserlogininfoDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserLogininfoServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.BrowTypeUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.VerifyImgUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ml/mlogin"})
public class MloginCon
extends SpringmvcController {
    private static String CODE = "ml.mlogin.con";
    @Autowired
    private RdRandomListServiceRepository rdRandomListServiceRepository;
    @Autowired
    private OsOAuthLoginServiceRepository osOAuthLoginServiceRepository;
    @Autowired
    private UserLogininfoServiceRepository userLogininfoServiceRepository;

    protected String getContext() {
        return "mlogin";
    }

    @RequestMapping(value={"noresource"})
    public String noresource(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noresource";
    }

    @RequestMapping(value={"noper"})
    public String noper(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noper";
    }

    @RequestMapping(value={"logininfo.json"})
    @ResponseBody
    public HtmlJsonReBean logininfo(HttpServletRequest request, HttpServletResponse response) {
        UserSession userSession = this.getUserSession(request);
        this.setUserSession(request, response, userSession);
        UserInfo userInfo = this.getUserInfo(request);
        return new HtmlJsonReBean((Object)userInfo);
    }

    @RequestMapping(value={"getProappinfo.json"}, name="\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u4fe1\u606f")
    @ResponseBody
    public TmProappEnvBean getProappinfo(HttpServletRequest request, HttpServletResponse response) {
        String cacheKey = "TmProappEnv-tenant-ProappCode";
        String proappCode = this.getProappCode(request);
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String json = SupDisUtil.getMap((String)cacheKey, (String)(tenantCode + "-" + proappCode));
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        TmProappEnvBean tmProappEnvBean = (TmProappEnvBean)JsonUtil.buildNormalBinder().getJsonToObject(json, TmProappEnvBean.class);
        return tmProappEnvBean;
    }

    @RequestMapping(value={"checkPlat.json"}, name="\u68c0\u6d4b\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean checkPlat(HttpServletRequest request) {
        if (this.checkMemquaPlat(request)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(CODE + ".checkMemquaPlat", "\u975e\u5e73\u53f0\u7528\u6237");
    }

    @RequestMapping(value={"checkMerchant.json"}, name="\u68c0\u6d4b\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5546\u5bb6")
    @ResponseBody
    public HtmlJsonReBean checkMerchant(HttpServletRequest request) {
        if (this.checkMemquaMerchant(request)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(CODE + ".checkMemquaPlat", "\u975e\u5546\u5bb6\u7528\u6237");
    }

    @RequestMapping(value={"loginIn.json"})
    public ResponseEntity<HtmlJsonReBean> loginIn(HttpServletRequest request, HttpServletResponse response, String loginName, String passwd, String code, String redirectURL) {
        String proappCode;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)passwd)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        String tenantCode = this.getTenantCode(request);
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        Map result = this.osOAuthLoginServiceRepository.validateLogin(loginName, passwd, browType, proappCode = this.getProappCode(request), tenantCode);
        if (!((Boolean)result.get("flag")).booleanValue() || null == result.get("session")) {
            this.sendLoginLog(request, loginName, tenantCode, proappCode);
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.no", result.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        UserSession userSession = (UserSession)JsonUtil.getAllJsonUtil().getJsonToObject(result.get("session").toString(), UserSession.class);
        if (null == userSession) {
            this.sendLoginLog(request, loginName, tenantCode, proappCode);
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.session", result.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        this.setUserSession(request, response, userSession);
        if (StringUtils.isBlank((String)redirectURL)) {
            redirectURL = userSession.getLoginIndexUrl();
        }
        return new ResponseEntity((Object)new HtmlJsonReBean((Object)redirectURL), (MultiValueMap)headers, HttpStatus.OK);
    }

    private void sendLoginLog(HttpServletRequest request, String loginName, String tenantCode, String proappCode) {
        UmUserlogininfoDomainBean umUserlogininfoDomainBean = new UmUserlogininfoDomainBean();
        umUserlogininfoDomainBean.setAppmanageIcode(proappCode);
        umUserlogininfoDomainBean.setLoginIp(this.getClientIp(request));
        umUserlogininfoDomainBean.setTenantCode(tenantCode);
        umUserlogininfoDomainBean.setUserCode(loginName);
        umUserlogininfoDomainBean.setUserName(loginName);
        try {
            this.userLogininfoServiceRepository.saveUserlogininfo(umUserlogininfoDomainBean);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @RequestMapping(value={"loginOut.json"})
    @ResponseBody
    public HtmlJsonReBean loginOut(HttpServletRequest request, HttpServletResponse response) {
        String token = this.getToken(request);
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        this.osOAuthLoginServiceRepository.LoginOut(token, browType, proappCode, tenantCode);
        this.setUserSession(request, response, null);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getVerCode.img"})
    @ResponseBody
    public void getVerCode(HttpServletRequest request, HttpServletResponse response) {
        String tenantCode = this.getTenantCode(request);
        String verCode = "";
        Map result = this.rdRandomListServiceRepository.createRandom("2", request.getRemoteAddr(), ServletMain.getAppName(), tenantCode);
        if (((Boolean)result.get("flag")).booleanValue()) {
            response.setHeader("Content-Type", "image/jped");
            response.setDateHeader("expries", -1L);
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            verCode = (String)result.get("message");
            BufferedImage bufferedImage = new VerifyImgUtils(verCode).getBuffImg();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                this.logger.error(CODE + ".getVerCode.write", (Throwable)e);
            }
        } else {
            this.logger.error(CODE + ".getVerCode.err", (Object)("result is " + result));
        }
    }
}

