/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.controller;

import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthLoginServiceRepository;
import com.qjsoft.laser.controller.facade.rd.repository.RdRandomListServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.BrowTypeUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.VerifyImgUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ml/mlogin"})
public class MloginCon
extends SpringmvcController {
    private static String CODE = "ml.mlogin.con";
    @Autowired
    private RdRandomListServiceRepository rdRandomListServiceRepository;
    @Autowired
    private OsOAuthLoginServiceRepository osOAuthLoginServiceRepository;

    protected String getContext() {
        return "mlogin";
    }

    @RequestMapping(value={"noresource"})
    public String noresource(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noresource";
    }

    @RequestMapping(value={"noper"})
    public String noper(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noper";
    }

    @RequestMapping(value={"logininfo.json"})
    @ResponseBody
    public HtmlJsonReBean login(HttpServletRequest request, HttpServletResponse response) {
        UserSession userSession = this.getUserSession(request);
        this.setUserSession(request, response, userSession);
        UserInfo userInfo = this.getUserInfo(request);
        return new HtmlJsonReBean((Object)userInfo);
    }

    @RequestMapping(value={"loginIn.json"})
    public ResponseEntity<HtmlJsonReBean> loginIn(HttpServletRequest request, HttpServletResponse response, String loginName, String passwd, String code, String redirectURL) {
        String proappCode;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)passwd)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        String tenantCode = this.getTenantCode(request);
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        Map result = this.osOAuthLoginServiceRepository.validateLogin(loginName, passwd, browType, proappCode = this.getProappCode(request), tenantCode);
        if (!((Boolean)result.get("flag")).booleanValue()) {
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.no", result.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        UserSession userSession = (UserSession)JsonUtil.getAllJsonUtil().getJsonToObject(result.get("session").toString(), UserSession.class);
        this.setUserSession(request, response, userSession);
        return new ResponseEntity((Object)new HtmlJsonReBean((Object)redirectURL), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"loginOut.json"})
    @ResponseBody
    public HtmlJsonReBean loginOut(HttpServletRequest request, HttpServletResponse response) {
        String token = this.getToken(request);
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        this.osOAuthLoginServiceRepository.LoginOut(token, browType, proappCode, tenantCode);
        this.setUserSession(request, response, null);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getVerCode.img"})
    @ResponseBody
    public void getVerCode(HttpServletRequest request, HttpServletResponse response) {
        String tenantCode = this.getTenantCode(request);
        String verCode = "";
        Map result = this.rdRandomListServiceRepository.createRandom("2", request.getRemoteAddr(), ServletMain.getAppName(), tenantCode);
        if (((Boolean)result.get("flag")).booleanValue()) {
            response.setHeader("Content-Type", "image/jped");
            response.setDateHeader("expries", -1L);
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            verCode = (String)result.get("message");
            BufferedImage bufferedImage = new VerifyImgUtils(verCode).getBuffImg();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                this.logger.error(CODE + ".getVerCode.write", (Throwable)e);
            }
        } else {
            this.logger.error(CODE + ".getVerCode.err", (Object)("result is " + result));
        }
    }
}

