/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.os.domain.OsOAuthEnvconfigReDomain;
import com.qjsoft.laser.controller.facade.os.domain.WeChartOpenIDBean;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthEnvconfigServiceRepository;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthThirdLoginRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ml/baidu"})
public class BaiduCon
extends SpringmvcController {
    @Autowired
    private OsOAuthEnvconfigServiceRepository osOAuthEnvconfigServiceRepository;
    @Autowired
    private OsOAuthThirdLoginRepository osOAuthThirdLoginRepository;
    private static String CODE = "ml.baidu.con";

    protected String getContext() {
        return "baidu";
    }

    @RequestMapping(value={"getList.json"}, name="\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u5168\u7c7b\u76ee\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean getList(HttpServletRequest request, String category_type) {
        if (StringUtils.isBlank((String)category_type)) {
            this.logger.error(CODE + ".getList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6ca1\u6709\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u5168\u7c7b\u76ee\u5217\u8868");
        }
        String json = this.MicroMessengerGetList(request, category_type);
        return new HtmlJsonReBean((Object)json);
    }

    @RequestMapping(value={"uploadPro.json"}, name="\u6388\u6743\u5c0f\u7a0b\u5e8f\u4e0a\u4f20\u5305")
    @ResponseBody
    public HtmlJsonReBean uploadPro(HttpServletRequest request, String ext_json, String template_id, String user_desc, String user_version) {
        if (StringUtils.isBlank((String)ext_json) || StringUtils.isBlank((String)template_id) || StringUtils.isBlank((String)user_desc) || StringUtils.isBlank((String)user_version)) {
            this.logger.error(CODE + ".uploadPro", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6388\u6743\u5c0f\u7a0b\u5e8f\u4e0a\u4f20\u5305\u5931\u8d25");
        }
        String json = this.MicroMessengerUploadPro(request, ext_json, template_id, user_desc, user_version);
        return new HtmlJsonReBean((Object)json);
    }

    @RequestMapping(value={"baiduCheck.json"}, name="\u6388\u6743\u5c0f\u7a0b\u5e8f\u63d0\u4ea4\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean baiduCheck(HttpServletRequest request, String content, String package_id, String remark) {
        if (StringUtils.isBlank((String)content) || StringUtils.isBlank((String)package_id) || StringUtils.isBlank((String)remark)) {
            this.logger.error(CODE + ".baiduCheck", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6388\u6743\u5c0f\u7a0b\u5e8f\u63d0\u4ea4\u5ba1\u6838\u5931\u8d25");
        }
        String json = this.MicroMessengerBaiDuCheck(request, content, package_id, remark);
        return new HtmlJsonReBean((Object)json);
    }

    @RequestMapping(value={"baiduPublish.json"}, name="\u6388\u6743\u5c0f\u7a0b\u5e8f\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean baiduCheck(HttpServletRequest request, String package_id) {
        if (StringUtils.isBlank((String)package_id)) {
            this.logger.error(CODE + ".baiduPublish", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6388\u6743\u5c0f\u7a0b\u5e8f\u53d1\u5e03\u5931\u8d25");
        }
        String json = this.MicroMessengerBaiDuPublish(request, package_id);
        return new HtmlJsonReBean((Object)json);
    }

    private String MicroMessengerGetList(HttpServletRequest request, String category_type) {
        String access_token = this.getComponentAccessToken(request);
        HtmlJsonReBean htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerGetList(access_token, category_type);
        if (null == htmlJsonReBean) {
            this.logger.error(CODE + "MicroMessengerGetList is null");
            return null;
        }
        String json = (String)htmlJsonReBean.getDataObj();
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(CODE + ".MicroMessengerGetList.json is null");
            return null;
        }
        return json;
    }

    private String MicroMessengerUploadPro(HttpServletRequest request, String ext_json, String template_id, String user_desc, String user_version) {
        String access_token = this.getComponentAccessToken(request);
        HtmlJsonReBean htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerUploadPro(access_token, ext_json, template_id, user_desc, user_version);
        if (null == htmlJsonReBean) {
            this.logger.error(CODE + "MicroMessengerUploadPro is null");
            return null;
        }
        String json = (String)htmlJsonReBean.getDataObj();
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(CODE + ".MicroMessengerUploadPro.json is null");
            return null;
        }
        return json;
    }

    private String MicroMessengerBaiDuCheck(HttpServletRequest request, String content, String package_id, String remark) {
        String access_token = this.getComponentAccessToken(request);
        HtmlJsonReBean htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerBaiDuCheck(access_token, content, package_id, remark);
        if (null == htmlJsonReBean) {
            this.logger.error(CODE + "MicroMessengerBaiDuCheck is null");
            return null;
        }
        String json = (String)htmlJsonReBean.getDataObj();
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(CODE + ".MicroMessengerBaiDuCheck.json is null");
            return null;
        }
        return json;
    }

    private String MicroMessengerBaiDuPublish(HttpServletRequest request, String package_id) {
        String access_token = this.getComponentAccessToken(request);
        HtmlJsonReBean htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerBaiDuPublish(access_token, package_id);
        if (null == htmlJsonReBean) {
            this.logger.error(CODE + "MicroMessengerBaiDuPublish is null");
            return null;
        }
        String json = (String)htmlJsonReBean.getDataObj();
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(CODE + ".MicroMessengerBaiDuPublish.json is null");
            return null;
        }
        return json;
    }

    private String getComponentAccessToken(HttpServletRequest request) {
        Map<String, Object> map = this.getOAuthEnvconfig(request);
        if (null == map || map.isEmpty()) {
            return null;
        }
        String access_token = request.getParameter("access_token");
        if (StringUtils.isBlank((String)access_token)) {
            WeChartOpenIDBean weChartOpenIDBean = this.getMiniToken(request);
            if (null == weChartOpenIDBean || StringUtils.isBlank((String)weChartOpenIDBean.getAccess_token())) {
                this.logger.error(CODE + ".access_token is null");
                return null;
            }
            access_token = weChartOpenIDBean.getAccess_token();
        }
        return access_token;
    }

    private Map<String, Object> getOAuthEnvconfig(HttpServletRequest request) {
        String proappCode;
        String oauthEnvCode;
        String tenantCode = this.getTenantCode(request);
        List nlist = this.osOAuthEnvconfigServiceRepository.queryOAuthEnvconfigByEnvCode(tenantCode, oauthEnvCode = this.getOauthEnvCode(request), proappCode = this.getProappCode(request));
        if (null == nlist || nlist.isEmpty()) {
            this.logger.error(CODE + ".getOAuthEnvconfig.nlist", (Object)(tenantCode + "-" + oauthEnvCode + "-" + proappCode));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (OsOAuthEnvconfigReDomain osOAuthEnvconfigReDomain : nlist) {
            map.put(osOAuthEnvconfigReDomain.getOauthEnvconfigType(), osOAuthEnvconfigReDomain.getOauthEnvconfigValue());
        }
        this.logger.error(CODE + ".getOAuthEnvconfig.map", (Object)(tenantCode + "-" + oauthEnvCode + "-" + proappCode + ":" + ((Object)map).toString()));
        return map;
    }

    private WeChartOpenIDBean getMiniToken(HttpServletRequest request) {
        String tenantCode;
        String secret;
        Map<String, Object> map = this.getOAuthEnvconfig(request);
        if (null == map || map.isEmpty()) {
            return null;
        }
        String appid = (String)map.get("appid");
        HtmlJsonReBean htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerPageLogin(appid, secret = (String)map.get("secret"), "client_credential", tenantCode = this.getTenantCode(request));
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            this.logger.error(CODE + ".getMiniToken.htmlJsonReBean", (Object)map.toString());
            return null;
        }
        String json = (String)htmlJsonReBean.getDataObj();
        WeChartOpenIDBean weChartOpenIDBean = (WeChartOpenIDBean)JsonUtil.buildNormalBinder().getJsonToObject(json, WeChartOpenIDBean.class);
        if (null == weChartOpenIDBean || StringUtils.isBlank((String)weChartOpenIDBean.getAccess_token())) {
            this.logger.error(CODE + ".getMiniToken.weChartOpenIDBean2");
            return null;
        }
        return weChartOpenIDBean;
    }
}

