/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ml/popupWindow"})
public class UserPopupWindowCon
extends SpringmvcController {
    private static String CODE = "ml.userPopupWindow.con";

    @RequestMapping(value={"getUserPopupWindow.json"}, name="\u83b7\u53d6\u5f39\u6846")
    @ResponseBody
    public HtmlJsonReBean getUserPopupWindow(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getUserPopupWindow", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("popupWindow", false);
        String tenantCode = userSession.getTenantCode();
        String key = tenantCode.concat("-").concat(userSession.getUserinfoParentCode()).concat("-").concat(userSession.getUserPcode());
        String dateString = DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd");
        String popupWindow = this.getUrl(tenantCode, "popupWindow", "popupWindow");
        if (StringUtils.isBlank((String)popupWindow)) {
            return new HtmlJsonReBean(param);
        }
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(popupWindow, String.class, Object.class);
        if (MapUtil.isEmpty((Map)map)) {
            return new HtmlJsonReBean(param);
        }
        Integer todayNum = null == map.get("todayNum") ? 0 : Integer.valueOf(map.get("todayNum").toString());
        Integer totalNum = null == map.get("totalNum") ? 0 : Integer.valueOf(map.get("totalNum").toString());
        String todayValue = SupDisUtil.getMap((String)(key + "-today"), (String)dateString);
        String totalValue = SupDisUtil.get((String)(key + "-total"));
        Integer todNum = 0;
        Integer totNum = 0;
        if (StringUtils.isNotBlank((String)todayValue)) {
            todNum = Integer.valueOf(todayValue) + 1;
        }
        if (StringUtils.isNotBlank((String)totalValue)) {
            totNum = Integer.valueOf(totalValue) + 1;
        }
        if (todNum >= todayNum) {
            return new HtmlJsonReBean(param);
        }
        if (totNum >= totalNum) {
            return new HtmlJsonReBean(param);
        }
        SupDisUtil.setMap((String)(key + "-today"), (String)dateString, (String)todNum.toString());
        SupDisUtil.set((String)(key + "-total"), (String)totNum.toString());
        param.put("popupWindow", true);
        return new HtmlJsonReBean(param);
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd"));
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    protected String getContext() {
        return "userPopupWindow";
    }
}

