/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.controller.task;

import com.qjsoft.laser.controller.mlogin.controller.task.DataFetcher;
import com.qjsoft.laser.controller.mlogin.controller.task.DataProcessor;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;

public class PagedDataProcessor {
    private static final String CODE = "mlogin.PagedDataProcessor";

    public static <T> void process(DataFetcher<T> fetcher, DataProcessor<T> processor, int pageSize, SupperLogUtil logger) {
        long startTime = System.currentTimeMillis();
        int pageNum = 1;
        try {
            SupQueryResult<T> result;
            do {
                if ((result = fetcher.fetch(pageNum, pageSize)) == null || result.getList() == null || result.getList().isEmpty()) continue;
                processor.process(result.getList());
                ++pageNum;
            } while (result != null && result.getList().size() == pageSize);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5206\u9875\u5904\u7406\u5931\u8d25", e);
        }
        logger.error("mlogin.PagedDataProcessor.process.\u6267\u884c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
    }
}

