/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class DecimalFormatter {
    public static String format(BigDecimal value) {
        if (value == null) {
            return "";
        }
        BigDecimal stripped = value.stripTrailingZeros();
        String plainStr = stripped.toPlainString();
        if (plainStr.contains(".")) {
            String[] parts = plainStr.split("\\.");
            String integerPart = parts[0];
            String decimalPart = parts[1];
            if (decimalPart.equals("0")) {
                return integerPart;
            }
        }
        return plainStr;
    }

    public static String formatWithScale(BigDecimal value, int scale) {
        if (value == null) {
            return "";
        }
        BigDecimal rounded = value.setScale(scale, RoundingMode.HALF_UP);
        return DecimalFormatter.format(rounded);
    }

    public static void main(String[] args) {
        System.out.println(DecimalFormatter.format(new BigDecimal("1.200")));
        System.out.println(DecimalFormatter.format(new BigDecimal("5")));
        System.out.println(DecimalFormatter.format(new BigDecimal("3.0")));
        System.out.println(DecimalFormatter.format(new BigDecimal("0.0050")));
        System.out.println(DecimalFormatter.format(new BigDecimal("123.45600")));
        System.out.println(DecimalFormatter.formatWithScale(new BigDecimal("1.2345"), 2));
        System.out.println(DecimalFormatter.formatWithScale(new BigDecimal("1.2000"), 2));
        System.out.println(DecimalFormatter.formatWithScale(new BigDecimal("5.00"), 2));
    }
}

