/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmCouponBatchDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmCouponBatchGoodsDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmCouponBatchGoodsReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmCouponBatchReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionRangelistDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionSupDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmCouponBatchGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmCouponBatchServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.promotion.controller.PromotionSupCon;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pm/promotionSignUpCon"}, name="\u8425\u9500\u6279\u6b21")
public class PromotionSignUpCon
extends SpringmvcController {
    private static String CODE = "pm.promotionSignUpCon.con";
    @Autowired
    private PmCouponBatchServiceRepository pmCouponBatchServiceRepository;
    @Autowired
    private PmCouponBatchGoodsServiceRepository pmCouponBatchGoodsServiceRepository;
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    protected static String TYPE_PLAT = "plat";
    protected static String TYPE_BUS = "bus";
    protected static String TYPE_USER = "user";
    protected static String TYPE_STORE = "store";

    protected String getContext() {
        return "promotionSignUpCon";
    }

    @RequestMapping(value={"savePromotionSeckillBatch.json"}, name="\u589e\u52a0\u79d2\u6740(\u589e\u52a0\u6279\u6b21)")
    @ResponseBody
    public HtmlJsonReBean savePromotionSeckillBatch(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, "channelCode", null, "0007", PromotionSupCon.TYPE_BUS);
    }

    protected HtmlJsonReBean savePromotionPlus(HttpServletRequest request, String paramStr, String channelCode, String memberCode, String pbCode, String type) {
        ArrayList pmPromotionDisLists;
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = userSession.getTenantCode();
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        promotionDomain.setPbCode(pbCode);
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                saveMemberCode = userSession.getUserinfoParentCode();
                saveMemberName = userSession.getUserinfoParentName();
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelName(), request));
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelCode(), request));
            promotionDomain.setGoodsClass(this.getGoodsClassByMem(promotionDomain.getChannelCode(), request));
        }
        if (StringUtils.isNotBlank((String)channelCode) && null == (pmPromotionDisLists = promotionDomain.getPmPromotionDisList())) {
            pmPromotionDisLists = new ArrayList();
            promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            ArrayList<PmPromotionSupDomain> pmPromotionSupDomains = promotionDomain.getPmPromotionSupList();
            if (null == pmPromotionSupDomains) {
                pmPromotionSupDomains = new ArrayList<PmPromotionSupDomain>();
                promotionDomain.setPmPromotionSupList(pmPromotionSupDomains);
            }
            PmPromotionSupDomain pmPromotionSupDomain = new PmPromotionSupDomain();
            pmPromotionSupDomain.setPpsupMemcode(saveMemberCode);
            pmPromotionSupDomain.setPpsupName(saveMemberName);
            pmPromotionSupDomains.add(pmPromotionSupDomain);
        }
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        promotionDomain.setTenantCode(tenantCode);
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        List pmPromotionRangeList = promotionDomain.getPmPromotionRangeList();
        if (ListUtil.isNotEmpty((Collection)pmPromotionRangeList)) {
            promotionDomain.setCouponOnceNums(((PmPromotionRangelistDomain)pmPromotionRangeList.get(0)).getDiscountAmount());
        }
        PmCouponBatchDomain pmCouponBatchDomain = new PmCouponBatchDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmCouponBatchDomain, (Object)promotionDomain);
            pmCouponBatchDomain.setCouponBatchOrgin(promotionDomain.getPromotionOrgin());
            pmCouponBatchDomain.setCouponBatchName(promotionDomain.getPromotionName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pmCouponBatchDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
        pmCouponBatchDomain.setChannelName(userSession.getUserName());
        pmCouponBatchDomain.setTenantCode(tenantCode);
        pmCouponBatchDomain.setMemberCode(userSession.getUserPcode());
        pmCouponBatchDomain.setPromotionTerstr(JsonUtil.buildNonDefaultBinder().toJson((Object)promotionDomain));
        HtmlJsonReBean htmlJsonReBean = this.pmCouponBatchServiceRepository.saveCouponBatch(pmCouponBatchDomain);
        if (!htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        if (0 == promotionDomain.getPromotionOrgin() && ListUtil.isNotEmpty((Collection)promotionDomain.getPmPromotionRangeList())) {
            Object dataObj = htmlJsonReBean.getDataObj();
            ArrayList<PmCouponBatchGoodsDomain> pmCouponBatchGoodsDomainList = new ArrayList<PmCouponBatchGoodsDomain>();
            for (PmPromotionRangelistDomain pmPromotionRangelistDomain : promotionDomain.getPmPromotionRangeList()) {
                PmCouponBatchGoodsDomain pmCouponBatchGoodsDomain = new PmCouponBatchGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)pmCouponBatchGoodsDomain, (Object)pmPromotionRangelistDomain);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ArrayList<PmPromotionRangelistDomain> getPmPromotionRangeList = new ArrayList<PmPromotionRangelistDomain>();
                pmCouponBatchGoodsDomain.setCouponBatchCode((String)dataObj);
                pmCouponBatchGoodsDomain.setTenantCode(tenantCode);
                pmCouponBatchGoodsDomainList.add(pmCouponBatchGoodsDomain);
                getPmPromotionRangeList.add(pmPromotionRangelistDomain);
                promotionDomain.setPmPromotionRangeList(getPmPromotionRangeList);
                promotionDomain.setCouponBatchCode((String)dataObj);
                promotionDomain.setPromotionFrequency(pmPromotionRangelistDomain.getCouponOnceUnum());
                promotionDomain.setCouponOnceNums(pmPromotionRangelistDomain.getDiscountAmount());
                this.pmPromotionServiceRepository.savePromotion(promotionDomain);
            }
            this.pmCouponBatchGoodsServiceRepository.saveCouponBatchGoodsBatch(pmCouponBatchGoodsDomainList);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateCouponBatch.json"}, name="\u66f4\u65b0\u8425\u9500\u6279\u6b21")
    @ResponseBody
    public HtmlJsonReBean updateCouponBatch(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmCouponBatchDomain pmCouponBatchDomain = (PmCouponBatchDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmCouponBatchDomain.class);
        return this.pmCouponBatchServiceRepository.updateCouponSelectiveBatch(pmCouponBatchDomain);
    }

    @RequestMapping(value={"updateCouponBatchState.json"}, name="\u66f4\u65b0\u8425\u9500\u6279\u6b21\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCouponBatchState(String couponBatchId, Integer dataState, Integer oldDataState, HttpServletRequest request) {
        SupQueryResult promotionPage;
        if (StringUtils.isBlank((String)couponBatchId)) {
            this.logger.error(CODE + ".updateCouponBatchState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String memo = request.getParameter("memo");
        PmCouponBatchReDomain couponBatch = this.pmCouponBatchServiceRepository.getCouponBatch(Integer.valueOf(couponBatchId));
        if (couponBatch == null) {
            this.logger.error(CODE + ".updateCouponBatchState", (Object)Integer.valueOf(couponBatchId));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u5f02\u5e38");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memo", memo);
        HtmlJsonReBean htmlJsonReBean = this.pmCouponBatchServiceRepository.updateCouponBatchState(Integer.valueOf(couponBatchId), dataState, oldDataState, map);
        if (htmlJsonReBean != null && htmlJsonReBean.isSuccess() && (promotionPage = this.pmPromotionServiceRepository.queryPromotionPage(this.getQueryMapParam("couponBatchCode,tenantCode", new Object[]{couponBatch.getCouponBatchCode(), couponBatch.getTenantCode()}))) != null && ListUtil.isNotEmpty((Collection)promotionPage.getList())) {
            for (PmPromotionReDomain pmPromotionReDomain : promotionPage.getList()) {
                this.pmPromotionServiceRepository.updatePromotionState(pmPromotionReDomain.getPromotionId(), dataState, null, null);
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryCouponBatchPage.json"}, name="\u67e5\u8be2\u8425\u9500\u6279\u6b21\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmCouponBatchReDomain> queryCouponBatchPage(HttpServletRequest request, String orderFlag) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("pbCode", "0007");
        }
        if ("true".equals(orderFlag)) {
            ArrayList couponBatchListOrderByState = new ArrayList();
            HashMap<String, Object> dataStateMap1 = new HashMap<String, Object>();
            dataStateMap1.put("dataState", 1);
            dataStateMap1.put("orderStr", "PROMOTION_ENDTIME asc");
            dataStateMap1.putAll(param);
            SupQueryResult pmCouponBatchReDomainSupQueryResult = this.pmCouponBatchServiceRepository.queryCouponBatchPage(dataStateMap1);
            if (ListUtil.isNotEmpty((Collection)pmCouponBatchReDomainSupQueryResult.getList())) {
                couponBatchListOrderByState.addAll(pmCouponBatchReDomainSupQueryResult.getList());
            }
            dataStateMap1.put("dataState", 4);
            dataStateMap1.put("orderStr", "PROMOTION_BEGINTIME asc");
            SupQueryResult pmCouponBatchReDomainSupQueryResult1 = this.pmCouponBatchServiceRepository.queryCouponBatchPage(dataStateMap1);
            if (ListUtil.isNotEmpty((Collection)pmCouponBatchReDomainSupQueryResult1.getList())) {
                couponBatchListOrderByState.addAll(pmCouponBatchReDomainSupQueryResult1.getList());
            }
            SupQueryResult returnSupQueryResult = new SupQueryResult();
            returnSupQueryResult.setList(couponBatchListOrderByState);
            returnSupQueryResult.setTotal((long)couponBatchListOrderByState.size());
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(couponBatchListOrderByState.size());
            returnSupQueryResult.setPageTools((SupPageTools)pageTools);
            return returnSupQueryResult;
        }
        return this.pmCouponBatchServiceRepository.queryCouponBatchPage(param);
    }

    @RequestMapping(value={"queryCouponBatchPageNew.json"}, name="\u67e5\u8be2\u8425\u9500\u6279\u6b21\u5206\u9875\u5217\u8868(\u9700\u8981\u62a5\u540d\u4e14\u8fdb\u884c\u4e2d)")
    @ResponseBody
    public SupQueryResult<PmCouponBatchReDomain> queryCouponBatchPageNew(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("pbCode", "0007");
            param.put("dataState", 4);
            param.put("couponBatchOrgin", 1);
        }
        return this.pmCouponBatchServiceRepository.queryCouponBatchPage(param);
    }

    @RequestMapping(value={"getCouponBatchByCode.json"}, name="\u67e5\u770b\u8be6\u60c5")
    @ResponseBody
    public PmCouponBatchReDomain toWithdraw(HttpServletRequest request, String couponBatchCode) {
        if (StringUtils.isBlank((String)couponBatchCode)) {
            this.logger.error(CODE + ".toWithdraw", (Object)"param is null");
            return null;
        }
        return this.pmCouponBatchServiceRepository.getCouponBatchByCode(this.getTenantCode(request), couponBatchCode);
    }

    @RequestMapping(value={"queryCouponBatchGoodsPage.json"}, name="\u67e5\u8be2\u8425\u9500\u5546\u54c1\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmCouponBatchGoodsReDomain> queryCouponBatchGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if ("006".equals(this.getProappCode(request))) {
            param.put("memberCode", this.getUserSession(request).getUserPcode());
            param.put("pprlOpcode3", "supplier");
        }
        return this.pmCouponBatchGoodsServiceRepository.queryCouponBatchGoodsPage(param);
    }

    @RequestMapping(value={"queryCouponBatchGoodsPagePlat.json"}, name="\u67e5\u8be2\u8425\u9500\u5546\u54c1\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmCouponBatchGoodsReDomain> queryCouponBatchGoodsPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("pprlOpcode3", "supplier");
        }
        return this.pmCouponBatchGoodsServiceRepository.queryCouponBatchGoodsPage(param);
    }

    @RequestMapping(value={"queryCouponBatchGoodsPageByuser.json"}, name="\u67e5\u8be2\u8425\u9500\u5546\u54c1\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmCouponBatchGoodsReDomain> queryCouponBatchGoodsPageByuser(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberCode", userSession.getUserPcode());
            param.put("pprlOpcode3", "supplier");
        }
        return this.pmCouponBatchGoodsServiceRepository.queryCouponBatchGoodsPage(param);
    }

    @RequestMapping(value={"updateCouponBatchGoodsState.json"}, name="\u66f4\u65b0\u8425\u9500\u5546\u54c1\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCouponBatchGoodsState(String couponBatchGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)couponBatchGoodsId)) {
            this.logger.error(CODE + ".updateCouponBatchGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmCouponBatchGoodsServiceRepository.updateCouponBatchGoodsState(Integer.valueOf(couponBatchGoodsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateCouponGoodsStateBatch.json"}, name="\u66f4\u65b0\u8425\u9500\u5546\u54c1\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCouponGoodsStateBatch(String couponBatchGoodsIdStr, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)couponBatchGoodsIdStr)) {
            this.logger.error(CODE + ".updateCouponBatchGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] ids = couponBatchGoodsIdStr.split(",");
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        for (String id : ids) {
            htmlJsonReBean = this.pmCouponBatchGoodsServiceRepository.updateCouponBatchGoodsState(Integer.valueOf(id), dataState, oldDataState, null);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryCouponBatchPageByOrgin.json"}, name="\u67e5\u8be2\u8425\u9500\u6279\u6b21\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmCouponBatchReDomain> queryCouponBatchPageByOrgin(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("couponBatchOrgin", 1);
            param.put("dataStateStr", "4,1,2,6");
        }
        return this.pmCouponBatchServiceRepository.queryCouponBatchPage(param);
    }

    @RequestMapping(value={"saveCouponBatchGoods.json"}, name="\u589e\u52a0\u8425\u9500\u5546\u54c1\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveCouponBatchGoods(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List pmCouponBatchGoodsDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, PmCouponBatchGoodsDomain.class);
        UserSession userSession = this.getUserSession(request);
        for (PmCouponBatchGoodsDomain pmCouponBatchGoodsDomain : pmCouponBatchGoodsDomainList) {
            pmCouponBatchGoodsDomain.setTenantCode(userSession.getTenantCode());
            pmCouponBatchGoodsDomain.setMemberCode(userSession.getUserPcode());
            pmCouponBatchGoodsDomain.setMemberName(userSession.getMerberCompname());
            pmCouponBatchGoodsDomain.setPprlOpcode3("supplier");
        }
        return this.pmCouponBatchGoodsServiceRepository.saveCouponBatchGoodsBatch(pmCouponBatchGoodsDomainList);
    }
}

