/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsPropertiesValueDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPropertiesValueReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsPropertiesValueServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/propvalue"}, name="\u5546\u54c1\u5c5e\u6027\u503c")
public class RsPropertiesValueCon
extends SpringmvcController {
    @Autowired
    private RsPropertiesValueServiceRepository rsPropertiesValueServiceRepository;
    private static String CODE = "rs.propvalue.con";

    protected String getContext() {
        return "propvalue";
    }

    @RequestMapping(value={"savePropValue.json"}, name="\u589e\u52a0\u5546\u54c1\u5c5e\u6027\u503c")
    @ResponseBody
    public HtmlJsonReBean savePropValue(HttpServletRequest request, RsPropertiesValueDomain rsPropertiesValueDomain) {
        if (null == rsPropertiesValueDomain) {
            this.logger.error(CODE + ".savePropValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsPropertiesValueDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPropertiesValueServiceRepository.savePropertiesValue(rsPropertiesValueDomain);
    }

    @RequestMapping(value={"getPropValue.json"}, name="\u83b7\u53d6\u5546\u54c1\u5c5e\u6027\u503c\u4fe1\u606f")
    @ResponseBody
    public RsPropertiesValueDomain getPropValue(String propertiesValueId) {
        if (StringUtils.isBlank((String)propertiesValueId)) {
            this.logger.error(CODE + ".getPropValue", (Object)"param is null");
            return null;
        }
        return this.rsPropertiesValueServiceRepository.getPropertiesValue(Integer.valueOf(propertiesValueId));
    }

    @RequestMapping(value={"updatePropertiesValue.json"}, name="\u7f16\u8f91\u5546\u54c1\u5c5e\u6027\u503c")
    @ResponseBody
    public HtmlJsonReBean updatePropertiesValue(HttpServletRequest request, RsPropertiesValueDomain rsPropertiesValueDomain) {
        if (null == rsPropertiesValueDomain) {
            this.logger.error(CODE + ".updatePropertiesValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsPropertiesValueDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPropertiesValueServiceRepository.updatePropertiesValue(rsPropertiesValueDomain);
    }

    @RequestMapping(value={"deletePropertiesValue.json"}, name="\u5220\u9664\u5546\u54c1\u5c5e\u6027\u503c")
    @ResponseBody
    public HtmlJsonReBean deletePropertiesValue(String propertiesValueId) {
        if (StringUtils.isBlank((String)propertiesValueId)) {
            this.logger.error(CODE + ".deletePropertiesValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsPropertiesValueServiceRepository.deletePropertiesValue(Integer.valueOf(propertiesValueId));
    }

    @RequestMapping(value={"queryPropertiesValuePage.json"}, name="\u5546\u54c1\u5c5e\u6027\u503c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsPropertiesValueReDomain> queryPropertiesValuePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPropertiesValueServiceRepository.queryPropertiesValuePage(param);
    }

    @RequestMapping(value={"queryPropertiesByGoods.json"}, name="\u67e5\u8be2\u5546\u54c1\u4e0bsku\u7684\u5c5e\u6027\u503c")
    @ResponseBody
    public List<Map> queryPropertiesByGoods(HttpServletRequest request, String goodsCode) {
        if (StringUtils.isBlank((String)goodsCode)) {
            return null;
        }
        String trnantCode = this.getTenantCode(request);
        return this.rsPropertiesValueServiceRepository.queryPropertiesByGoods(trnantCode, goodsCode);
    }
}

