/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRtagDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRtagReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsRtagDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsRtagReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsRtagServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsRtagServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/rtag"}, name="\u5546\u54c1\u6807\u7b7e")
public class RtagCon
extends SpringmvcController {
    private static String CODE = "rs.rtag.con";
    @Autowired
    private RsRtagServiceRepository rsRtagServiceRepository;
    @Autowired
    private RsGoodsRtagServiceRepository rsGoodsRtagServiceRepository;

    protected String getContext() {
        return "rtag";
    }

    @RequestMapping(value={"saveRtag.json"}, name="\u589e\u52a0\u5546\u54c1\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean saveRtag(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveRtag.paramStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        RsRtagDomain rsRtagDomain = this.makeRsRtagDomain(paramStr);
        if (null == rsRtagDomain) {
            this.logger.error(CODE + ".saveRtag.rsRtagDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        UserSession userSession = this.getUserSession(request);
        rsRtagDomain.setTenantCode(this.getTenantCode(request));
        rsRtagDomain.setRtagType("0");
        rsRtagDomain.setUserCode(userSession.getUserCode());
        rsRtagDomain.setMemberCode(userSession.getUserPcode());
        rsRtagDomain.setMemberName(userSession.getMerberCompname());
        return this.rsRtagServiceRepository.saveRtag(rsRtagDomain);
    }

    private RsRtagDomain makeRsRtagDomain(String paramStr) {
        RsGoodsRtagDomain rsGoodsRtagDomain;
        RsRtagDomain rsRtagDomain = (RsRtagDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RsRtagDomain.class);
        if (null == rsRtagDomain) {
            this.logger.error(CODE + ".saveRtag.rsRtagDomain", (Object)paramStr);
            return null;
        }
        if (StringUtils.isBlank((String)rsRtagDomain.getRtagName())) {
            this.logger.error(CODE + ".saveRtag.rtagName", (Object)paramStr);
            return null;
        }
        if (StringUtils.isBlank((String)rsRtagDomain.getRtagContent())) {
            this.logger.error(CODE + ".saveRtag.getRtagContent", (Object)paramStr);
            return null;
        }
        if (StringUtils.isBlank((String)rsRtagDomain.getRtagFont())) {
            this.logger.error(CODE + ".saveRtag.getRtagFont", (Object)paramStr);
            return null;
        }
        if (StringUtils.isBlank((String)rsRtagDomain.getRtagBack())) {
            this.logger.error(CODE + ".saveRtag.getRtagBack", (Object)paramStr);
            return null;
        }
        if (StringUtils.isBlank((String)rsRtagDomain.getGoodsType())) {
            this.logger.error(CODE + ".saveRtag.getGoodsType", (Object)paramStr);
            return null;
        }
        ArrayList<RsGoodsRtagDomain> rsGoodsRtagDomainList = new ArrayList<RsGoodsRtagDomain>();
        if ("0".equals(rsRtagDomain.getGoodsType())) {
            rsGoodsRtagDomain = new RsGoodsRtagDomain();
            rsGoodsRtagDomain.setGoodsRtagType("1");
            rsGoodsRtagDomain.setGoodsRtagValuetype("goodsType");
            rsGoodsRtagDomain.setGoodsRtagValue("all");
            rsGoodsRtagDomainList.add(rsGoodsRtagDomain);
        } else {
            if (ListUtil.isEmpty((Collection)rsRtagDomain.getGoodsTypeList())) {
                this.logger.error(CODE + ".saveRtag.getGoodsTypeList", (Object)paramStr);
                return null;
            }
            List goodsTypeList = rsRtagDomain.getGoodsTypeList();
            for (String goodsType : goodsTypeList) {
                RsGoodsRtagDomain rsGoodsRtagDomain2 = new RsGoodsRtagDomain();
                rsGoodsRtagDomain2.setGoodsRtagType("1");
                rsGoodsRtagDomain2.setGoodsRtagValuetype("goodsType");
                rsGoodsRtagDomain2.setGoodsRtagValue(goodsType);
                rsGoodsRtagDomainList.add(rsGoodsRtagDomain2);
            }
        }
        if (StringUtils.isBlank((String)rsRtagDomain.getGoodsRange())) {
            this.logger.error(CODE + ".saveRtag.getGoodsRange", (Object)paramStr);
            return null;
        }
        if ("all".equals(rsRtagDomain.getGoodsRange())) {
            rsGoodsRtagDomain = new RsGoodsRtagDomain();
            rsGoodsRtagDomain.setGoodsRtagType("2");
            rsGoodsRtagDomain.setGoodsRtagValuetype("all");
            rsGoodsRtagDomain.setGoodsRtagValue("all");
            rsGoodsRtagDomainList.add(rsGoodsRtagDomain);
        } else {
            if (ListUtil.isEmpty((Collection)rsRtagDomain.getGoodsRangeList())) {
                this.logger.error(CODE + ".saveRtag.getGoodsRangeList", (Object)paramStr);
                return null;
            }
            for (RsGoodsRtagDomain goodsRtagDomain : rsRtagDomain.getGoodsRangeList()) {
                RsGoodsRtagDomain rsGoodsRtagDomain3 = new RsGoodsRtagDomain();
                rsGoodsRtagDomain3.setGoodsRtagType("2");
                rsGoodsRtagDomain3.setGoodsRtagValuetype(rsRtagDomain.getGoodsRange());
                if (StringUtils.isBlank((String)goodsRtagDomain.getGoodsRtagValue())) {
                    this.logger.error(CODE + ".saveRtag.getGoodsRtagValue", (Object)paramStr);
                    return null;
                }
                rsGoodsRtagDomain3.setGoodsRtagValue(goodsRtagDomain.getGoodsRtagValue());
                rsGoodsRtagDomain3.setGoodsRtagValuen(goodsRtagDomain.getGoodsRtagValuen());
                rsGoodsRtagDomain3.setGoodsRtagValue1(goodsRtagDomain.getGoodsRtagValue1());
                rsGoodsRtagDomain3.setGoodsRtagValue2(goodsRtagDomain.getGoodsRtagValue2());
                rsGoodsRtagDomainList.add(rsGoodsRtagDomain3);
            }
        }
        if (ListUtil.isEmpty(rsGoodsRtagDomainList)) {
            this.logger.error(CODE + ".saveRtag.rsGoodsRtagDomainList", (Object)paramStr);
            return null;
        }
        rsRtagDomain.setRsGoodsRtagDomainList(rsGoodsRtagDomainList);
        return rsRtagDomain;
    }

    @RequestMapping(value={"getRtag.json"}, name="\u83b7\u53d6\u5546\u54c1\u6807\u7b7e\u4fe1\u606f")
    @ResponseBody
    public RsRtagReDomain getRtag(HttpServletRequest request, String rtagCode) {
        if (StringUtils.isBlank((String)rtagCode)) {
            this.logger.error(CODE + ".getRtag", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        RsRtagReDomain rtagByCode = this.rsRtagServiceRepository.getRtagByCode(tenantCode, rtagCode);
        if (null != rtagByCode) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("rtagCode", rtagCode);
            map.put("tenantCode", tenantCode);
            map.put("goodsRtagType", "1");
            SupQueryResult supQueryResult = this.rsGoodsRtagServiceRepository.queryGoodsRtagPage(map);
            ArrayList<String> goodsTypeList = new ArrayList<String>();
            for (RsGoodsRtagReDomain rsGoodsRtagReDomain : supQueryResult.getList()) {
                goodsTypeList.add(rsGoodsRtagReDomain.getGoodsRtagValue());
            }
            rtagByCode.setGoodsTypeList(goodsTypeList);
        }
        return rtagByCode;
    }

    @RequestMapping(value={"updateRtag.json"}, name="\u66f4\u65b0\u5546\u54c1\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean updateRtag(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveRtag.paramStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        RsRtagDomain rsRtagDomain = this.makeRsRtagDomain(paramStr);
        if (null == rsRtagDomain) {
            this.logger.error(CODE + ".saveRtag.rsRtagDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isBlank((String)rsRtagDomain.getRtagCode())) {
            this.logger.error(CODE + ".saveRtag.getRtagCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UserSession userSession = this.getUserSession(request);
        rsRtagDomain.setTenantCode(this.getTenantCode(request));
        rsRtagDomain.setRtagType("0");
        rsRtagDomain.setUserCode(userSession.getUserCode());
        rsRtagDomain.setMemberCode(userSession.getUserPcode());
        rsRtagDomain.setMemberName(userSession.getMerberCompname());
        return this.rsRtagServiceRepository.updateRtag(rsRtagDomain);
    }

    @RequestMapping(value={"deleteRtag.json"}, name="\u5220\u9664\u5546\u54c1\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean deleteRtag(HttpServletRequest request, String rtagCode) {
        if (StringUtils.isBlank((String)rtagCode)) {
            this.logger.error(CODE + ".deleteRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] rtagCodes = rtagCode.split(",");
        String tenantCode = this.getTenantCode(request);
        for (String code : rtagCodes) {
            HtmlJsonReBean htmlJsonReBean = this.rsRtagServiceRepository.deleteRtagByCode(tenantCode, code);
            if (htmlJsonReBean.isSuccess()) continue;
            return htmlJsonReBean;
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryRtagPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u6807\u7b7e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsRtagReDomain> queryRtagPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsRtagServiceRepository.queryRtagPage(param);
    }

    @RequestMapping(value={"queryRtagPageByPlat.json"}, name="\u67e5\u8be2\u5546\u54c1\u6807\u7b7e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsRtagReDomain> queryRtagPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        return this.rsRtagServiceRepository.queryRtagPageByGoods(param);
    }

    @RequestMapping(value={"queryRtagPageByUser.json"}, name="\u67e5\u8be2\u5546\u54c1\u6807\u7b7e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsRtagReDomain> queryRtagPageUser(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("dataState", 1);
        }
        return this.rsRtagServiceRepository.queryRtagPageByGoods(param);
    }

    @RequestMapping(value={"queryGoodsRtagPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u6807\u7b7e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsGoodsRtagReDomain> queryGoodsRtagPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("goodsRtagType", "2");
            param.put("fuzzy", true);
        }
        return this.rsGoodsRtagServiceRepository.queryGoodsRtagPage(param);
    }

    @RequestMapping(value={"updateRtagState.json"}, name="\u66f4\u65b0\u5546\u54c1\u6807\u7b7e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRtagState(HttpServletRequest request, String rtagCode, String dataState, String oldDataState) {
        String[] rtagCodes;
        if (StringUtils.isBlank((String)rtagCode)) {
            this.logger.error(CODE + ".updateRtagState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String code : rtagCodes = rtagCode.split(",")) {
            HtmlJsonReBean htmlJsonReBean = this.rsRtagServiceRepository.updateRtagStateByCode(this.getTenantCode(request), code, dataState, oldDataState, null);
            if (htmlJsonReBean.isSuccess()) continue;
            return htmlJsonReBean;
        }
        return new HtmlJsonReBean();
    }
}

