/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.eq;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.eq.EqAuctionEnrollDomain;
import cn.com.qj.bff.domain.eq.EqAuctionEnrollReDomain;
import cn.com.qj.bff.domain.eq.EqAuctionGoodsDomain;
import cn.com.qj.bff.domain.eq.TransferState;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.um.UmUserReDomainBean;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.eq.EqAuctionEnrollServiceRepository;
import cn.com.qj.bff.service.eq.EqAuctionGoodsServiceRepository;
import cn.com.qj.bff.service.nm.NmNoService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/web/eq/eqAuctionEnroll"}, name="\u62a5\u4ef7\u5355")
public class EqAuctionEnrollCon
extends SpringmvcController {
    @Autowired
    private EqAuctionEnrollServiceRepository eqAuctionEnrollServiceRepository;
    @Autowired
    private EqAuctionGoodsServiceRepository eqAuctionGoodsServiceRepository;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private UserService userService;
    @Autowired
    private NmNoService nmNoService;

    @Override
    protected String getContext() {
        return "eqAuctionEnroll";
    }

    @RequestMapping(value={"createEqAuctionEnroll.json"}, name="\u6dfb\u52a0\u62a5\u4ef7\u5355")
    public HtmlJsonReBean createEqAuctionEnroll(HttpServletRequest request, String eqAuctionEnrollStr) {
        HtmlJsonReBean htmlJsonReBean;
        String FUNC_CODE = "createEqAuctionEnroll ----> ";
        this.logger.error("createEqAuctionEnroll ----> ", (Object)"start");
        this.logger.error("createEqAuctionEnroll ----> eqAuctionEnrollStr", (Object)eqAuctionEnrollStr);
        if (StringUtils.isBlank((String)eqAuctionEnrollStr)) {
            return new HtmlJsonReBean("error", "param eqAuctionEnrollStr is required but null");
        }
        EqAuctionEnrollReDomain eqAuctionEnroll = (EqAuctionEnrollReDomain)JsonUtil.buildNormalBinder().getJsonToObject(eqAuctionEnrollStr, EqAuctionEnrollReDomain.class);
        this.logger.error("createEqAuctionEnroll ----> eqAuctionEnroll", (Object)JsonUtil.buildNonNullBinder().toJson((Object)eqAuctionEnroll));
        if (eqAuctionEnroll == null) {
            return new HtmlJsonReBean("error", "json serialization error");
        }
        EqAuctionEnrollReDomain eqAuctionEnrollXunjia = this.eqAuctionEnrollServiceRepository.getAuctionEnrollByCode(this.getTenantCode(request), eqAuctionEnroll.getAuctionEnrollCode());
        if (eqAuctionEnrollXunjia != null) {
            eqAuctionEnroll.setAuctionCode(eqAuctionEnrollXunjia.getAuctionEnrollCode());
            eqAuctionEnroll.setAuctionName(eqAuctionEnrollXunjia.getAuctionName());
        }
        String auctionEnrollCode = this.nmNoService.createMaxBillNumber(null, "EqAuctionEnroll", "eqAuctionEnroll", this.getTenantCode(request));
        eqAuctionEnroll.setAuctionEnrollCode(auctionEnrollCode);
        eqAuctionEnroll.setTenantCode(this.getTenantCode(request));
        eqAuctionEnroll.setParentCode("0");
        eqAuctionEnroll.setAuctionEnrollType("0");
        eqAuctionEnroll.setChannelCode(this.getChannelCode(request));
        if (eqAuctionEnroll.getEqAuctionGoodsDomainList() != null) {
            if (eqAuctionEnroll.getEqAuctionGoodsDomainList().size() > 50) {
                return new HtmlJsonReBean((Object)"\u62a5\u4ef7\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc750\u4e2a");
            }
            for (EqAuctionGoodsDomain target : eqAuctionEnroll.getEqAuctionGoodsDomainList()) {
                String skuCode = target.getSkuCode();
                if (StringUtils.isBlank((String)skuCode)) {
                    return new HtmlJsonReBean((Object)"skuCode is empty");
                }
                HashMap<String, Object> dParam = new HashMap<String, Object>();
                dParam.put("tenantCode", this.getTenantCode(request));
                dParam.put("skuCode", skuCode);
                this.logger.error("createEqAuctionEnroll ----> getSkuByCode", dParam);
                RsSkuReDomain skuByCode = this.rsSkuService.getSkuByCode(dParam);
                this.logger.error("createEqAuctionEnroll ----> skuByCode", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)skuByCode));
                if (skuByCode == null) {
                    return new HtmlJsonReBean((Object)String.format("sku of skuCode(%s) is not exists", skuCode));
                }
                BigDecimal goodsNum = target.getGoodsNum();
                BigDecimal pricesetPrefprice = target.getPricesetPrefprice();
                BeanUtils.copyProperties((Object)skuByCode, (Object)target);
                target.setGoodsNum(goodsNum);
                target.setPricesetPrefprice(pricesetPrefprice);
                target.setGoodsSpec1(skuByCode.getSkuName());
            }
        }
        if ((htmlJsonReBean = this.eqAuctionEnrollServiceRepository.saveAuctionEnroll(eqAuctionEnroll)).isSuccess() && eqAuctionEnrollXunjia != null) {
            htmlJsonReBean = this.eqAuctionEnrollServiceRepository.updateAuctionEnrollState(eqAuctionEnrollXunjia.getAuctionEnrollId(), 3, eqAuctionEnrollXunjia.getDataState(), null);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryEqAuctionEnrollPage.json"}, name="\u67e5\u8be2\u62a5\u4ef7\u5355")
    public SupQueryResult<EqAuctionEnrollReDomain> queryEqAuctionEnrollPage(HttpServletRequest request) {
        Map<String, Object> map = this.assemMapParam(request);
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("tenantCode", this.getTenantCode(request));
        map.put("parentCode", "0");
        String gmtCreateDay = (String)map.get("gmtCreateDay");
        if (gmtCreateDay != null && !gmtCreateDay.isEmpty()) {
            try {
                SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date date = dayFormat.parse(gmtCreateDay);
                SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String gmtCreateQstart = dateTimeFormat.format(date) + " 00:00:00";
                String gmtCreateQend = dateTimeFormat.format(date) + " 23:59:59";
                map.put("gmtCreateQstart", gmtCreateQstart);
                map.put("gmtCreateQend", gmtCreateQend);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        map.put("order", true);
        return this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(map);
    }

    @RequestMapping(value={"queryEqAuctionGoodsPage.json"}, name="\u67e5\u8be2\u62a5\u4ef7\u5355\u5546\u54c1")
    public SupQueryResult<EqAuctionGoodsDomain> queryEqAuctionGoodsPage(HttpServletRequest request, String auctionEnrollCode) {
        String FUNC_CODE = "queryEqAuctionGoodsPage ----> ";
        this.logger.error("queryEqAuctionGoodsPage ----> ", (Object)"start");
        this.logger.error("queryEqAuctionGoodsPage ----> auctionEnrollCode", (Object)auctionEnrollCode);
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            return new SupQueryResult();
        }
        Map<String, Object> map = this.assemMapParamMHMpMprice(request);
        this.logger.error("queryEqAuctionGoodsPage ----> map", map);
        if (map == null) {
            return new SupQueryResult();
        }
        map.put("tenantCode", this.getTenantCode(request));
        map.put("auctionEnrollCode", auctionEnrollCode);
        SupQueryResult<EqAuctionGoodsDomain> eqAuctionGoodsDomainSupQueryResult = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(map);
        EqAuctionEnrollReDomain auctionEnrollByCode = this.eqAuctionEnrollServiceRepository.getAuctionEnrollByCode(this.getTenantCode(request), auctionEnrollCode);
        this.assemSupplierEqAuctionGoodsDomain(request, auctionEnrollByCode, eqAuctionGoodsDomainSupQueryResult.getList());
        return eqAuctionGoodsDomainSupQueryResult;
    }

    @RequestMapping(value={"updateEqAuctionEnrollState.json"}, name="\u66f4\u65b0\u62a5\u4ef7\u5355\u72b6\u6001")
    public HtmlJsonReBean updateEqAuctionEnrollState(HttpServletRequest request, String auctionEnrollCode, Integer oldDataState, Integer newDataState) {
        String FUNC_CODE = "updateEqAuctionEnrollState ----> ";
        this.logger.error("updateEqAuctionEnrollState ----> start", (Object)String.format("auctionEnrollCode: %s, oldDataState: %d, newDataState: %d", auctionEnrollCode, oldDataState, newDataState));
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            return new HtmlJsonReBean("error", "auctionEnrollCode is required but is empty");
        }
        if (oldDataState == null) {
            return new HtmlJsonReBean("error", "oldDataState is required but is empty");
        }
        if (newDataState == null) {
            return new HtmlJsonReBean("error", "newDataState is required but is empty");
        }
        EqAuctionEnrollReDomain auctionEnrollByCode = this.eqAuctionEnrollServiceRepository.getAuctionEnrollByCode(this.getTenantCode(request), auctionEnrollCode);
        auctionEnrollByCode.setAuctionEnrollSendDate(new Date());
        this.eqAuctionEnrollServiceRepository.updateAuctionEnroll(auctionEnrollByCode);
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnrollStateByCode(this.getTenantCode(request), auctionEnrollCode, newDataState, oldDataState, null);
    }

    @RequestMapping(value={"readEqAuctionEnroll.json"}, name="\u67e5\u770b\u62a5\u4ef7\u5355")
    public HtmlJsonReBean readEqAuctionEnroll(HttpServletRequest request, String auctionEnrollCode) {
        String FUNC_CODE = "readEqAuctionEnroll ----> ";
        this.logger.error("readEqAuctionEnroll ----> start", (Object)String.format("auctionEnrollCode: %s", auctionEnrollCode));
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            return new HtmlJsonReBean("error", "auctionEnrollCode is required but is empty");
        }
        EqAuctionEnrollReDomain auctionEnrollByCode = this.eqAuctionEnrollServiceRepository.getAuctionEnrollByCode(this.getTenantCode(request), auctionEnrollCode);
        this.logger.error("readEqAuctionEnroll ----> auctionEnrollByCode", (Object)auctionEnrollByCode);
        this.assemSupplierEqAuctionGoodsDomain(request, auctionEnrollByCode, auctionEnrollByCode.getEqAuctionGoodsDomainList());
        return new HtmlJsonReBean((Object)auctionEnrollByCode);
    }

    private void assemSupplierEqAuctionGoodsDomain(HttpServletRequest request, EqAuctionEnrollReDomain auctionEnrollByCode, List<EqAuctionGoodsDomain> targetEqAuctionGoodsDomainList) {
        if ("0".equals(auctionEnrollByCode.getAuctionEnrollType())) {
            return;
        }
        HashMap supplierAuctionDataState = new HashMap();
        HashMap supplierPreferentialPriceMap = new HashMap();
        ArrayList transferedSkuNoList = new ArrayList();
        Map<String, Object> subMap = this.assemMapParamMHMpMprice(request);
        subMap.remove("auctionEnrollCode");
        subMap.put("tenantCode", this.getTenantCode(request));
        subMap.put("parentCode", auctionEnrollByCode.getAuctionEnrollCode());
        subMap.put("startRow", 0);
        subMap.put("rows", 50);
        List eqAuctionEnrollReDomainSupQueryResult = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(subMap).getList();
        if (CollectionUtil.isNotEmpty((Collection)eqAuctionEnrollReDomainSupQueryResult)) {
            eqAuctionEnrollReDomainSupQueryResult.forEach(eqAuctionEnrollReDomain -> {
                ArrayList<String> dataStateList = new ArrayList<String>();
                dataStateList.add("1");
                dataStateList.add("2");
                dataStateList.add("3");
                dataStateList.add("4");
                dataStateList.add("5");
                if (dataStateList.contains(String.valueOf(eqAuctionEnrollReDomain.getDataState()))) {
                    Map<String, Object> bmap = this.assemMapParamMHMpMprice(request);
                    bmap.remove("auctionEnrollCode");
                    bmap.put("tenantCode", this.getTenantCode(request));
                    bmap.put("auctionCode", eqAuctionEnrollReDomain.getAuctionEnrollCode());
                    bmap.put("auctionEnrollType", "0");
                    bmap.put("startRow", 0);
                    bmap.put("rows", 50);
                    bmap.put("dataStateStr", "1,2,3,4,5");
                    List list = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(bmap).getList();
                    if (CollectionUtil.isNotEmpty((Collection)list)) {
                        EqAuctionEnrollReDomain b = (EqAuctionEnrollReDomain)this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(bmap).getList().get(0);
                        Map<String, Object> map = this.assemMapParamMHMpMprice(request);
                        map.remove("auctionEnrollCode");
                        map.put("tenantCode", this.getTenantCode(request));
                        map.put("auctionEnrollCode", b.getAuctionEnrollCode());
                        map.put("startRow", 0);
                        map.put("rows", 50);
                        List eqAuctionGoodsDomainList = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(map).getList();
                        if (CollectionUtil.isNotEmpty((Collection)eqAuctionGoodsDomainList)) {
                            eqAuctionGoodsDomainList.forEach(eqAuctionGoodsDomain -> supplierPreferentialPriceMap.put(eqAuctionGoodsDomain.getSkuNo(), eqAuctionGoodsDomain.getPricesetPrefprice()));
                        }
                    }
                }
                Map<String, Object> zmap = this.assemMapParamMHMpMprice(request);
                zmap.remove("auctionEnrollCode");
                zmap.put("tenantCode", this.getTenantCode(request));
                zmap.put("auctionEnrollCode", eqAuctionEnrollReDomain.getAuctionEnrollCode());
                zmap.put("startRow", 0);
                zmap.put("rows", 50);
                List subEqAuctionGoodsDomainList = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(zmap).getList();
                subEqAuctionGoodsDomainList.forEach(eqAuctionGoodsDomain -> {
                    transferedSkuNoList.add(eqAuctionGoodsDomain.getSkuNo());
                    supplierAuctionDataState.put(eqAuctionGoodsDomain.getSkuNo(), eqAuctionEnrollReDomain.getDataState());
                });
            });
        }
        HashMap pricesetPrefpriceMap = new HashMap();
        if ("1".equals(auctionEnrollByCode.getAuctionEnrollType())) {
            Map<String, Object> bmap = this.assemMapParamMHMpMprice(request);
            bmap.remove("auctionEnrollCode");
            bmap.put("tenantCode", this.getTenantCode(request));
            bmap.put("auctionCode", auctionEnrollByCode.getAuctionEnrollCode());
            bmap.put("auctionEnrollType", "0");
            bmap.put("startRow", 0);
            bmap.put("rows", 50);
            bmap.put("dataStateStr", "1,2,3,4,5");
            List list = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(bmap).getList();
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                EqAuctionEnrollReDomain b = (EqAuctionEnrollReDomain)list.get(0);
                Map<String, Object> map = this.assemMapParamMHMpMprice(request);
                map.remove("auctionEnrollCode");
                map.put("tenantCode", this.getTenantCode(request));
                map.put("auctionEnrollCode", b.getAuctionEnrollCode());
                map.put("startRow", 0);
                map.put("rows", 50);
                List eqAuctionGoodsDomainList = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(map).getList();
                if (CollectionUtil.isNotEmpty((Collection)eqAuctionGoodsDomainList)) {
                    eqAuctionGoodsDomainList.forEach(eqAuctionGoodsDomain -> pricesetPrefpriceMap.put(eqAuctionGoodsDomain.getSkuNo(), eqAuctionGoodsDomain.getPricesetPrefprice()));
                }
            }
        }
        targetEqAuctionGoodsDomainList.forEach(eqAuctionGoodsDomain -> {
            UmUserinfoReDomainBean umUserinfoReDomainBean = this.userService.getUserInfoByUserinfoCode(eqAuctionGoodsDomain.getMemberCode(), eqAuctionGoodsDomain.getTenantCode());
            if (ObjectUtil.isNotNull((Object)umUserinfoReDomainBean)) {
                eqAuctionGoodsDomain.setUserinfoQuality(umUserinfoReDomainBean.getUserinfoQuality());
            }
            if (ObjectUtil.isNotNull(supplierAuctionDataState.get(eqAuctionGoodsDomain.getSkuNo()))) {
                eqAuctionGoodsDomain.setSupplierAuctionDataState((Integer)supplierAuctionDataState.get(eqAuctionGoodsDomain.getSkuNo()));
            }
            if (ObjectUtil.isNotNull(supplierPreferentialPriceMap.get(eqAuctionGoodsDomain.getSkuNo()))) {
                eqAuctionGoodsDomain.setSupplierPreferentialPrice((BigDecimal)supplierPreferentialPriceMap.get(eqAuctionGoodsDomain.getSkuNo()));
            }
            if (transferedSkuNoList.contains(eqAuctionGoodsDomain.getSkuNo())) {
                eqAuctionGoodsDomain.setTransferState(0);
            } else {
                eqAuctionGoodsDomain.setTransferState(1);
            }
            if (ObjectUtil.isNotNull(pricesetPrefpriceMap.get(eqAuctionGoodsDomain.getSkuNo()))) {
                eqAuctionGoodsDomain.setPricesetPrefprice((BigDecimal)pricesetPrefpriceMap.get(eqAuctionGoodsDomain.getSkuNo()));
                eqAuctionGoodsDomain.setPricesetInsideprice(((BigDecimal)pricesetPrefpriceMap.get(eqAuctionGoodsDomain.getSkuNo())).multiply(eqAuctionGoodsDomain.getGoodsNum()));
            }
        });
    }

    @RequestMapping(value={"updateEqAuctionEnroll.json"}, name="\u66f4\u65b0\u62a5\u4ef7\u5355(\u66f4\u65b0\u5546\u54c1)")
    public HtmlJsonReBean updateEqAuctionEnroll(HttpServletRequest request, String eqAuctionEnrollStr) {
        String FUNC_CODE = "addEqAuctionGoods ----> ";
        this.logger.error("addEqAuctionGoods ----> ", (Object)"start");
        this.logger.error("addEqAuctionGoods ----> eqAuctionEnrollStr", (Object)eqAuctionEnrollStr);
        if (StringUtils.isBlank((String)eqAuctionEnrollStr)) {
            return new HtmlJsonReBean("error", "param eqAuctionEnrollStr is required but is empty");
        }
        EqAuctionEnrollReDomain eqAuctionEnroll = (EqAuctionEnrollReDomain)JsonUtil.buildNormalBinder().getJsonToObject(eqAuctionEnrollStr, EqAuctionEnrollReDomain.class);
        this.logger.error("addEqAuctionGoods ----> eqAuctionEnroll", (Object)JsonUtil.buildNonNullBinder().toJson((Object)eqAuctionEnroll));
        if (eqAuctionEnroll == null) {
            return new HtmlJsonReBean("error", "json serialization error");
        }
        if (eqAuctionEnroll.getAuctionEnrollCode() == null) {
            return new HtmlJsonReBean("error", "param eqAuctionEnrollStr.auctionEnrollCode is required but is null");
        }
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnroll(eqAuctionEnroll);
    }

    @RequestMapping(value={"addEqAuctionGoods.json"}, name="\u6dfb\u52a0\u62a5\u4ef7\u5355\u5546\u54c1")
    public HtmlJsonReBean addEqAuctionGoods(HttpServletRequest request, String eqAuctionEnrollStr) {
        return new HtmlJsonReBean((Object)"TODO");
    }

    @RequestMapping(value={"deleteEqAuctionGoods.json"}, name="\u5220\u9664\u62a5\u4ef7\u5355\u5546\u54c1")
    public HtmlJsonReBean addEqAuctionGoods(HttpServletRequest request, List<String> auctionGoodsCodes) {
        if (auctionGoodsCodes == null) {
            return new HtmlJsonReBean("error", "param auctionGoodsCodes is required but null");
        }
        return new HtmlJsonReBean((Object)"TODO");
    }

    @RequestMapping(value={"updateEqAuctionGoods.json"}, name="\u66f4\u65b0\u62a5\u4ef7\u5355\u5546\u54c1")
    public HtmlJsonReBean updateEqAuctionGoods(HttpServletRequest request) {
        return new HtmlJsonReBean((Object)"TODO");
    }

    @RequestMapping(value={"querySkuPage.json"}, name="\u67e5\u8be2\u5546\u54c1")
    public SupQueryResult<RsSkuReDomain> querySkuPage(HttpServletRequest request) {
        String FUNC_CODE = "querySkuPage ----> ";
        Map<String, Object> map = this.assemMapParam(request);
        this.logger.error("querySkuPage ----> start", map);
        map.put("tenantCode", this.getTenantCode(request));
        return this.rsSkuService.querySkuPage(map);
    }

    @RequestMapping(value={"queryBuyers.json"}, name="\u67e5\u8be2\u91c7\u8d2d\u5546")
    public SupQueryResult<UmUserReDomainBean> queryBuyers(HttpServletRequest request) {
        String FUNC_CODE = "queryBuyers ----> ";
        Map<String, Object> map = this.assemMapParam(request);
        this.logger.error("queryBuyers ----> start", map);
        map.put("tenantCode", this.getTenantCode(request));
        return this.userService.queryUserPage(map);
    }

    @RequestMapping(value={"transferAuctionEnroll.json"}, name="\u8be2\u4ef7\u8f6c\u5355")
    public HtmlJsonReBean transferAuctionEnroll(HttpServletRequest request, String eqAuctionEnrollStr) {
        String FUNC_CODE = "transferAuctionEnroll ----> ";
        this.logger.error("transferAuctionEnroll ----> ", (Object)"start");
        this.logger.error("transferAuctionEnroll ----> eqAuctionEnrollStr", (Object)eqAuctionEnrollStr);
        if (StringUtils.isBlank((String)eqAuctionEnrollStr)) {
            return new HtmlJsonReBean("error", "param eqAuctionEnrollStr is required but null");
        }
        EqAuctionEnrollReDomain eqAuctionEnrollReDomain = (EqAuctionEnrollReDomain)JsonUtil.buildNormalBinder().getJsonToObject(eqAuctionEnrollStr, EqAuctionEnrollReDomain.class);
        if (eqAuctionEnrollReDomain == null) {
            return new HtmlJsonReBean("error", "json serialization error");
        }
        this.logger.error("transferAuctionEnroll ----> eqAuctionEnrollReDomain", (Object)JsonUtil.buildNonNullBinder().toJson((Object)eqAuctionEnrollReDomain));
        if (StringUtils.isBlank((String)eqAuctionEnrollReDomain.getAuctionEnrollCode())) {
            return new HtmlJsonReBean("error", "param auctionEnrollCode is required but is null");
        }
        String auctionEnrollCode = eqAuctionEnrollReDomain.getAuctionEnrollCode();
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            return new HtmlJsonReBean("error", "auctionEnrollCode is required but is empty");
        }
        EqAuctionEnrollReDomain eqAuctionEnroll = this.eqAuctionEnrollServiceRepository.getAuctionEnrollByCode(this.getTenantCode(request), auctionEnrollCode);
        if (eqAuctionEnroll == null) {
            return new HtmlJsonReBean("error", "auctionEnrollCode not exist");
        }
        if (ObjectUtil.isNull((Object)eqAuctionEnroll.getTransferState()) || TransferState.NOT_TRANSFERRED.getCode().equals(eqAuctionEnroll.getTransferState())) {
            return new HtmlJsonReBean("error", "auctionEnrollCode can not be transferred");
        }
        if (eqAuctionEnroll.getTransferState().equals(TransferState.TRANSFERRED.getCode())) {
            return new HtmlJsonReBean("error", "auctionEnrollCode has been transferred");
        }
        List<EqAuctionEnrollDomain> eqAuctionEnrollDomainList = this.splitEqAuctionEnroll(request, eqAuctionEnrollReDomain);
        return this.eqAuctionEnrollServiceRepository.saveAuctionEnrollBatch(eqAuctionEnrollDomainList);
    }

    private List<EqAuctionEnrollDomain> splitEqAuctionEnroll(HttpServletRequest request, EqAuctionEnrollReDomain eqAuctionEnroll) {
        ArrayList<EqAuctionEnrollDomain> eqAuctionEnrollDomainList = new ArrayList<EqAuctionEnrollDomain>();
        UserSession userSession = this.getUserSession(request);
        Map<String, List<EqAuctionGoodsDomain>> eqAuctionGoodsDomainMap = eqAuctionEnroll.getEqAuctionGoodsDomainList().stream().collect(Collectors.groupingBy(EqAuctionGoodsDomain::getMemberCcode));
        eqAuctionGoodsDomainMap.forEach((k, v) -> {
            EqAuctionEnrollDomain target = new EqAuctionEnrollDomain();
            target.setAuctionName(eqAuctionEnroll.getAuctionName());
            target.setContactPhone(eqAuctionEnroll.getContactPhone());
            target.setAuctionEdate(eqAuctionEnroll.getAuctionEdate());
            target.setAuctionEnrollRemark(eqAuctionEnroll.getAuctionEnrollRemark());
            target.setTransferMemo(eqAuctionEnroll.getTransferMemo());
            target.setParentCode(eqAuctionEnroll.getAuctionEnrollCode());
            target.setTenantCode(userSession.getTenantCode());
            target.setMemberBcode(userSession.getUserPcode());
            target.setMemberBname(userSession.getMerberCompname());
            target.setAuctionEnrollType("1");
            target.setChannelCode(this.getChannelCode(request));
            target.setMemberCode((String)k);
            v.forEach(eqAuctionGoodsDomain -> {
                eqAuctionGoodsDomain.setAuctionGoodsId(null);
                eqAuctionGoodsDomain.setAuctionGoodsCode(null);
                eqAuctionGoodsDomain.setAuctionEnrollCode(null);
            });
            target.setEqAuctionGoodsDomainList((List<EqAuctionGoodsDomain>)v);
            target.setTransferState(TransferState.TRANSFERRED.getCode());
            target.setDataState(1);
            eqAuctionEnrollDomainList.add(target);
        });
        return eqAuctionEnrollDomainList;
    }
}

