/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.pte;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.pte.PteDpriceDomain;
import cn.com.qj.bff.domain.pte.PteDpriceReDomain;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.pte.PteDpriceService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/dprice"}, name="\u5206\u6da6\u8bbe\u7f6e")
public class PteDpriceCon
extends SpringmvcController {
    private static String CODE = "pte.dprice.con";
    @Autowired
    private PteDpriceService pteDpriceService;

    @Override
    protected String getContext() {
        return "dprice";
    }

    @RequestMapping(value={"saveDprice.json"}, name="\u589e\u52a0\u5206\u6da6\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveDprice(HttpServletRequest request, PteDpriceDomain pteDpriceDomain) {
        if (null == pteDpriceDomain) {
            this.logger.error(CODE + ".saveDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveDprice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        pteDpriceDomain.setTenantCode(this.getTenantCode(request));
        return this.pteDpriceService.saveDprice(pteDpriceDomain);
    }

    @RequestMapping(value={"getDprice.json"}, name="\u83b7\u53d6\u5206\u6da6\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public PteDpriceReDomain getDprice(HttpServletRequest request, Integer dpriceId) {
        if (StringUtils.isBlank((Integer)dpriceId)) {
            this.logger.error(CODE + ".getDprice", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getDprice", (Object)"userSession is null");
            return null;
        }
        return this.pteDpriceService.getDprice(dpriceId);
    }

    @RequestMapping(value={"getDpriceByDpriceType.json"}, name="\u83b7\u53d6\u5206\u6da6\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public PteDpriceReDomain getDpriceByDpriceType(HttpServletRequest request) {
        PteDpriceReDomain dpriceReDomain;
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getDprice", (Object)"userSession is null");
            return null;
        }
        String channelCode = "";
        channelCode = param.containsKey("channelCode") && null != param.get("channelCode") ? String.valueOf(param.get("channelCode")) : BaseInterUtil.getChannelCodeByType((HttpServletRequest)request, (String)BaseInterUtil.QUA_BUS);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceType", "oc");
        map.put("channelCode", channelCode);
        map.put("tenantCode", userSession.getTenantCode());
        SupQueryResult<PteDpriceReDomain> queryResult = this.pteDpriceService.queryDpricePage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            dpriceReDomain = new PteDpriceReDomain();
            dpriceReDomain.setDpriceType("oc");
            dpriceReDomain.setDpricePro("0");
            dpriceReDomain.setDpricePrice(new BigDecimal(10));
            dpriceReDomain.setUserName(userSession.getUserName());
            dpriceReDomain.setUserCode(userSession.getUserCode());
            dpriceReDomain.setTenantCode(userSession.getTenantCode());
            dpriceReDomain.setChannelCode(channelCode);
            dpriceReDomain.setChannelName(this.getChannelName(channelCode, request));
            dpriceReDomain.setMemberMcode(userSession.getUserPcode());
            dpriceReDomain.setMemberMname(userSession.getMerberCompname());
            dpriceReDomain.setMemberCode(this.getMemberCode(channelCode, request));
            dpriceReDomain.setMemberName(userSession.getMerberCompname());
            HtmlJsonReBean htmlJsonReBean = this.pteDpriceService.saveDprice(dpriceReDomain);
            if (htmlJsonReBean.isSuccess()) {
                queryResult = this.pteDpriceService.queryDpricePage(map);
                if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                    return new PteDpriceReDomain();
                }
                return (PteDpriceReDomain)queryResult.getList().get(0);
            }
        } else {
            return (PteDpriceReDomain)queryResult.getList().get(0);
        }
        return dpriceReDomain;
    }

    @RequestMapping(value={"getDpriceByShannelCode.json"}, name="\u83b7\u53d6\u5206\u62e5\u8bbe\u7f6e\u4fe1\u606f(\u8ba2\u5355\u62bd\u4f63)")
    @ResponseBody
    public PteDpriceReDomain getDpriceByShannelCode(HttpServletRequest request) {
        PteDpriceReDomain dpriceReDomain;
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getDprice", (Object)"userSession is null");
            return null;
        }
        String channelCode = "";
        channelCode = param.containsKey("channelCode") && null != param.get("channelCode") ? String.valueOf(param.get("channelCode")) : BaseInterUtil.getChannelCodeByType((HttpServletRequest)request, (String)BaseInterUtil.QUA_BUS);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceType", "oc");
        map.put("channelCode", channelCode);
        map.put("tenantCode", userSession.getTenantCode());
        SupQueryResult<PteDpriceReDomain> queryResult = this.pteDpriceService.queryDpricePage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            dpriceReDomain = new PteDpriceReDomain();
            dpriceReDomain.setDpriceType("oc");
            dpriceReDomain.setDpricePro("0");
            dpriceReDomain.setDpricePrice(new BigDecimal(10));
            dpriceReDomain.setUserName(userSession.getUserName());
            dpriceReDomain.setUserCode(userSession.getUserCode());
            dpriceReDomain.setTenantCode(userSession.getTenantCode());
            dpriceReDomain.setChannelCode(channelCode);
            dpriceReDomain.setChannelName(this.getChannelName(channelCode, request));
            dpriceReDomain.setMemberMcode(userSession.getUserPcode());
            dpriceReDomain.setMemberMname(userSession.getMerberCompname());
            dpriceReDomain.setMemberCode(this.getMemberCode(channelCode, request));
            dpriceReDomain.setMemberName(userSession.getMerberCompname());
            HtmlJsonReBean htmlJsonReBean = this.pteDpriceService.saveDprice(dpriceReDomain);
            if (htmlJsonReBean.isSuccess()) {
                queryResult = this.pteDpriceService.queryDpricePage(map);
                if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                    return new PteDpriceReDomain();
                }
                return (PteDpriceReDomain)queryResult.getList().get(0);
            }
        } else {
            return (PteDpriceReDomain)queryResult.getList().get(0);
        }
        return dpriceReDomain;
    }

    @RequestMapping(value={"updateDprice.json"}, name="\u66f4\u65b0\u5206\u6da6\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateDprice(HttpServletRequest request, PteDpriceDomain pteDpriceDomain) {
        if (null == pteDpriceDomain) {
            this.logger.error(CODE + ".updateDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateDprice", (Object)"userSession is null");
            return null;
        }
        pteDpriceDomain.setTenantCode(this.getTenantCode(request));
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberCode())) {
            pteDpriceDomain.setMemberCode(this.getMemberCode(this.getChannelCode(request), request));
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberName())) {
            pteDpriceDomain.setMemberName(userSession.getMerberCompname());
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberName())) {
            pteDpriceDomain.setMemberName("\u7ffc\u652f\u4ed8");
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberMcode())) {
            pteDpriceDomain.setMemberMcode(userSession.getUserPcode());
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberMname())) {
            pteDpriceDomain.setMemberMname(userSession.getMerberCompname());
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberMname())) {
            pteDpriceDomain.setMemberMname("\u7ffc\u652f\u4ed8");
        }
        return this.pteDpriceService.updateDprice(pteDpriceDomain);
    }

    @RequestMapping(value={"updateOrderCommission.json"}, name="\u66f4\u65b0\u5206\u62e5\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateOrderCommission(HttpServletRequest request, PteDpriceDomain pteDpriceDomain) {
        if (null == pteDpriceDomain) {
            this.logger.error(CODE + ".updateDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".userSession is null ", (Object)JsonUtil.buildNormalBinder().toJson((Object)userSession));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession-null");
        }
        if (null == pteDpriceDomain.getDpriceId()) {
            this.logger.error(CODE + ".updateDprice", (Object)"getDpriceId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        PteDpriceReDomain dprice = this.pteDpriceService.getDprice(pteDpriceDomain.getDpriceId());
        if (null == dprice || !StringUtils.equals((CharSequence)dprice.getMemberCode(), (CharSequence)userSession.getUserPcode())) {
            this.logger.error(CODE + ".updateDprice", (Object)"getDpriceId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f02\u5e38\u8bbf\u95ee");
        }
        pteDpriceDomain.setTenantCode(this.getTenantCode(request));
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberCode())) {
            pteDpriceDomain.setMemberCode(this.getMemberCode(this.getChannelCode(request), request));
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberName())) {
            pteDpriceDomain.setMemberName(userSession.getMerberCompname());
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberName())) {
            pteDpriceDomain.setMemberName("\u7ffc\u652f\u4ed8");
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberMcode())) {
            pteDpriceDomain.setMemberMcode(userSession.getUserPcode());
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberMname())) {
            pteDpriceDomain.setMemberMname(userSession.getMerberCompname());
        }
        if (StringUtils.isBlank((String)pteDpriceDomain.getMemberMname())) {
            pteDpriceDomain.setMemberMname("\u7ffc\u652f\u4ed8");
        }
        return this.pteDpriceService.updateDprice(pteDpriceDomain);
    }

    @RequestMapping(value={"updateDpriceTime.json"}, name="\u66f4\u65b0\u5206\u6da6\u8bbe\u7f6e\u65f6\u95f4")
    @ResponseBody
    public HtmlJsonReBean updateDpriceTime(HttpServletRequest request, String dpriceType, String startTime, String endTime) {
        if (StringUtils.isBlank((String)dpriceType) || StringUtils.isBlank((String)startTime) || StringUtils.isBlank((String)endTime)) {
            this.logger.error(CODE + ".updateDpriceTime", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateDpriceTime", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        PteDpriceReDomain dpriceReDomain = this.pteDpriceService.getDpriceByDpriceType(dpriceType);
        if (null == dpriceReDomain) {
            this.logger.error(CODE + ".updateDpriceTime", (Object)"dpriceReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "dpriceReDomain is null");
        }
        dpriceReDomain.setDpriceSydate(new Date(startTime));
        dpriceReDomain.setDpriceEydate(new Date(endTime));
        dpriceReDomain.setTenantCode(this.getTenantCode(request));
        return this.pteDpriceService.updateDprice(dpriceReDomain);
    }

    @RequestMapping(value={"deleteDprice.json"}, name="\u5220\u9664\u5206\u6da6\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteDprice(Integer dpriceId) {
        if (StringUtils.isBlank((Integer)dpriceId)) {
            this.logger.error(CODE + ".deleteDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteDpriceService.deleteDprice(dpriceId);
    }

    @RequestMapping(value={"queryDpricePage.json"}, name="\u67e5\u8be2\u5206\u6da6\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PteDpriceReDomain> queryDpricePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pteDpriceService.queryDpricePage(param);
    }

    @RequestMapping(value={"updateDpriceState.json"}, name="\u66f4\u65b0\u5206\u6da6\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDpriceState(String dpriceId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dpriceId)) {
            this.logger.error(CODE + ".updateDpriceState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteDpriceService.updateDpriceState(Integer.valueOf(dpriceId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateOrderCommissionState.json"}, name="\u66f4\u65b0\u5206\u6da6\u8bbe\u7f6e\u72b6\u6001(\u5206\u4f63)")
    @ResponseBody
    public HtmlJsonReBean updateOrderCommissionState(HttpServletRequest request, String dpriceId, Integer dataState, Integer oldDataState) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".userSession is null ", (Object)JsonUtil.buildNormalBinder().toJson((Object)userSession));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f02\u5e38\u8bbf\u95ee");
        }
        if (StringUtils.isBlank((String)dpriceId)) {
            this.logger.error(CODE + ".updateDpriceState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteDpriceService.updateDpriceState(Integer.valueOf(dpriceId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateDpriceStateByDpriceType.json"}, name="\u66f4\u65b0\u5206\u6da6\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDpriceStateByDpriceType(String dpriceType, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dpriceType)) {
            this.logger.error(CODE + ".updateDpriceState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteDpriceService.updateDpriceStateByDpriceType(dpriceType, dataState, oldDataState, null);
    }
}

