/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.sp;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.ct.CtCustrelReDomain;
import cn.com.qj.bff.domain.oc.ContractType;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.SkuDomain;
import cn.com.qj.bff.domain.org.OrgUserBean;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.sp.ContractTypeEnum;
import cn.com.qj.bff.domain.sp.SpScontractDomain;
import cn.com.qj.bff.domain.sp.SpScontractFileDomain;
import cn.com.qj.bff.domain.sp.SpScontractFileReDomain;
import cn.com.qj.bff.domain.sp.SpScontractGoodsDomain;
import cn.com.qj.bff.domain.sp.SpScontractGoodsReDomain;
import cn.com.qj.bff.domain.sp.SpScontractReDomain;
import cn.com.qj.bff.domain.um.UmUserDomainBean;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.ct.CtCustrelService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.sp.SpScontractBaseService;
import cn.com.qj.bff.service.sp.SpScontractService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/sp/scontract"}, name="\u9500\u552e\u5408\u540c")
public class SpScontractCon
extends SpringmvcController {
    private static final String CODE = "sp.scontract.con";
    @Autowired
    private SpScontractService spScontractService;
    @Autowired
    private OrgCompanyService orgCompanyService;
    @Autowired
    private CtCustrelService ctCustrelService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private UserService userService;
    @Autowired
    private SpScontractBaseService spScontractBaseService;

    @Override
    protected String getContext() {
        return "scontract";
    }

    @RequestMapping(value={"saveScontract.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isEmpty((String)spScontractDomain.getContractPmode())) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"ContractEffectivedate is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u586b\u5199\u5408\u540c\u7c7b\u578b");
        }
        spScontractDomain.setChannelCode(BaseInterUtil.getChannelCode((HttpServletRequest)request));
        spScontractDomain.setScontractNbcode(this.createUUIDString().replace("-", ""));
        String tenantCode = this.getTenantCode(request);
        spScontractDomain.setTenantCode(tenantCode);
        if (StringUtils.equals((CharSequence)"3", (CharSequence)spScontractDomain.getContractPmode())) {
            this.createLrAgreementCheck(spScontractDomain);
            this.handleSpScontractGoodsDomain(spScontractDomain);
        } else if (spScontractDomain.getContractEffectivedate() == null) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"ContractEffectivedate is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u586b\u5199\u751f\u6548\u7ed3\u675f\u65f6\u95f4");
        }
        UmUserinfoReDomainBean userinfoReDomainBean = this.userService.getUserInfoByUserinfoCode(tenantCode, spScontractDomain.getMemberBcode());
        if (userinfoReDomainBean != null) {
            spScontractDomain.setEmployeeCode(userinfoReDomainBean.getEmployeeCode());
            spScontractDomain.setEmployeeName(userinfoReDomainBean.getEmployeeName());
        }
        return this.spScontractBaseService.sendSaveScontract(spScontractDomain);
    }

    private void createLrAgreementCheck(SpScontractDomain spScontractDomain) throws ApiException {
        if (StringUtils.isBlank((String)spScontractDomain.getContractType())) {
            throw new ApiException("contractType", "\u534f\u8bae\u7c7b\u578b\u5fc5\u586b\uff01");
        }
        if (!ContractTypeEnum.getAllCodes().contains(spScontractDomain.getContractType())) {
            String msg = String.format("\u534f\u8bae\u7c7b\u578b<%s>\u4e0d\u5408\u6cd5\uff01\u76ee\u524d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b\u6709\uff1a%s", spScontractDomain.getContractType(), String.join((CharSequence)",", ContractTypeEnum.getAllCodes()));
            throw new ApiException("contractType", msg);
        }
        if (StringUtils.isBlank((String)spScontractDomain.getScontractBcode())) {
            throw new ApiException("scontractBcode", "\u534f\u8bae\u7f16\u53f7\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getScontractName())) {
            throw new ApiException("scontractName", "\u534f\u8bae\u540d\u79f0\u5fc5\u586b\uff01");
        }
        if (ObjectUtil.isNull((Object)spScontractDomain.getDataBmoney())) {
            throw new ApiException("dataBmoney", "\u534f\u8bae\u91d1\u989d\u5fc5\u586b\uff01");
        }
        if (spScontractDomain.getDataBmoney().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ApiException("dataBmoney", "\u534f\u8bae\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff01");
        }
        if (ObjectUtil.isNull((Object)spScontractDomain.getContractDepositdate())) {
            throw new ApiException("contractDepositdate", "\u534f\u8bae\u751f\u6548\u65f6\u95f4\u5fc5\u586b\uff01");
        }
        if (ObjectUtil.isNull((Object)spScontractDomain.getContractEffectivedate())) {
            throw new ApiException("contractEffectivedate", "\u534f\u8bae\u7ed3\u675f\u65f6\u95f4\u5fc5\u586b\uff01");
        }
        if (spScontractDomain.getContractDepositdate().compareTo(spScontractDomain.getContractEffectivedate()) > 0) {
            throw new ApiException("contractDepositdate", "\u534f\u8bae\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (spScontractDomain.getContractEffectivedate().compareTo(spScontractDomain.getContractDepositdate()) < 0) {
            throw new ApiException("contractEffectivedate", "\u534f\u8bae\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65f6\u95f4\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getMemberBcode())) {
            throw new ApiException("memberBcode", "\u670d\u52a1\u5546\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getMemberBname())) {
            throw new ApiException("memberBname", "\u670d\u52a1\u5546\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getMemberGcode())) {
            throw new ApiException("memberGcode", "\u534f\u8bae\u65b9\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getMemberGname())) {
            throw new ApiException("memberGname", "\u534f\u8bae\u65b9\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getSpScontractGoodsDomainListStr())) {
            throw new ApiException("spScontractGoodsDomainListStr", "\u8bf7\u6dfb\u52a0\u534f\u8bae\u5546\u54c1\uff01");
        }
        spScontractDomain.setSpScontractGoodsDomainList(JsonUtil.buildNormalBinder().getJsonToList(spScontractDomain.getSpScontractGoodsDomainListStr(), SpScontractGoodsDomain.class));
        spScontractDomain.getSpScontractGoodsDomainList().forEach(spScontractGoodsDomain -> {
            if (StringUtils.isBlank((String)spScontractGoodsDomain.getSkuCode())) {
                throw new ApiException("spScontractGoodsDomainList", "\u534f\u8bae\u5546\u54c1 skuCode \u5fc5\u586b\uff01");
            }
        });
        List skuCodeListGoodsNum = spScontractDomain.getSpScontractGoodsDomainList().stream().filter(item -> ObjectUtil.isNull((Object)item.getGoodsNum()) || item.getGoodsNum().compareTo(BigDecimal.ZERO) <= 0).map(SpScontractGoodsDomain::getSkuCode).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(skuCodeListGoodsNum)) {
            throw new ApiException("spScontractGoodsDomainList", String.format("\u534f\u8bae\u5546\u54c1<%s>\u6570\u91cf\u5fc5\u586b\uff0c\u4e14\u5fc5\u987b\u5927\u4e8e0\uff01", String.join((CharSequence)",", skuCodeListGoodsNum)));
        }
        List skuCodeListGoodsPrice = spScontractDomain.getSpScontractGoodsDomainList().stream().filter(item -> ObjectUtil.isNull((Object)item.getContractGoodsPrice()) || item.getContractGoodsPrice().compareTo(BigDecimal.ZERO) <= 0).map(SpScontractGoodsDomain::getSkuCode).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(skuCodeListGoodsPrice)) {
            throw new ApiException("spScontractGoodsDomainList", String.format("\u534f\u8bae\u5546\u54c1<%s>\u5408\u540c\u5355\u4ef7\u5fc5\u586b\uff0c\u4e14\u5fc5\u987b\u5927\u4e8e0\uff01", String.join((CharSequence)",", skuCodeListGoodsPrice)));
        }
        BigDecimal contractAmount = spScontractDomain.getSpScontractGoodsDomainList().stream().map(item -> item.getGoodsNum().multiply(item.getContractGoodsPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (contractAmount.compareTo(spScontractDomain.getDataBmoney()) != 0) {
            throw new ApiException("spScontractGoodsDomainList", String.format("\u534f\u8bae\u91d1\u989d<%s>\u4e0e\u534f\u8bae\u5546\u54c1\u6570\u91cf*\u5408\u540c\u5355\u4ef7<%s>\u4e0d\u4e00\u81f4\uff01", spScontractDomain.getDataBmoney(), contractAmount));
        }
        if (StringUtils.isNotBlank((String)spScontractDomain.getSpScontractFileDomainListStr())) {
            spScontractDomain.setSpScontractFileDomainList(JsonUtil.buildNormalBinder().getJsonToList(spScontractDomain.getSpScontractFileDomainListStr(), SpScontractFileDomain.class));
            for (SpScontractFileDomain spScontractFileDomain : spScontractDomain.getSpScontractFileDomainList()) {
                if (StringUtils.isBlank((String)spScontractFileDomain.getScontractFileSname())) {
                    throw new ApiException("scontractFileSname", "\u534f\u8bae\u6587\u4ef6\u540e\u7f00\u540d\u5fc5\u586b\uff01");
                }
                if (StringUtils.isBlank((String)spScontractFileDomain.getScontractFileType())) {
                    throw new ApiException("scontractFileType", "\u534f\u8bae\u6587\u4ef6\u7c7b\u578b\u5fc5\u586b\uff01");
                }
                if (StringUtils.isBlank((String)spScontractFileDomain.getScontractFileName())) {
                    throw new ApiException("scontractFileName", "\u534f\u8bae\u6587\u4ef6\u540d\u5fc5\u586b\uff01");
                }
                if (!StringUtils.isBlank((String)spScontractFileDomain.getScontractFileUrl())) continue;
                throw new ApiException("scontractFileUrl", "\u534f\u8bae\u6587\u4ef6url\u5fc5\u586b\uff01");
            }
        }
    }

    private void handleSpScontractGoodsDomain(SpScontractDomain spScontractDomain) throws ApiException {
        spScontractDomain.getSpScontractGoodsDomainList().forEach(spScontractGoodsDomain -> {
            String skuCode = spScontractGoodsDomain.getSkuCode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuCode", skuCode);
            map.put("tenantCode", spScontractDomain.getTenantCode());
            RsSkuReDomain rsSkuReDomain = this.rsSkuService.getSkuByCode(map);
            if (ObjectUtil.isNull((Object)rsSkuReDomain)) {
                throw new ApiException("skuCode", "\u5546\u54c1\u4e0d\u5b58\u5728\uff01skuCode\uff1a" + skuCode);
            }
            if (ObjectUtil.notEqual((Object)1, (Object)rsSkuReDomain.getDataOpbillstate())) {
                throw new ApiException("skuCode", "\u5546\u54c1\u672a\u4e0a\u67b6\uff01skuCode\uff1a" + skuCode);
            }
            BigDecimal goodsNum = spScontractGoodsDomain.getGoodsNum();
            BigDecimal contractGoodsPrice = spScontractGoodsDomain.getContractGoodsPrice();
            BeanUtil.copyProperties((Object)rsSkuReDomain, (Object)spScontractGoodsDomain, (String[])new String[0]);
            spScontractGoodsDomain.setScontractGoodsType(0);
            spScontractGoodsDomain.setContractGoodsGtype("0");
            spScontractGoodsDomain.setGoodsNum(goodsNum);
            spScontractGoodsDomain.setContractGoodsPrice(contractGoodsPrice);
        });
    }

    @RequestMapping(value={"queryScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.setUserMap(request, param);
        SupQueryResult<SpScontractReDomain> scontractReDomainSupQueryResult = this.spScontractService.queryScontractPage(param);
        scontractReDomainSupQueryResult.getList().forEach(spScontractReDomain -> {
            UmUserinfoReDomainBean userinfoReDomainBean;
            if (null == spScontractReDomain.getEmployeeCode() && (userinfoReDomainBean = this.userService.getUserInfoByUserinfoCode(spScontractReDomain.getMemberBcode(), spScontractReDomain.getTenantCode())) != null) {
                spScontractReDomain.setEmployeeCode(userinfoReDomainBean.getEmployeeCode());
                spScontractReDomain.setEmployeeName(userinfoReDomainBean.getEmployeeName());
            }
        });
        return scontractReDomainSupQueryResult;
    }

    @RequestMapping(value={"getScontract.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u4fe1\u606f")
    @ResponseBody
    public SpScontractReDomain getScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error("sp.scontract.con.getScontract", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontract(scontractId);
    }

    @RequestMapping(value={"updateScontractState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractState(String scontractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractId)) {
            this.logger.error("sp.scontract.con.updateScontractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractBaseService.sendUpdateScontractState(Integer.valueOf(scontractId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateScontract.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error("sp.scontract.con.updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Integer scontractId = spScontractDomain.getScontractId();
        if (ObjectUtil.isNull((Object)scontractId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "scontractId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getContractPmode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "contractPmode \u4e0d\u80fd\u4e3a\u7a7a");
        }
        SpScontractReDomain scontract = this.spScontractService.getScontract(scontractId);
        if (ObjectUtil.isNull((Object)scontract)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "scontractId \u65e0\u6548");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        if (StringUtils.equals((CharSequence)"3", (CharSequence)spScontractDomain.getContractPmode())) {
            if (ObjectUtil.notEqual((Object)0, (Object)scontract.getDataState())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4ec5\u5f85\u63d0\u4ea4\u72b6\u6001\u53ef\u4ee5\u66f4\u65b0");
            }
            this.createLrAgreementCheck(spScontractDomain);
            this.handleSpScontractGoodsDomain(spScontractDomain);
            this.spScontractBaseService.sendUpdateScontract(spScontractDomain);
            List<SpScontractGoodsDomain> spScontractGoodsDomainList = spScontractDomain.getSpScontractGoodsDomainList();
            List scontractGoodsIdList = spScontractGoodsDomainList.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getScontractGoodsId())).map(SpScontractGoodsDomain::getScontractGoodsId).collect(Collectors.toList());
            scontract.getSpScontractGoodsReDomainList().forEach(spScontractGoodsDomain -> {
                if (scontractGoodsIdList.contains(spScontractGoodsDomain.getScontractGoodsId())) {
                    SpScontractGoodsDomain first = spScontractGoodsDomainList.stream().filter(item -> ObjectUtil.equals((Object)spScontractGoodsDomain.getScontractGoodsId(), (Object)item.getScontractGoodsId())).findFirst().orElse(null);
                    if (first != null) {
                        first.setTenantCode(this.getTenantCode(request));
                        this.spScontractService.updateScontractGoods(first);
                    }
                } else {
                    this.spScontractService.deleteScontractGoods(spScontractGoodsDomain.getScontractGoodsId());
                }
            });
            spScontractGoodsDomainList.forEach(spScontractGoodsDomain -> {
                if (ObjectUtil.isNull((Object)spScontractGoodsDomain.getScontractGoodsId())) {
                    spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
                    spScontractGoodsDomain.setScontractCode(scontract.getScontractCode());
                    this.spScontractService.saveScontractGoods((SpScontractGoodsDomain)spScontractGoodsDomain);
                }
            });
            List<SpScontractFileDomain> spScontractFileDomainList = spScontractDomain.getSpScontractFileDomainList();
            List<SpScontractFileReDomain> spScontractFileDomainListHa = scontract.getSpScontractFileReDomainList();
            if (CollectionUtil.isEmpty(spScontractFileDomainList) && CollectionUtil.isNotEmpty(spScontractFileDomainListHa)) {
                spScontractFileDomainListHa.forEach(spScontractFileDomain -> this.spScontractService.deleteScontractFile(spScontractFileDomain.getScontractFileId()));
            } else if (CollectionUtil.isNotEmpty(spScontractFileDomainList) && CollectionUtil.isEmpty(spScontractFileDomainListHa)) {
                spScontractFileDomainList.forEach(spScontractFileDomain -> {
                    spScontractFileDomain.setTenantCode(this.getTenantCode(request));
                    spScontractFileDomain.setScontractCode(scontract.getScontractCode());
                    this.spScontractService.saveScontractFile((SpScontractFileDomain)spScontractFileDomain);
                });
            } else if (CollectionUtil.isNotEmpty(spScontractFileDomainList) && CollectionUtil.isNotEmpty(spScontractFileDomainListHa)) {
                List spScontractFileIdList = spScontractFileDomainList.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getScontractFileId())).map(SpScontractFileDomain::getScontractFileId).collect(Collectors.toList());
                spScontractFileDomainListHa.forEach(ha -> {
                    if (spScontractFileIdList.contains(ha.getScontractFileId())) {
                        SpScontractFileDomain first = spScontractFileDomainList.stream().filter(item -> ObjectUtil.equals((Object)ha.getScontractFileId(), (Object)item.getScontractFileId())).findFirst().orElse(null);
                        if (first != null) {
                            first.setTenantCode(this.getTenantCode(request));
                            this.spScontractService.updateScontractFile(first);
                        }
                    } else {
                        this.spScontractService.deleteScontractFile(ha.getScontractFileId());
                    }
                });
                spScontractFileDomainList.forEach(spScontractFileDomain -> {
                    if (ObjectUtil.isNull((Object)spScontractFileDomain.getScontractFileId())) {
                        spScontractFileDomain.setTenantCode(this.getTenantCode(request));
                        spScontractFileDomain.setScontractCode(scontract.getScontractCode());
                        this.spScontractService.saveScontractFile((SpScontractFileDomain)spScontractFileDomain);
                    }
                });
            } else {
                return new HtmlJsonReBean();
            }
            return new HtmlJsonReBean();
        }
        return this.spScontractBaseService.sendUpdateScontract(spScontractDomain);
    }

    @RequestMapping(value={"deleteScontract.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean deleteScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error("sp.scontract.con.deleteScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractReDomain scontract = this.spScontractService.getScontract(scontractId);
        if (scontract == null) {
            this.logger.error("sp.scontract.con.deleteScontract.getScontract", (Object)scontractId);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        if (scontract.getContractPmode().equals("1")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", scontract.getTenantCode());
            map.put("memberBcode", scontract.getMemberBcode());
            SupQueryResult<SpScontractReDomain> spScontractReDomainSupQueryResult = this.spScontractService.queryScontractPage(map);
            Date effctDate = scontract.getContractEffectivedate();
            if (spScontractReDomainSupQueryResult != null && CollectionUtils.isNotEmpty((Collection)spScontractReDomainSupQueryResult.getList())) {
                List collect = spScontractReDomainSupQueryResult.getList().stream().filter(s -> s.getScontractId().intValue() != scontractId.intValue() && s.getContractPmode().equals("1")).sorted(Comparator.comparing(SpScontractDomain::getContractEffectivedate, Comparator.reverseOrder())).collect(Collectors.toList());
                HashMap<String, String> queryUserinfoPageMap = new HashMap<String, String>();
                queryUserinfoPageMap.put("tenantCode", scontract.getTenantCode());
                queryUserinfoPageMap.put("userPcode", scontract.getMemberBcode());
                UmUserDomainBean userByPcode = this.userService.getUserByPcode(scontract.getMemberBcode(), scontract.getTenantCode());
                if (userByPcode == null) {
                    this.logger.error("sp.scontract.con.saveScontract.queryUserinfoPage", queryUserinfoPageMap);
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ecf\u9500\u5546\u4fe1\u606f\u6682\u672a\u67e5\u5230");
                }
                HashMap<String, Object> newUserMap = new HashMap<String, Object>();
                newUserMap.put("userId", userByPcode.getUserId());
                if (collect.isEmpty()) {
                    newUserMap.put("gmtValid", null);
                } else {
                    newUserMap.put("gmtValid", ((SpScontractReDomain)collect.get(0)).getContractEffectivedate());
                }
                this.userService.updateUserValidate(newUserMap);
            }
        }
        return this.spScontractBaseService.sendDeleteScontract(scontractId);
    }

    @RequestMapping(value={"saveScontractStr.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractBaseService.sendSaveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private void makeChannelStr(List<SpScontractDomain> spScontractDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(spScontractDomainList) || null == request) {
            return;
        }
        for (SpScontractDomain orderDomain : spScontractDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    private OrgUserBean getOrgUserBeanStr(String memberBcode, String userCode, String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyService.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean.setMemberBcode(memberBcode);
            SupQueryResult<CtCustrelReDomain> qcust = this.ctCustrelService.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode));
            if (null != qcust && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            }
        }
        return orgUserBean;
    }

    public SpScontractDomain makeScontractDomain(SpScontractDomain orderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("makeScontractDomain", (Object)"UserSession is null");
            return null;
        }
        SpScontractDomain contractDomain = new SpScontractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("makeScontractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getMemberBcode())) {
            contractDomain.setMemberBcode(userSession.getUserPcode());
            contractDomain.setMemberBname(userSession.getMerberCompname());
        }
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        contractDomain.setContractUserurl(userSession.getUserImgurl());
        contractDomain.setUserCode(userSession.getUserCode());
        contractDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        contractDomain.setContractDelcode(randomCode);
        return contractDomain;
    }

    public List<SpScontractDomain> createScontract(List<SpScontractDomain> orderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.debug("sp.scontract.con.createScontract", (Object)"param is null");
        }
        ArrayList<SpScontractDomain> orderDomains = new ArrayList<SpScontractDomain>();
        String tenantCode = userSession.getTenantCode();
        for (SpScontractDomain orderDomain : orderDomainList) {
            try {
                SpScontractDomain contractDomain = this.makeScontractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == contractDomain) {
                    this.logger.error("sp.scontract.con.createScontract");
                    return null;
                }
                if (StringUtils.isBlank((String)contractProperty)) {
                    contractProperty = "0";
                }
                contractDomain.setContractProperty(contractProperty);
                SpScontractDomain spScontractDomain = this.makeSpScontractGoodsDomainList(contractDomain, orderDomain.getGiftSkuIdList());
                orderDomains.add(spScontractDomain);
            }
            catch (Exception e) {
                this.logger.error("sp.scontract.con.createScontract.ex", (Throwable)e);
            }
        }
        return orderDomains;
    }

    public SpScontractDomain makeSpScontractGoodsDomainList(SpScontractDomain spScontractDomain, List<SkuDomain> giftSkuIdList) {
        ArrayList<SpScontractGoodsDomain> spScontractGoodsDomainList = new ArrayList<SpScontractGoodsDomain>();
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        BigDecimal pacgeMoney = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        this.logger.debug("sp.scontract.con.makeSpScontractGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson(giftSkuIdList));
        if (ListUtil.isNotEmpty(giftSkuIdList)) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                HashMap<String, Object> map;
                SpScontractGoodsDomain spScontractGoodsDomain = new SpScontractGoodsDomain();
                RsSkuReDomain rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuService.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, Object>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", spScontractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuService.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error("sp.scontract.con.makeSpScontractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    return null;
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error("sp.scontract.con.makeSpScontractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    return null;
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error("sp.scontract.con.makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.toString()));
                    return null;
                }
                if (StringUtils.isBlank((String)spScontractDomain.getMemberCode())) {
                    spScontractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    spScontractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                try {
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error("sp.scontract.con.makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    return null;
                }
                spScontractGoodsDomain.setContractGoodsPrice(skuDomain.getGoodsPinprice());
                spScontractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                spScontractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                spScontractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                spScontractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                spScontractGoodsDomain.setMemberBcode(spScontractDomain.getMemberBcode());
                spScontractGoodsDomain.setMemberBname(spScontractDomain.getMemberBname());
                spScontractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                spScontractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                spScontractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == spScontractGoodsDomain.getContractGoodsPrice()) {
                    spScontractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                sum = sum.add(spScontractGoodsDomain.getContractGoodsPrice().multiply(spScontractGoodsDomain.getGoodsNum()));
                if (null == spScontractGoodsDomain.getGoodsNum()) {
                    spScontractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
                }
                goodsNum = goodsNum.add(spScontractGoodsDomain.getGoodsNum());
                if (null == spScontractGoodsDomain.getGoodsCweight()) {
                    spScontractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                goodsWeight = goodsWeight.add(spScontractGoodsDomain.getGoodsCweight());
                if (null == spScontractGoodsDomain.getPricesetRefrice()) {
                    spScontractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                pefMoney = pefMoney.add(spScontractGoodsDomain.getPricesetRefrice());
                if (null == spScontractGoodsDomain.getPricesetNprice()) {
                    spScontractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                dataBmoney = dataBmoney.add(spScontractGoodsDomain.getPricesetNprice().multiply(spScontractGoodsDomain.getGoodsNum()));
                spScontractGoodsDomainList.add(spScontractGoodsDomain);
            }
        }
        spScontractDomain.setPricesetRefrice(pefMoney);
        spScontractDomain.setGoodsNum(goodsNum);
        spScontractDomain.setGoodsWeight(goodsWeight);
        spScontractDomain.setDataBweight(goodsWeight);
        spScontractDomain.setContractInmoney(contractInmoney);
        spScontractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        spScontractDomain.setDataBnum(dataBnum);
        spScontractDomain.setDataBmoney(dataBmoney);
        spScontractDomain.setGoodsLogmoney(goodsLogmoney);
        spScontractDomain.setGoodsPmoney(sum);
        spScontractDomain.setSpScontractGoodsDomainList(spScontractGoodsDomainList);
        return spScontractDomain;
    }

    private void setUserMap(HttpServletRequest request, Map<String, Object> param) {
        UmUserinfoReDomainBean userinfo;
        String tenantCode = this.getTenantCode(request);
        String storeFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-store_check-store_check"));
        Object userinfoCode = param.get("userinfoCode");
        if (StringUtils.isNotBlank((String)storeFlag) && userinfoCode != null && (userinfo = this.userService.getUserInfoByUserinfoCode(String.valueOf(userinfoCode), tenantCode)) != null) {
            param.put("mschannelCode", userinfo.getUserinfoChannelcode());
            param.put("companyCode", userinfo.getDepartCode());
            param.put("employeeCode", userinfo.getUserinfoOcode());
        }
    }

    @RequestMapping(value={"saveScontractFile.json"}, name="\u589e\u52a0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveScontractFile(HttpServletRequest request, SpScontractFileDomain spScontractFileDomain) {
        if (null == spScontractFileDomain) {
            this.logger.error("sp.scontract.con.saveScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractFileDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontractFile(spScontractFileDomain);
    }

    @RequestMapping(value={"getScontractFile.json"}, name="\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public SpScontractFileReDomain getScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error("sp.scontract.con.getScontractFile", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontractFile(scontractFileId);
    }

    @RequestMapping(value={"updateScontractFile.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error("sp.scontract.con.updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"deleteScontractFile.json"}, name="\u5220\u9664\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error("sp.scontract.con.deleteScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontractFile(scontractFileId);
    }

    @RequestMapping(value={"queryScontractFilePage.json"}, name="\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractFilePage(param);
    }

    @RequestMapping(value={"updateScontractFileState.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileState(String scontractFileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractFileId)) {
            this.logger.error("sp.scontract.con.updateScontractFileState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractFileState(Integer.valueOf(scontractFileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractGoods.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error("sp.scontract.con.saveScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"getScontractGoods.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SpScontractGoodsReDomain getScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error("sp.scontract.con.getScontractGoods", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"updateScontractGoods.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error("sp.scontract.con.updateScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"deleteScontractGoods.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error("sp.scontract.con.deleteScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"queryScontractGoodsPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"updateScontractGoodsState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoodsState(String scontractGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractGoodsId)) {
            this.logger.error("sp.scontract.con.updateScontractGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractGoodsState(Integer.valueOf(scontractGoodsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryScontractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractPage(param);
    }

    @RequestMapping(value={"queryScontractFilePageC.json"}, name="C\u7aef\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractFilePage(param);
    }

    @RequestMapping(value={"queryScontractGoodsPageC.json"}, name="C\u7aef\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u5408\u540c\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractService.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"saveScontractStrC.json"}, name="C\u7aef\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractBaseService.sendSaveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private HtmlJsonReBean getSpScontractDomains(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        if (null == scontractDomainStr) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean = this.getOrgUserBeanStr(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        this.makeChannelStr(orderDomainList, request);
        List<SpScontractDomain> SpScontractDomainList = this.createScontract(orderDomainList, ContractType.CON.getCode(), userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, null);
        return new HtmlJsonReBean(SpScontractDomainList);
    }
}

