/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.gt;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.gt.GtGiftDomain;
import cn.com.qj.bff.domain.gt.GtGiftFileReDomain;
import cn.com.qj.bff.domain.gt.GtGiftReDomain;
import cn.com.qj.bff.domain.gt.GtGiftRelReDomain;
import cn.com.qj.bff.domain.gt.GtGiftSendReDomain;
import cn.com.qj.bff.domain.gt.GtGiftSendlistReDomain;
import cn.com.qj.bff.domain.gt.GtGiftSpecDomain;
import cn.com.qj.bff.domain.gt.GtGiftSpecReDomain;
import cn.com.qj.bff.domain.gt.GtGiftUserDomain;
import cn.com.qj.bff.domain.gt.GtGiftUserReDomain;
import cn.com.qj.bff.domain.gt.GtGiftUserrelDomain;
import cn.com.qj.bff.domain.gt.GtGiftUserrelReDomain;
import cn.com.qj.bff.domain.rs.RsGoodsFileDomain;
import cn.com.qj.bff.domain.rs.RsGoodsRelDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSpecValueDomain;
import cn.com.qj.bff.service.gt.GtGiftFileService;
import cn.com.qj.bff.service.gt.GtGiftRelService;
import cn.com.qj.bff.service.gt.GtGiftSendService;
import cn.com.qj.bff.service.gt.GtGiftSendlistService;
import cn.com.qj.bff.service.gt.GtGiftService;
import cn.com.qj.bff.service.gt.GtGiftSpecService;
import cn.com.qj.bff.service.gt.GtGiftUserService;
import cn.com.qj.bff.service.gt.GtGiftUserrelService;
import cn.com.qj.bff.service.rs.RsGoodsOtherService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/gt/gift"}, name="\u793c\u54c1\u670d\u52a1")
public class GiftCon
extends SpringmvcController {
    private static String CODE = "gt.gift.con";
    @Autowired
    private GtGiftService gtGiftService;
    @Autowired
    private GtGiftFileService gtGiftFileService;
    @Autowired
    private GtGiftRelService gtGiftRelService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private RsGoodsOtherService rsGoodsOtherService;
    @Autowired
    private GtGiftSendlistService gtGiftSendlistService;
    @Autowired
    private GtGiftSendService gtGiftSendService;
    @Autowired
    private GtGiftUserrelService gtGiftUserrelService;
    @Autowired
    private GtGiftUserService gtGiftUserService;
    @Autowired
    private GtGiftSpecService gtGiftSpecService;

    @Override
    protected String getContext() {
        return "gift";
    }

    @RequestMapping(value={"saveGift.json"}, name="\u589e\u52a0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<GtGiftRelReDomain> gtGiftRelDomainArr = gtGiftDomain.getGtGiftRelDomainList();
        if (null != gtGiftRelDomainArr && gtGiftRelDomainArr.size() > 0) {
            for (GtGiftRelReDomain gtGiftRelReDomain : gtGiftRelDomainArr) {
                if (null == gtGiftRelReDomain.getPricesetBaseprice() || gtGiftRelReDomain.getPricesetBaseprice().equals("") || 0 == gtGiftRelReDomain.getPricesetBaseprice().intValue()) {
                    gtGiftRelReDomain.setPricesetBaseprice(gtGiftRelReDomain.getPricesetNprice());
                }
                gtGiftRelReDomain.getPricesetBaseprice();
            }
        }
        if (null == gtGiftDomain.getGtGiftSpecDomainList() || gtGiftDomain.getGtGiftSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.relList", (Object)"getGtGiftSpecDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        gtGiftDomain.setChannelCode(this.getChannelCode(request));
        gtGiftDomain.setGiftRemark(GiftCon.makeRemark(gtGiftDomain.getGiftRemark()));
        return this.gtGiftService.saveGift(gtGiftDomain);
    }

    private static String makeRemark(String remark) {
        if (StringUtils.isNotBlank((String)remark)) {
            Pattern scriptPattern = Pattern.compile("alert(.*?)", 42);
            remark = scriptPattern.matcher(remark).replaceAll(" ");
        }
        return remark;
    }

    @RequestMapping(value={"getGift.json"}, name="\u83b7\u53d6\u793c\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public GtGiftReDomain getGift(Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".getGift", (Object)"param is null");
            return null;
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftService.getGift(giftId);
        Map<String, Object> amap = this.getQueryMapParam("giftCode,tenantCode", gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode());
        gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileService.queryGiftFilePage(amap).getList());
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelService.queryGiftRelPage(amap).getList());
        List gtGiftSpecReDomainList = this.gtGiftSpecService.queryGiftSpecPage(amap).getList();
        ArrayList<GtGiftSpecDomain> gtGiftSpecDomainArr = new ArrayList<GtGiftSpecDomain>();
        if (null != gtGiftSpecReDomainList && gtGiftSpecReDomainList.size() > 0) {
            for (GtGiftSpecReDomain gtGiftSpecDomain : gtGiftSpecReDomainList) {
                gtGiftSpecDomainArr.add(gtGiftSpecDomain);
            }
        }
        gtGiftReDomain.setGtGiftSpecDomainList(gtGiftSpecDomainArr);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"updateGift.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftService.updateGift(gtGiftDomain);
    }

    @RequestMapping(value={"deleteGift.json"}, name="\u5220\u9664\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteGift(String giftId) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".deleteGift", (Object)"giftId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        String[] s = giftId.split(",");
        if (null != s && s.length > 0) {
            for (String gid : s) {
                GtGiftReDomain gtGiftReDomain = this.getGift(Integer.valueOf(gid));
                htmlJsonReBean = this.gtGiftService.updateGiftState(Integer.valueOf(giftId), -1, gtGiftReDomain.getDataState());
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryGiftPage.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("ntoDataState", -1);
        param.remove("channelCode");
        return this.gtGiftService.queryGiftPage(param);
    }

    @RequestMapping(value={"queryGiftPageForUp.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageForUp(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("ntoDataState", -1);
        return this.gtGiftService.queryGiftPage(param);
    }

    @RequestMapping(value={"queryGiftPageToB.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToB(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("sendState", 1);
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult<GtGiftUserReDomain> gtGiftUserrelReDomainList = this.gtGiftUserService.queryGiftUserPage(param);
        List gtGiftUserReDomainArr = gtGiftUserrelReDomainList.getList();
        ArrayList<GtGiftReDomain> gtGiftReDomainArr = new ArrayList<GtGiftReDomain>();
        if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
            long time = 2592000000L;
            for (GtGiftUserReDomain gtGiftUserReDomain : gtGiftUserReDomainArr) {
                GtGiftReDomain gtGiftReDomain = this.gtGiftService.getGiftByCode(this.getTenantCode(request), gtGiftUserReDomain.getGiftCode());
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime > 0L && endTime < time) {
                    gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
                }
                gtGiftReDomain.setGtGiftUserDomain(gtGiftUserReDomain);
                gtGiftReDomainArr.add(gtGiftReDomain);
            }
        }
        SupQueryResult gtGiftReDomainList = new SupQueryResult();
        if (null != gtGiftReDomainArr) {
            gtGiftReDomainList.setList(gtGiftReDomainArr);
            gtGiftReDomainList.setTotal(gtGiftUserrelReDomainList.getTotal());
            gtGiftReDomainList.setPageTools(gtGiftUserrelReDomainList.getPageTools());
        }
        return gtGiftReDomainList;
    }

    @RequestMapping(value={"queryGiftPageToB2.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u88682")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> queryGiftPageToB2(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("sendState", 1);
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult<GtGiftUserReDomain> gtGiftUserrelReDomainList = this.gtGiftUserService.queryGiftUserPage(param);
        List gtGiftUserReDomainArr = gtGiftUserrelReDomainList.getList();
        if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
            long time = 2592000000L;
            for (GtGiftUserReDomain gtGiftUserReDomain : gtGiftUserReDomainArr) {
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime <= 0L || endTime >= time) continue;
                gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
            }
        }
        return gtGiftUserrelReDomainList;
    }

    @RequestMapping(value={"queryGiftUnissued.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u672a\u53d1\u653e\u670d\u52a1")
    @ResponseBody
    public Long queryGiftUnissued(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("validState", "0");
        param.put("sendState", 1);
        param.put("dataState", 0);
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult<GtGiftUserReDomain> gtGiftUserrelReDomainList = this.gtGiftUserService.queryGiftUserPage(param);
        return gtGiftUserrelReDomainList.getTotal();
    }

    @RequestMapping(value={"queryGiftSendlistPageByGiftSendCodeToB.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u5305\u9886\u53d6\u7684\u8be6\u60c5\uff08\u67e5\u770b\u5458\u5de5\u9886\u53d6\u5217\u8868\uff09")
    @ResponseBody
    public GtGiftReDomain queryGiftSendlistPageByGiftSendCodeToB(String giftUserId) {
        if (null == giftUserId) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToB", (Object)"giftUserId is null");
            return null;
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserService.getGiftUser(Integer.valueOf(giftUserId));
        GtGiftReDomain gtGiftReDomain = this.gtGiftService.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        HashMap<String, Object> mapUserList = new HashMap<String, Object>();
        if (null != gtGiftUserReDomain.getGiftSendCode()) {
            mapUserList.put("giftUserType", "1");
            mapUserList.put("giftSendCode", gtGiftUserReDomain.getGiftSendCode());
            SupQueryResult<GtGiftUserReDomain> gtGiftUserReDomainList = this.gtGiftUserService.queryGiftUserPage(mapUserList);
            List gtGiftUserReDomainArr = gtGiftUserReDomainList.getList();
            Integer claimedNum = 0;
            Integer unclaimedNum = 0;
            Integer someClaimedNum = 0;
            if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
                ArrayList<GtGiftUserDomain> gtGiftUserDomainArr = new ArrayList<GtGiftUserDomain>();
                for (GtGiftUserReDomain gtGiftUserDomain : gtGiftUserReDomainArr) {
                    Integer n;
                    Integer n2;
                    if (gtGiftUserDomain.getDataState() == 0 || gtGiftUserDomain.getDataState() == 4) {
                        n2 = unclaimedNum;
                        n = unclaimedNum = Integer.valueOf(unclaimedNum + 1);
                    }
                    if (gtGiftUserDomain.getDataState() == 1) {
                        n2 = claimedNum;
                        n = claimedNum = Integer.valueOf(claimedNum + 1);
                    }
                    if (gtGiftUserDomain.getDataState() == 2) {
                        n2 = someClaimedNum;
                        n = someClaimedNum = Integer.valueOf(someClaimedNum + 1);
                    }
                    gtGiftUserDomainArr.add(gtGiftUserDomain);
                }
                gtGiftUserReDomain.setClaimedNum(claimedNum);
                gtGiftUserReDomain.setUnclaimedNum(unclaimedNum);
                gtGiftUserReDomain.setSomeClaimedNum(someClaimedNum);
                gtGiftReDomain.setGtGiftUserDomainList(gtGiftUserDomainArr);
            }
            gtGiftReDomain.setGtGiftUserDomain(gtGiftUserReDomain);
            HtmlJsonReBean htmlJsonReBean = this.gtGiftUserrelService.countGoodsByGiftCode(gtGiftUserReDomain.getGiftSendCode(), gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getMemberCode());
            Object countGoods = htmlJsonReBean.getDataObj();
            this.logger.debug("gift--------", (Object)(countGoods + "----------" + gtGiftUserReDomain.getGiftSendCode() + "-*-*-*-*----" + gtGiftUserReDomain.getMemberCode()));
            gtGiftReDomain.setCountGoods(countGoods);
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToBNotState.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u72b6\u6001")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToBNotState(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("notSendDataState", 0);
        param.put("companyCode", userSession.getUserPcode());
        SupQueryResult<GtGiftUserReDomain> giftUserList = this.gtGiftUserService.queryGiftUserPage(param);
        List giftUserArr = giftUserList.getList();
        ArrayList<GtGiftReDomain> gtGiftReDomainArr = new ArrayList<GtGiftReDomain>();
        if (null != giftUserArr && giftUserArr.size() > 0) {
            for (GtGiftUserReDomain gtGiftUserReDomain : giftUserArr) {
                GtGiftReDomain gtGiftReDomain = this.gtGiftService.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
                gtGiftReDomain.setGtGiftUserDomain(gtGiftUserReDomain);
                gtGiftReDomainArr.add(gtGiftReDomain);
            }
        }
        SupQueryResult gtGiftReDomain = new SupQueryResult();
        if (null != gtGiftReDomainArr) {
            gtGiftReDomain.setList(gtGiftReDomainArr);
            gtGiftReDomain.setPageTools(giftUserList.getPageTools());
            gtGiftReDomain.setTotal(giftUserList.getTotal());
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToBNotState2.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u72b6\u60012")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> queryGiftPageToBNotState2(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("companyCode", userSession.getUserPcode());
        SupQueryResult<GtGiftUserReDomain> gtGiftUserReDomainSupQueryResult = this.gtGiftUserService.queryGiftUserPage(param);
        if (ListUtil.isNotEmpty((Collection)gtGiftUserReDomainSupQueryResult.getList())) {
            for (GtGiftUserReDomain gtGiftUserReDomain : gtGiftUserReDomainSupQueryResult.getList()) {
                GtGiftSendReDomain gtGiftSendReDomain;
                if (!StringUtils.isNotBlank((String)gtGiftUserReDomain.getGiftSendCode()) || null == (gtGiftSendReDomain = this.gtGiftSendService.getGiftSendByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftSendCode())) || !gtGiftSendReDomain.getDataState().equals(1)) continue;
                gtGiftUserReDomain.setGrantNum(gtGiftSendReDomain.getEmployeeNum());
            }
        }
        return gtGiftUserReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryGiftUserByGiftUserCodeToB.json"}, name="wap\u7aef \u4f01\u4e1a\u67e5\u770b\u53d1\u653e\u8bb0\u5f55\u91cc\u9762\u7684\u793c\u5305\u8be6\u60c5")
    @ResponseBody
    public GtGiftReDomain queryGiftUserByGiftUserCodeToB(HttpServletRequest request, String giftUserCode) {
        GtGiftSendReDomain gtGiftSendReDomain;
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryGiftUserByGiftUserCodeToB", (Object)"giftUserCode is null");
            return null;
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserService.getGiftUserByCode(this.getTenantCode(request), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftService.getGiftByCode(this.getTenantCode(request), gtGiftUserReDomain.getGiftCode());
        if (StringUtils.isNotBlank((String)gtGiftUserReDomain.getGiftSendCode()) && null != (gtGiftSendReDomain = this.gtGiftSendService.getGiftSendByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftSendCode())) && gtGiftSendReDomain.getDataState().equals(1)) {
            gtGiftUserReDomain.setGrantNum(gtGiftSendReDomain.getEmployeeNum());
        }
        gtGiftReDomain.setGtGiftUserDomain(gtGiftUserReDomain);
        if (StringUtils.isNotBlank((String)gtGiftUserReDomain.getGiftSendCode())) {
            HashMap<String, Object> mapUserList = new HashMap<String, Object>();
            mapUserList.put("giftUserType", "1");
            mapUserList.put("giftSendCode", gtGiftUserReDomain.getGiftSendCode());
            SupQueryResult<GtGiftUserReDomain> gtGiftUserReDomainList = this.gtGiftUserService.queryGiftUserPage(mapUserList);
            List gtGiftUserReDomainArr = gtGiftUserReDomainList.getList();
            ArrayList<GtGiftUserDomain> gtGiftUserDomainArr = new ArrayList<GtGiftUserDomain>();
            if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
                for (GtGiftUserReDomain gtGiftUserDomain : gtGiftUserReDomainArr) {
                    gtGiftUserDomainArr.add(gtGiftUserDomain);
                }
            }
            gtGiftReDomain.setGtGiftUserDomainList(gtGiftUserDomainArr);
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftSendlistPageByGiftSendCodeToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u5305\u9886\u53d6\u7684\u8be6\u60c5\uff08\u67e5\u770b\u5458\u5de5\u9886\u53d6\u5217\u8868\uff09")
    @ResponseBody
    public GtGiftReDomain queryGiftSendlistPageByGiftSendCodeToC(String giftSendId) {
        if (null == giftSendId) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"giftSendId is null");
            return null;
        }
        GtGiftSendReDomain gtGiftSendReDomain = this.gtGiftSendService.getGiftSend(Integer.valueOf(giftSendId));
        ArrayList<GtGiftSendReDomain> gtGiftSendDomainList = new ArrayList<GtGiftSendReDomain>();
        gtGiftSendDomainList.add(gtGiftSendReDomain);
        HashMap<String, Object> maprel = new HashMap<String, Object>();
        maprel.put("giftSendCode", gtGiftSendReDomain);
        List GtGiftRelReDomain2 = this.gtGiftRelService.queryGiftRelPage(maprel).getList();
        GtGiftReDomain gtGiftReDomain = this.gtGiftService.getGiftByCode(gtGiftSendReDomain.getTenantCode(), gtGiftSendReDomain.getGiftCode());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("giftCode", gtGiftSendReDomain.getGiftCode());
        SupQueryResult<GtGiftSendlistReDomain> gtGiftSendlistDomain = this.gtGiftSendlistService.queryGiftSendlistPage(param);
        if (null == gtGiftSendlistDomain) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"gtGiftSendlistDomain is null");
            return null;
        }
        List gtGiftSendlistDomainList = gtGiftSendlistDomain.getList();
        if (null == gtGiftSendlistDomainList || gtGiftSendlistDomainList.size() == 0) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"gtGiftSendlistDomainList is null");
            return null;
        }
        gtGiftReDomain.setGtGiftSendlistDomainList(gtGiftSendlistDomainList);
        gtGiftReDomain.setGtGiftSendDomainList(gtGiftSendDomainList);
        gtGiftReDomain.setGtGiftRelDomainList(GtGiftRelReDomain2);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "1");
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult<GtGiftUserReDomain> gtGiftUserReDomainList = this.gtGiftUserService.queryGiftUserPage(param);
        List giftUserDomainArr = gtGiftUserReDomainList.getList();
        ArrayList<GtGiftReDomain> gtGiftReDomainList = new ArrayList<GtGiftReDomain>();
        long time = 2592000000L;
        if (null != giftUserDomainArr && giftUserDomainArr.size() > 0) {
            for (GtGiftUserReDomain gtGiftUserReDomain : giftUserDomainArr) {
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime > 0L && endTime < time) {
                    gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
                }
                GtGiftReDomain gtGiftReDomain = this.gtGiftService.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
                HashMap<String, String> fileMap = new HashMap<String, String>();
                fileMap.put("giftCode", gtGiftUserReDomain.getGiftCode());
                gtGiftReDomain.setGtGiftUserDomain(gtGiftUserReDomain);
                gtGiftReDomainList.add(gtGiftReDomain);
            }
        }
        SupQueryResult gtGiftReDomain = new SupQueryResult();
        if (null != gtGiftReDomainList) {
            gtGiftReDomain.setList(gtGiftReDomainList);
            gtGiftReDomain.setTotal(gtGiftUserReDomainList.getTotal());
            gtGiftReDomain.setPageTools(gtGiftUserReDomainList.getPageTools());
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToC2.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> queryGiftPageToC2(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "1");
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult<GtGiftUserReDomain> gtGiftUserReDomainList = this.gtGiftUserService.queryGiftUserPage(param);
        List giftUserDomainArr = gtGiftUserReDomainList.getList();
        long time = 2592000000L;
        if (null != giftUserDomainArr && giftUserDomainArr.size() > 0) {
            for (GtGiftUserReDomain gtGiftUserReDomain : giftUserDomainArr) {
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime <= 0L || endTime >= time) continue;
                gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
            }
        }
        return gtGiftUserReDomainList;
    }

    @RequestMapping(value={"queryRelToC.json"}, name="wap\u5458\u5de5\u9886\u53d6\u793c\u54c1\u65f6\u663e\u793a\u7684\u5546\u54c1")
    @ResponseBody
    public GtGiftReDomain queryRelToC(HttpServletRequest request, String giftUserCode) {
        int userNum;
        UserSession userSession = this.getUserSession(request);
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryRelToC", (Object)"giftUserCode is null");
            return new GtGiftReDomain();
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserService.getGiftUserByCode(userSession.getTenantCode(), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftService.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        Map<String, Object> amap = this.getQueryMapParam("giftCode,tenantCode", gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode());
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelService.queryGiftRelPage(amap).getList());
        String cType = gtGiftReDomain.getGiftChange();
        if ("1".equals(cType)) {
            int userCnum = 0;
            if (null != gtGiftUserReDomain.getGiftUserCnum()) {
                userCnum = gtGiftUserReDomain.getGiftUserCnum().intValue();
            }
            userNum = gtGiftUserReDomain.getGiftUserNum().intValue();
            int num = gtGiftUserReDomain.getGiftCnum().intValue() * userNum - userCnum;
            gtGiftUserReDomain.setUserRelNum(num);
        }
        if ("0".equals(cType)) {
            int userAmt = 0;
            if (null != gtGiftUserReDomain.getGiftUserCamt()) {
                userAmt = gtGiftUserReDomain.getGiftUserCamt().intValue();
            }
            userNum = gtGiftUserReDomain.getGiftUserNum().intValue();
            int amt = gtGiftUserReDomain.getGiftCnum().intValue() * userNum - userAmt;
            gtGiftUserReDomain.setUserRelNum(amt);
        }
        gtGiftReDomain.setGtGiftUserDomain(gtGiftUserReDomain);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftUserRelToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u770b\u793c\u5305\u8be6\u60c5")
    @ResponseBody
    public GtGiftReDomain queryGiftUserRelToC(HttpServletRequest request, String giftUserCode) {
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryGiftUserRelToC", (Object)"giftUserCode is null");
            return new GtGiftReDomain();
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserService.getGiftUserByCode(this.getTenantCode(request), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftService.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        Map<String, Object> fileMap = this.getQueryMapParam("giftCode,tenantCode", gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode());
        gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileService.queryGiftFilePage(fileMap).getList());
        Map<String, Object> amap = this.getQueryMapParam("giftSendCode,memberBcode,giftUserCode", gtGiftUserReDomain.getGiftSendCode(), gtGiftUserReDomain.getMemberBcode(), gtGiftUserReDomain.getGiftUserCode());
        List gtGiftUserrelDomainArr = this.gtGiftUserrelService.queryGiftUserrelPage(amap).getList();
        ArrayList<GtGiftUserrelDomain> gtGiftUserrelDomainList = new ArrayList<GtGiftUserrelDomain>();
        if (null != gtGiftUserrelDomainArr && gtGiftUserrelDomainArr.size() > 0) {
            for (GtGiftUserrelReDomain GtGiftUserrelReDomain2 : gtGiftUserrelDomainArr) {
                if (null == GtGiftUserrelReDomain2.getGiftUserrelNum()) continue;
                gtGiftUserrelDomainList.add(GtGiftUserrelReDomain2);
            }
        }
        gtGiftReDomain.setGtGiftUserrelDomainList(gtGiftUserrelDomainList);
        gtGiftReDomain.setGtGiftUserDomain(gtGiftUserReDomain);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"updateGiftState.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGiftState(String giftId, Integer dataState, Integer oldDataState) {
        String[] id;
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String a : id = giftId.split(",")) {
            this.gtGiftService.updateGiftState(Integer.valueOf(a), dataState, oldDataState);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateGiftPrice.json"}, name="\u66f4\u65b0\u793c\u54c1\u552e\u4ef7")
    @ResponseBody
    public HtmlJsonReBean updateGiftPrice(String giftId, BigDecimal pricesetNprice) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"giftId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == pricesetNprice) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"pricesetNprice is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gtGiftService.updateGiftPrice(Integer.valueOf(giftId), pricesetNprice);
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"updateGiftShelfState.json"}, name="\u793c\u5305\u4e0a\u67b6\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateGiftShelfState(HttpServletRequest request, String giftId) {
        String[] giftIdArray;
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftShelfState", (Object)"giftId is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (String gid : giftIdArray = giftId.split(",")) {
            GtGiftReDomain gtGiftReDomain = this.getGift(Integer.valueOf(gid));
            if (null == gtGiftReDomain) {
                this.logger.error(CODE + ".updateGiftShelfState", (Object)"gtGiftReDomain is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "gtGiftReDomain");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsOrigin", "5");
            map.put("goodsNo", gtGiftReDomain.getGiftCode());
            map.put("tenantCode", gtGiftReDomain.getTenantCode());
            SupQueryResult<RsResourceGoodsReDomain> rsList = this.rsResourceGoodsService.queryResourceGoodsPage(map);
            if (null != rsList && null != rsList.getRows() && !rsList.getRows().isEmpty()) continue;
            RsResourceGoodsDomain rsResourceGoodsDomain = this.make(request, gtGiftReDomain);
            ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
            goodsList.add(rsResourceGoodsDomain);
            HtmlJsonReBean htmlJsonReBean1 = this.rsResourceGoodsService.savePassResourceGoodsBatch(goodsList);
            String rs = htmlJsonReBean1.getErrorCode();
            if (StringUtils.isNotBlank((String)rs)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
            }
            htmlJsonReBean = this.gtGiftService.updateGiftStateByCode(gtGiftReDomain.getTenantCode(), gtGiftReDomain.getGiftCode(), 1, 2);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateGiftLowerState.json"}, name="\u793c\u5305\u4e0b\u67b6\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateGiftLowerState(HttpServletRequest request, String giftCode) {
        String[] giftCodeArray;
        if (StringUtils.isBlank((String)giftCode)) {
            this.logger.error(CODE + ".updateGiftLowerState", (Object)"giftCode is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (String gcode : giftCodeArray = giftCode.split(",")) {
            HtmlJsonReBean htmlJsonReBean1;
            String errorCode;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String tenantCode = this.getTenantCode(request);
            map.put("goodsOrigin", "5");
            map.put("goodsNo", gcode);
            map.put("tenantCode", tenantCode);
            SupQueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainList = this.rsResourceGoodsService.queryResourceGoodsPage(map);
            List list = rsResourceGoodsReDomainList.getList();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (null != list && list.size() != 0) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)list.get(0);
                params.put("goodsOrigin", "5");
                params.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
                params.put("tenantCode", tenantCode);
            }
            if (StringUtils.isNotBlank((String)(errorCode = (htmlJsonReBean1 = this.rsResourceGoodsService.delResourceGoodsByCode(params)).getErrorCode()))) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5220\u9664\u5546\u54c1\u5931\u8d25");
            }
            htmlJsonReBean = this.gtGiftService.updateGiftStateByCode(tenantCode, gcode, 2, 1);
        }
        return htmlJsonReBean;
    }

    private RsResourceGoodsDomain make(HttpServletRequest request, GtGiftReDomain gtGiftReDomain) {
        List<GtGiftRelReDomain> gtGiftRelReDomain;
        if (null == gtGiftReDomain || null == request) {
            return null;
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsName(gtGiftReDomain.getGiftName());
        rsResourceGoodsDomain.setGoodsNo(gtGiftReDomain.getGiftCode());
        rsResourceGoodsDomain.setPntreeCode(gtGiftReDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(gtGiftReDomain.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(gtGiftReDomain.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(gtGiftReDomain.getClasstreeName());
        rsResourceGoodsDomain.setPricesetNprice(gtGiftReDomain.getPricesetNprice());
        rsResourceGoodsDomain.setPricesetMakeprice(gtGiftReDomain.getPricesetMakeprice());
        rsResourceGoodsDomain.setBrandCode(gtGiftReDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(gtGiftReDomain.getBrandName());
        UserSession userSession = this.getUserSession(request);
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(userSession.getUserName());
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsOrigin("5");
        rsResourceGoodsDomain.setGoodsType("05");
        rsResourceGoodsDomain.setPricesetMakeshow("1");
        rsResourceGoodsDomain.setPartsnameNumunit("\u4e2a");
        rsResourceGoodsDomain.setGoodsWeight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsSupplyweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsAhweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangnum(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsNum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsAhnum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsSupplynum(new BigDecimal("9999"));
        this.makeChannel(rsResourceGoodsDomain, request);
        List<GtGiftFileReDomain> gtGiftFileReDomain = gtGiftReDomain.getGtGiftFileDomainList();
        if (!ListUtil.isEmpty(gtGiftFileReDomain)) {
            ArrayList<RsGoodsFileDomain> rsGoodsFileList = new ArrayList<RsGoodsFileDomain>();
            for (GtGiftFileReDomain gtGiftFileReDomain2 : gtGiftFileReDomain) {
                RsGoodsFileDomain rsGoodsFile = new RsGoodsFileDomain();
                rsGoodsFile.setGoodsFileName(gtGiftFileReDomain2.getGiftFileFilename());
                rsGoodsFile.setAppmanageIcode(gtGiftFileReDomain2.getAppmanageIcode());
                rsGoodsFile.setGoodsFileSort(gtGiftFileReDomain2.getGiftFileSort());
                rsGoodsFile.setGoodsFileType(gtGiftFileReDomain2.getGiftFileType());
                rsGoodsFile.setGoodsFilesortName(gtGiftFileReDomain2.getGiftFilesortName());
                rsGoodsFile.setGoodsFileUrl(gtGiftFileReDomain2.getGiftFileFileUrl());
                rsGoodsFile.setTenantCode(gtGiftFileReDomain2.getTenantCode());
                rsGoodsFileList.add(rsGoodsFile);
            }
            rsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileList);
        }
        if (ListUtil.isNotEmpty(gtGiftRelReDomain = gtGiftReDomain.getGtGiftRelDomainList())) {
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
            for (GtGiftRelReDomain gtGiftRel : gtGiftRelReDomain) {
                RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
                rsGoodsRelDomain.setGoodsRelGcode(gtGiftRel.getGoodsCode());
                rsGoodsRelDomain.setMemberCcode(gtGiftRel.getMemberCcode());
                rsGoodsRelDomain.setMemberCname(gtGiftRel.getMemberCname());
                rsGoodsRelDomain.setSkuCode(gtGiftRel.getSkuCode());
                rsGoodsRelDomain.setSkuName(gtGiftRel.getSkuName());
                rsGoodsRelDomain.setSkuNo(gtGiftRel.getSkuNo());
                rsGoodsRelDomain.setSkuShowno(gtGiftRel.getSkuShowno());
                rsGoodsRelDomain.setPricesetNprice(gtGiftRel.getPricesetNprice());
                rsGoodsRelDomain.setPricesetMakeprice(gtGiftRel.getPricesetMakeprice());
                rsGoodsRelDomain.setPricesetBaseprice(gtGiftRel.getPricesetBaseprice());
                rsGoodsRelDomain.setGoodsWeight(gtGiftRel.getGoodsWeight());
                rsGoodsRelDomain.setGoodsNum(gtGiftRel.getGoodsNum());
                rsGoodsRelDomain.setDataPic(gtGiftRel.getDataPic());
                rsGoodsRelDomain.setDataPicpath(gtGiftRel.getDataPicpath());
                rsGoodsRelDomain.setAppmanageIcode(gtGiftRel.getAppmanageIcode());
                rsGoodsRelDomainList.add(rsGoodsRelDomain);
            }
            rsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
        }
        ArrayList<RsSpecValueDomain> RsSpecValueList = new ArrayList<RsSpecValueDomain>();
        GtGiftSpecDomain gtGiftSpecDomain = gtGiftReDomain.getGtGiftSpecDomainList().get(0);
        RsSpecValueDomain rsSpecValue = new RsSpecValueDomain();
        rsSpecValue.setSpecCode(gtGiftSpecDomain.getSpecCode());
        rsSpecValue.setSpecName(gtGiftSpecDomain.getSpecName());
        rsSpecValue.setSpecGroupCode(gtGiftSpecDomain.getSpecGroupCode());
        rsSpecValue.setSpecValueBillno(gtGiftReDomain.getGiftCode());
        rsSpecValue.setSpecValueFlag(gtGiftSpecDomain.getSpecValueFlag());
        rsSpecValue.setSpecValueType(gtGiftSpecDomain.getSpecValueType());
        rsSpecValue.setSpecValueValue(gtGiftSpecDomain.getSpecValueValue());
        rsSpecValue.setTenantCode(gtGiftReDomain.getTenantCode());
        RsSpecValueList.add(rsSpecValue);
        rsResourceGoodsDomain.setRsSpecValueDomainList(RsSpecValueList);
        return rsResourceGoodsDomain;
    }
}

