/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.sp;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.util.ExportExcelUtlis;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.ct.CtCustrelReDomain;
import cn.com.qj.bff.domain.fm.FmFileDomainBean;
import cn.com.qj.bff.domain.fm.FmFileReDomainBean;
import cn.com.qj.bff.domain.oc.ContractType;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.SkuDomain;
import cn.com.qj.bff.domain.org.OrgUserBean;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.sp.ContractTypeEnum;
import cn.com.qj.bff.domain.sp.CreateSignTaskWithTemplateDomain;
import cn.com.qj.bff.domain.sp.SignTaskCallBackEventEnum;
import cn.com.qj.bff.domain.sp.SpScontractDomain;
import cn.com.qj.bff.domain.sp.SpScontractExcelExportTemplate;
import cn.com.qj.bff.domain.sp.SpScontractFileDomain;
import cn.com.qj.bff.domain.sp.SpScontractFileReDomain;
import cn.com.qj.bff.domain.sp.SpScontractGoodsDomain;
import cn.com.qj.bff.domain.sp.SpScontractGoodsReDomain;
import cn.com.qj.bff.domain.sp.SpScontractReDomain;
import cn.com.qj.bff.domain.um.UmUserDomainBean;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.ct.CtCustrelService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.sp.SignTaskService;
import cn.com.qj.bff.service.sp.SpScontractBaseService;
import cn.com.qj.bff.service.sp.SpScontractService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/sp/scontract"}, name="\u9500\u552e\u5408\u540c")
public class SpScontractCon
extends SpringmvcController {
    private static final String CODE = "sp.scontract.con";
    @Autowired
    private SpScontractService spScontractService;
    @Autowired
    private OrgCompanyService orgCompanyService;
    @Autowired
    private CtCustrelService ctCustrelService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private UserService userService;
    @Autowired
    private SpScontractBaseService spScontractBaseService;
    @Autowired
    private SignTaskService signTaskService;

    @Override
    protected String getContext() {
        return "scontract";
    }

    @RequestMapping(value={"saveScontract.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        HtmlJsonReBean htmlJsonReBean;
        if (null == spScontractDomain) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isEmpty((String)spScontractDomain.getContractPmode())) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"ContractEffectivedate is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u586b\u5199\u5408\u540c\u7c7b\u578b");
        }
        spScontractDomain.setChannelCode(BaseInterUtil.getChannelCode((HttpServletRequest)request));
        spScontractDomain.setScontractNbcode(this.createUUIDString().replace("-", ""));
        String tenantCode = this.getTenantCode(request);
        spScontractDomain.setTenantCode(tenantCode);
        if (StringUtils.equals((CharSequence)"3", (CharSequence)spScontractDomain.getContractPmode())) {
            this.createLrAgreementCheck(spScontractDomain);
            this.handleSpScontractGoodsDomain(spScontractDomain);
            spScontractDomain.setContractProperty("4");
        } else if (spScontractDomain.getContractEffectivedate() == null) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"ContractEffectivedate is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u586b\u5199\u751f\u6548\u7ed3\u675f\u65f6\u95f4");
        }
        UmUserinfoReDomainBean userinfoReDomainBean = this.userService.getUserInfoByUserinfoCode(tenantCode, spScontractDomain.getMemberBcode());
        if (userinfoReDomainBean != null) {
            spScontractDomain.setEmployeeCode(userinfoReDomainBean.getEmployeeCode());
            spScontractDomain.setEmployeeName(userinfoReDomainBean.getEmployeeName());
        }
        if ((htmlJsonReBean = this.spScontractBaseService.sendSaveScontract(spScontractDomain)).isSuccess()) {
            String scontractCode = String.valueOf(htmlJsonReBean.getDataObj());
            if (StringUtils.equals((CharSequence)"1", (CharSequence)spScontractDomain.getDataStatestr())) {
                this.spScontractBaseService.sendUpdateScontractStateByCode(tenantCode, scontractCode, 1, 0, null);
            }
        }
        return htmlJsonReBean;
    }

    private void createLrAgreementCheck(SpScontractDomain spScontractDomain) throws ApiException {
        if (StringUtils.isBlank((String)spScontractDomain.getContractType())) {
            throw new ApiException("contractType", "\u534f\u8bae\u7c7b\u578b\u5fc5\u586b\uff01");
        }
        if (!ContractTypeEnum.getAllCodes().contains(spScontractDomain.getContractType())) {
            String msg = String.format("\u534f\u8bae\u7c7b\u578b<%s>\u4e0d\u5408\u6cd5\uff01\u76ee\u524d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b\u6709\uff1a%s", spScontractDomain.getContractType(), String.join((CharSequence)",", ContractTypeEnum.getAllCodes()));
            throw new ApiException("contractType", msg);
        }
        if (StringUtils.isBlank((String)spScontractDomain.getScontractBcode())) {
            throw new ApiException("scontractBcode", "\u534f\u8bae\u7f16\u53f7\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getScontractName())) {
            throw new ApiException("scontractName", "\u534f\u8bae\u540d\u79f0\u5fc5\u586b\uff01");
        }
        if (ObjectUtil.isNull((Object)spScontractDomain.getDataBmoney())) {
            throw new ApiException("dataBmoney", "\u534f\u8bae\u91d1\u989d\u5fc5\u586b\uff01");
        }
        if (spScontractDomain.getDataBmoney().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ApiException("dataBmoney", "\u534f\u8bae\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff01");
        }
        if (ObjectUtil.isNull((Object)spScontractDomain.getContractDepositdate())) {
            throw new ApiException("contractDepositdate", "\u534f\u8bae\u751f\u6548\u65f6\u95f4\u5fc5\u586b\uff01");
        }
        if (ObjectUtil.isNull((Object)spScontractDomain.getContractEffectivedate())) {
            throw new ApiException("contractEffectivedate", "\u534f\u8bae\u7ed3\u675f\u65f6\u95f4\u5fc5\u586b\uff01");
        }
        if (spScontractDomain.getContractDepositdate().compareTo(spScontractDomain.getContractEffectivedate()) > 0) {
            throw new ApiException("contractDepositdate", "\u534f\u8bae\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (spScontractDomain.getContractEffectivedate().compareTo(spScontractDomain.getContractDepositdate()) < 0) {
            throw new ApiException("contractEffectivedate", "\u534f\u8bae\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65f6\u95f4\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getMemberBcode())) {
            throw new ApiException("memberBcode", "\u670d\u52a1\u5546\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getMemberBname())) {
            throw new ApiException("memberBname", "\u670d\u52a1\u5546\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getMemberGcode())) {
            throw new ApiException("memberGcode", "\u534f\u8bae\u65b9\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getMemberGname())) {
            throw new ApiException("memberGname", "\u534f\u8bae\u65b9\u5fc5\u586b\uff01");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getSpScontractGoodsDomainListStr())) {
            throw new ApiException("spScontractGoodsDomainListStr", "\u8bf7\u6dfb\u52a0\u534f\u8bae\u5546\u54c1\uff01");
        }
        spScontractDomain.setSpScontractGoodsDomainList(JsonUtil.buildNormalBinder().getJsonToList(spScontractDomain.getSpScontractGoodsDomainListStr(), SpScontractGoodsDomain.class));
        spScontractDomain.getSpScontractGoodsDomainList().forEach(spScontractGoodsDomain -> {
            if (StringUtils.isBlank((String)spScontractGoodsDomain.getSkuCode())) {
                throw new ApiException("spScontractGoodsDomainList", "\u534f\u8bae\u5546\u54c1 skuCode \u5fc5\u586b\uff01");
            }
        });
        List skuCodeListGoodsNum = spScontractDomain.getSpScontractGoodsDomainList().stream().filter(item -> ObjectUtil.isNull((Object)item.getGoodsNum()) || item.getGoodsNum().compareTo(BigDecimal.ZERO) <= 0).map(SpScontractGoodsDomain::getSkuCode).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(skuCodeListGoodsNum)) {
            throw new ApiException("spScontractGoodsDomainList", String.format("\u534f\u8bae\u5546\u54c1<%s>\u6570\u91cf\u5fc5\u586b\uff0c\u4e14\u5fc5\u987b\u5927\u4e8e0\uff01", String.join((CharSequence)",", skuCodeListGoodsNum)));
        }
        List skuCodeListGoodsPrice = spScontractDomain.getSpScontractGoodsDomainList().stream().filter(item -> ObjectUtil.isNull((Object)item.getContractGoodsPrice()) || item.getContractGoodsPrice().compareTo(BigDecimal.ZERO) <= 0).map(SpScontractGoodsDomain::getSkuCode).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(skuCodeListGoodsPrice)) {
            throw new ApiException("spScontractGoodsDomainList", String.format("\u534f\u8bae\u5546\u54c1<%s>\u5408\u540c\u5355\u4ef7\u5fc5\u586b\uff0c\u4e14\u5fc5\u987b\u5927\u4e8e0\uff01", String.join((CharSequence)",", skuCodeListGoodsPrice)));
        }
        BigDecimal contractAmount = spScontractDomain.getSpScontractGoodsDomainList().stream().map(item -> item.getGoodsNum().multiply(item.getContractGoodsPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (contractAmount.compareTo(spScontractDomain.getDataBmoney()) != 0) {
            throw new ApiException("spScontractGoodsDomainList", String.format("\u534f\u8bae\u91d1\u989d<%s>\u4e0e\u534f\u8bae\u5546\u54c1\u6570\u91cf*\u5408\u540c\u5355\u4ef7<%s>\u4e0d\u4e00\u81f4\uff01", spScontractDomain.getDataBmoney(), contractAmount));
        }
        if (StringUtils.isNotBlank((String)spScontractDomain.getSpScontractFileDomainListStr())) {
            spScontractDomain.setSpScontractFileDomainList(JsonUtil.buildNormalBinder().getJsonToList(spScontractDomain.getSpScontractFileDomainListStr(), SpScontractFileDomain.class));
            for (SpScontractFileDomain spScontractFileDomain : spScontractDomain.getSpScontractFileDomainList()) {
                if (StringUtils.isBlank((String)spScontractFileDomain.getScontractFileSname())) {
                    throw new ApiException("scontractFileSname", "\u534f\u8bae\u6587\u4ef6\u540e\u7f00\u540d\u5fc5\u586b\uff01");
                }
                if (StringUtils.isBlank((String)spScontractFileDomain.getScontractFileType())) {
                    throw new ApiException("scontractFileType", "\u534f\u8bae\u6587\u4ef6\u7c7b\u578b\u5fc5\u586b\uff01");
                }
                if (StringUtils.isBlank((String)spScontractFileDomain.getScontractFileName())) {
                    throw new ApiException("scontractFileName", "\u534f\u8bae\u6587\u4ef6\u540d\u5fc5\u586b\uff01");
                }
                if (!StringUtils.isBlank((String)spScontractFileDomain.getScontractFileUrl())) continue;
                throw new ApiException("scontractFileUrl", "\u534f\u8bae\u6587\u4ef6url\u5fc5\u586b\uff01");
            }
        }
    }

    private void handleSpScontractGoodsDomain(SpScontractDomain spScontractDomain) throws ApiException {
        spScontractDomain.getSpScontractGoodsDomainList().forEach(spScontractGoodsDomain -> {
            String skuCode = spScontractGoodsDomain.getSkuCode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuCode", skuCode);
            map.put("tenantCode", spScontractDomain.getTenantCode());
            RsSkuReDomain rsSkuReDomain = this.rsSkuService.getSkuByCode(map);
            if (ObjectUtil.isNull((Object)rsSkuReDomain)) {
                throw new ApiException("skuCode", "\u5546\u54c1\u4e0d\u5b58\u5728\uff01skuCode\uff1a" + skuCode);
            }
            if (ObjectUtil.notEqual((Object)1, (Object)rsSkuReDomain.getDataOpbillstate())) {
                throw new ApiException("skuCode", "\u5546\u54c1\u672a\u4e0a\u67b6\uff01skuCode\uff1a" + skuCode);
            }
            BigDecimal goodsNum = spScontractGoodsDomain.getGoodsNum();
            BigDecimal contractGoodsPrice = spScontractGoodsDomain.getContractGoodsPrice();
            BeanUtil.copyProperties((Object)rsSkuReDomain, (Object)spScontractGoodsDomain, (String[])new String[0]);
            spScontractGoodsDomain.setScontractGoodsType(0);
            spScontractGoodsDomain.setContractGoodsGtype("0");
            spScontractGoodsDomain.setGoodsNum(goodsNum);
            spScontractGoodsDomain.setContractGoodsPrice(contractGoodsPrice);
        });
    }

    @RequestMapping(value={"queryScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        String fileName = "scontractlist";
        boolean exportFlag = false;
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (ObjectUtil.isNotNull((Object)param.get("fileName"))) {
                fileName = param.get("fileName").toString();
            }
            if (ObjectUtil.isNotNull((Object)param.get("exportFlag"))) {
                exportFlag = Boolean.parseBoolean(param.get("exportFlag").toString());
            }
        }
        this.setUserMap(request, param);
        if (exportFlag) {
            UserSession userSession = this.getUserSession(request);
            String userCode = null == userSession ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("headMap", SpScontractExcelExportTemplate.covertScontractPage());
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            try {
                this.exportExcel(param, infoMap, "sp.scontract.queryScontractPage", "sp");
            }
            catch (Exception e) {
                this.logger.error("sp.scontract.con.queryScontractPage.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        SupQueryResult<SpScontractReDomain> scontractReDomainSupQueryResult = this.spScontractService.queryScontractPage(param);
        scontractReDomainSupQueryResult.getList().forEach(spScontractReDomain -> {
            UmUserinfoReDomainBean userinfoReDomainBean;
            if (null == spScontractReDomain.getEmployeeCode() && (userinfoReDomainBean = this.userService.getUserInfoByUserinfoCode(spScontractReDomain.getMemberBcode(), spScontractReDomain.getTenantCode())) != null) {
                spScontractReDomain.setEmployeeCode(userinfoReDomainBean.getEmployeeCode());
                spScontractReDomain.setEmployeeName(userinfoReDomainBean.getEmployeeName());
            }
        });
        return scontractReDomainSupQueryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FmFileReDomainBean exportExcel(Map<String, Object> paramMap, Map<String, Object> infoMap, String apiRouter, String dataType) {
        ArrayList<String> data;
        String json;
        PostParamMap pmap;
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap) || StringUtils.isBlank((String)apiRouter)) {
            this.logger.error("SpScontractCon.exportExcel", (Object)"param is null");
            return null;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        if (null == infoMap.get("userCode")) {
            this.logger.error("SpScontractCon.exportExcel", (Object)"userCode is null");
            return null;
        }
        String userCode = (String)infoMap.get("userCode");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        fileName = formatData + "-" + fileName;
        this.logger.debug("=====SpScontractCon.fileName=====", (Object)fileName);
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        List headMapList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNormalBinder().toJson(headMap), Object.class);
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle setBorder = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBoldweight((short)700);
            setBorder.setFont(font);
            cell.setCellStyle(setBorder);
        }
        int index = 0;
        int page = null == paramMap.get("page") ? 1 : Integer.valueOf(paramMap.get("page").toString());
        this.logger.debug("====SpScontractCon.paramMap=======", paramMap);
        while (true) {
            this.logger.debug("====SpScontractCon\u3002time=====.t1", (Object)System.currentTimeMillis());
            paramMap.put("page", page);
            this.makePage(paramMap);
            pmap = new PostParamMap(apiRouter);
            pmap.putParamToJson("map", paramMap);
            json = this.htmlIBaseService.sendMesReJson(pmap);
            List<Map<String, Object>> fromDataList = this.makeExcelData(json, dataType);
            if (ListUtil.isEmpty(fromDataList)) break;
            this.logger.error("SpScontractCon.exportExcel.fromDataList.num", (Object)(pmap.toString() + "=" + json));
            ArrayList<String[]> dataList = new ArrayList<String[]>();
            data = null;
            for (Map<String, Object> map : fromDataList) {
                data = new ArrayList<String>();
                for (Map map1 : headMapList) {
                    String beanName = map1.get("dataName").toString();
                    String value = "";
                    if (StringUtils.isNotBlank((String)beanName)) {
                        String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                        if ("null".equals(value)) {
                            value = "";
                        }
                    }
                    data.add(value);
                }
                String[] array = data.toArray(new String[data.size()]);
                dataList.add(array);
            }
            try {
                ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)index);
            }
            catch (Exception e) {
                this.logger.error("SpScontractCon.exportExcel", (Throwable)e);
                return null;
            }
            index += dataList.size();
            ++page;
            this.logger.debug("====SpScontractCon.exportExcel time=====.t2", (Object)System.currentTimeMillis());
        }
        this.logger.error("SpScontractCon.exportExcel.fromDataList", (Object)(pmap.toString() + "=" + json));
        String fileType = "xls";
        String tempPath = "/tmp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("SpScontractCon.exportExcel.tempPath", (Object)tempPath);
            return null;
        }
        this.logger.debug("sp.scontract.conSpScontractCon.exportExcel.tempPath", (Object)tempPath);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempPath);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            this.logger.error("SpScontractCon.exportExcel.close", (Throwable)e);
            data = null;
            return data;
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
        }
        catch (Exception e) {
            this.logger.error("SpScontractCon.exportExcel.InputStreamByteArray", (Throwable)e);
            return null;
        }
        return this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }

    private FmFileReDomainBean saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("SpScontractCon.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "--" + fileType + "-" + tenantCode));
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileCtype("xls");
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        return this.saveFile(fileBean, tenantCode, "FILE_11", fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean fmFileDomainBeanBean) {
        if (null == fmFileDomainBeanBean || null == fileBean) {
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            PostParamMap pmapReq = new PostParamMap("fm.file.saveFile");
            fmFileDomainBeanBean.setFileType("0");
            fmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            fmFileDomainBeanBean.setTenantCode(tenantCode);
            fmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmapReq.putParamToJson("fmFileDomainBean", (Object)fmFileDomainBeanBean);
            pmapReq.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            this.logger.debug("sp.scontract.con.saveFileSaveExcel", (Object)("====================pmap" + JsonUtil.buildNormalBinder().toJson((Object)pmapReq)));
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmapReq, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = "/paas/shop";
            }
            if (null == fmFileReDomainBean) {
                this.logger.error("sp.scontract.con.saveFileSaveExcelStr", (Object)("pmap" + JsonUtil.buildNonDefaultBinder().toJson((Object)pmapReq)));
                return fmFileReDomainBean;
            }
            String fileUrl = fmFileReDomainBean.getFileUrl();
            if (StringUtils.isNotBlank((String)fileUrl) && !fileUrl.trim().substring(0, 4).equals("http")) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("sp.scontract.con.saveFile", (Throwable)e);
        }
        return fmFileReDomainBean;
    }

    private void makePage(Map<String, Object> map) {
        String rows;
        String page;
        String ui_page = "page";
        String ui_rows = "rows";
        String dao_startRow = "startRow";
        String dao_endRow = "endRow";
        if (null == map || map.isEmpty()) {
            return;
        }
        String string = page = null == map.get(ui_page) ? "1" : map.get(ui_page).toString();
        if (null == page) {
            return;
        }
        if (StringUtils.isBlank((String)page)) {
            page = "1";
        }
        String string2 = rows = null == map.get(ui_rows) ? "0" : map.get(ui_rows).toString();
        if (StringUtils.isBlank((String)rows) || "0".equals(rows)) {
            rows = "10";
        }
        map.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
        map.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
        map.put(ui_rows, Long.valueOf(rows).intValue());
        map.put(ui_page, Long.valueOf(page).intValue());
    }

    private List<Map<String, Object>> makeExcelData(String json, String dataType) {
        Map objectToMap;
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error("sp.scontract.con.makeExcelData.supQueryResult", (Object)(" is null" + json));
            return null;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (StringUtils.equals((CharSequence)dataType, (CharSequence)"sp")) {
            List contractReDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), SpScontractReDomain.class);
            if (ListUtil.isEmpty((Collection)contractReDomainList)) {
                this.logger.error("sp.scontract.con.makeExcelData.contractReDomainList", (Object)(" is null" + json));
                return null;
            }
            for (SpScontractReDomain sp : contractReDomainList) {
                objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)sp), String.class, Object.class);
                Map<String, Object> stringObjectMap = this.coverSpScontractExportData(objectToMap);
                mapList.add(stringObjectMap);
            }
        }
        if (StringUtils.equals((CharSequence)dataType, (CharSequence)"spg")) {
            List contractGoodsReDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), SpScontractGoodsReDomain.class);
            if (ListUtil.isEmpty((Collection)contractGoodsReDomainList)) {
                this.logger.error("sp.scontract.con.makeExcelData.contractReDomainList", (Object)(" is null" + json));
                return null;
            }
            for (SpScontractGoodsReDomain spg : contractGoodsReDomainList) {
                objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)spg), String.class, Object.class);
                mapList.add(objectToMap);
            }
        }
        return mapList;
    }

    private Map<String, Object> coverSpScontractExportData(Map<String, Object> map) {
        Integer dataState = Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 0: {
                map.put("dataState", "\u5f85\u63d0\u4ea4");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u7b7e\u7f72");
                break;
            }
            case 3: {
                map.put("dataState", "\u5ba1\u6838\u62d2\u7edd");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u7b7e\u7f72");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + dataState);
            }
        }
        return map;
    }

    @RequestMapping(value={"getScontract.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u4fe1\u606f")
    @ResponseBody
    public SpScontractReDomain getScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error("sp.scontract.con.getScontract", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontract(scontractId);
    }

    @RequestMapping(value={"updateScontractState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractState(HttpServletRequest request, String scontractId, Integer dataState, Integer oldDataState, String signFlag, String signTemplateId) {
        if (StringUtils.isBlank((String)scontractId)) {
            this.logger.error("sp.scontract.con.updateScontractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        boolean isSign = false;
        if (StringUtils.isNotBlank((String)signFlag)) {
            isSign = Boolean.parseBoolean(signFlag);
        }
        String tenantCode = this.getTenantCode(request);
        if (ObjectUtil.equal((Object)2, (Object)dataState) && StringUtils.equals((CharSequence)tenantCode, (CharSequence)"1053245264466858008")) {
            SpScontractReDomain contract;
            if (StringUtils.isBlank((String)signTemplateId)) {
                signTemplateId = "1765796573124194330";
            }
            if (ObjectUtil.isNull((Object)(contract = this.spScontractService.getScontract(Integer.valueOf(scontractId))))) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "scontractId\u65e0\u6548\uff01");
            }
            UserSession userSession = this.getUserSession(request);
            String userCode = null == userSession ? "" : userSession.getUserCode();
            HtmlJsonReBean signTask = this.createSignTask(tenantCode, userCode, signTemplateId, contract);
            if (ObjectUtil.isNull((Object)signTask)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u521b\u5efa\u7b7e\u7f72\u4efb\u52a1\u5f02\u5e38\uff01");
            }
            if (!signTask.isSuccess()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, signTask.getMsg());
            }
            String signTaskId = (String)signTask.getDataObj();
            contract.setScontractNcode(signTaskId);
            contract.setScontractScode(signTemplateId);
            contract.setDataStatestr("0");
            this.spScontractBaseService.sendUpdateScontract(contract);
        }
        return this.spScontractBaseService.sendUpdateScontractState(Integer.valueOf(scontractId), dataState, oldDataState, null);
    }

    private HtmlJsonReBean createSignTask(String tenantCode, String userCode, String signTemplateId, SpScontractReDomain contract) {
        CreateSignTaskWithTemplateDomain domain = new CreateSignTaskWithTemplateDomain();
        domain.setTenantCode(tenantCode);
        domain.setSignTaskSubject(contract.getScontractName());
        domain.setSignTemplateId(signTemplateId);
        domain.setTransReferenceId(contract.getScontractCode());
        CreateSignTaskWithTemplateDomain.Actor a1 = new CreateSignTaskWithTemplateDomain.Actor();
        a1.setActorId("\u534f\u8bae\u65b9");
        a1.setActorName(contract.getMemberGname());
        a1.setInitiator("1");
        a1.setUserCode(contract.getMemberGcode());
        CreateSignTaskWithTemplateDomain.Actor a2 = new CreateSignTaskWithTemplateDomain.Actor();
        a2.setActorId("\u670d\u52a1\u5546");
        a2.setActorName(contract.getMemberBname());
        a2.setUserCode(contract.getMemberBcode());
        domain.setActors(Arrays.asList(a1, a2));
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("headMap", SpScontractExcelExportTemplate.covertScontractGoodsPage());
        infoMap.put("userCode", userCode);
        infoMap.put("fileName", "\u9644\u4ef6");
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("scontractCode", contract.getScontractCode());
            FmFileReDomainBean ff = this.exportExcel(param, infoMap, "sp.scontract.queryScontractGoodsPage", "spg");
            if (ObjectUtil.isNotNull((Object)ff)) {
                CreateSignTaskWithTemplateDomain.Attach attach1 = new CreateSignTaskWithTemplateDomain.Attach();
                attach1.setAttachName("\u9644\u4ef6.xlsx");
                attach1.setAttachPath(ff.getRootPath());
                domain.setAttaches(Collections.singletonList(attach1));
            }
        }
        catch (Exception e) {
            this.logger.error("sp.scontract.con.queryScontractPage.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
        }
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo1 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo1.setFieldName("\u534f\u8bae\u7c7b\u578b");
        docFieldValueInfo1.setFieldValue(ContractTypeEnum.getDescByCode(contract.getContractType()));
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo2 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo2.setFieldName("\u534f\u8bae\u7f16\u53f7");
        docFieldValueInfo2.setFieldValue(contract.getScontractCode());
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo3 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo3.setFieldName("\u534f\u8bae\u540d\u79f0");
        docFieldValueInfo3.setFieldValue(contract.getScontractName());
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo4 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo4.setFieldName("\u534f\u8bae\u65b9");
        docFieldValueInfo4.setFieldValue(contract.getMemberGname());
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo5 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo5.setFieldName("\u670d\u52a1\u5546");
        docFieldValueInfo5.setFieldValue(contract.getMemberBname());
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo6 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo6.setFieldName("\u534f\u8bae\u91d1\u989d");
        docFieldValueInfo6.setFieldValue(String.valueOf(contract.getDataBmoney()));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5", Locale.CHINESE);
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo7 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo7.setFieldName("\u534f\u8bae\u751f\u6548\u65f6\u95f4");
        LocalDate contractDepositdate = contract.getContractDepositdate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        docFieldValueInfo7.setFieldValue(contractDepositdate.format(formatter));
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo8 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo8.setFieldName("\u534f\u8bae\u7ed3\u675f\u65f6\u95f4");
        LocalDate contractEffectivedate = contract.getContractEffectivedate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        docFieldValueInfo8.setFieldValue(contractEffectivedate.format(formatter));
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo9 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo9.setFieldName("\u9644\u4ef6\u6570\u91cf");
        docFieldValueInfo9.setFieldValue("1");
        CreateSignTaskWithTemplateDomain.DocFieldValueInfo docFieldValueInfo10 = new CreateSignTaskWithTemplateDomain.DocFieldValueInfo();
        docFieldValueInfo10.setFieldName("\u534f\u8bae\u63cf\u8ff0");
        docFieldValueInfo10.setFieldValue(contract.getContractRemark());
        domain.setDocFieldValues(Arrays.asList(docFieldValueInfo1, docFieldValueInfo2, docFieldValueInfo3, docFieldValueInfo4, docFieldValueInfo5, docFieldValueInfo6, docFieldValueInfo7, docFieldValueInfo8, docFieldValueInfo9, docFieldValueInfo10));
        return this.signTaskService.createSignTaskWithTemplate(domain);
    }

    @RequestMapping(value={"signTaskCallbackEvent.json"}, name="\u7b7e\u7f72\u4efb\u52a1\u56de\u8c03")
    @ResponseBody
    public String signTaskCallbackEvent(@RequestHeader HttpHeaders headers, @RequestParam(value="bizContent") String bizContent) {
        String transReferenceId;
        SpScontractReDomain contract;
        JSONObject bizJson;
        String signTaskStatus;
        String event = headers.getFirst("X-FASC-Event");
        this.logger.info(".callbackEvent:event=" + event + ",bizContent=" + bizContent);
        if (StringUtils.isNotBlank((String)event) && StringUtils.equals((CharSequence)event, (CharSequence)SignTaskCallBackEventEnum.SIGN_TASK_FINISHED.getCode()) && StringUtils.equals((CharSequence)(signTaskStatus = (bizJson = JSON.parseObject((String)bizContent)).getString("signTaskStatus")), (CharSequence)"task_finished") && ObjectUtil.isNotNull((Object)(contract = this.spScontractService.getScontract(Integer.valueOf(transReferenceId = bizJson.getString("transReferenceId")))))) {
            contract.setDataStatestr("1");
            this.spScontractBaseService.sendUpdateScontract(contract);
        }
        JSONObject result = new JSONObject();
        result.put("msg", (Object)"success");
        return result.toJSONString();
    }

    @RequestMapping(value={"updateScontract.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error("sp.scontract.con.updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Integer scontractId = spScontractDomain.getScontractId();
        if (ObjectUtil.isNull((Object)scontractId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "scontractId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)spScontractDomain.getContractPmode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "contractPmode \u4e0d\u80fd\u4e3a\u7a7a");
        }
        SpScontractReDomain scontract = this.spScontractService.getScontract(scontractId);
        if (ObjectUtil.isNull((Object)scontract)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "scontractId \u65e0\u6548");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        if (StringUtils.equals((CharSequence)"3", (CharSequence)spScontractDomain.getContractPmode())) {
            if (ObjectUtil.notEqual((Object)0, (Object)scontract.getDataState())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4ec5\u5f85\u63d0\u4ea4\u72b6\u6001\u53ef\u4ee5\u66f4\u65b0");
            }
            this.createLrAgreementCheck(spScontractDomain);
            this.handleSpScontractGoodsDomain(spScontractDomain);
            this.spScontractBaseService.sendUpdateScontract(spScontractDomain);
            List<SpScontractGoodsDomain> spScontractGoodsDomainList = spScontractDomain.getSpScontractGoodsDomainList();
            List scontractGoodsIdList = spScontractGoodsDomainList.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getScontractGoodsId())).map(SpScontractGoodsDomain::getScontractGoodsId).collect(Collectors.toList());
            scontract.getSpScontractGoodsReDomainList().forEach(spScontractGoodsDomain -> {
                if (scontractGoodsIdList.contains(spScontractGoodsDomain.getScontractGoodsId())) {
                    SpScontractGoodsDomain first = spScontractGoodsDomainList.stream().filter(item -> ObjectUtil.equals((Object)spScontractGoodsDomain.getScontractGoodsId(), (Object)item.getScontractGoodsId())).findFirst().orElse(null);
                    if (first != null) {
                        first.setTenantCode(this.getTenantCode(request));
                        this.spScontractService.updateScontractGoods(first);
                    }
                } else {
                    this.spScontractService.deleteScontractGoods(spScontractGoodsDomain.getScontractGoodsId());
                }
            });
            spScontractGoodsDomainList.forEach(spScontractGoodsDomain -> {
                if (ObjectUtil.isNull((Object)spScontractGoodsDomain.getScontractGoodsId())) {
                    spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
                    spScontractGoodsDomain.setScontractCode(scontract.getScontractCode());
                    this.spScontractService.saveScontractGoods((SpScontractGoodsDomain)spScontractGoodsDomain);
                }
            });
            List<SpScontractFileDomain> spScontractFileDomainList = spScontractDomain.getSpScontractFileDomainList();
            List<SpScontractFileReDomain> spScontractFileDomainListHa = scontract.getSpScontractFileReDomainList();
            if (CollectionUtil.isEmpty(spScontractFileDomainList) && CollectionUtil.isNotEmpty(spScontractFileDomainListHa)) {
                spScontractFileDomainListHa.forEach(spScontractFileDomain -> this.spScontractService.deleteScontractFile(spScontractFileDomain.getScontractFileId()));
            } else if (CollectionUtil.isNotEmpty(spScontractFileDomainList) && CollectionUtil.isEmpty(spScontractFileDomainListHa)) {
                spScontractFileDomainList.forEach(spScontractFileDomain -> {
                    spScontractFileDomain.setTenantCode(this.getTenantCode(request));
                    spScontractFileDomain.setScontractCode(scontract.getScontractCode());
                    this.spScontractService.saveScontractFile((SpScontractFileDomain)spScontractFileDomain);
                });
            } else if (CollectionUtil.isNotEmpty(spScontractFileDomainList) && CollectionUtil.isNotEmpty(spScontractFileDomainListHa)) {
                List spScontractFileIdList = spScontractFileDomainList.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getScontractFileId())).map(SpScontractFileDomain::getScontractFileId).collect(Collectors.toList());
                spScontractFileDomainListHa.forEach(ha -> {
                    if (spScontractFileIdList.contains(ha.getScontractFileId())) {
                        SpScontractFileDomain first = spScontractFileDomainList.stream().filter(item -> ObjectUtil.equals((Object)ha.getScontractFileId(), (Object)item.getScontractFileId())).findFirst().orElse(null);
                        if (first != null) {
                            first.setTenantCode(this.getTenantCode(request));
                            this.spScontractService.updateScontractFile(first);
                        }
                    } else {
                        this.spScontractService.deleteScontractFile(ha.getScontractFileId());
                    }
                });
                spScontractFileDomainList.forEach(spScontractFileDomain -> {
                    if (ObjectUtil.isNull((Object)spScontractFileDomain.getScontractFileId())) {
                        spScontractFileDomain.setTenantCode(this.getTenantCode(request));
                        spScontractFileDomain.setScontractCode(scontract.getScontractCode());
                        this.spScontractService.saveScontractFile((SpScontractFileDomain)spScontractFileDomain);
                    }
                });
            } else {
                return new HtmlJsonReBean();
            }
            return new HtmlJsonReBean();
        }
        return this.spScontractBaseService.sendUpdateScontract(spScontractDomain);
    }

    @RequestMapping(value={"deleteScontract.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean deleteScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error("sp.scontract.con.deleteScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractReDomain scontract = this.spScontractService.getScontract(scontractId);
        if (scontract == null) {
            this.logger.error("sp.scontract.con.deleteScontract.getScontract", (Object)scontractId);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        if (scontract.getContractPmode().equals("1")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", scontract.getTenantCode());
            map.put("memberBcode", scontract.getMemberBcode());
            SupQueryResult<SpScontractReDomain> spScontractReDomainSupQueryResult = this.spScontractService.queryScontractPage(map);
            Date effctDate = scontract.getContractEffectivedate();
            if (spScontractReDomainSupQueryResult != null && CollectionUtils.isNotEmpty((Collection)spScontractReDomainSupQueryResult.getList())) {
                List collect = spScontractReDomainSupQueryResult.getList().stream().filter(s -> s.getScontractId().intValue() != scontractId.intValue() && s.getContractPmode().equals("1")).sorted(Comparator.comparing(SpScontractDomain::getContractEffectivedate, Comparator.reverseOrder())).collect(Collectors.toList());
                HashMap<String, String> queryUserinfoPageMap = new HashMap<String, String>();
                queryUserinfoPageMap.put("tenantCode", scontract.getTenantCode());
                queryUserinfoPageMap.put("userPcode", scontract.getMemberBcode());
                UmUserDomainBean userByPcode = this.userService.getUserByPcode(scontract.getMemberBcode(), scontract.getTenantCode());
                if (userByPcode == null) {
                    this.logger.error("sp.scontract.con.saveScontract.queryUserinfoPage", queryUserinfoPageMap);
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ecf\u9500\u5546\u4fe1\u606f\u6682\u672a\u67e5\u5230");
                }
                HashMap<String, Object> newUserMap = new HashMap<String, Object>();
                newUserMap.put("userId", userByPcode.getUserId());
                if (collect.isEmpty()) {
                    newUserMap.put("gmtValid", null);
                } else {
                    newUserMap.put("gmtValid", ((SpScontractReDomain)collect.get(0)).getContractEffectivedate());
                }
                this.userService.updateUserValidate(newUserMap);
            }
        }
        return this.spScontractBaseService.sendDeleteScontract(scontractId);
    }

    @RequestMapping(value={"saveScontractStr.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractBaseService.sendSaveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private void makeChannelStr(List<SpScontractDomain> spScontractDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(spScontractDomainList) || null == request) {
            return;
        }
        for (SpScontractDomain orderDomain : spScontractDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    private OrgUserBean getOrgUserBeanStr(String memberBcode, String userCode, String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyService.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean.setMemberBcode(memberBcode);
            SupQueryResult<CtCustrelReDomain> qcust = this.ctCustrelService.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode));
            if (null != qcust && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            }
        }
        return orgUserBean;
    }

    public SpScontractDomain makeScontractDomain(SpScontractDomain orderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("makeScontractDomain", (Object)"UserSession is null");
            return null;
        }
        SpScontractDomain contractDomain = new SpScontractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("makeScontractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getMemberBcode())) {
            contractDomain.setMemberBcode(userSession.getUserPcode());
            contractDomain.setMemberBname(userSession.getMerberCompname());
        }
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        contractDomain.setContractUserurl(userSession.getUserImgurl());
        contractDomain.setUserCode(userSession.getUserCode());
        contractDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        contractDomain.setContractDelcode(randomCode);
        return contractDomain;
    }

    public List<SpScontractDomain> createScontract(List<SpScontractDomain> orderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.debug("sp.scontract.con.createScontract", (Object)"param is null");
        }
        ArrayList<SpScontractDomain> orderDomains = new ArrayList<SpScontractDomain>();
        String tenantCode = userSession.getTenantCode();
        for (SpScontractDomain orderDomain : orderDomainList) {
            try {
                SpScontractDomain contractDomain = this.makeScontractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == contractDomain) {
                    this.logger.error("sp.scontract.con.createScontract");
                    return null;
                }
                if (StringUtils.isBlank((String)contractProperty)) {
                    contractProperty = "0";
                }
                contractDomain.setContractProperty(contractProperty);
                SpScontractDomain spScontractDomain = this.makeSpScontractGoodsDomainList(contractDomain, orderDomain.getGiftSkuIdList());
                orderDomains.add(spScontractDomain);
            }
            catch (Exception e) {
                this.logger.error("sp.scontract.con.createScontract.ex", (Throwable)e);
            }
        }
        return orderDomains;
    }

    public SpScontractDomain makeSpScontractGoodsDomainList(SpScontractDomain spScontractDomain, List<SkuDomain> giftSkuIdList) {
        ArrayList<SpScontractGoodsDomain> spScontractGoodsDomainList = new ArrayList<SpScontractGoodsDomain>();
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        BigDecimal pacgeMoney = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        this.logger.debug("sp.scontract.con.makeSpScontractGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson(giftSkuIdList));
        if (ListUtil.isNotEmpty(giftSkuIdList)) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                HashMap<String, Object> map;
                SpScontractGoodsDomain spScontractGoodsDomain = new SpScontractGoodsDomain();
                RsSkuReDomain rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuService.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, Object>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", spScontractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuService.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error("sp.scontract.con.makeSpScontractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    return null;
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error("sp.scontract.con.makeSpScontractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    return null;
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error("sp.scontract.con.makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.toString()));
                    return null;
                }
                if (StringUtils.isBlank((String)spScontractDomain.getMemberCode())) {
                    spScontractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    spScontractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                try {
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error("sp.scontract.con.makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    return null;
                }
                spScontractGoodsDomain.setContractGoodsPrice(skuDomain.getGoodsPinprice());
                spScontractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                spScontractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                spScontractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                spScontractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                spScontractGoodsDomain.setMemberBcode(spScontractDomain.getMemberBcode());
                spScontractGoodsDomain.setMemberBname(spScontractDomain.getMemberBname());
                spScontractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                spScontractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                spScontractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == spScontractGoodsDomain.getContractGoodsPrice()) {
                    spScontractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                sum = sum.add(spScontractGoodsDomain.getContractGoodsPrice().multiply(spScontractGoodsDomain.getGoodsNum()));
                if (null == spScontractGoodsDomain.getGoodsNum()) {
                    spScontractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
                }
                goodsNum = goodsNum.add(spScontractGoodsDomain.getGoodsNum());
                if (null == spScontractGoodsDomain.getGoodsCweight()) {
                    spScontractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                goodsWeight = goodsWeight.add(spScontractGoodsDomain.getGoodsCweight());
                if (null == spScontractGoodsDomain.getPricesetRefrice()) {
                    spScontractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                pefMoney = pefMoney.add(spScontractGoodsDomain.getPricesetRefrice());
                if (null == spScontractGoodsDomain.getPricesetNprice()) {
                    spScontractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                dataBmoney = dataBmoney.add(spScontractGoodsDomain.getPricesetNprice().multiply(spScontractGoodsDomain.getGoodsNum()));
                spScontractGoodsDomainList.add(spScontractGoodsDomain);
            }
        }
        spScontractDomain.setPricesetRefrice(pefMoney);
        spScontractDomain.setGoodsNum(goodsNum);
        spScontractDomain.setGoodsWeight(goodsWeight);
        spScontractDomain.setDataBweight(goodsWeight);
        spScontractDomain.setContractInmoney(contractInmoney);
        spScontractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        spScontractDomain.setDataBnum(dataBnum);
        spScontractDomain.setDataBmoney(dataBmoney);
        spScontractDomain.setGoodsLogmoney(goodsLogmoney);
        spScontractDomain.setGoodsPmoney(sum);
        spScontractDomain.setSpScontractGoodsDomainList(spScontractGoodsDomainList);
        return spScontractDomain;
    }

    private void setUserMap(HttpServletRequest request, Map<String, Object> param) {
        UmUserinfoReDomainBean userinfo;
        String tenantCode = this.getTenantCode(request);
        String storeFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-store_check-store_check"));
        Object userinfoCode = param.get("userinfoCode");
        if (StringUtils.isNotBlank((String)storeFlag) && userinfoCode != null && (userinfo = this.userService.getUserInfoByUserinfoCode(String.valueOf(userinfoCode), tenantCode)) != null) {
            param.put("mschannelCode", userinfo.getUserinfoChannelcode());
            param.put("companyCode", userinfo.getDepartCode());
            param.put("employeeCode", userinfo.getUserinfoOcode());
        }
    }

    @RequestMapping(value={"saveScontractFile.json"}, name="\u589e\u52a0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveScontractFile(HttpServletRequest request, SpScontractFileDomain spScontractFileDomain) {
        if (null == spScontractFileDomain) {
            this.logger.error("sp.scontract.con.saveScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractFileDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontractFile(spScontractFileDomain);
    }

    @RequestMapping(value={"getScontractFile.json"}, name="\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public SpScontractFileReDomain getScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error("sp.scontract.con.getScontractFile", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontractFile(scontractFileId);
    }

    @RequestMapping(value={"updateScontractFile.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error("sp.scontract.con.updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"deleteScontractFile.json"}, name="\u5220\u9664\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error("sp.scontract.con.deleteScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontractFile(scontractFileId);
    }

    @RequestMapping(value={"queryScontractFilePage.json"}, name="\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractFilePage(param);
    }

    @RequestMapping(value={"updateScontractFileState.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileState(String scontractFileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractFileId)) {
            this.logger.error("sp.scontract.con.updateScontractFileState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractFileState(Integer.valueOf(scontractFileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractGoods.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error("sp.scontract.con.saveScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"getScontractGoods.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SpScontractGoodsReDomain getScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error("sp.scontract.con.getScontractGoods", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"updateScontractGoods.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error("sp.scontract.con.updateScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"deleteScontractGoods.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error("sp.scontract.con.deleteScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"queryScontractGoodsPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"updateScontractGoodsState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoodsState(String scontractGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractGoodsId)) {
            this.logger.error("sp.scontract.con.updateScontractGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractGoodsState(Integer.valueOf(scontractGoodsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryScontractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractPage(param);
    }

    @RequestMapping(value={"queryScontractFilePageC.json"}, name="C\u7aef\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractFilePage(param);
    }

    @RequestMapping(value={"queryScontractGoodsPageC.json"}, name="C\u7aef\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u5408\u540c\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractService.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"saveScontractStrC.json"}, name="C\u7aef\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractBaseService.sendSaveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private HtmlJsonReBean getSpScontractDomains(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        if (null == scontractDomainStr) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("sp.scontract.con.saveScontract", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean = this.getOrgUserBeanStr(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        this.makeChannelStr(orderDomainList, request);
        List<SpScontractDomain> SpScontractDomainList = this.createScontract(orderDomainList, ContractType.CON.getCode(), userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, null);
        return new HtmlJsonReBean(SpScontractDomainList);
    }
}

