/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.service.rs;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.send.SupperFacade;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsGoodsClassDomain;
import cn.com.qj.bff.domain.rs.RsGoodsClassReDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class RsGoodsClassService
extends SupperFacade {
    public HtmlJsonReBean updateGoodsClassState(Integer goodsClassId, Integer dataState, Integer oldDataState) {
        PostParamMap pmap = new PostParamMap("rs.goodsClass.updateGoodsClassState");
        pmap.putParam("goodsClassId", (Object)goodsClassId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        PostParamMap pmap = new PostParamMap("rs.resource.saveGoodsClass");
        pmap.putParamToJson("rsGoodsClassDomain", (Object)rsGoodsClassDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        PostParamMap pmap = new PostParamMap("rs.resource.updateGoodsClass");
        pmap.putParamToJson("rsGoodsClassDomain", (Object)rsGoodsClassDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteGoodsClass(Integer goodsClassId) {
        PostParamMap pmap = new PostParamMap("rs.resource.deleteGoodsClass");
        pmap.putParam("goodsClassId", (Object)goodsClassId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<RsGoodsClassReDomain> queryGoodsClassPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.goodsClass.queryGoodsClassPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, RsGoodsClassReDomain.class);
    }

    public RsGoodsClassReDomain getGoodsClassByCode(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.goodsClass.getGoodsClassByCode");
        pmap.putParamToJson("map", map);
        return (RsGoodsClassReDomain)this.htmlIBaseService.senReObject(pmap, RsGoodsClassReDomain.class);
    }

    public HtmlJsonReBean delGoodsClassByCode(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.resource.delGoodsClassByCode");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public RsGoodsClassReDomain getGoodsClass(Integer goodsClassId) {
        PostParamMap pmap = new PostParamMap("rs.goodsClass.getGoodsClass");
        pmap.putParam("goodsClassId", (Object)goodsClassId);
        return (RsGoodsClassReDomain)this.htmlIBaseService.senReObject(pmap, RsGoodsClassReDomain.class);
    }

    public HtmlJsonReBean updateStateList(String tenantCode, Integer dataState, Integer oldDataState, String goodsClassHide) {
        PostParamMap pmap = new PostParamMap("rs.goodsClass.updateStateList");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParam("goodsClassHide", (Object)goodsClassHide);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<RsGoodsClassReDomain> queryGoodsClassByParent(String goodsClassParentcode, String goodsClassType, String channelCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("rs.goodsClass.queryGoodsClassByParent");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("goodsClassParentcode", (Object)goodsClassParentcode);
        pmap.putParam("goodsClassType", (Object)goodsClassType);
        pmap.putParam("channelCode", (Object)channelCode);
        return this.htmlIBaseService.getForList(pmap, RsGoodsClassReDomain.class);
    }

    public List<String> getGoodsClass(String goodsClassParentcode, String goodsClassType, String channelCode, String tenantCode) {
        List<RsGoodsClassReDomain> goodsList = this.queryGoodsClassByParent(goodsClassParentcode, goodsClassType, channelCode, tenantCode);
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("RsGoodsClassServiceRepository.getGoodsClass.goodsList", (Object)(goodsClassParentcode + "=:=" + goodsClassType + "=:=" + channelCode + "=:=" + tenantCode));
            return null;
        }
        ArrayList<String> classCodeList = new ArrayList<String>();
        this.makeClassCode(goodsList, classCodeList);
        return classCodeList;
    }

    private void makeClassCode(List<RsGoodsClassReDomain> goodsList, List<String> classCodeList) {
        if (ListUtil.isEmpty(goodsList) || null == classCodeList) {
            return;
        }
        for (RsGoodsClassReDomain rsGoodsClassReDomain : goodsList) {
            if (StringUtils.isNotBlank((String)rsGoodsClassReDomain.getClasstreeCode())) {
                classCodeList.add(rsGoodsClassReDomain.getClasstreeCode());
            }
            if (!ListUtil.isNotEmpty(rsGoodsClassReDomain.getChildList())) continue;
            this.makeClassCode(rsGoodsClassReDomain.getChildList(), classCodeList);
        }
    }

    public List<String> getGoodsClassAllByPcode(String goodsClassParentcode, String goodsClassType, String channelCode, String tenantCode) {
        List<RsGoodsClassReDomain> goodsList = this.queryGoodsClassByParent(goodsClassParentcode, goodsClassType, channelCode, tenantCode);
        this.logger.info("RsGoodsClassServiceRepository.getGoodsClassAllByPcode.goodsList1", (Object)JsonUtil.buildNormalBinder().toJson(goodsList));
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("RsGoodsClassServiceRepository.getGoodsClass.goodsList", (Object)(goodsClassParentcode + "=:=" + goodsClassType + "=:=" + channelCode + "=:=" + tenantCode));
            return null;
        }
        ArrayList<String> classCodeList = new ArrayList<String>();
        this.makeGoodsClassCode(goodsList, classCodeList);
        this.logger.info("RsGoodsClassServiceRepository.getGoodsClassAllByPcode.classCodeList", (Object)JsonUtil.buildNormalBinder().toJson(classCodeList));
        return classCodeList;
    }

    private void makeGoodsClassCode(List<RsGoodsClassReDomain> goodsList, List<String> classCodeList) {
        if (ListUtil.isEmpty(goodsList) || null == classCodeList) {
            return;
        }
        for (RsGoodsClassReDomain rsGoodsClassReDomain : goodsList) {
            this.logger.info("RsGoodsClassServiceRepository.makeGoodsClassCode", (Object)(rsGoodsClassReDomain.getGoodsClassCode() + "==" + rsGoodsClassReDomain.getGoodsClassLast()));
            if (StringUtils.isNotBlank((String)rsGoodsClassReDomain.getGoodsClassCode()) && "0".equals(rsGoodsClassReDomain.getGoodsClassLast())) {
                classCodeList.add(rsGoodsClassReDomain.getGoodsClassCode());
            }
            if (!ListUtil.isNotEmpty(rsGoodsClassReDomain.getChildList())) continue;
            this.makeGoodsClassCode(rsGoodsClassReDomain.getChildList(), classCodeList);
        }
    }

    public HtmlJsonReBean sendupdateOrder(List<RsGoodsClassDomain> rsGoodsClassDomains) {
        PostParamMap pmap = new PostParamMap("rs.resource.sendupdateOrder");
        pmap.putParamToJson("rsGoodsClassDomains", rsGoodsClassDomains);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }
}

