/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.express;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HtmlUtil;
import cn.com.qj.bff.domain.wl.WlExpressDomain;
import cn.com.qj.bff.domain.wl.WlExpressReDomain;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.wl.WlExpressService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wl/express"}, name="\u7269\u6d41\u670d\u52a1")
public class ExpressCon
extends SpringmvcController {
    private static String CODE = "wl.express.con";
    @Autowired
    private WlExpressService wlExpressService;

    @Override
    protected String getContext() {
        return "express";
    }

    @RequestMapping(value={"saveExpress.json"}, name="\u589e\u52a0\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExpress(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateSendgoodsByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WlExpressDomain wlExpressDomain = (WlExpressDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, WlExpressDomain.class);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        wlExpressDomain.setTenantCode(this.getTenantCode(request));
        wlExpressDomain.setMemberCode(userSession.getUserPcode());
        wlExpressDomain.setMemberName(userSession.getUserName());
        return this.wlExpressService.saveExpress(wlExpressDomain);
    }

    @RequestMapping(value={"getExpress.json"}, name="\u83b7\u53d6\u7269\u6d41\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public WlExpressReDomain getExpress(String expressId) {
        if (StringUtils.isBlank((String)expressId)) {
            this.logger.error(CODE + ".getExpress", (Object)"param is null");
            return null;
        }
        return this.wlExpressService.getExpress(Integer.valueOf(expressId));
    }

    @RequestMapping(value={"updateExpress.json"}, name="\u66f4\u65b0\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateExpress(HttpServletRequest request, WlExpressDomain wlExpressDomain) {
        if (null == wlExpressDomain) {
            this.logger.error(CODE + ".updateExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExpressDomain.setTenantCode(this.getTenantCode(request));
        wlExpressDomain.setMemberCode(BaseInterUtil.getMemberCode((HttpServletRequest)request));
        return this.wlExpressService.updateExpress(wlExpressDomain);
    }

    @RequestMapping(value={"deleteExpress.json"}, name="\u5220\u9664\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteExpress(HttpServletRequest request, String expressId) {
        if (StringUtils.isBlank((String)expressId)) {
            this.logger.error(CODE + ".deleteExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExpressService.deleteExpress(Integer.valueOf(expressId));
    }

    @RequestMapping(value={"queryExpressPage.json"}, name="\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExpressService.queryExpressPage(param);
    }

    @RequestMapping(value={"updateExpressState.json"}, name="\u66f4\u65b0\u7269\u6d41\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateExpressState(String expressId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)expressId)) {
            this.logger.error(CODE + ".updateExpressState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExpressService.updateExpressState(Integer.valueOf(expressId), dataState, oldDataState);
    }

    @RequestMapping(value={"deleteExpressBatch.json"}, name="\u6279\u91cf\u5220\u9664\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteExpressBatch(String expressIds) {
        String[] ids;
        if (StringUtils.isBlank((String)expressIds)) {
            this.logger.error(CODE + ".deleteExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String id : ids = expressIds.split(",")) {
            if (id == null) continue;
            this.wlExpressService.deleteExpress(Integer.valueOf(id));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryExpressPageForProp.json"}, name="\u5546\u5bb6\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPageForProp(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("orderStr", "DATA_STATE DESC");
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberCode", BaseInterUtil.getMemberCode((HttpServletRequest)request));
        }
        return this.wlExpressService.queryExpressPage(param);
    }

    @RequestMapping(value={"queryExpressPageForFreight.json"}, name="\u5546\u5bb6\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868-\u8fd0\u8d39\u6a21\u677f")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPageForFreight(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("orderStr", "DATA_STATE DESC");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExpressService.queryExpressPage(param);
    }

    @RequestMapping(value={"queryExpressPageForC.json"}, name="\u5546\u5bb6\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868-C\u7aef")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPageForC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("orderStr", "DATA_STATE DESC");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExpressService.queryExpressPage(param);
    }
}

