/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.ct.CtCustrelReDomain;
import cn.com.qj.bff.domain.es.AccurateQueryDomain;
import cn.com.qj.bff.domain.es.ReturnBean;
import cn.com.qj.bff.domain.es.SearchDomain;
import cn.com.qj.bff.domain.oc.GoodsBean;
import cn.com.qj.bff.domain.oc.GoodsNumDomain;
import cn.com.qj.bff.domain.oc.OcShoppingDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingpackgeDomain;
import cn.com.qj.bff.domain.oc.TypeBean;
import cn.com.qj.bff.domain.org.OrgEmployeeReDomain;
import cn.com.qj.bff.domain.org.OrgUserBean;
import cn.com.qj.bff.domain.pm.PmCheckBean;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.um.UmGroupListReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.ct.CtCustrelService;
import cn.com.qj.bff.service.es.SearchengineService;
import cn.com.qj.bff.service.oc.OcShoppingService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.service.org.OrgEmployeeService;
import cn.com.qj.bff.service.pm.PmPromotionService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.um.UmGroupService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.service.upm.UpmUpointsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ShoppingComCon
extends SpringmvcController {
    private static String CODE = "oc.shoppingcom.con";
    @Autowired
    private OrgCompanyService orgCompanyService;
    @Autowired
    private OrgEmployeeService orgEmployeeService;
    @Autowired
    private OcShoppingService ocShoppingService;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private PmPromotionService pmPromotionService;
    @Autowired
    private CtCustrelService ctCustrelService;
    @Autowired
    private UpmUpointsService upmUpointsService;
    @Autowired
    private UserService userService;
    @Autowired
    private SearchengineService searchengineService;
    @Autowired
    UmGroupService umGroupService;

    @Override
    protected String getContext() {
        return "shoppingcom";
    }

    public RsSkuReDomain getRsByNo(String skuNo, String memberCcode, String channelCode, String tenantCode, String goodsType) {
        SupQueryResult<RsSkuReDomain> qrs = this.rsSkuService.querySkuOnePage(this.getQueryMapParam("skuNo,memberCcode,channelCode,tenantCode,goodsType", skuNo, memberCcode, channelCode, tenantCode, goodsType));
        if (null == qrs || ListUtil.isEmpty((Collection)qrs.getList())) {
            return null;
        }
        if (StringUtils.isBlank((String)goodsType)) {
            for (RsSkuReDomain rsSkuReDomain : qrs.getList()) {
                if ("24".equals(rsSkuReDomain.getGoodsType()) || "25".equals(rsSkuReDomain.getGoodsType()) || "26".equals(rsSkuReDomain.getGoodsType()) || "27".equals(rsSkuReDomain.getGoodsType()) || "28".equals(rsSkuReDomain.getGoodsType()) || "29".equals(rsSkuReDomain.getGoodsType())) continue;
                return rsSkuReDomain;
            }
        }
        return (RsSkuReDomain)qrs.getList().get(0);
    }

    public RsSkuReDomain getRsByCode(String skuCode, String tenantCode) {
        RsSkuReDomain rsSkuReDomain = this.rsSkuService.getSkuByCode(this.getQueryMapParam("skuCode,tenantCode", skuCode, tenantCode));
        return rsSkuReDomain;
    }

    public String getEmp(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        SupQueryResult<OrgEmployeeReDomain> qemp = this.orgEmployeeService.queryEmployeePage(this.getQueryMapParam("userCode,userinfoCode,tenantCode", userSession.getUserCode(), userSession.getUserPcode(), userSession.getTenantCode()));
        if (null == qemp || ListUtil.isEmpty((Collection)qemp.getList())) {
            return null;
        }
        return ((OrgEmployeeReDomain)qemp.getList().get(0)).getEmployeeCode();
    }

    public HtmlJsonReBean saveShoppingCom(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveShoppingCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.saveShopping(ocShoppingDomain);
    }

    public OcShoppingReDomain getShoppingCom(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".getShoppingCom", (Object)"param is null");
            return null;
        }
        return this.ocShoppingService.getShopping(Integer.valueOf(shoppingId));
    }

    public HtmlJsonReBean updateShoppingCom(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".updateShoppingCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.updateShopping(ocShoppingDomain);
    }

    public HtmlJsonReBean deleteShoppingCom(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".deleteShoppingCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingIdS = shoppingId.split(",");
        if (null == shoppingIdS || shoppingIdS.length <= 0) {
            this.logger.error(CODE + ".deleteShopping1", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (int i = 0; i < shoppingIdS.length; ++i) {
            htmlJsonReBean = this.ocShoppingService.deleteShopping(Integer.valueOf(shoppingIdS[i]));
        }
        return htmlJsonReBean;
    }

    public SupQueryResult<Integer> wishListsCom(HttpServletRequest request, Map<String, Object> param) {
        SupQueryResult number = new SupQueryResult();
        SupQueryResult<OcShoppingGoodsReDomain> ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingService.queryShoppingGoodsPage(param);
        if (null == ocShoppingGoodsReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) {
            number.setTotal(0L);
            return number;
        }
        number.setTotal(ocShoppingGoodsReDomainSupQueryResult.getTotal());
        return number;
    }

    public SupQueryResult<Integer> shoppingListCom(HttpServletRequest request, Map<String, Object> param) {
        SupQueryResult number = new SupQueryResult();
        SupQueryResult<OcShoppingGoodsReDomain> ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingService.queryShoppingGoodsPage(param);
        if (null == ocShoppingGoodsReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) {
            number.setTotal(0L);
            return number;
        }
        number.setTotal(ocShoppingGoodsReDomainSupQueryResult.getTotal());
        return number;
    }

    public SupQueryResult<OcShoppingReDomain> queryShoppingPageCom(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        return this.queryShopping(request, param, memberBcode);
    }

    protected PmCheckBean getPmCheckBean(HttpServletRequest request, UserSession userSession, String contractPmode) {
        if (null == request) {
            return null;
        }
        return this.ocShoppingService.getPmCheckBean(this.getPmChannel(request), this.getProappCode(request), this.getTenantCode(request), null == userSession ? null : userSession.getUserPcode(), null == userSession ? null : userSession.getMerberCompname(), null == userSession ? null : userSession.getUserCode(), contractPmode);
    }

    private SupQueryResult<OcShoppingReDomain> queryShopping(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        long startTime = System.currentTimeMillis();
        this.logger.info("\u67e5\u8be2\u8d2d\u7269\u8f66\u5f00\u59cb");
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryShopping.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("\u8d2d\u7269\u8f66\u67e5\u8be21\u9636\u6bb5\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        HashMap<String, String> fcodeMap = new HashMap<String, String>();
        SupQueryResult<OcShoppingReDomain> ocShoppingReDomainSupQueryResult = this.queryShoppingPage(param, fcodeMap, request);
        if (null == ocShoppingReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryShopping.", (Object)("ocShoppingReDomainSupQueryResult is null" + param));
            return null;
        }
        long end2Time = System.currentTimeMillis();
        this.logger.info("\u8d2d\u7269\u8f66\u67e5\u8be22\u9636\u6bb5\u65f6\u95f4 ocShoppingService.queryShoppingPage \uff1a" + (end2Time - endTime) + "ms");
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainSupQueryResult.getRows()) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                this.makeShowShoppingDomainList(shoppingpackage, userSession);
            }
        }
        long end3Time = System.currentTimeMillis();
        this.logger.info("\u8d2d\u7269\u8f66\u67e5\u8be23\u9636\u6bb5\u65f6\u95f4(\u663e\u793a\u4ef7\u683c)\uff1a" + (end3Time - end2Time) + "ms");
        TypeBean typeBean = this.ocShoppingService.getOcSetting(((OcShoppingReDomain)ocShoppingReDomainSupQueryResult.getList().get(0)).getShoppingType(), tenantCode);
        long end4Time = System.currentTimeMillis();
        this.logger.info("\u8d2d\u7269\u8f66\u67e5\u8be24\u9636\u6bb5\u65f6\u95f4(ocShoppingService.getOcSetting)\uff1a" + (end4Time - end3Time) + "ms");
        List<OcShoppingReDomain> ocShoppingReDomainList = ocShoppingReDomainSupQueryResult.getRows();
        if (StringUtils.isNotBlank((String)userSession.getQualityQtypeName()) && "\u76f4\u8425\u5e97".equals(userSession.getQualityQtypeName())) {
            this.logger.info("\u76f4\u8425\u5e97\u4e0d\u53c2\u52a0\u8425\u9500", (Object)userSession.getUserPcode());
        } else if (this.ocShoppingService.checkPm(typeBean)) {
            PmCheckBean pmCheckBean = this.getPmCheckBean(request, userSession, (String)param.get("contractPmode"));
            String flagStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(userSession.getTenantCode() + "-price_check-price_check"));
            if (StringUtils.isNotBlank((String)flagStr) && ListUtil.isNotEmpty((Collection)ocShoppingReDomainList) && StringUtils.isNotBlank((String)((OcShoppingReDomain)ocShoppingReDomainList.get(0)).getChannelCode())) {
                pmCheckBean.setChannelCode(((OcShoppingReDomain)ocShoppingReDomainList.get(0)).getChannelCode());
                pmCheckBean.setCheckBargain("1");
            }
            this.logger.error(CODE + ".ocShoppingReDomainList-5", (Object)("ocShoppingReDomainList" + JsonUtil.buildNormalBinder().toJson((Object)ocShoppingReDomainList) + "pmCheckBean" + JsonUtil.buildNormalBinder().toJson((Object)pmCheckBean)));
            ocShoppingReDomainList = this.ocShoppingService.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
            if (ListUtil.isNotEmpty(ocShoppingReDomainList)) {
                for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
                    BigDecimal depositTotal = BigDecimal.ZERO;
                    List<OcShoppingpackgeDomain> shoppingpackageList = ocShoppingReDomain.getShoppingpackageList();
                    if (ListUtil.isNotEmpty(shoppingpackageList)) {
                        for (OcShoppingpackgeDomain ocShoppingpackgeDomain : shoppingpackageList) {
                            List<OcShoppingGoodsDomain> shoppingGoodsList = ocShoppingpackgeDomain.getShoppingGoodsList();
                            if (!ListUtil.isNotEmpty(shoppingGoodsList)) continue;
                            for (OcShoppingGoodsDomain shoppingGoodsDomain : shoppingGoodsList) {
                                if (0 != shoppingGoodsDomain.getShoppingGoodsCheck()) continue;
                                BigDecimal depositNprice = null != shoppingGoodsDomain.getDepositNprice() ? shoppingGoodsDomain.getDepositNprice() : BigDecimal.ZERO;
                                depositTotal = depositTotal.add(depositNprice);
                            }
                        }
                    }
                    ocShoppingReDomain.setDepositTotal(depositTotal);
                }
            }
            this.logger.error(CODE + ".ocShoppingReDomainList.ocShoppingReDomainList", (Object)("ocShoppingReDomainList" + JsonUtil.buildNormalBinder().toJson(ocShoppingReDomainList)));
            ocShoppingReDomainSupQueryResult.setRows(ocShoppingReDomainList);
        }
        long end5Time = System.currentTimeMillis();
        this.logger.info("\u8d2d\u7269\u8f66\u67e5\u8be25\u9636\u6bb5\u65f6\u95f4(ocShoppingService.checkPm(typeBean) \u8425\u9500\u6d3b\u52a8\u914d\u7f6e)\uff1a" + (end5Time - end4Time) + "ms");
        this.makeOcShoppingReDomain(ocShoppingReDomainSupQueryResult.getRows(), userSession);
        long end6Time = System.currentTimeMillis();
        this.logger.info("\u8d2d\u7269\u8f66\u67e5\u8be26\u9636\u6bb5\u65f6\u95f4(makeOcShoppingReDomain \u4ef7\u683c\u7ec4\u6c47\u603b\u4ef7\u683c)\uff1a" + (end6Time - end5Time) + "ms");
        this.logger.info("\u8d2d\u7269\u8f66\u67e5\u8be2\u603b\u8017\u65f6" + (startTime - end5Time) + "ms");
        return ocShoppingReDomainSupQueryResult;
    }

    public SupQueryResult<OcShoppingReDomain> queryShoppingPage(Map<String, Object> map, Map<String, String> fcode, HttpServletRequest request) {
        SupQueryResult<OcShoppingGoodsReDomain> qlist = this.ocShoppingService.queryShoppingGoodsPage(map);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            this.logger.error("queryShoppingPage.goodsList is null.1", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
            return null;
        }
        List<OcShoppingGoodsReDomain> goodsList = this.makeEsByGoods(qlist.getList(), fcode, request);
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("makeEs.goodsList is null.2", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
            return null;
        }
        ArrayList<OcShoppingReDomain> ocShoppingReDomainList = new ArrayList<OcShoppingReDomain>();
        HashMap<String, OcShoppingReDomain> shoppingMap = new HashMap<String, OcShoppingReDomain>();
        HashMap<String, OcShoppingpackgeDomain> shoppingpackageMap = new HashMap<String, OcShoppingpackgeDomain>();
        String key = "";
        String packKey = "";
        for (OcShoppingGoodsReDomain ocShoppingGoodsReDomain : goodsList) {
            List<OcShoppingGoodsDomain> shoppingGoodsList;
            if (StringUtils.isBlank((String)ocShoppingGoodsReDomain.getShoppingGoodsPm())) {
                ocShoppingGoodsReDomain.setShoppingGoodsPm("");
            }
            if (null == ocShoppingGoodsReDomain.getGoodsCweight()) {
                ocShoppingGoodsReDomain.setGoodsCweight(BigDecimal.ZERO);
            }
            key = ocShoppingGoodsReDomain.getGoodsType() + "-" + ocShoppingGoodsReDomain.getMemberCode() + "-" + ocShoppingGoodsReDomain.getChannelCode() + "-" + ocShoppingGoodsReDomain.getMemberBcode() + "-" + ocShoppingGoodsReDomain.getTenantCode();
            packKey = ocShoppingGoodsReDomain.getGoodsType() + "-" + ocShoppingGoodsReDomain.getMemberCode() + "-" + ocShoppingGoodsReDomain.getChannelCode() + "-" + ocShoppingGoodsReDomain.getMemberBcode() + "-" + ocShoppingGoodsReDomain.getTenantCode();
            ocShoppingGoodsReDomain.setShoppingCode(key);
            ocShoppingGoodsReDomain.setShoppingpackgeCode(packKey);
            OcShoppingReDomain ocShoppingReDomain = (OcShoppingReDomain)shoppingMap.get(key);
            if (null == ocShoppingReDomain) {
                ocShoppingReDomain = new OcShoppingReDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)ocShoppingReDomain, (Object)ocShoppingGoodsReDomain);
                }
                catch (Exception e) {
                    this.logger.error("queryShoppingPage.copy ocShoppingReDomain ", (Throwable)e);
                }
                ocShoppingReDomain.setShoppingCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                ocShoppingReDomain.setShoppingCweight(ocShoppingGoodsReDomain.getGoodsCweight());
                if (null == ocShoppingGoodsReDomain.getPricesetNprice()) {
                    ocShoppingGoodsReDomain.setPricesetNprice(new BigDecimal("0"));
                }
                ocShoppingReDomain.setGoodsMoney(ocShoppingGoodsReDomain.getGoodsCamount().multiply(ocShoppingGoodsReDomain.getPricesetNprice()));
                if (null == ocShoppingGoodsReDomain.getPricesetRefrice()) {
                    ocShoppingGoodsReDomain.setPricesetRefrice(new BigDecimal("0"));
                }
                ocShoppingReDomain.setPricesetRefrice(ocShoppingGoodsReDomain.getGoodsCamount().multiply(ocShoppingGoodsReDomain.getPricesetRefrice()));
                ocShoppingReDomainList.add(ocShoppingReDomain);
                ocShoppingReDomain.setShoppingCode(key);
                shoppingMap.put(key, ocShoppingReDomain);
            } else {
                ocShoppingReDomain.setShoppingCamount(ocShoppingReDomain.getShoppingCamount().add(ocShoppingGoodsReDomain.getGoodsCamount()));
                ocShoppingReDomain.setShoppingCweight(ocShoppingReDomain.getShoppingCweight().add(ocShoppingGoodsReDomain.getGoodsCweight()));
                ocShoppingReDomain.setGoodsMoney(ocShoppingReDomain.getGoodsMoney().add(ocShoppingGoodsReDomain.getGoodsCamount().multiply(ocShoppingGoodsReDomain.getPricesetNprice())));
                ocShoppingReDomain.setPricesetRefrice(ocShoppingReDomain.getPricesetRefrice().add(ocShoppingGoodsReDomain.getGoodsCamount().multiply(ocShoppingGoodsReDomain.getPricesetRefrice())));
            }
            OcShoppingpackgeDomain ocShoppingpackgeDomain = (OcShoppingpackgeDomain)shoppingpackageMap.get(packKey);
            List<OcShoppingpackgeDomain> shoppingpackageList = ocShoppingReDomain.getShoppingpackageList();
            if (null == shoppingpackageList) {
                shoppingpackageList = new ArrayList<OcShoppingpackgeDomain>();
                ocShoppingReDomain.setShoppingpackageList(shoppingpackageList);
            }
            if (null == ocShoppingpackgeDomain) {
                ocShoppingpackgeDomain = new OcShoppingpackgeDomain();
                ocShoppingpackgeDomain.setShoppingpackgeCode(packKey);
                try {
                    BeanUtils.copyAllPropertys((Object)ocShoppingpackgeDomain, (Object)ocShoppingGoodsReDomain);
                }
                catch (Exception e) {
                    this.logger.error("queryShoppingPage.copy ocShoppingpackgeDomain ", (Throwable)e);
                }
                ocShoppingpackgeDomain.setShoppingpackgeCode(packKey);
                ocShoppingpackgeDomain.setGoodsNum(ocShoppingGoodsReDomain.getGoodsCamount());
                ocShoppingpackgeDomain.setGoodsWeight(ocShoppingGoodsReDomain.getGoodsCweight());
                if (null == ocShoppingGoodsReDomain.getPricesetNprice()) {
                    ocShoppingGoodsReDomain.setPricesetNprice(new BigDecimal("0"));
                }
                ocShoppingpackgeDomain.setGoodsMoney(ocShoppingGoodsReDomain.getGoodsCamount().multiply(ocShoppingGoodsReDomain.getPricesetNprice()));
                if (null == ocShoppingGoodsReDomain.getPricesetRefrice()) {
                    ocShoppingGoodsReDomain.setPricesetRefrice(new BigDecimal("0"));
                }
                ocShoppingpackgeDomain.setPricesetRefrice(ocShoppingGoodsReDomain.getGoodsCamount().multiply(ocShoppingGoodsReDomain.getPricesetRefrice()));
                shoppingpackageList.add(ocShoppingpackgeDomain);
                if (ListUtil.isEmpty(ocShoppingpackgeDomain.getShoppingGoodsList())) {
                    shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
                    shoppingGoodsList.add(ocShoppingGoodsReDomain);
                    ocShoppingpackgeDomain.setShoppingGoodsList(shoppingGoodsList);
                }
                shoppingpackageMap.put(packKey, ocShoppingpackgeDomain);
                continue;
            }
            ocShoppingpackgeDomain.setGoodsNum(ocShoppingpackgeDomain.getGoodsNum().add(ocShoppingGoodsReDomain.getGoodsCamount()));
            ocShoppingpackgeDomain.setGoodsWeight(ocShoppingpackgeDomain.getGoodsWeight().add(ocShoppingGoodsReDomain.getGoodsCweight()));
            ocShoppingpackgeDomain.setGoodsMoney(ocShoppingpackgeDomain.getGoodsMoney().add(ocShoppingGoodsReDomain.getGoodsCamount().multiply(ocShoppingGoodsReDomain.getPricesetNprice())));
            ocShoppingpackgeDomain.setPricesetRefrice(ocShoppingpackgeDomain.getPricesetRefrice().add(ocShoppingGoodsReDomain.getGoodsCamount().multiply(ocShoppingGoodsReDomain.getPricesetRefrice())));
            if (ListUtil.isEmpty(ocShoppingpackgeDomain.getShoppingGoodsList())) {
                shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
                shoppingGoodsList.add(ocShoppingGoodsReDomain);
                ocShoppingpackgeDomain.setShoppingGoodsList(shoppingGoodsList);
                continue;
            }
            shoppingGoodsList = ocShoppingpackgeDomain.getShoppingGoodsList();
            shoppingGoodsList.add(ocShoppingGoodsReDomain);
        }
        SupQueryResult rqlist = new SupQueryResult();
        rqlist.setList(ocShoppingReDomainList);
        return rqlist;
    }

    public List<OcShoppingGoodsReDomain> makeEsByGoods(List<OcShoppingGoodsReDomain> goodsList, Map<String, String> fcode, HttpServletRequest request) {
        if (ListUtil.isEmpty(goodsList)) {
            return null;
        }
        String skuCodeStr = "";
        String channelCode = "";
        String tenantCode = "";
        ArrayList<String> goodsCodeList = new ArrayList<String>();
        HashMap<String, OcShoppingGoodsReDomain> shoppingGoodsMap = new HashMap<String, OcShoppingGoodsReDomain>();
        for (OcShoppingGoodsReDomain ocShoppingGoodsReDomain : goodsList) {
            tenantCode = ocShoppingGoodsReDomain.getTenantCode();
            channelCode = ocShoppingGoodsReDomain.getChannelCode();
            if (StringUtils.isNotBlank((String)skuCodeStr)) {
                skuCodeStr = skuCodeStr + ",";
            }
            skuCodeStr = skuCodeStr + ocShoppingGoodsReDomain.getSkuCode();
            shoppingGoodsMap.put(ocShoppingGoodsReDomain.getSkuCode(), ocShoppingGoodsReDomain);
            if (3 != ocShoppingGoodsReDomain.getDataState()) {
                ocShoppingGoodsReDomain.setDataState(2);
            }
            if (!StringUtils.isNotBlank((String)ocShoppingGoodsReDomain.getGoodsCode())) continue;
            goodsCodeList.add(ocShoppingGoodsReDomain.getGoodsCode());
        }
        HashMap<String, RsResourceGoodsReDomain> goodsMap = new HashMap<String, RsResourceGoodsReDomain>();
        List<RsResourceGoodsReDomain> rsResourceGoodsReDomainListByGoodsCode = null;
        try {
            rsResourceGoodsReDomainListByGoodsCode = this.findRsResourceGoodsReDomainListByGoodsCode(goodsCodeList, request);
        }
        catch (Exception e) {
            this.logger.error("queryShoppingPage makeEsByGoods is null", (Throwable)e);
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomainListByGoodsCode)) {
            for (RsResourceGoodsReDomain rsResourceGoodsReDomain : rsResourceGoodsReDomainListByGoodsCode) {
                goodsMap.put(rsResourceGoodsReDomain.getGoodsCode() + "-" + rsResourceGoodsReDomain.getTenantCode(), rsResourceGoodsReDomain);
            }
        }
        if (ListUtil.isNotEmpty(goodsList)) {
            for (OcShoppingGoodsReDomain shoppingGoodsReDomain : goodsList) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)goodsMap.get(shoppingGoodsReDomain.getGoodsCode() + "-" + shoppingGoodsReDomain.getTenantCode());
                if (null == rsResourceGoodsReDomain) {
                    shoppingGoodsReDomain.setDataState(3);
                }
                if (2 == shoppingGoodsReDomain.getDataState() && 1 == rsResourceGoodsReDomain.getDataOpbillstate()) {
                    shoppingGoodsReDomain.setDataState(0);
                }
                if (2 == shoppingGoodsReDomain.getDataState() && 0 == rsResourceGoodsReDomain.getDataOpbillstate()) {
                    shoppingGoodsReDomain.setDataState(2);
                }
                if (shoppingGoodsReDomain.getGoodsSupplynum().compareTo(BigDecimal.ZERO) > 0) continue;
                shoppingGoodsReDomain.setDataState(3);
            }
        }
        return goodsList;
    }

    private List<RsResourceGoodsReDomain> findRsResourceGoodsReDomainListByGoodsCode(List<String> goodsCodeList, HttpServletRequest request) {
        List<RsResourceGoodsReDomain> list = new ArrayList<RsResourceGoodsReDomain>();
        ArrayList<AccurateQueryDomain> accurateQueryList = new ArrayList<AccurateQueryDomain>();
        String channelCode = this.getChannelByMemCc(this.getMerchantCode(request), request);
        if (StringUtils.isNotBlank((String)channelCode)) {
            AccurateQueryDomain accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("channelCode.keyword");
            accurateQueryDomain.setAccurateFieldValue(channelCode);
            accurateQueryList.add(accurateQueryDomain);
        }
        SearchDomain searchDomain = new SearchDomain();
        if (CollectionUtils.isNotEmpty(goodsCodeList)) {
            AccurateQueryDomain accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("goodsCode.keyword");
            accurateQueryDomain.setAccurateFieldValues(goodsCodeList);
            accurateQueryList.add(accurateQueryDomain);
        }
        searchDomain.setBizType("sku");
        searchDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put("page", 1);
        pageMap.put("rows", 10000);
        searchDomain.setPageMap(pageMap);
        searchDomain.setAccurateQueryList(accurateQueryList);
        this.logger.info(CODE + ".find.searchDomain.", (Object)JsonUtil.buildNonNullBinder().toJson((Object)searchDomain));
        SupQueryResult queryResult = new SupQueryResult();
        ReturnBean returnBean = this.searchengineService.find(searchDomain);
        if (null == returnBean || CollectionUtils.isEmpty(returnBean.getSourcelist())) {
            return list;
        }
        list = returnBean.getSourcelist().stream().map(e -> {
            RsResourceGoodsReDomain resourceGoodsReDomain = new RsResourceGoodsReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)resourceGoodsReDomain, (Object)e);
            }
            catch (Exception exception) {
                this.logger.error(CODE + ".findRsResourceGoodsReDomainListByGoodsCode.error", (Throwable)exception);
            }
            return resourceGoodsReDomain;
        }).collect(Collectors.toList());
        return list;
    }

    private void makeOcShoppingReDomain(List<OcShoppingReDomain> ocShoppingReDomainList, UserSession userSession) {
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                this.makeShoppingDomainList(shoppingpackage, userSession);
            }
        }
    }

    private void makeShowShoppingDomainList(OcShoppingpackgeDomain shoppingpackage, UserSession userSession) {
        List objmapList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNormalBinder().toJson(shoppingpackage.getShoppingGoodsList()), Object.class);
        List<Map<String, Object>> list = this.rsResourceGoodsService.getShoppGoodMemPriceReBean(objmapList, userSession, shoppingpackage.getChannelCode(), shoppingpackage.getTenantCode());
        if (ListUtil.isEmpty(list)) {
            return;
        }
        List rsShoppingDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(list), OcShoppingGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)rsShoppingDomainList)) {
            shoppingpackage.setShoppingGoodsList(rsShoppingDomainList);
        }
    }

    private void makeShoppingDomainList(OcShoppingpackgeDomain shoppingpackage, UserSession userSession) {
        shoppingpackage.setSumMoney(BigDecimal.ZERO);
        shoppingpackage.setSumNum(BigDecimal.ZERO);
        shoppingpackage.setSumWeight(BigDecimal.ZERO);
        shoppingpackage.setSumRefMoney(BigDecimal.ZERO);
        for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
            if (null == ocShoppingGoodsDomain.getGoodsCamount()) {
                ocShoppingGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == ocShoppingGoodsDomain.getGoodsCweight()) {
                ocShoppingGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
            }
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null != ocShoppingGoodsDomain.getShoppingGoodsCheck() && 0 != ocShoppingGoodsDomain.getShoppingGoodsCheck()) continue;
            shoppingpackage.setSumMoney(shoppingpackage.getSumMoney().add(ocShoppingGoodsDomain.getPricesetNprice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
            shoppingpackage.setSumNum(shoppingpackage.getSumNum().add(ocShoppingGoodsDomain.getGoodsCamount()));
            shoppingpackage.setSumWeight(shoppingpackage.getSumWeight().add(ocShoppingGoodsDomain.getGoodsCweight()));
            shoppingpackage.setSumRefMoney(shoppingpackage.getSumRefMoney().add(ocShoppingGoodsDomain.getPricesetRefrice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
        }
    }

    public HtmlJsonReBean updateShoppingGoodsPmInfoCom(HttpServletRequest request, String shoppingGoodsId, String promotionCode) {
        if (StringUtils.isBlank((String)shoppingGoodsId) || StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".updateShoppingGoodsPmInfo", (Object)" param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.ocShoppingService.updateShoppingGoodsPmInfo(Integer.valueOf(shoppingGoodsId), promotionCode);
    }

    public HtmlJsonReBean updateShoppingGoodsCheckStateCom(HttpServletRequest request, String shoppingGoodsIdStr, String shoppingCode, Integer checkState) {
        String[] shoppingGoodsIdS;
        String memberCode = this.getMerchantCode(request);
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsCheckStateCom", (Object)" shoppingGoodsIdStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        for (String shoppingGoodsId : shoppingGoodsIdS = shoppingGoodsIdStr.split("\\,")) {
            this.logger.info(CODE + ".queryShopping.getShoppingGoods.start", (Object)new Date().getTime());
            OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.ocShoppingService.getShoppingGoods(Integer.valueOf(shoppingGoodsId));
            this.logger.info(CODE + ".queryShopping.getShoppingGoods.end", (Object)new Date().getTime());
            if (null == ocShoppingGoodsReDomain) {
                this.logger.error(CODE + ".updateShoppingGoodsCheckStateCom.shoppingGoodsId", (Object)shoppingGoodsId);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "error");
            }
            if (memberCode.equals(ocShoppingGoodsReDomain.getMemberBcode())) continue;
            this.logger.error(CODE + ".updateShoppingGoodsCheckStateCom.memberCode", (Object)(shoppingGoodsId + "=" + memberCode + "=" + ocShoppingGoodsReDomain.getMemberBcode()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f\u6709\u8bef");
        }
        this.logger.info(CODE + ".queryShopping.updateShoppingGoodsListCheckState.start", (Object)new Date().getTime());
        HtmlJsonReBean htmlJsonReBean = this.ocShoppingService.updateShoppingGoodsListCheckState(memberCode, shoppingCode, shoppingGoodsIdStr, checkState);
        this.logger.info(CODE + ".queryShopping.updateShoppingGoodsListCheckState.start", (Object)new Date().getTime());
        return htmlJsonReBean;
    }

    public HtmlJsonReBean updateShoppingGoodsCheckStateComCrm(HttpServletRequest request, String shoppingGoodsIdStr, String shoppingCode, Integer checkState) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param.get("memberBcode")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "memberBcod\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String memberCode = param.get("memberBcode").toString();
        return this.ocShoppingService.updateShoppingGoodsListCheckState(memberCode, shoppingCode, shoppingGoodsIdStr, checkState);
    }

    public HtmlJsonReBean updateShoppingGoodsNumCom(HttpServletRequest request, Integer shoppingGoodsId, BigDecimal amount, BigDecimal goodWeight) {
        if (StringUtils.isBlank((Integer)shoppingGoodsId) || null == amount && null == goodWeight) {
            this.logger.error(CODE + ".updateShoppingGoodsNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingService.updateShoppingGoodsNum(shoppingGoodsId, amount, goodWeight);
    }

    public HtmlJsonReBean updateShoppingStateCom(String shoppingId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".updateShoppingState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingService.updateShoppingState(Integer.valueOf(shoppingId), dataState, oldDataState);
    }

    public HtmlJsonReBean saveContractByOcShoppingCom(HttpServletRequest request, OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveContractByOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.saveContractByOcShopping(ocShoppingDomain, contractTypepro);
    }

    public HtmlJsonReBean insertShoppingGoodsCom(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getMemberBcode())) {
            ocShoppingGoodsDomain.setMemberBcode(userSession.getUserPcode());
            ocShoppingGoodsDomain.setMemberBname(userSession.getMerberCompname());
        }
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.insertShoppingGoods(ocShoppingGoodsDomain);
    }

    public HtmlJsonReBean addShoppingGoodsBySpecCom(HttpServletRequest request, String goodsCode, String specStr, String memberBcode) {
        List spcList;
        RsSkuReDomain rsSkuReDomain;
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".addShoppingGoodsBySpecCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (null == (rsSkuReDomain = this.rsSkuService.getSkuBySpec(spcList = JsonUtil.buildNormalBinder().getJsonToList(specStr, String.class), goodsCode, tenantCode))) {
            this.logger.error(CODE + ".addShoppingGoodsBySpecCom", (Object)(specStr.toString() + "-" + goodsCode + "-" + tenantCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        if (null != userSession && rsSkuReDomain.getMemberCode().equals(userSession.getUserPcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u8d2d\u4e70\u81ea\u5df1\u5546\u54c1");
        }
        if (1 != rsSkuReDomain.getDataOpbillstate()) {
            this.logger.error(CODE + ".addShoppingGoodsBySpecCom", (Object)(specStr.toString() + "-" + goodsCode + "-" + tenantCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u4e0b\u67b6\uff01");
        }
        if (null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().subtract(new BigDecimal(1)).intValue() < 0) {
            this.logger.error(CODE + ".addShoppingGoodsBySpecCom", (Object)(specStr.toString() + "-" + goodsCode + "-" + tenantCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
        rsSkuReDomain = this.rsSkuService.getSkuMemPriceReBean(rsSkuReDomain, userSession, rsSkuReDomain.getChannelCode(), rsSkuReDomain.getTenantCode());
        return new HtmlJsonReBean((Object)rsSkuReDomain);
    }

    protected HtmlJsonReBean saveShopping(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, UserSession userSession, OrgUserBean orgUserBean) {
        if (null == skuId) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (!ShoppingComCon.isIntegerValue(goodsNum)) {
            this.logger.error(CODE + ".saveShopping.goodsNum", (Object)goodsNum);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u662f\u4e3a\u5c0f\u6570");
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(this.getNowChannel(request));
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        ArrayList<GoodsBean> goodsBeanList = new ArrayList<GoodsBean>();
        goodsBeanList.add(goodsBean);
        return this.saveShoppingBean(request, goodsBeanList, userSession, orgUserBean);
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        boolean ret;
        try {
            bd.toBigIntegerExact();
            ret = true;
        }
        catch (ArithmeticException ex) {
            ret = false;
        }
        return ret;
    }

    protected HtmlJsonReBean saveShoppings(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, UserSession userSession, OrgUserBean orgUserBean) {
        if (null == skuId) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(this.getNowChannel(request));
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        ArrayList<GoodsBean> goodsBeanList = new ArrayList<GoodsBean>();
        goodsBeanList.add(goodsBean);
        return this.saveShoppingBean(request, goodsBeanList, userSession, orgUserBean);
    }

    private HtmlJsonReBean saveShoppingBean(HttpServletRequest request, List<GoodsBean> goodsBeanList, UserSession userSession, OrgUserBean orgUserBean) {
        if (ListUtil.isEmpty(goodsBeanList) || null == userSession) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        ArrayList<OcShoppingGoodsDomain> shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
        try {
            for (GoodsBean goodsBean : goodsBeanList) {
                OcShoppingGoodsDomain ocShoppingGoodsDomain = this.ocShoppingService.createShoppingGoodsDomain(userSession, goodsBean, orgUserBean, "shop");
                if (null == ocShoppingGoodsDomain) {
                    this.logger.error(CODE + ".saveShopping", (Object)"ocShoppingGoodsDomain is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff01");
                }
                shoppingGoodsList.add(ocShoppingGoodsDomain);
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveOrder.ex", (Throwable)e);
            return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
        }
        return this.saveShoppingDomain(request, shoppingGoodsList);
    }

    private HtmlJsonReBean saveShoppingDomain(HttpServletRequest request, List<OcShoppingGoodsDomain> shoppingGoodsList) {
        if (ListUtil.isEmpty(shoppingGoodsList)) {
            this.logger.error(CODE + ".saveShoppingDomain", (Object)"shoppingGoodsList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u5e93\u5b58\u4e0d\u8db3");
        }
        HtmlJsonReBean htmlJsonReBean = this.ocShoppingService.insertBatchShoppingGoods(shoppingGoodsList);
        if (htmlJsonReBean != null && htmlJsonReBean.getMsg() != null && htmlJsonReBean.getMsg().equals("\u64cd\u4f5c\u6210\u529f")) {
            htmlJsonReBean.setMsg("\u6dfb\u52a0\u6210\u529f");
        }
        return htmlJsonReBean;
    }

    public HtmlJsonReBean addShoppingGoodsCustCom(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode) {
        String userinfoCode = this.getUserInfo(request).getUserInfoCode();
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userinfoCode = memberBcode;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> pMap = new HashMap<String, Object>();
        pMap.put("userinfoCode", userinfoCode);
        pMap.put("tenantCode", tenantCode);
        List ctCustrelEmpReDomainsList = this.ctCustrelService.queryCustrelEmpPage(pMap).getList();
        if (ListUtil.isNotEmpty((Collection)ctCustrelEmpReDomainsList)) {
            UserSession userSession = this.getUserSession(request);
            OrgUserBean orgUserBean = null;
            if (StringUtils.isNotBlank((String)memberBcode)) {
                userSession = this.getUserSession(memberBcode, userSession);
                orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
            }
            return this.saveShopping(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, userSession, orgUserBean);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u5206\u914d\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
    }

    private UserSession getUserSession(String memberBcode, UserSession userSession) {
        if (StringUtils.isBlank((String)memberBcode) || null == userSession) {
            return null;
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = this.userService.getUserinfoByCode(memberBcode, userSession.getTenantCode());
        if (null == umUserinfoReDomainBean) {
            return null;
        }
        UserSession reuserSession = new UserSession();
        try {
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)userSession);
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)umUserinfoReDomainBean);
            reuserSession.setUserCode(userSession.getUserCode());
            reuserSession.setUserPcode(umUserinfoReDomainBean.getUserinfoCode());
            reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        }
        catch (Exception exception) {
            // empty catch block
        }
        reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        SupQueryResult<UmGroupListReDomain> qmem = this.umGroupService.queryGroupListPage(this.getQueryMapParam("userinfoCode,tenantCode", umUserinfoReDomainBean.getUserinfoCode(), umUserinfoReDomainBean.getTenantCode()));
        if (null != qmem && ListUtil.isNotEmpty((Collection)qmem.getList())) {
            reuserSession.setGroupCode(((UmGroupListReDomain)qmem.getList().get(0)).getGroupCode());
            reuserSession.setGroupName(((UmGroupListReDomain)qmem.getList().get(0)).getGroupName());
        }
        return reuserSession;
    }

    public HtmlJsonReBean addShoppingGoodsComBean(HttpServletRequest request, List<GoodsBean> goodsBeanList, String memberBcode) {
        UserSession userSession = this.getUserSession(request);
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShoppingBean(request, goodsBeanList, userSession, orgUserBean);
    }

    public HtmlJsonReBean addShoppingGoodsCom(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode) {
        UserSession userSession = this.getUserSession(request);
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShopping(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, userSession, orgUserBean);
    }

    public HtmlJsonReBean addShoppingGoodsComs(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode) {
        UserSession userSession = this.getUserSession(request);
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShoppings(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, userSession, orgUserBean);
    }

    private OrgUserBean getOrgUserBean(String memberBcode, String userCode, String companyCode, String tenantCode) {
        SupQueryResult<CtCustrelReDomain> qcust;
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyService.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelService.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
        }
        return orgUserBean;
    }

    private HtmlJsonReBean saveShoppingSkuCodeCom(HttpServletRequest request, String goodsBeanStr, String memberBcode) {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".saveShoppingSkuCodeCom", (Object)"goodsBeanStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        List skuCodeList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveShoppingSkuCodeCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShoppingBean(request, skuCodeList, userSession, orgUserBean);
    }

    public HtmlJsonReBean addShoppingGoodsCodeCom(HttpServletRequest request, String goodsBeanStr, String memberBcode) {
        return this.saveShoppingSkuCodeCom(request, goodsBeanStr, memberBcode);
    }

    public OcShoppingGoodsReDomain getShoppingGoodsCom(String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".getShoppingGoodsCom", (Object)"param is null");
            return null;
        }
        return this.ocShoppingService.getShoppingGoods(Integer.valueOf(shoppingGoodsId));
    }

    public HtmlJsonReBean updateShoppingGoodsCom(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".updateShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.updateShoppingGoods(ocShoppingGoodsDomain);
    }

    public HtmlJsonReBean deleteShoppingGoodsCom(HttpServletRequest request, String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".deleteShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingGoodsIdS = shoppingGoodsId.split(",");
        if (null == shoppingGoodsIdS || shoppingGoodsIdS.length <= 0) {
            this.logger.error(CODE + ".deleteShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (String string : shoppingGoodsIdS) {
            idList.add(Integer.valueOf(string));
        }
        htmlJsonReBean = this.ocShoppingService.deleteShoppingGoodsBatch(idList);
        return htmlJsonReBean;
    }

    public HtmlJsonReBean deleteShoppingGoodsBatchCom(String shoppingGoodsIdStr, Map<String, Object> map) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".deleteShoppingGoodsBatchCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List shoppingGoodsIdList = JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        ArrayList<Integer> shoppingGoodsIdListStr = new ArrayList<Integer>();
        for (Integer shoppingGoodsId : shoppingGoodsIdList) {
            map.put("shoppingGoodsId", shoppingGoodsId);
            SupQueryResult<OcShoppingGoodsReDomain> ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingService.queryShoppingGoodsPage(map);
            if (!ListUtil.isNotEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) continue;
            shoppingGoodsIdListStr.add(shoppingGoodsId);
        }
        return this.ocShoppingService.deleteShoppingGoodsBatch(shoppingGoodsIdListStr);
    }

    public void sendShoppingBigData(List<OcShoppingGoodsDomain> shoppingGoodsList) {
        String value = "{\"paasLabel\":\"orderPayment\",\"message\":" + JsonUtil.buildNormalBinder().toJson(shoppingGoodsList) + "}";
        PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
        pmap.putParam("topic", (Object)"paas_business");
        pmap.putParam("value", (Object)value);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }

    public HtmlJsonReBean updateShoppingGoodsNumBatchCom(String goodsListStr) {
        if (StringUtils.isBlank((String)goodsListStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsNumBatchCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsList = JsonUtil.buildNormalBinder().getJsonToList(goodsListStr, GoodsNumDomain.class);
        return this.ocShoppingService.updateShoppingGoodsNumBatch(goodsList);
    }

    public SupQueryResult<OcShoppingGoodsReDomain> queryShoppingGoodsPageCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocShoppingService.queryShoppingGoodsPage(param);
    }

    public HtmlJsonReBean updateShoppingGoodsStateCom(String shoppingGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".updateShoppingGoodsStateCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingService.updateShoppingGoodsState(Integer.valueOf(shoppingGoodsId), dataState, oldDataState);
    }

    public List<OcShoppingReDomain> queryShoppingToContractCom(HttpServletRequest request, String shoppingGoodsIdStr, String memberBcode, String contractPmode) {
        List<OcShoppingReDomain> ocShoppingReDomainList;
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".queryShoppingToContractCom", (Object)"param is null");
            return null;
        }
        List shoppingGoodsIdList = JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryShoppingToContractCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (ListUtil.isEmpty(ocShoppingReDomainList = this.ocShoppingService.queryShoppingToContract(shoppingGoodsIdList, this.getOauthEnvCode(request)))) {
            return null;
        }
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            if (ocShoppingReDomain.getMemberBcode().equals(userSession.getUserPcode())) continue;
            this.logger.error(CODE + ".queryShoppingToContractCom.getMemberBcode", (Object)"getMemberBcode is null");
            return null;
        }
        PmCheckBean pmCheckBean = this.getPmCheckBean(request, userSession, null);
        ocShoppingReDomainList = this.ocShoppingService.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
        this.makeOcShoppingReDomain(ocShoppingReDomainList, userSession);
        return ocShoppingReDomainList;
    }

    public List<OcShoppingReDomain> queryToContractCodeCom(HttpServletRequest request, String skuCode, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String shoppingType, String contractNbillcode, String pricesetType, String memberBcode, String contractPmode) throws Exception {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".queryToContractCodeCom", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryToContractCodeCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(this.getNowChannel(request));
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuCode(skuCode);
        goodsBean.setContractNbillcode(contractNbillcode);
        goodsBean.setPricesetType(pricesetType);
        goodsBean.setShoppingType(shoppingType);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        OcShoppingDomain ocShoppingDomain = this.ocShoppingService.makeOcShoppingDomain(userSession, goodsBean, orgUserBean);
        if (!ocShoppingDomain.getMemberBcode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryShoppingToContractCom.getMemberBcode", (Object)"getMemberBcode is null");
            return null;
        }
        return this.ocShoppingService.queryToContractDomain(ocShoppingDomain, this.getTeananMemberCode(request), this.getPmCheckBean(request, userSession, contractPmode));
    }

    public List<OcShoppingReDomain> queryToContractCodeListCom(HttpServletRequest request, String goodsBeanStr, String memberBcode, String contractPmode) throws Exception {
        List skuCodeList;
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".queryToContractCodeList", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryToContractCodeList.UserSession", (Object)"UserSession is null");
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        if (ListUtil.isEmpty((Collection)(skuCodeList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class)))) {
            this.logger.error(CODE + ".queryToContractCodeList.skuCodeList", (Object)"skuCodeList is null");
            return null;
        }
        skuCodeList.stream().forEach(s -> {
            if ("08".equals(s.getShoppingType())) {
                s.setChannelCode(this.getNowChannel(request));
            }
        });
        List<OcShoppingDomain> ocShoppingDomainList = this.ocShoppingService.makeOcShoppingDomainList(userSession, skuCodeList, orgUserBean);
        return this.ocShoppingService.queryToContractDomainList(ocShoppingDomainList, this.getTeananMemberCode(request), this.getPmCheckBean(request, userSession, contractPmode));
    }

    public List<OcShoppingReDomain> queryToContractCom(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode, String contractPmode) throws Exception {
        if (null == skuId) {
            this.logger.error(CODE + ".queryToContract", (Object)"skuId is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (!ShoppingComCon.isIntegerValue(goodsNum)) {
            this.logger.error(CODE + ".queryToContractCom.goodsNum", (Object)goodsNum);
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(this.getNowChannel(request));
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        this.logger.error(CODE + ".queryToContractCom.log", (Object)"step 1");
        OcShoppingDomain ocShoppingDomain = this.ocShoppingService.makeOcShoppingDomain(userSession, goodsBean, orgUserBean);
        this.logger.error(CODE + ".queryToContractCom.log", (Object)"step 2");
        return this.ocShoppingService.queryToContractDomain(ocShoppingDomain, this.getTeananMemberCode(request), this.getPmCheckBean(request, userSession, contractPmode));
    }
}

