/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.springmvc.filter;

import cn.com.qj.bff.springmvc.filter.ResponseContent;
import cn.com.qj.bff.springmvc.filter.SplitServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private PrintWriter cachedWriter = null;
    private ResponseContent result = new ResponseContent();
    private SplitServletOutputStream cacheOut = null;
    private int status = 200;
    private long cacheControl = -60L;

    public CacheHttpServletResponseWrapper(HttpServletResponse response) {
        this(response, Long.MAX_VALUE, 1L, -1L, -60L);
    }

    public CacheHttpServletResponseWrapper(HttpServletResponse response, long time, long lastModified, long expires, long cacheControl) {
        super(response);
        this.cacheControl = cacheControl;
        if (lastModified == -1L) {
            long current = System.currentTimeMillis();
            current -= current % 1000L;
            this.result.setLastModified(current);
            super.setDateHeader("Last-Modified", this.result.getLastModified());
        }
        if (expires == 1L) {
            this.result.setExpires(this.result.getLastModified() + time);
            super.setDateHeader("Expires", this.result.getExpires());
        }
        if (this.cacheControl == 0L) {
            long maxAge = System.currentTimeMillis();
            maxAge = maxAge - maxAge % 1000L + time;
            this.result.setMaxAge(maxAge);
            super.addHeader("Cache-Control", "max-age=" + time / 1000L);
        } else if (this.cacheControl != 0L) {
            this.result.setMaxAge(this.cacheControl);
            super.addHeader("Cache-Control", "max-age=" + -this.cacheControl);
        } else if (this.cacheControl == 0L) {
            this.result.setMaxAge(this.cacheControl);
        }
    }

    public ResponseContent getContent() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.result.commit();
        return this.result;
    }

    public void setContentType(String value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ContentType: " + value));
        }
        super.setContentType(value);
        this.result.setContentType(value);
    }

    public void setHeader(String name, String value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("header: " + name + ": " + value));
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.result.setContentType(value);
        }
        if ("Content-Encoding".equalsIgnoreCase(name)) {
            this.result.setContentEncoding(value);
        }
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("header: " + name + ": " + value));
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.result.setContentType(value);
        }
        if ("Content-Encoding".equalsIgnoreCase(name)) {
            this.result.setContentEncoding(value);
        }
        super.addHeader(name, value);
    }

    public void sendError(int status, String string) throws IOException {
        super.sendError(status, string);
        this.status = status;
    }

    public void sendError(int status) throws IOException {
        super.sendError(status);
        this.status = status;
    }

    public void setStatus(int status, String string) {
        super.setStatus(status, string);
        this.status = status;
    }

    public void sendRedirect(String location) throws IOException {
        this.status = 302;
        super.sendRedirect(location);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        super.setStatus(status);
        this.status = status;
    }

    public void setLocale(Locale value) {
        super.setLocale(value);
        this.result.setLocale(value);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.cacheOut == null) {
            this.cacheOut = new SplitServletOutputStream(this.result.getOutputStream(), (OutputStream)super.getOutputStream());
        }
        return this.cacheOut;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.cachedWriter == null) {
            String encoding = this.getCharacterEncoding();
            this.cachedWriter = encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), encoding)) : new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream()));
        }
        return this.cachedWriter;
    }

    private void flush() throws IOException {
        if (this.cacheOut != null) {
            this.cacheOut.flush();
        }
        if (this.cachedWriter != null) {
            this.cachedWriter.flush();
        }
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        this.flush();
    }
}

