/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.service.fm;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.send.SupperFacade;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.fm.FmFchannelDomainBean;
import cn.com.qj.bff.domain.fm.FmFchannelReDomainBean;
import cn.com.qj.bff.domain.fm.FmFileDomainBean;
import cn.com.qj.bff.domain.fm.FmFileReDomainBean;
import cn.com.qj.bff.domain.fm.FmFilelistDomainBean;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Repository
public class FileService
extends SupperFacade {
    private static final int FM_NAME_MAX_LENGTH = 40;
    public static final int BYTESIZE = 1024;
    public static String TEMP = null;

    public SupQueryResult<FmFileReDomainBean> queryFilePagePlus(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("fm.file.queryFilePage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, FmFileReDomainBean.class);
    }

    public SupQueryResult<FmFileReDomainBean> queryFilePage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("fm.file.queryFilePage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, FmFileReDomainBean.class);
    }

    public List<FmFilelistDomainBean> queryFilelist(String fileCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("fm.file.queryFilelist");
        pmap.putParam("fileCode", (Object)fileCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.getForList(pmap, FmFilelistDomainBean.class);
    }

    public FmFileReDomainBean queryFileByFileCode(String fileCode) {
        PostParamMap postParamMap = new PostParamMap("fm.file.queryFilePage");
        HashMap<String, String> inner = new HashMap<String, String>();
        inner.put("fileCode", fileCode);
        postParamMap.putParamToJson("map", inner);
        SupQueryResult result = this.htmlIBaseService.sendReSupObject(postParamMap, FmFileReDomainBean.class);
        if (result != null && !CollectionUtils.isEmpty((Collection)result.getList())) {
            return (FmFileReDomainBean)result.getList().get(0);
        }
        return null;
    }

    public List<FmFileReDomainBean> queryFile(String fileSort, String tenantCode, String relationCode) {
        List fileList = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileSort", fileSort);
        map.put("tenantCode", tenantCode);
        map.put("relationCode", relationCode);
        map.put("order", true);
        String key = "filePath";
        String settingType = "0";
        String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
        String separtor = System.getProperties().getProperty("file.separator");
        SupQueryResult<FmFileReDomainBean> queryResult = this.queryFilePage(map);
        if (queryResult != null && !CollectionUtils.isEmpty((Collection)queryResult.getList())) {
            fileList = queryResult.getList();
            for (FmFileDomainBean FmFileDomainBean2 : queryResult.getList()) {
                String fileCode = FmFileDomainBean2.getFileCode();
                String fileUrl = FmFileDomainBean2.getFileUrl();
                String fileCtype = FmFileDomainBean2.getFileCtype();
                FmFileDomainBean2.setRootPath(httpPath + separtor + fileUrl + separtor + fileCode + "." + fileCtype);
            }
        }
        return fileList;
    }

    private FmFileReDomainBean convertFmFileDomainBean(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        String fileName = file.getOriginalFilename();
        if (StringUtils.isBlank((String)fileName)) {
            throw new ApiException("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        List<String> list = Arrays.asList("jpg", "gif", "png", "jpeg", "xlsx", "xls", "zip", "csv", "mp4", "ogg", "flv", "mkv");
        if (!list.contains(fileType.toLowerCase())) {
            throw new ApiException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u6301");
        }
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(name.length() > 40 ? name.substring(0, 40) : name);
        fmFileReDomainBean.setFileSize((int)file.getSize());
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileCtype(fileType);
        fmFileReDomainBean.setFileRemark(name);
        try {
            fmFileReDomainBean.setFileContext(Base64.encodeBase64((byte[])file.getBytes()));
        }
        catch (Exception e) {
            return null;
        }
        return fmFileReDomainBean;
    }

    private FileBean convertFileBean(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        String fileName = file.getOriginalFilename();
        String[] split = fileName.split("\\.");
        if (split.length > 2) {
            throw new ApiException("\u6587\u4ef6\u540d\u79f0\u683c\u5f0f\u4e0d\u5bf9");
        }
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        byte[] fileBytes = new byte[(int)file.getSize()];
        try {
            file.getInputStream().read(fileBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])fileBytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(name.length() > 40 ? name.substring(0, 40) : name);
        fileBean.setSize(Long.valueOf(file.getSize()));
        return fileBean;
    }

    public FmFileReDomainBean saveFile(MultipartFile file, String tenantCode, String fileSort) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        FmFileReDomainBean FmFileDomainBeanBean = this.convertFmFileDomainBean(file);
        FileBean fileBean = this.convertFileBean(file);
        return this.saveFile(fileBean, tenantCode, fileSort, FmFileDomainBeanBean);
    }

    public FmFileReDomainBean saveFileO(MultipartFile file, String tenantCode, String fileSort, String fileOwner) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        FmFileReDomainBean FmFileDomainBeanBean = this.convertFmFileDomainBean(file);
        FmFileDomainBeanBean.setFileOwner(fileOwner);
        FileBean fileBean = this.convertFileBean(file);
        return this.saveFile(fileBean, tenantCode, fileSort, FmFileDomainBeanBean);
    }

    public FmFileReDomainBean saveFileConPcode(MultipartFile file, String tenantCode, String fileSort, String filePcode, String fileOwner, FmFileDomainBean fmle) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        FmFileReDomainBean FmFileDomainBeanBean = this.convertFmFileDomainBean(file);
        if (StringUtils.isNotBlank((String)filePcode)) {
            FmFileDomainBeanBean.setFilePcode(filePcode);
        }
        if (StringUtils.isNotBlank((String)fileOwner)) {
            FmFileDomainBeanBean.setFileOwner(fileOwner);
        }
        FileBean fileBean = this.convertFileBean(file);
        return this.saveTFile(fileBean, tenantCode, fileSort, FmFileDomainBeanBean, fmle);
    }

    public FmFileReDomainBean saveFileConPcode(MultipartFile file, String tenantCode, String fileSort, String filePcode, String fileOwner) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        FmFileReDomainBean FmFileDomainBeanBean = this.convertFmFileDomainBean(file);
        if (StringUtils.isNotBlank((String)filePcode)) {
            FmFileDomainBeanBean.setFilePcode(filePcode);
        }
        if (StringUtils.isNotBlank((String)fileOwner)) {
            FmFileDomainBeanBean.setFileOwner(fileOwner);
        }
        FileBean fileBean = this.convertFileBean(file);
        return this.saveFile(fileBean, tenantCode, fileSort, FmFileDomainBeanBean);
    }

    public FmFileReDomainBean saveFileConPcode(MultipartFile file, String tenantCode, String fileSort, String filePcode) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        FmFileReDomainBean FmFileDomainBeanBean = this.convertFmFileDomainBean(file);
        if (StringUtils.isNotBlank((String)filePcode)) {
            FmFileDomainBeanBean.setFilePcode(filePcode);
        }
        FileBean fileBean = this.convertFileBean(file);
        return this.saveFile(fileBean, tenantCode, fileSort, FmFileDomainBeanBean);
    }

    public FmFileReDomainBean saveFileRelSkuNo(MultipartFile file, String tenantCode, String fileSort, String skuNo) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        FmFileReDomainBean FmFileDomainBeanBean = this.convertFmFileDomainBean(file);
        FmFileDomainBeanBean.setFileOpcode1(skuNo);
        FileBean fileBean = this.convertFileBean(file);
        return this.saveFile(fileBean, tenantCode, fileSort, FmFileDomainBeanBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveTempFile(InputStream is, String fileName) {
        File temp = null;
        try {
            TEMP = System.getProperty("java.io.tmpdir");
        }
        catch (Exception e1) {
            this.logger.error("FileService", (Throwable)e1);
        }
        if (TEMP != null && is != null) {
            temp = new File(TEMP + fileName);
            BufferedInputStream bis = null;
            FilterOutputStream bos = null;
            FileOutputStream fs = null;
            try {
                bis = new BufferedInputStream(is);
                fs = new FileOutputStream(temp);
                bos = new BufferedOutputStream(fs);
                int len = 0;
                byte[] buf = new byte[10240];
                while ((len = bis.read(buf)) != -1) {
                    ((BufferedOutputStream)bos).write(buf, 0, len);
                }
                ((BufferedOutputStream)bos).flush();
            }
            catch (IOException e) {
                this.logger.error("FileService1", (Throwable)e);
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    if (null != fs) {
                        fs.close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error("FileService2", (Throwable)e);
                }
            }
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FmFileReDomainBean> convertFmFileDomainBeans(InputStream inputStream, String originalFilename, String tenantCode, String fileSort, String channelCodeStr) throws IOException {
        if (null == inputStream) {
            return null;
        }
        File tempFile = this.saveTempFile(inputStream, originalFilename);
        ArrayList<FmFileReDomainBean> fmFileReDomainBeanList = new ArrayList<FmFileReDomainBean>();
        ZipFile zipFile = new ZipFile(tempFile);
        try {
            ZipEntry ze = null;
            Enumeration<? extends ZipEntry> zplist = zipFile.entries();
            while (zplist.hasMoreElements()) {
                FmFileReDomainBean fmFileReDomainBean;
                int len;
                ze = zplist.nextElement();
                InputStream is = zipFile.getInputStream(ze);
                byte[] buf = new byte[1024];
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                while ((len = is.read(buf)) != -1) {
                    output.write(buf, 0, len);
                }
                String fileName = ze.getName();
                String name = fileName.substring(0, fileName.lastIndexOf("."));
                FmFileDomainBean fmFileDomainBean = new FmFileDomainBean();
                fmFileDomainBean.setFileContext(Base64.encodeBase64((byte[])output.toByteArray()));
                fmFileDomainBean.setFileSize((int)ze.getSize());
                fmFileDomainBean.setFileCtype(fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()));
                fmFileDomainBean.setFileName(name.length() > 40 ? name.substring(0, 40) : name);
                fmFileDomainBean.setFileType("0");
                fmFileDomainBean.setFileRemark(fileName);
                FileBean fileBean = new FileBean();
                fileBean.setBytes(Base64.encodeBase64((byte[])output.toByteArray()));
                fileBean.setSize(Long.valueOf(ze.getSize()));
                fileBean.setFileType(fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()));
                fileBean.setName(fileName.substring(0, fileName.lastIndexOf(".")));
                fileBean.setOriginalFilename(fileName.substring(0, fileName.lastIndexOf(".")));
                if (StringUtils.isBlank((String)channelCodeStr)) {
                    fmFileReDomainBean = this.saveFile(fileBean, tenantCode, fileSort, fmFileDomainBean);
                    fmFileReDomainBeanList.add(fmFileReDomainBean);
                    continue;
                }
                for (String channelCode : channelCodeStr.split(",")) {
                    fmFileReDomainBean = this.saveFile(fileBean, tenantCode, fileSort + channelCode, fmFileDomainBean);
                    fmFileReDomainBean.setChannelCode(channelCode);
                    fmFileReDomainBeanList.add(fmFileReDomainBean);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("FileService", (Throwable)e);
        }
        finally {
            zipFile.close();
            inputStream.close();
            tempFile.delete();
        }
        return fmFileReDomainBeanList;
    }

    public List<FmFileReDomainBean> convertFmFileDomainBeans(MultipartFile file, String tenantCode, String fileSort, String channelCodeStr) throws IOException {
        return this.convertFmFileDomainBeans(file.getInputStream(), file.getOriginalFilename(), tenantCode, fileSort, channelCodeStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileBean> savefile(MultipartFile file) throws IOException {
        InputStream inputStream = null;
        ZipInputStream zipInputStream = null;
        InputStream stin = null;
        try {
            inputStream = file.getInputStream();
            stin = new BufferedInputStream(inputStream);
            zipInputStream = new ZipInputStream(stin);
            ZipEntry ze = null;
            ArrayList<FileBean> fileList = new ArrayList<FileBean>();
            InputStreamReader in = null;
            while ((ze = zipInputStream.getNextEntry()) != null) {
                try {
                    String line;
                    in = new InputStreamReader(zipInputStream);
                    BufferedReader br = new BufferedReader(in);
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((line = br.readLine()) != null) {
                        stringBuffer.append(line);
                    }
                    String fileName = ze.getName();
                    FileBean fileBean = new FileBean();
                    fileBean.setBytes(Base64.encodeBase64((byte[])stringBuffer.toString().getBytes()));
                    fileBean.setSize(Long.valueOf(ze.getSize()));
                    fileBean.setFileType(fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()));
                    fileBean.setName(fileName.substring(0, fileName.lastIndexOf(".")));
                    fileBean.setOriginalFilename(fileName.substring(0, fileName.lastIndexOf(".")));
                    fileList.add(fileBean);
                }
                finally {
                    if (null == in) continue;
                    in.close();
                }
            }
            ArrayList<FileBean> arrayList = fileList;
            return arrayList;
        }
        finally {
            if (null != stin) {
                stin.close();
            }
            if (null != zipInputStream) {
                zipInputStream.closeEntry();
            }
            if (null != inputStream) {
                inputStream.close();
            }
        }
    }

    public List<FmFileReDomainBean> saveFiles(MultipartFile file, String tenantCode, String fileSort, String channelCodeStr) throws Exception {
        if (file == null || file.isEmpty()) {
            return null;
        }
        return this.convertFmFileDomainBeans(file, tenantCode, fileSort, channelCodeStr);
    }

    private FmFileReDomainBean saveTFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean, FmFileDomainBean fmle) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap pmap = new PostParamMap("fm.file.saveTFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            pmap.putParam("fmle", (Object)fmle);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = "/paas/shop";
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("saveFile", (Throwable)e);
        }
        return fmFileReDomainBean;
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = "/paas/shop";
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl())) && (fileUrl.length() <= 4 || !fileUrl.trim().substring(0, 4).equals("http"))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("saveFile", (Throwable)e);
        }
        return fmFileReDomainBean;
    }

    public static void main(String[] args) {
        String url = "http://se";
        System.out.println(url.substring(0, 4));
    }

    public FmFileReDomainBean saveFile(byte[] file, String tenantCode, String fileSort, String relationCode, String fileType, String fileRemark) {
        if (file == null) {
            return null;
        }
        FmFileDomainBean FmFileDomainBeanBean = new FmFileDomainBean();
        FmFileDomainBeanBean.setFileSize(file.length);
        FmFileDomainBeanBean.setFileType("0");
        FmFileDomainBeanBean.setFileCtype(fileType);
        FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
        FmFileDomainBeanBean.setTenantCode(tenantCode);
        FmFileDomainBeanBean.setRootPath(tenantCode + "/");
        FmFileDomainBeanBean.setFileRemark(fileRemark);
        FmFileDomainBeanBean.setRelationCode(relationCode);
        FileBean fileBean = new FileBean();
        fileBean.setFileType(fileType);
        fileBean.setSize(Long.valueOf(file.length));
        fileBean.setBytes(Base64.encodeBase64((byte[])file));
        return this.saveFile(fileBean, tenantCode, fileSort, FmFileDomainBeanBean);
    }

    private FileBean getFileBean(InputStream is, long flex, String fileType, String name) throws IOException {
        byte[] b = new byte[(int)flex];
        FileBean fileBean = new FileBean();
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(name);
        fileBean.setSize(Long.valueOf(flex));
        is.read(b);
        fileBean.setBytes(Base64.encodeBase64((byte[])b));
        return fileBean;
    }

    public FmFileReDomainBean saveFile(MultipartFile file, String tenantCode, String fileSort, String code, String fileRemark) {
        return this.asserblyFile(file, tenantCode, fileSort, code, fileRemark);
    }

    public FmFileReDomainBean saveFile(MultipartFile file, String tenantCode, String fileSort, String code) {
        return this.asserblyFile(file, tenantCode, fileSort, code, "");
    }

    public HtmlJsonReBean deleteFile(Integer fileId) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteFile");
        pmap.putParamToJson("fileId", (Object)fileId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean getFile(Integer fileId) {
        PostParamMap pmap = new PostParamMap("fm.file.getFile");
        pmap.putParamToJson("fileId", (Object)fileId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteFileByCode(String tenantCode, String fileCode) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteFileByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("fileCode", (Object)fileCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteFileListByCode(String tenantCode, String fileCode) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteFileListByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("fileCode", (Object)fileCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateFile(FmFileDomainBean FmFileDomainBean2) {
        PostParamMap pmap = new PostParamMap("fm.file.updateFile");
        pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBean2);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateFileByCode(FmFileDomainBean FmFileDomainBean2) {
        PostParamMap pmap = new PostParamMap("fm.file.updateFileByCode");
        pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBean2);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public FmFileReDomainBean getFileById(Integer fileId) {
        PostParamMap pmap = new PostParamMap("fm.file.getFile");
        pmap.putParamToJson("fileId", (Object)fileId);
        return (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
    }

    public FmFileReDomainBean getFileByCode(String fileCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("fm.file.getFileByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("fileCode", (Object)fileCode);
        return (FmFileReDomainBean)this.htmlIBaseService.sendMes(pmap, FmFileReDomainBean.class);
    }

    public FmFileReDomainBean downloadFile(String fileCode) {
        PostParamMap pmap = new PostParamMap("fm.file.getDownloadFile");
        pmap.putParam("fileCode", (Object)fileCode);
        return (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
    }

    public HtmlJsonReBean saveFchannel(FmFchannelDomainBean fmFchannelDomainBean) {
        PostParamMap pmap = new PostParamMap("fm.file.saveFchannel");
        pmap.putParamToJson("fmFchannelDomainBeanBean", (Object)fmFchannelDomainBean);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateFchannel(FmFchannelDomainBean fmFchannelDomainBean) {
        PostParamMap pmap = new PostParamMap("fm.file.updateFchannel");
        pmap.putParamToJson("fmFchannelDomainBeanBean", (Object)fmFchannelDomainBean);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteFchannel(Integer fchannelId) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteFchannel");
        pmap.putParam("fchannelId", (Object)fchannelId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateFchannelState(String fchannelId, String dataState, String oldDataState) {
        PostParamMap pmap = new PostParamMap("fm.file.updateFchannelState");
        pmap.putParam("fchannelId", (Object)Integer.valueOf(fchannelId));
        pmap.putParam("dataState", (Object)Integer.valueOf(dataState));
        pmap.putParam("oldDataState", (Object)Integer.valueOf(oldDataState));
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public FmFchannelReDomainBean getFchannel(Integer fchannelId) {
        PostParamMap pmap = new PostParamMap("fm.file.getFchannel");
        pmap.putParam("fchannelId", (Object)fchannelId);
        return (FmFchannelReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFchannelReDomainBean.class);
    }

    public SupQueryResult<FmFchannelReDomainBean> queryFchannelPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("fm.file.queryFchannelPage");
        pmap.putParam("map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        return this.htmlIBaseService.sendReSupObject(pmap, FmFchannelReDomainBean.class);
    }

    private FmFileReDomainBean asserblyFile(MultipartFile file, String tenantCode, String fileSort, String relationCode, String fileRemark) {
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            if (file == null) {
                return null;
            }
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            String filename = file.getOriginalFilename();
            String fileType = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
            String name = filename.substring(0, filename.lastIndexOf("."));
            if (name.length() > 50) {
                throw new SupperSysException("error", "\u6587\u4ef6\u540d\u8fc7\u957f");
            }
            FmFileDomainBean FmFileDomainBeanBean = new FmFileDomainBean();
            FmFileDomainBeanBean.setFileName(name);
            FmFileDomainBeanBean.setFileSize((int)file.getSize());
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileCtype(fileType);
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            FmFileDomainBeanBean.setFileRemark(fileRemark);
            FmFileDomainBeanBean.setRelationCode(relationCode);
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            FileBean fileBean = new FileBean();
            fileBean.setFileType(fileType);
            fileBean.setOriginalFilename(name);
            fileBean.setSize(Long.valueOf(file.getSize()));
            InputStream is = file.getInputStream();
            byte[] b = new byte[(int)file.getSize()];
            is.read(b);
            fileBean.setBytes(Base64.encodeBase64((byte[])b));
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFmFileDomainBeanBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = "/paas/shop";
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                fmFileReDomainBean.setFileUrl(httpPath + System.getProperties().getProperty("file.separator") + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            throw new SupperSysException("error", e.getMessage());
        }
        return fmFileReDomainBean;
    }

    public Map<String, Object> updateFile(HttpServletRequest request, String tenantCode, String fileSort, String relationCode, String fileRemark) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer flexSize = 2;
        Integer returnInfo = 0;
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<String> fileCodes = new ArrayList<String>();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map multipartFileMap = multipartRequest.getFileMap();
        for (Map.Entry entryFile : multipartFileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entryFile.getValue();
            if (StringUtils.isBlank((String)file.getOriginalFilename())) {
                returnInfo = 1;
                continue;
            }
            if (file == null) continue;
            long fileSize = file.getSize() / 1024L / 1024L;
            if (fileSize > (long)flexSize.intValue()) {
                returnInfo = 2;
                break;
            }
            FmFileReDomainBean FmFileDomainBean2 = this.saveFile(file, tenantCode, fileSort, relationCode, fileRemark);
            if (FmFileDomainBean2 != null) {
                returnInfo = 0;
                fileCodes.add(FmFileDomainBean2.getFileCode());
                urls.add(FmFileDomainBean2.getRootPath());
                break;
            }
            returnInfo = 3;
        }
        if (returnInfo == 0) {
            map.put("data", "success");
            map.put("msg", urls.get(0));
            map.put("tenantCode", tenantCode);
            map.put("fileCode", fileCodes.get(0));
        } else if (returnInfo == 1) {
            map.put("data", "error");
            map.put("msg", "\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        } else {
            map.put("data", "error");
            map.put("msg", "\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e" + flexSize + "M");
        }
        return map;
    }

    public HtmlJsonReBean saveFolder(FmFileDomainBean fmFileDomainBean) {
        PostParamMap pmap = new PostParamMap("fm.file.saveFolder");
        pmap.putParamToJson("fmFileDomainBean", (Object)fmFileDomainBean);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveFile(FmFileDomainBean fmFileDomainBean) {
        PostParamMap pmap = new PostParamMap("fm.file.saveFolde");
        pmap.putParamToJson("fmFileDomainBean", (Object)fmFileDomainBean);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteModelFile(String ids) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteModelFile");
        pmap.putParamToJson("ids", (Object)ids);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSensitByIdBatch(List<Integer> idList) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteSensitByIdBatch");
        pmap.putParamToJson("idList", idList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateState(Integer fileId, Integer dataState, Integer oldDataState) {
        PostParamMap pmap = new PostParamMap("fm.file.updateFileState");
        pmap.putParam("fileId", (Object)fileId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean downloadFileByName(String fileName, String tenantCode) {
        PostParamMap pmap = new PostParamMap("fm.file.downloadFileByName");
        pmap.putParamToJson("fileName", (Object)fileName);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public String getTemporaryUrl(Map<String, String> paramMap) {
        PostParamMap map = new PostParamMap("oss.oss.getTemporaryUrl");
        map.putParamToJson("paramMap", paramMap);
        HtmlJsonReBean htmlJsonReBean = this.htmlIBaseService.sendMesReBean(map);
        if (htmlJsonReBean == null || Objects.isNull(htmlJsonReBean.getDataObj())) {
            this.logger.error("web.fm.file.downFileUrl.getTemporaryUrl RESULT :", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
            return null;
        }
        return (String)htmlJsonReBean.getDataObj();
    }

    public String downFileStreamByUrl(Map<String, String> paramMap) {
        PostParamMap map = new PostParamMap("oss.oss.downFileStreamByUrl");
        map.putParamToJson("paramMap", paramMap);
        HtmlJsonReBean htmlJsonReBean = this.htmlIBaseService.sendMesReBean(map);
        if (htmlJsonReBean == null || Objects.isNull(htmlJsonReBean.getDataObj())) {
            this.logger.error("web.fm.file.downFileStreamByUrl RESULT :", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
            return null;
        }
        return (String)htmlJsonReBean.getDataObj();
    }
}

