/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.service.um;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.send.SupperFacade;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.um.AmAddress;
import cn.com.qj.bff.domain.um.UmAddressDomain;
import cn.com.qj.bff.domain.um.UmAddressReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoDomain;
import cn.com.qj.bff.service.da.DataCryptoAndDesensitizationService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UmAddressService
extends SupperFacade {
    @Autowired
    private DataCryptoAndDesensitizationService dataCryptoAndDesensitizationService;

    public UmAddressReDomain getAddress(Integer addressId) {
        PostParamMap pmap = new PostParamMap("um.address.getAddress");
        pmap.putParam("addressId", (Object)addressId);
        return (UmAddressReDomain)this.htmlIBaseService.senReObject(pmap, UmAddressReDomain.class);
    }

    public HtmlJsonReBean updateAddressState(Integer addressId, Integer dataState, Integer oldDataState) {
        PostParamMap pmap = new PostParamMap("um.address.updateAddressState");
        pmap.putParam("addressId", (Object)addressId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<UmAddressReDomain> queryAddressPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("um.address.queryAddressPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, UmAddressReDomain.class);
    }

    public UmAddressReDomain getAddressByCode(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("um.address.getAddressByCode");
        pmap.putParamToJson("map", map);
        return (UmAddressReDomain)this.htmlIBaseService.senReObject(pmap, UmAddressReDomain.class);
    }

    public HtmlJsonReBean delAddressByCode(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("um.address.delAddressByCode");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<UmAddressReDomain> getAddressBymerberCode(String userCode) {
        PostParamMap pmap = new PostParamMap("um.address.getAddressBymerberCode");
        pmap.putParam("userCode", (Object)userCode);
        return this.htmlIBaseService.getForList(pmap, UmAddressReDomain.class);
    }

    public List<UmAddressReDomain> queryAddressBymerberCode(String userCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("um.address.queryAddressBymerberCode");
        pmap.putParam("userCode", (Object)userCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        List umAddressReDomains = this.htmlIBaseService.getForList(pmap, UmAddressReDomain.class);
        this.decryptUmAddress(umAddressReDomains);
        this.desensitizationAddressDetailList(umAddressReDomains);
        return umAddressReDomains;
    }

    public List<UmAddressReDomain> queryAddressBymerberCodeByPage(Map<String, Object> map) {
        List<UmAddressReDomain> resultList = new ArrayList<UmAddressReDomain>();
        PostParamMap pmap = new PostParamMap("um.address.queryAddressPage");
        pmap.putParamToJson("map", map);
        SupQueryResult queryResult = this.htmlIBaseService.sendReSupObject(pmap, UmAddressReDomain.class);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            resultList = queryResult.getList();
            this.decryptUmAddress(resultList);
            this.desensitizationAddressDetailList(resultList);
        }
        return resultList;
    }

    public void decryptUmAddress(List<UmAddressReDomain> umAddressReDomains) {
        if (ListUtil.isEmpty(umAddressReDomains)) {
            return;
        }
        for (UmAddressReDomain umAddressDomain : umAddressReDomains) {
            this.decryptUmAddressOne(umAddressDomain);
        }
    }

    public void decryptUmAddressOne(UmAddressReDomain umAddressDomain) {
        try {
            JSONObject jsonObject = this.decryptApiData(umAddressDomain);
            if (Objects.isNull(jsonObject)) {
                return;
            }
            JSONObject newData = this.dataCryptoAndDesensitizationService.decryptApi(jsonObject);
            if (Objects.nonNull(newData) && newData.getBoolean("success").booleanValue()) {
                JSONArray jsonArray = newData.getJSONObject("result").getJSONArray("secBaseDtoList");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject1 = jsonArray.getJSONObject(i);
                    if ("addressMember".equals(org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)jsonObject1.getString("descriptor"), (CharSequence)""))) {
                        umAddressDomain.setAddressMember(jsonObject1.getString("result"));
                    }
                    if ("addressPhone".equals(org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)jsonObject1.getString("descriptor"), (CharSequence)""))) {
                        umAddressDomain.setAddressPhone(jsonObject1.getString("result"));
                    }
                    if (!"addressDetail".equals(org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)jsonObject1.getString("descriptor"), (CharSequence)""))) continue;
                    umAddressDomain.setAddressDetail(jsonObject1.getString("result"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("desensitization.e.\u6570\u636e:", (Object)umAddressDomain, (Throwable)e);
        }
    }

    public static String desensitizedPhoneNumber(String phoneNumber) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)phoneNumber)) {
            phoneNumber = phoneNumber.replaceAll("(\\w{3})\\w*(\\w{3})", "$1*****$2");
        }
        return phoneNumber;
    }

    public static String desensitizedName(String fullName) {
        if (StringUtils.isNotBlank((String)fullName)) {
            if (fullName.length() > 2) {
                String name = fullName.substring(0, 1);
                for (int i = 0; i < fullName.length() - 2; ++i) {
                    name = name + "*";
                }
                name = name + fullName.substring(fullName.length() - 1);
                return name;
            }
            return fullName.substring(0, 1).concat("*");
        }
        return fullName;
    }

    public JSONObject decryptApiData(UmAddressDomain umAddressDomain) {
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> secBaseDtoList = new ArrayList<JSONObject>();
        JSONObject secBaseDto = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)umAddressDomain.getAddressMember())) {
            secBaseDto = new JSONObject();
            secBaseDto.put("data", (Object)umAddressDomain.getAddressMember());
            secBaseDto.put("descriptor", (Object)"addressMember");
            secBaseDtoList.add(secBaseDto);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)umAddressDomain.getAddressPhone())) {
            secBaseDto = new JSONObject();
            secBaseDto.put("data", (Object)umAddressDomain.getAddressPhone());
            secBaseDto.put("descriptor", (Object)"addressPhone");
            secBaseDtoList.add(secBaseDto);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)umAddressDomain.getAddressDetail())) {
            secBaseDto = new JSONObject();
            secBaseDto.put("data", (Object)umAddressDomain.getAddressDetail());
            secBaseDto.put("descriptor", (Object)"addressDetail");
            secBaseDtoList.add(secBaseDto);
        }
        jsonObject.put("secBaseDtoList", secBaseDtoList);
        return jsonObject;
    }

    public void desensitizationAddressDetailList(List<UmAddressReDomain> umAddressReDomains) {
        if (ListUtil.isEmpty(umAddressReDomains)) {
            return;
        }
        for (UmAddressReDomain umAddressDomain : umAddressReDomains) {
            this.desensitizationAddressDetail(umAddressDomain);
        }
    }

    public void desensitizationAddressDetail(UmAddressReDomain umAddressDomain) {
        try {
            List<JSONObject> jsonObjects = this.desensitizationOcContractApiData(umAddressDomain.getAddressMember(), umAddressDomain.getAddressPhone(), umAddressDomain.getAddressDetail());
            if (ListUtil.isEmpty(jsonObjects)) {
                return;
            }
            JSONObject newData = this.dataCryptoAndDesensitizationService.desensitizationApi(jsonObjects);
            if (Objects.nonNull(newData) && newData.getBoolean("success").booleanValue()) {
                JSONArray jsonArray = newData.getJSONObject("result").getJSONArray("desensitizationDtoList");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject1 = jsonArray.getJSONObject(i);
                    if ("NAME".equals(StringUtils.defaultIfBlank((String)jsonObject1.getString("descriptor"), (String)""))) {
                        umAddressDomain.setAddressMember(jsonObject1.getString("data"));
                    }
                    if ("TEL".equals(StringUtils.defaultIfBlank((String)jsonObject1.getString("descriptor"), (String)""))) {
                        umAddressDomain.setAddressPhone(jsonObject1.getString("data"));
                    }
                    if (!"ADDRESS_DETAIL".equals(StringUtils.defaultIfBlank((String)jsonObject1.getString("descriptor"), (String)""))) continue;
                    umAddressDomain.setAddressDetail(jsonObject1.getString("data"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("desensitizationAddressDetail.e.", (Object)("\u6570\u636e:" + umAddressDomain.getAddressMember() + "-" + umAddressDomain.getAddressPhone() + "-" + umAddressDomain.getAddressDetail()));
        }
    }

    public List<JSONObject> desensitizationOcContractApiData(String name, String tel, String addressDetail) {
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> secBaseDtoList = new ArrayList<JSONObject>();
        JSONObject secBaseDto = null;
        if (StringUtils.isNotBlank((String)name)) {
            secBaseDto = new JSONObject();
            secBaseDto.put("data", (Object)name);
            secBaseDto.put("descriptor", (Object)"NAME");
            secBaseDtoList.add(secBaseDto);
        }
        if (StringUtils.isNotBlank((String)tel)) {
            secBaseDto = new JSONObject();
            secBaseDto.put("data", (Object)tel);
            secBaseDto.put("descriptor", (Object)"TEL");
            secBaseDtoList.add(secBaseDto);
        }
        if (StringUtils.isNotBlank((String)addressDetail)) {
            secBaseDto = new JSONObject();
            secBaseDto.put("data", (Object)addressDetail);
            secBaseDto.put("descriptor", (Object)"ADDRESS_DETAIL");
            secBaseDtoList.add(secBaseDto);
        }
        return secBaseDtoList;
    }

    public HtmlJsonReBean saveAddress(UmAddressDomain umAddressDomain) {
        PostParamMap pmap = new PostParamMap("um.address.saveAddress");
        pmap.putParamToJson("umAddressDomain", (Object)umAddressDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateAddress(UmAddressDomain umAddressDomain) {
        PostParamMap pmap = new PostParamMap("um.address.updateAddress");
        pmap.putParamToJson("umAddressDomain", (Object)umAddressDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteAddress(Integer addressId) {
        PostParamMap pmap = new PostParamMap("um.address.deleteAddress");
        pmap.putParam("addressId", (Object)addressId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateAddressDefault(String userCode, String addressCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("um.address.setAddressDefault");
        pmap.putParam("userCode", (Object)userCode);
        pmap.putParam("addressCode", (Object)addressCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public UmAddressReDomain getDefAddressBymerberCode(String userCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("um.address.getDefAddressBymerberCode");
        pmap.putParam("userCode", (Object)userCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return (UmAddressReDomain)this.htmlIBaseService.senReObject(pmap, UmAddressReDomain.class);
    }

    public List<AmAddress> queryAmUserAddressByCode(String userinfoCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("extam.amUser.queryAmUserAddressByCode");
        pmap.putParam("userinfoCode", (Object)userinfoCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.getForList(pmap, AmAddress.class);
    }

    public HtmlJsonReBean saveUserAddressByCode(String userinfoCode, String tenantCode, List<AmAddress> amAddresses) {
        PostParamMap pmap = new PostParamMap("extam.amUser.saveUserAddressByCode");
        pmap.putParamToJson("amAddresses", amAddresses);
        pmap.putParam("userinfoCode", (Object)userinfoCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteUserAddressByCode(String userinfoCode, String tenantCode, List<AmAddress> amAddresses) {
        PostParamMap pmap = new PostParamMap("extam.amUser.deleteUserAddressByCode");
        pmap.putParamToJson("amAddresses", amAddresses);
        pmap.putParam("userinfoCode", (Object)userinfoCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateUserAddressByCode(String userinfoCode, String tenantCode, List<AmAddress> amAddresses) {
        PostParamMap pmap = new PostParamMap("extam.amUser.updateUserAddressByCode");
        pmap.putParamToJson("amAddresses", amAddresses);
        pmap.putParam("userinfoCode", (Object)userinfoCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<AmAddress> queryUserAddressByCode(String userinfoCode, String tenantCode, String addressCode, String addressType) {
        PostParamMap pmap = new PostParamMap("extam.amUser.queryUserAddressByCode");
        pmap.putParam("userinfoCode", (Object)userinfoCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("addressCode", (Object)addressCode);
        pmap.putParam("addressType", (Object)addressType);
        return this.htmlIBaseService.getForList(pmap, AmAddress.class);
    }

    public HtmlJsonReBean updateAmUserAddressByCode(String userinfoCode, String tenantCode, List<AmAddress> amAddresses) {
        PostParamMap pmap = new PostParamMap("extam.amUser.updateAmUserAddressByCode");
        pmap.putParamToJson("amAddresses", amAddresses);
        pmap.putParam("userinfoCode", (Object)userinfoCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public UmUserinfoDomain getAmUserByCode(String userinfoCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("extam.amUser.getAmUserByCode");
        pmap.putParam("userinfoCode", (Object)userinfoCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return (UmUserinfoDomain)this.htmlIBaseService.senReObject(pmap, UmUserinfoDomain.class);
    }
}

