/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.service.crms;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.send.SupperFacade;
import cn.com.qj.bff.convert.ContractCopier;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.crms.CrmsSOrderDomain;
import cn.com.qj.bff.domain.crms.CrmsSOrderGoodsDomain;
import cn.com.qj.bff.domain.crms.CrmsSOrderReDomain;
import cn.com.qj.bff.domain.crms.CrmsURechargeDomain;
import cn.com.qj.bff.domain.crms.CrmsURechargeReDomain;
import cn.com.qj.bff.domain.crms.OrderStateEnums;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsGoodsDomain;
import cn.com.qj.bff.domain.oc.OrderContractGoodsBean;
import cn.com.qj.bff.domain.oc.PackageDomain;
import cn.com.qj.bff.domain.org.OrgUserBean;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoQuaReDomain;
import cn.com.qj.bff.service.crms.CrmsSOrderGoodsService;
import cn.com.qj.bff.service.crms.CrmsURechargeService;
import cn.com.qj.bff.service.oc.OcShoppingService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.um.UmUserinfoQuaService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CrmsSOrderService
extends SupperFacade {
    private static String CODE = "crms.CrmsSOrderService";
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private OcShoppingService ocShoppingService;
    @Autowired
    private CrmsURechargeService crmsURechargeService;
    @Autowired
    private UmUserinfoQuaService umUserinfoQuaService;
    @Autowired
    private CrmsSOrderGoodsService crmsSOrderGoodsService;
    @Autowired
    ContractCopier contractCopier;
    private Object UUIDLock = new Object();

    public HtmlJsonReBean saveSOrderBatch(List<CrmsSOrderDomain> crmsSOrderDomainList) {
        PostParamMap pmap = new PostParamMap("crms.sorder.saveSOrderBatch");
        pmap.putParamToJson("crmsSOrderDomainList", crmsSOrderDomainList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public CrmsSOrderReDomain getSOrder(Integer sorderId) {
        PostParamMap pmap = new PostParamMap("crms.sorder.getSOrder");
        pmap.putParam("sorderId", (Object)sorderId);
        return (CrmsSOrderReDomain)this.htmlIBaseService.senReObject(pmap, CrmsSOrderReDomain.class);
    }

    public HtmlJsonReBean updateSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        PostParamMap pmap = new PostParamMap("crms.sorder.updateSOrder");
        pmap.putParamToJson("crmsSOrderDomain", (Object)crmsSOrderDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSOrder(Integer sorderId) {
        PostParamMap pmap = new PostParamMap("crms.sorder.deleteSOrder");
        pmap.putParam("sorderId", (Object)sorderId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<CrmsSOrderReDomain> querySOrderPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("crms.sorder.querySOrderPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, CrmsSOrderReDomain.class);
    }

    public HtmlJsonReBean saveSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        PostParamMap pmap = new PostParamMap("crms.sorder.saveSOrder");
        pmap.putParamToJson("crmsSOrderDomain", (Object)crmsSOrderDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean createOrder(List<CrmsSOrderDomain> crmsSOrderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(crmsSOrderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<CrmsSOrderDomain> crmsSOrderDomains = new ArrayList<CrmsSOrderDomain>();
        ArrayList<Integer> shoppingGoodsIdList = new ArrayList<Integer>();
        for (CrmsSOrderDomain orderDomain : crmsSOrderDomainList) {
            CrmsSOrderDomain crmsSOrderDomain;
            try {
                crmsSOrderDomain = this.makeContractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == crmsSOrderDomain) {
                    this.logger.error(CODE + ".createOrder.contractDomain");
                    return new HtmlJsonReBean((Object)(CODE + ".saveContract.contractDomain"));
                }
                if (StringUtils.isNotBlank((String)contractProperty)) {
                    crmsSOrderDomain.setContractProperty(contractProperty);
                }
                if (StringUtils.isBlank((String)crmsSOrderDomain.getContractProperty())) {
                    crmsSOrderDomain.setContractProperty("0");
                }
                for (PackageDomain packageDomain : orderDomain.getPackageList()) {
                    List<CrmsSOrderGoodsDomain> crmsSOrderGoodsDomainList = this.makePackageDomain(packageDomain, crmsSOrderDomain);
                    if (ListUtil.isEmpty(crmsSOrderDomain.getCrmsSOrderGoodsDomainList())) {
                        crmsSOrderDomain.setCrmsSOrderGoodsDomainList(crmsSOrderGoodsDomainList);
                    } else {
                        crmsSOrderDomain.getCrmsSOrderGoodsDomainList().addAll(crmsSOrderGoodsDomainList);
                    }
                    if (null == shoppingGoodsIdList || null == packageDomain.getShoppingGoodsIdList()) continue;
                    shoppingGoodsIdList.addAll(packageDomain.getShoppingGoodsIdList());
                }
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createOrder.ex", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
            }
            HtmlJsonReBean htmlJsonReBean = this.calculateContract(crmsSOrderDomain);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                return htmlJsonReBean;
            }
            crmsSOrderDomains.add(crmsSOrderDomain);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        HashMap<String, String> result = new HashMap<String, String>();
        String orderCode = "";
        if (crmsSOrderDomains.size() > 1) {
            htmlJsonReBean = this.saveSOrderBatch(crmsSOrderDomains);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess() && null != htmlJsonReBean.getDataObj()) {
                orderCode = htmlJsonReBean.getDataObj().toString();
                result.put("contractBbillcode", orderCode);
            }
        } else {
            htmlJsonReBean = this.saveSOrder((CrmsSOrderDomain)crmsSOrderDomains.get(0));
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess() && null != htmlJsonReBean.getDataObj()) {
                orderCode = htmlJsonReBean.getDataObj().toString();
                result.put("contractBbillcode", orderCode);
            }
        }
        this.otherOperations(crmsSOrderDomains, shoppingGoodsIdList, orderCode);
        htmlJsonReBean.setDataObj(result);
        return htmlJsonReBean;
    }

    private void otherOperations(List<CrmsSOrderDomain> crmsSOrderDomains, List<Integer> shoppingGoodsIdList, String sOrderCode) {
        UmUserinfoQuaReDomain domain;
        CrmsURechargeReDomain crmsURechargeReDomain;
        if (shoppingGoodsIdList != null && shoppingGoodsIdList.size() > 0) {
            this.ocShoppingService.deleteShoppingGoodsBatch(shoppingGoodsIdList);
        }
        BigDecimal allMoney = BigDecimal.ZERO;
        for (CrmsSOrderDomain crmsSOrderDomain : crmsSOrderDomains) {
            allMoney = allMoney.add(crmsSOrderDomain.getContractMoney());
        }
        CrmsSOrderDomain crmsSOrderDomain = crmsSOrderDomains.get(0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crmsSOrderDomain.getTenantCode());
        map.put("userinfoCode", crmsSOrderDomain.getMemberBcode());
        map.put("userinfoQuaKey", "depName");
        List umUserinfoQuaReDomains = this.umUserinfoQuaService.queryUserinfoQuaPage(map).getList();
        if (umUserinfoQuaReDomains != null && umUserinfoQuaReDomains.size() > 0 && (crmsURechargeReDomain = this.crmsURechargeService.getURechargeByUserInfoCode((domain = (UmUserinfoQuaReDomain)umUserinfoQuaReDomains.get(0)).getUserinfoQuaVaule1())) != null) {
            CrmsURechargeDomain crmsURechargeDomain = new CrmsURechargeDomain();
            crmsURechargeDomain.setUrechargeId(crmsURechargeReDomain.getUrechargeId());
            crmsURechargeDomain.setRechargeAllmoney(allMoney.multiply(new BigDecimal(-1)));
            crmsURechargeDomain.setOrderCode(sOrderCode);
            this.crmsURechargeService.updateURecharge(crmsURechargeDomain);
        }
    }

    public HtmlJsonReBean calculateContract(CrmsSOrderDomain contractDomain) {
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        String memberCode = "";
        boolean teflag = false;
        for (PackageDomain ocPackageDomain : contractDomain.getPackageList()) {
            if (StringUtils.isBlank((String)memberCode)) {
                memberCode = ocPackageDomain.getMemberCode();
            } else if (!memberCode.equals(ocPackageDomain.getMemberCode())) {
                teflag = true;
            }
            contractDomain.setMemberCode(ocPackageDomain.getMemberCode());
            contractDomain.setMemberName(ocPackageDomain.getMemberName());
            if (null == ocPackageDomain.getGoodsNum()) {
                ocPackageDomain.setGoodsNum(BigDecimal.ZERO);
            }
            goodsNum = goodsNum.add(ocPackageDomain.getGoodsNum());
            if (null == ocPackageDomain.getGoodsWeight()) {
                ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            goodsWeight = goodsWeight.add(ocPackageDomain.getGoodsWeight());
            if (null == ocPackageDomain.getGoodsMoney()) {
                ocPackageDomain.setGoodsMoney(BigDecimal.ZERO);
            }
            contractInmoney = contractInmoney.add(ocPackageDomain.getGoodsMoney());
            if (null == ocPackageDomain.getPackageFare()) {
                ocPackageDomain.setPackageFare(BigDecimal.ZERO + "");
            }
            if (null == ocPackageDomain.getGoodsPmoney()) {
                ocPackageDomain.setGoodsPmoney(BigDecimal.ZERO);
            }
            contractMoney = contractMoney.add(ocPackageDomain.getGoodsPmoney());
            if (null == ocPackageDomain.getPricesetRefrice()) {
                ocPackageDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            pefMoney = pefMoney.add(ocPackageDomain.getPricesetRefrice());
        }
        if (ListUtil.isNotEmpty(contractDomain.getPackageList()) && contractDomain.getPackageList().size() == 1 && StringUtils.isBlank((String)contractDomain.getContractRemark())) {
            contractDomain.setContractRemark(contractDomain.getPackageList().get(0).getPackageRemark());
        }
        dataBnum = goodsNum;
        dataBweight = goodsWeight;
        if (null == contractDomain.getContractPaymoney()) {
            contractDomain.setContractPaymoney(BigDecimal.ZERO);
        }
        contractDomain.setPricesetRefrice(pefMoney);
        contractDomain.setGoodsNum(goodsNum);
        contractDomain.setGoodsWeight(goodsWeight);
        contractDomain.setContractInmoney(contractInmoney);
        contractDomain.setGoodsMoney(contractMoney);
        contractDomain.setContractMoney(contractMoney.add(contractDomain.getGoodsLogmoney()));
        contractDomain.setDataBnum(dataBnum);
        contractDomain.setDataBweight(dataBweight);
        if ("06".equals(contractDomain.getContractType()) || "28".equals(contractDomain.getContractType())) {
            contractDomain.setDataBmoney(contractMoney.add(contractDomain.getGoodsLogmoney()).add(contractDomain.getContractPaymoney()));
        } else {
            contractDomain.setDataBmoney(contractMoney.add(contractDomain.getGoodsLogmoney()).add(pefMoney).add(contractDomain.getContractPaymoney()));
        }
        contractDomain.setGoodsPmoney(contractInmoney.subtract(contractMoney));
        if (teflag) {
            if (StringUtils.isNotBlank((String)contractDomain.getChannelCode())) {
                DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(contractDomain.getChannelCode() + "-" + contractDomain.getTenantCode()), DisChannel.class);
                if (null != disChannel) {
                    contractDomain.setMemberCode(disChannel.getMemberCode());
                    contractDomain.setMemberName(disChannel.getMemberName());
                } else {
                    contractDomain.setMemberCode(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
                    contractDomain.setMemberName(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
                }
            } else {
                contractDomain.setMemberCode(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
                contractDomain.setMemberName(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
            }
        }
        return new HtmlJsonReBean();
    }

    private List<CrmsSOrderGoodsDomain> makePackageDomain(PackageDomain packageDomain, CrmsSOrderDomain ocContractDomain) throws Exception {
        if (null == packageDomain || null == ocContractDomain) {
            return null;
        }
        ArrayList<CrmsSOrderGoodsDomain> crmsSOrderGoodsDomainList = new ArrayList<CrmsSOrderGoodsDomain>();
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        for (OrderContractGoodsBean ocContractGoodsDomain : packageDomain.getContractGoodsList()) {
            ocContractGoodsDomain.setContractGoodsCode(this.createUUIDString());
            ocContractGoodsDomain.setGoodsOrdnum(ocContractGoodsDomain.getGoodsCamount());
            ocContractGoodsDomain.setGoodsOrdweight(ocContractGoodsDomain.getGoodsCweight());
            ocContractGoodsDomain.setGoodsNum(ocContractGoodsDomain.getGoodsCamount());
            ocContractGoodsDomain.setGoodsWeight(ocContractGoodsDomain.getGoodsCweight());
            if (null == ocContractGoodsDomain.getPricesetRefrice()) {
                ocContractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getGinfoCode()) && StringUtils.isNotBlank((String)ocContractGoodsDomain.getShoppingGoodsPm())) {
                ocContractGoodsDomain.setGinfoCode(ocContractGoodsDomain.getShoppingGoodsPm());
            }
            ocContractGoodsDomain.setContractGoodsPefprice(ocContractGoodsDomain.getPricesetRefrice());
            this.makeGoods(this.contractCopier.copyOrCoGoodsBeanToOcCoGoodsDomain(ocContractGoodsDomain));
            if (StringUtils.isBlank((String)ocContractDomain.getMemberCcode())) {
                ocContractDomain.setMemberCcode(ocContractGoodsDomain.getMemberCcode());
                ocContractDomain.setMemberCname(ocContractGoodsDomain.getMemberCname());
            }
            ocContractDomain.setChannelCode(ocContractGoodsDomain.getChannelCode());
            ocContractDomain.setChannelName(ocContractGoodsDomain.getChannelName());
            ocContractDomain.setMschannelCode(ocContractGoodsDomain.getMschannelCode());
            ocContractDomain.setMschannelName(ocContractGoodsDomain.getMschannelName());
            if (StringUtils.isEmpty((String)ocContractDomain.getMemberBname())) {
                ocContractDomain.setMemberBname(ocContractGoodsDomain.getMemberBname());
            }
            contractGoodsList.add(this.contractCopier.copyOrCoGoodsBeanToOcCoGoodsDomain(ocContractGoodsDomain));
        }
        if (ListUtil.isNotEmpty(contractGoodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                CrmsSOrderGoodsDomain crmsSOrderGoodsDomain = new CrmsSOrderGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)crmsSOrderGoodsDomain, (Object)ocContractGoodsDomain);
                    crmsSOrderGoodsDomain.setGoodsPro("2");
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".makePackageDomain.copyAllPropertys.e", (Throwable)e);
                }
                crmsSOrderGoodsDomainList.add(crmsSOrderGoodsDomain);
            }
        }
        return crmsSOrderGoodsDomainList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUUIDString() {
        Object object = this.UUIDLock;
        synchronized (object) {
            return UUID.randomUUID().toString().replace("-", "");
        }
    }

    private OcContractGoodsDomain makeGoodsAdd(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain || ListUtil.isEmpty(ocContractGoodsDomain.getOcContractGoodsGoodsList())) {
            return null;
        }
        for (OcContractGoodsGoodsDomain ocContractGoodsGoodsDomain : ocContractGoodsDomain.getOcContractGoodsGoodsList()) {
            OcContractGoodsDomain tcOcContractGoodsDomain = new OcContractGoodsDomain();
            RsSkuReDomain rsSkuReDomain = this.rsSkuService.getChannelSkuBySkuNo(ocContractGoodsGoodsDomain.getSkuNo(), ocContractGoodsDomain.getMemberCode(), ocContractGoodsDomain.getMemberCcode(), ocContractGoodsDomain.getChannelCode(), ocContractGoodsDomain.getTenantCode());
            if (null == rsSkuReDomain) {
                CODE = ".makeGoodsAdd.rsSkuReDomain.null";
                this.logger.info(".makeGoodsAdd.rsSkuReDomain.null", (Object)(ocContractGoodsGoodsDomain.getSkuNo() + ocContractGoodsGoodsDomain.getChannelCode()));
                continue;
            }
            RsResourceGoodsReDomain resourceGoodsByCodeStr = this.rsResourceGoodsService.getResourceGoodsByCodeStr(rsSkuReDomain.getGoodsCode(), rsSkuReDomain.getTenantCode());
            if (null == resourceGoodsByCodeStr) {
                CODE = ".makeGoodsAdd.resourceGoodsByCodeStr.null";
                this.logger.info(".makeGoodsAdd.resourceGoodsByCodeStr.null", (Object)(rsSkuReDomain.getGoodsCode() + rsSkuReDomain.getTenantCode()));
                continue;
            }
            try {
                BeanUtils.copyAllPropertys((Object)tcOcContractGoodsDomain, (Object)resourceGoodsByCodeStr);
                BeanUtils.copyAllPropertys((Object)tcOcContractGoodsDomain, (Object)rsSkuReDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".makeGoodsAdd.copyAllPropertys.e", (Throwable)e);
            }
            tcOcContractGoodsDomain.setMemberBcode(ocContractGoodsDomain.getMemberBcode());
            tcOcContractGoodsDomain.setMemberBname(ocContractGoodsDomain.getMemberBname());
            tcOcContractGoodsDomain.setContractGoodsType(3);
            tcOcContractGoodsDomain.setContractGoodsGtype("3");
            tcOcContractGoodsDomain.setContractGoodsOldcode(ocContractGoodsDomain.getContractGoodsCode());
            tcOcContractGoodsDomain.setGoodsMinnum(ocContractGoodsGoodsDomain.getGoodsMinnum());
            tcOcContractGoodsDomain.setGoodsHangnum(ocContractGoodsGoodsDomain.getGoodsHangnum());
            tcOcContractGoodsDomain.setGoodsAhnum(ocContractGoodsGoodsDomain.getGoodsAhnum());
            tcOcContractGoodsDomain.setGoodsNum(ocContractGoodsGoodsDomain.getGoodsNum());
            tcOcContractGoodsDomain.setPricesetNprice(ocContractGoodsGoodsDomain.getPricesetNprice());
            tcOcContractGoodsDomain.setPricesetMakeprice(ocContractGoodsGoodsDomain.getPricesetMakeprice());
            tcOcContractGoodsDomain.setGoodsOrdnum(ocContractGoodsGoodsDomain.getGoodsNum());
            tcOcContractGoodsDomain.setGoodsOrdweight(ocContractGoodsGoodsDomain.getGoodsWeight());
            tcOcContractGoodsDomain.setGoodsCamount(ocContractGoodsGoodsDomain.getGoodsNum());
            tcOcContractGoodsDomain.setGoodsCweight(ocContractGoodsGoodsDomain.getGoodsWeight());
            if (null == tcOcContractGoodsDomain.getPricesetRefrice()) {
                tcOcContractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((String)tcOcContractGoodsDomain.getGinfoCode()) && StringUtils.isNotBlank((String)tcOcContractGoodsDomain.getShoppingGoodsPm())) {
                tcOcContractGoodsDomain.setGinfoCode(tcOcContractGoodsDomain.getShoppingGoodsPm());
            }
            tcOcContractGoodsDomain.setContractGoodsPefprice(tcOcContractGoodsDomain.getPricesetRefrice());
            this.makeGoods(tcOcContractGoodsDomain);
            return tcOcContractGoodsDomain;
        }
        return null;
    }

    public CrmsSOrderDomain makeContractDomain(CrmsSOrderDomain crmsSOrderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == crmsSOrderDomain) {
            this.logger.error("OcService.saveContract", (Object)"UserSession is null");
            return null;
        }
        try {
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)crmsSOrderDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("OcService.makeContractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)crmsSOrderDomain.getContractType())) {
            if (StringUtils.isBlank((String)contractType)) {
                contractType = "00";
            }
            crmsSOrderDomain.setContractType(contractType);
        }
        if (StringUtils.isBlank((String)crmsSOrderDomain.getMemberBcode())) {
            crmsSOrderDomain.setMemberBcode(userSession.getUserPcode());
            crmsSOrderDomain.setMemberBname(userSession.getMerberCompname());
        }
        crmsSOrderDomain.setTenantCode(userSession.getTenantCode());
        crmsSOrderDomain.setAppmanageIcode(proappCode);
        crmsSOrderDomain.setContractUserurl(userSession.getUserImgurl());
        crmsSOrderDomain.setUserCode(userSession.getUserCode());
        crmsSOrderDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        crmsSOrderDomain.setContractDelcode(randomCode);
        return crmsSOrderDomain;
    }

    public void makeGoods(OcContractGoodsDomain contractGoodsDomain) {
        if (null == contractGoodsDomain) {
            return;
        }
        if (null == contractGoodsDomain.getGoodsNum()) {
            contractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == contractGoodsDomain.getPricesetNprice()) {
            contractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
        }
        BigDecimal inmoney = contractGoodsDomain.getPricesetNprice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsInmoney(inmoney);
        if (null == contractGoodsDomain.getPricesetRefrice()) {
            contractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        BigDecimal refmoney = contractGoodsDomain.getPricesetRefrice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsPefinmoney(refmoney);
        contractGoodsDomain.setContractGoodsPefmoney(refmoney);
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
        if (null != contractGoodsDomain.getGoodsNum() && BigDecimal.ZERO.compareTo(contractGoodsDomain.getGoodsNum()) != 0) {
            contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum(), 2, 4));
        }
        contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
        contractGoodsDomain.setContractGoodsAppraise(0);
        contractGoodsDomain.setRefundFlag(0);
    }

    public CrmsSOrderReDomain getSOrderByCode(String tenantCode, String sorderCode) {
        PostParamMap pmap = new PostParamMap("crms.sorder.getSOrderByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("sorderCode", (Object)sorderCode);
        return (CrmsSOrderReDomain)this.htmlIBaseService.senReObject(pmap, CrmsSOrderReDomain.class);
    }

    public HtmlJsonReBean updateSOrderState(Integer sorderId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("crms.sorder.updateSOrderState");
        pmap.putParam("sorderId", (Object)sorderId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSOrderState(Integer sorderId, Integer dataState, Integer oldDataState) {
        if (OrderStateEnums.AUDIT_FAILURE.getCode().equals(dataState) || OrderStateEnums.ORDER_CLOSED.getCode().equals(dataState)) {
            CrmsSOrderReDomain crmsSOrderReDomain = this.getSOrder(sorderId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", crmsSOrderReDomain.getTenantCode());
            map.put("userinfoCode", crmsSOrderReDomain.getMemberBcode());
            map.put("userinfoQuaKey", "depName");
            List umUserinfoQuaReDomains = this.umUserinfoQuaService.queryUserinfoQuaPage(map).getList();
            if (umUserinfoQuaReDomains != null && umUserinfoQuaReDomains.size() > 0) {
                UmUserinfoQuaReDomain domain = (UmUserinfoQuaReDomain)umUserinfoQuaReDomains.get(0);
                CrmsURechargeReDomain crmsURechargeReDomain = this.crmsURechargeService.getURechargeByUserInfoCode(domain.getUserinfoQuaVaule1());
                CrmsURechargeDomain crmsURechargeDomain = new CrmsURechargeDomain();
                crmsURechargeDomain.setUrechargeId(crmsURechargeReDomain.getUrechargeId());
                crmsURechargeDomain.setRechargeAllmoney(crmsSOrderReDomain.getContractMoney());
                crmsURechargeDomain.setOrderCode(crmsSOrderReDomain.getSorderCode());
                this.crmsURechargeService.updateURecharge(crmsURechargeDomain);
            }
        }
        return this.updateSOrderState(sorderId, dataState, oldDataState, null);
    }

    public HtmlJsonReBean updateSOrderStateByCode(String tenantCode, String sorderCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("crms.sorder.updateSOrderStateByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("sorderCode", (Object)sorderCode);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSOrderByCode(String tenantCode, String sorderCode) {
        PostParamMap pmap = new PostParamMap("crms.sorder.deleteSOrderByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("sorderCode", (Object)sorderCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean returnOrderGoods(String tenantCode, String orderGoodsDomainStr) {
        BigDecimal allMoney = BigDecimal.ZERO;
        List orderDomainList = JsonUtil.buildNormalBinder().getJsonToList(orderGoodsDomainStr, CrmsSOrderGoodsDomain.class);
        for (CrmsSOrderGoodsDomain crmsSOrderGoodsDomain : orderDomainList) {
            allMoney = allMoney.add(crmsSOrderGoodsDomain.getContractGoodsRefnum().multiply(crmsSOrderGoodsDomain.getContractGoodsInmoney()));
            this.crmsSOrderGoodsService.updateSOrderGoods(crmsSOrderGoodsDomain);
        }
        CrmsSOrderReDomain crmsSOrderReDomain = this.getSOrderByCode(tenantCode, ((CrmsSOrderGoodsDomain)orderDomainList.get(0)).getCorderCode());
        if (crmsSOrderReDomain != null) {
            UmUserinfoQuaReDomain domain;
            CrmsURechargeReDomain crmsURechargeReDomain;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("userinfoCode", crmsSOrderReDomain.getMemberBcode());
            map.put("userinfoQuaKey", "depName");
            List umUserinfoQuaReDomains = this.umUserinfoQuaService.queryUserinfoQuaPage(map).getList();
            if (umUserinfoQuaReDomains != null && umUserinfoQuaReDomains.size() > 0 && (crmsURechargeReDomain = this.crmsURechargeService.getURechargeByUserInfoCode((domain = (UmUserinfoQuaReDomain)umUserinfoQuaReDomains.get(0)).getUserinfoQuaVaule1())) != null) {
                CrmsURechargeDomain crmsURechargeDomain = new CrmsURechargeDomain();
                crmsURechargeDomain.setUrechargeId(crmsURechargeReDomain.getUrechargeId());
                crmsURechargeDomain.setRechargeAllmoney(allMoney);
                crmsURechargeDomain.setOrderCode(crmsSOrderReDomain.getSorderCode());
                this.crmsURechargeService.updateURecharge(crmsURechargeDomain);
            }
        }
        return new HtmlJsonReBean();
    }
}

