/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.express;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HtmlUtil;
import cn.com.qj.bff.domain.wl.WlExporgExpDomain;
import cn.com.qj.bff.domain.wl.WlExporgExpReDomain;
import cn.com.qj.bff.domain.wl.WlExpressDomain;
import cn.com.qj.bff.domain.wl.WlExpressReDomain;
import cn.com.qj.bff.service.wl.WlExporgService;
import cn.com.qj.bff.service.wl.WlExpressService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wl/express"}, name="\u7269\u6d41\u670d\u52a1")
public class ExpressCon
extends SpringmvcController {
    private static String CODE = "wl.express.con";
    @Autowired
    private WlExpressService wlExpressService;
    @Autowired
    private WlExporgService wlExporgService;

    @Override
    protected String getContext() {
        return "express";
    }

    @RequestMapping(value={"queryExpressAndOrgPage.json"}, name="\u5546\u5bb6\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u548c\u6620\u5c04")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressAndOrgPage(HttpServletRequest request) {
        SupQueryResult<WlExpressReDomain> wlExpressPage;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("orderStr", "DATA_STATE DESC");
            param.put("order", true);
            param.put("fuzzy", true);
            if (null != param.get("notfuzzyFlag")) {
                param.put("fuzzy", false);
            }
        }
        if (null != (wlExpressPage = this.wlExpressService.queryExpressPage(param)) && ListUtil.isNotEmpty((Collection)wlExpressPage.getList())) {
            for (WlExpressReDomain wlExpressReDomain : wlExpressPage.getList()) {
                WlExporgExpReDomain exporgExpByCode = this.wlExporgService.getExporgExpByCode(wlExpressReDomain.getTenantCode(), wlExpressReDomain.getExpressCode());
                if (null == exporgExpByCode) continue;
                wlExpressReDomain.setExporgExpMpcode(exporgExpByCode.getExporgExpMpcode());
                wlExpressReDomain.setExporgExpRemark(exporgExpByCode.getExporgExpRemark());
            }
        }
        return wlExpressPage;
    }

    @RequestMapping(value={"saveExpressAndOrg.json"}, name="\u589e\u52a0\u7269\u6d41\u516c\u53f8\u6620\u5c04")
    @ResponseBody
    public HtmlJsonReBean saveExpressAndOrg(HttpServletRequest request, WlExpressDomain wlExpressDomain) {
        if (null == wlExpressDomain || StringUtils.isBlank((String)wlExpressDomain.getExpressCode()) || StringUtils.isBlank((String)wlExpressDomain.getExpressName())) {
            this.logger.error(CODE + ".saveExpressAndOrg", (Object)JsonUtil.buildNormalBinder().toJson((Object)wlExpressDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        String tenantCode = this.getTenantCode(request);
        WlExpressReDomain expressByCode = this.wlExpressService.getExpressByCode(this.getQueryMapParam("expressCode,tenantCode", wlExpressDomain.getExpressCode(), tenantCode));
        if (null != expressByCode) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5feb\u9012\u516c\u53f8\u5df2\u5b58\u5728");
        }
        WlExporgExpReDomain exporgExpByCode = this.wlExporgService.getExporgExpByCode(tenantCode, wlExpressDomain.getExpressCode());
        if (null != exporgExpByCode) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7269\u6d41\u6620\u5c04\u5df2\u5b58\u5728");
        }
        wlExpressDomain.setTenantCode(tenantCode);
        wlExpressDomain.setExpressapiCode("kuaidi100fufei");
        HtmlJsonReBean htmlJsonReBean = this.wlExpressService.saveExpress(wlExpressDomain);
        if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
            WlExporgExpDomain wlExporgExpDomain = new WlExporgExpDomain();
            wlExporgExpDomain.setTenantCode(tenantCode);
            wlExporgExpDomain.setExporgCode("kuaidi100fufei");
            wlExporgExpDomain.setExporgExpCode(wlExpressDomain.getExpressCode());
            wlExporgExpDomain.setExpressCode(wlExpressDomain.getExpressCode());
            wlExporgExpDomain.setExporgExpMpcode(wlExpressDomain.getExporgExpMpcode());
            wlExporgExpDomain.setExporgExpRemark(wlExpressDomain.getExporgExpRemark());
            return this.wlExporgService.saveExporgExp(wlExporgExpDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateExpressAndOrg.json"}, name="\u7f16\u8f91\u7269\u6d41\u516c\u53f8\u548c\u6620\u5c04")
    @ResponseBody
    public HtmlJsonReBean updateExpressAndOrg(HttpServletRequest request, WlExpressDomain wlExpressDomain) {
        if (null == wlExpressDomain || null == wlExpressDomain.getExpressId()) {
            this.logger.error(CODE + ".updateExpressAndOrg", (Object)JsonUtil.buildNormalBinder().toJson((Object)wlExpressDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        String tenantCode = this.getTenantCode(request);
        WlExpressReDomain express = this.wlExpressService.getExpress(wlExpressDomain.getExpressId());
        if (null == express) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u5feb\u9012\u516c\u53f8");
        }
        WlExpressReDomain expressByCode = this.wlExpressService.getExpressByCode(this.getQueryMapParam("expressCode,tenantCode", wlExpressDomain.getExpressCode(), tenantCode));
        if (null != expressByCode && !Objects.equals(expressByCode.getExpressId(), express.getExpressId())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5feb\u9012\u516c\u53f8\u5df2\u5b58\u5728");
        }
        WlExporgExpReDomain exporgExpByCode = this.wlExporgService.getExporgExpByCode(tenantCode, express.getExpressCode());
        if (null == exporgExpByCode) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u7269\u6d41\u6620\u5c04");
        }
        WlExporgExpReDomain exporgExpByCodeNew = this.wlExporgService.getExporgExpByCode(tenantCode, wlExpressDomain.getExpressCode());
        if (null != exporgExpByCodeNew && !Objects.equals(exporgExpByCodeNew.getExporgExpId(), exporgExpByCode.getExporgExpId())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7269\u6d41\u6620\u5c04\u5df2\u5b58\u5728");
        }
        express.setExpressCode(wlExpressDomain.getExpressCode());
        express.setExpressName(wlExpressDomain.getExpressName());
        HtmlJsonReBean htmlJsonReBean = this.wlExpressService.updateExpressOld(express);
        if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
            exporgExpByCode.setExporgExpCode(wlExpressDomain.getExpressCode());
            exporgExpByCode.setExpressCode(wlExpressDomain.getExpressCode());
            if (StringUtils.isNotBlank((String)wlExpressDomain.getExporgExpMpcode())) {
                exporgExpByCode.setExporgExpMpcode(wlExpressDomain.getExporgExpMpcode());
            }
            if (StringUtils.isNotBlank((String)wlExpressDomain.getExporgExpRemark())) {
                exporgExpByCode.setExporgExpRemark(wlExpressDomain.getExporgExpRemark());
            }
            return this.wlExporgService.updateExporgExp(exporgExpByCode);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveExpress.json"}, name="\u589e\u52a0\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExpress(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateSendgoodsByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WlExpressDomain wlExpressDomain = (WlExpressDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, WlExpressDomain.class);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        wlExpressDomain.setTenantCode(this.getTenantCode(request));
        wlExpressDomain.setMemberCode(userSession.getUserPcode());
        wlExpressDomain.setMemberName(userSession.getUserName());
        return this.wlExpressService.saveExpress(wlExpressDomain);
    }

    @RequestMapping(value={"getExpress.json"}, name="\u83b7\u53d6\u7269\u6d41\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public WlExpressReDomain getExpress(String expressId) {
        if (StringUtils.isBlank((String)expressId)) {
            this.logger.error(CODE + ".getExpress", (Object)"param is null");
            return null;
        }
        return this.wlExpressService.getExpress(Integer.valueOf(expressId));
    }

    @RequestMapping(value={"updateExpress.json"}, name="\u66f4\u65b0\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateExpress(HttpServletRequest request, WlExpressDomain wlExpressDomain) {
        if (null == wlExpressDomain) {
            this.logger.error(CODE + ".updateExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExpressDomain.setTenantCode(this.getTenantCode(request));
        return this.wlExpressService.updateExpress(wlExpressDomain);
    }

    @RequestMapping(value={"deleteExpress.json"}, name="\u5220\u9664\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteExpress(HttpServletRequest request, String expressId) {
        if (StringUtils.isBlank((String)expressId)) {
            this.logger.error(CODE + ".deleteExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExpressService.deleteExpress(Integer.valueOf(expressId));
    }

    @RequestMapping(value={"queryExpressPage.json"}, name="\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExpressService.queryExpressPage(param);
    }

    @RequestMapping(value={"updateExpressState.json"}, name="\u66f4\u65b0\u7269\u6d41\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateExpressState(String expressId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)expressId)) {
            this.logger.error(CODE + ".updateExpressState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.wlExpressService.updateExpressState(Integer.valueOf(expressId), dataState, oldDataState);
        if (htmlJsonReBean != null && htmlJsonReBean.isSuccess()) {
            this.wlExpressService.loadExpressCache();
            this.wlExporgService.loadExporg();
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"deleteExpressBatch.json"}, name="\u6279\u91cf\u5220\u9664\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteExpressBatch(String expressIds) {
        String[] ids;
        if (StringUtils.isBlank((String)expressIds)) {
            this.logger.error(CODE + ".deleteExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String id : ids = expressIds.split(",")) {
            if (id == null) continue;
            this.wlExpressService.deleteExpress(Integer.valueOf(id));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryExpressPageForProp.json"}, name="\u5546\u5bb6\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPageForProp(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("orderStr", "DATA_STATE DESC");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExpressService.queryExpressPage(param);
    }

    @RequestMapping(value={"queryExpressPageForFreight.json"}, name="\u5546\u5bb6\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868-\u8fd0\u8d39\u6a21\u677f")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPageForFreight(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("orderStr", "DATA_STATE DESC");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExpressService.queryExpressPage(param);
    }

    @RequestMapping(value={"queryExpressPageForC.json"}, name="\u5546\u5bb6\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868-C\u7aef")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPageForC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("orderStr", "DATA_STATE DESC");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExpressService.queryExpressPage(param);
    }

    @RequestMapping(value={"loadExpressCache.json"}, name="\u5237\u65b0\u5feb\u9012\u516c\u53f8\u7f13\u5b58")
    @ResponseBody
    public HtmlJsonReBean loadExpressCache(HttpServletRequest request) {
        return this.wlExpressService.loadExpressCache();
    }
}

