/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.res;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.res.ResTemplateDomain;
import cn.com.qj.bff.domain.res.ResTemplateReDomain;
import cn.com.qj.bff.domain.res.ResTemplateValuesDomain;
import cn.com.qj.bff.domain.res.ResTemplateValuesReDomain;
import cn.com.qj.bff.service.res.ResTemplateService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/res/template"}, name="\u8bc4\u4ef7\u6a21\u677f")
public class TemplateCon
extends SpringmvcController {
    private static String CODE = "res.template.con";
    @Autowired
    private ResTemplateService resTemplateService;

    @Override
    protected String getContext() {
        return "template";
    }

    @RequestMapping(value={"saveTemplate.json"}, name="\u589e\u52a0\u8bc4\u4ef7\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveTemplate(HttpServletRequest request, ResTemplateDomain resTemplateDomain) {
        if (null == resTemplateDomain) {
            this.logger.error(CODE + ".saveTemplate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resTemplateDomain.setTenantCode(this.getTenantCode(request));
        return this.resTemplateService.saveTemplate(resTemplateDomain);
    }

    @RequestMapping(value={"saveTemplateValues.json"}, name="\u589e\u52a0\u8bc4\u4ef7\u5206\u503c")
    @ResponseBody
    public HtmlJsonReBean saveTemplateValues(HttpServletRequest request, ResTemplateValuesDomain resTemplateValuesDomain) {
        if (null == resTemplateValuesDomain) {
            this.logger.error(CODE + ".saveTemplateValues", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resTemplateValuesDomain.setTenantCode(this.getTenantCode(request));
        return this.resTemplateService.saveTemplateValues(resTemplateValuesDomain);
    }

    @RequestMapping(value={"getTemplate.json"}, name="\u83b7\u53d6\u8bc4\u4ef7\u914d\u7f6e\u4fe1\u606f")
    @ResponseBody
    public ResTemplateReDomain getTemplate(String templateId) {
        if (StringUtils.isBlank((String)templateId)) {
            this.logger.error(CODE + ".getTemplate", (Object)"param is null");
            return null;
        }
        return this.resTemplateService.getTemplate(Integer.valueOf(templateId));
    }

    @RequestMapping(value={"getTemplateValues.json"}, name="\u83b7\u53d6\u8bc4\u4ef7\u5206\u503c\u4fe1\u606f")
    @ResponseBody
    public ResTemplateValuesDomain getTemplateValues(String templateValuesId) {
        if (StringUtils.isBlank((String)templateValuesId)) {
            this.logger.error(CODE + ".getTemplateValuesId", (Object)"param is null");
            return null;
        }
        return this.resTemplateService.getTemplateValues(Integer.valueOf(templateValuesId));
    }

    @RequestMapping(value={"updateTemplate.json"}, name="\u66f4\u65b0\u8bc4\u4ef7\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateTemplate(HttpServletRequest request, ResTemplateDomain resTemplateDomain) {
        if (null == resTemplateDomain) {
            this.logger.error(CODE + ".updateTemplate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resTemplateDomain.setTenantCode(this.getTenantCode(request));
        return this.resTemplateService.updateTemplate(resTemplateDomain);
    }

    @RequestMapping(value={"updateTemplateValues.json"}, name="\u66f4\u65b0\u8bc4\u4ef7\u5206\u503c")
    @ResponseBody
    public HtmlJsonReBean updateTemplateValues(HttpServletRequest request, ResTemplateValuesDomain resTemplateValuesDomain) {
        if (null == resTemplateValuesDomain) {
            this.logger.error(CODE + ".updateTemplateValues", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resTemplateValuesDomain.setTenantCode(this.getTenantCode(request));
        return this.resTemplateService.updateTemplateValues(resTemplateValuesDomain);
    }

    @RequestMapping(value={"deleteTemplate.json"}, name="\u5220\u9664\u8bc4\u4ef7\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteTemplate(String templateId) {
        if (StringUtils.isBlank((String)templateId)) {
            this.logger.error(CODE + ".deleteTemplate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resTemplateService.deleteTemplate(Integer.valueOf(templateId));
    }

    @RequestMapping(value={"deleteTemplateValues.json"}, name="\u5220\u9664\u8bc4\u4ef7\u5206\u503c")
    @ResponseBody
    public HtmlJsonReBean deleteTemplateValues(String templateValuesId) {
        if (StringUtils.isBlank((String)templateValuesId)) {
            this.logger.error(CODE + ".deleteTemplateValues", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resTemplateService.deleteTemplateValues(Integer.valueOf(templateValuesId));
    }

    @RequestMapping(value={"queryTemplatePage.json"}, name="\u67e5\u8be2\u8bc4\u4ef7\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ResTemplateReDomain> queryTemplatePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.resTemplateService.queryTemplatePage(param);
    }

    @RequestMapping(value={"updateTemplateState.json"}, name="\u66f4\u65b0\u8bc4\u4ef7\u914d\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTemplateState(String templateId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)templateId)) {
            this.logger.error(CODE + ".updateTemplateState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resTemplateService.updateTemplateState(Integer.valueOf(templateId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveBatchTemplateValues.json"}, name="\u66f4\u65b0\u8bc4\u4ef7\u914d\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean saveBatchTemplateValues(HttpServletRequest request, String templateCode, List<ResTemplateValuesDomain> resTemplateValuesDomainList) {
        if (StringUtils.isBlank((String)templateCode) || ListUtil.isEmpty(resTemplateValuesDomainList)) {
            this.logger.error(CODE + ".saveBatchTemplateValues", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resTemplateService.saveBatchTemplateValues(resTemplateValuesDomainList, templateCode, null, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryUseTemplate.json"}, name="\u67e5\u8be2\u8bc4\u4ef7\u914d\u7f6e\u72b6\u6001")
    @ResponseBody
    public List<ResTemplateReDomain> queryUseTemplate(HttpServletRequest request, String applyTarget) {
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)applyTarget) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryUseTemplate", (Object)"param is null");
            return null;
        }
        return this.fetchInfo(tenantCode, applyTarget);
    }

    @RequestMapping(value={"queryUseTemplateForGoods.json"}, name="\u67e5\u8be2\u8bc4\u4ef7\u914d\u7f6e\u72b6\u6001 - \u5546\u54c1\u8bc4\u8bba\u5217\u8868")
    @ResponseBody
    public List<ResTemplateReDomain> queryUseTemplateForGoods(HttpServletRequest request, String applyTarget) {
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)applyTarget) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryUseTemplateForGoods", (Object)"param is null");
            return null;
        }
        return this.fetchInfo(tenantCode, applyTarget);
    }

    private List<ResTemplateReDomain> fetchInfo(String tenantCode, String applyTarget) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("templateApplyTarget", applyTarget);
        List<ResTemplateReDomain> tmplist = this.resTemplateService.queryUseTemplate(map);
        if (ListUtil.isEmpty(tmplist)) {
            map.put("tenantCode", "00000000");
            return this.resTemplateService.queryUseTemplate(map);
        }
        return tmplist;
    }

    @RequestMapping(value={"queryTemplateValuesPage.json"}, name="\u67e5\u8be2\u8bc4\u4ef7\u914d\u7f6eValues\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ResTemplateValuesReDomain> queryTemplateValuesPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.resTemplateService.queryTemplateValuesPage(param);
    }

    @RequestMapping(value={"queryTemplateValuesPageForSc.json"}, name="\u67e5\u8be2\u8bc4\u4ef7\u914d\u7f6eValues\u5206\u9875\u5217\u8868\u661f\u4e91")
    @ResponseBody
    public SupQueryResult<ResTemplateValuesReDomain> queryTemplateValuesPageForSc(HttpServletRequest request, String templateCode) {
        Map<String, Object> param = this.assemMapParam(request);
        String tenantCode = this.getTenantCode(request);
        if (null != param) {
            param.put("order", true);
            param.put("templateCode", templateCode);
            param.put("tenantCode", tenantCode);
        }
        return this.resTemplateService.queryTemplateValuesPage(param);
    }
}

