/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.cms;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.cms.CmsNoticeDomain;
import cn.com.qj.bff.domain.cms.CmsNoticeReDomain;
import cn.com.qj.bff.domain.cms.CmsTginfoReDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.service.cms.CmsNoticeService;
import cn.com.qj.bff.service.cms.CmsTginfoService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cms/noticeBusiness"}, name="\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
public class NoticeBusCon
extends SpringmvcController {
    private static String CODE = "cms.notice.con";
    @Autowired
    private CmsNoticeService cmsNoticeService;
    @Autowired
    private CmsTginfoService cmsTginfoService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;

    @Override
    protected String getContext() {
        return "notice";
    }

    @RequestMapping(value={"saveNotice.json"}, name="\u589e\u52a0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveNotice(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".saveNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeService.saveNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"getNotice.json"}, name="\u83b7\u53d6\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u4fe1\u606f")
    @ResponseBody
    public CmsNoticeReDomain getNotice(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".getNotice", (Object)"param is null");
            return null;
        }
        return this.cmsNoticeService.getNotice(noticeId);
    }

    @RequestMapping(value={"updateNotice.json"}, name="\u66f4\u65b0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateNotice(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".updateNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeService.updateNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"deleteNotice.json"}, name="\u5220\u9664\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteNotice(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".deleteNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeService.deleteNotice(noticeId);
    }

    @RequestMapping(value={"queryNoticePage.json"}, name="\u67e5\u8be2\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeReDomain> queryNoticePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cmsNoticeService.queryNoticePage(param);
    }

    @RequestMapping(value={"updateNoticeState.json"}, name="\u66f4\u65b0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateNoticeState(String noticeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)noticeId)) {
            this.logger.error(CODE + ".updateNoticeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeService.updateNoticeState(Integer.valueOf(noticeId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryNoticePageList.json"}, name="C\u7aef\u67e5\u8be2\u516c\u544a")
    @ResponseBody
    public List<CmsNoticeDomain> queryNoticePageList(HttpServletRequest request, String noticeType, String goodsCode) throws Exception {
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)goodsCode)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("goodsCode", goodsCode);
            paramMap.put("tenantCode", tenantCode);
            RsResourceGoodsReDomain resourceGoodsByCode = this.rsResourceGoodsService.getResourceGoodsByCode(paramMap);
            if (null == resourceGoodsByCode) {
                throw new Exception("\u5546\u54c1\u53c2\u6570\u5f02\u5e38");
            }
            map.put("goodsNo", resourceGoodsByCode.getGoodsNo());
            map.put("classtreeCode", resourceGoodsByCode.getClasstreeCode());
        }
        String tginfoCode = null;
        if ("wechatmini".equals(this.getOauthEnvCode(request))) {
            String companyCode = "";
            if (null != userSession) {
                String userinfoQuality = userSession.getUserinfoQuality();
                if ("buy".equals(userinfoQuality)) {
                    companyCode = userSession.getUserinfoParentCode();
                }
                if ("company".equals(userinfoQuality)) {
                    companyCode = userSession.getUserPcode();
                }
                HashMap<String, Object> param = new HashMap<String, Object>();
                if (StringUtils.isBlank((String)companyCode)) {
                    companyCode = this.getTeananMemberCode(request);
                }
                param.put("memberCode", companyCode);
                param.put("tenantCode", tenantCode);
                param.put("proappCode", this.getProappCode(request));
                SupQueryResult<CmsTginfoReDomain> cmsTginfoReDomainSupQueryResult = this.cmsTginfoService.queryTginfoPage(param);
                if (ListUtil.isNotEmpty((Collection)cmsTginfoReDomainSupQueryResult.getList())) {
                    tginfoCode = ((CmsTginfoReDomain)cmsTginfoReDomainSupQueryResult.getList().get(0)).getTginfoCode();
                }
            }
        } else {
            tginfoCode = this.getTginfoCode(request);
        }
        if (StringUtils.isBlank((String)tginfoCode)) {
            this.logger.error(CODE + "tginfoMenuCode! wechatmini is null");
            throw new Exception("\u7ad9\u70b9\u53c2\u6570\u4e3a\u7a7a");
        }
        map.put("tginfoCode", tginfoCode);
        this.logger.error(CODE + "queryNoticePageList map", map);
        return this.cmsNoticeService.queryNoticePageList(map, tenantCode, "0");
    }
}

