/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.dis;

import cn.com.qj.bff.controller.dis.DisInit;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/initBe"}, name="\u997f\u767e\u6e20\u9053\u521d\u59cb\u5316")
public class DisInitBe
extends DisInit {
    protected static String CODE = "dis.initBe.con";
    private String channelCode = "be";

    @Override
    protected String getContext() {
        return "initBe";
    }

    @RequestMapping(value={"checkClass.json"}, name="\u95e8\u5e97\u5206\u7c7b\u68c0\u67e5")
    @ResponseBody
    public HtmlJsonReBean checkClass(HttpServletRequest request, String memberCcode, String memberCode) {
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveDictionaryClass.json"}, name="\u95e8\u5e97\u5206\u7c7b\u521d\u59cb\u5316")
    @ResponseBody
    public HtmlJsonReBean saveDictionaryClass(HttpServletRequest request, String memberCcode, String memberCode) {
        return this.saveDictionaryClassCom(request, this.channelCode, memberCcode, memberCode);
    }

    @RequestMapping(value={"checkGoods.json"}, name="\u95e8\u5e97\u5546\u54c1\u68c0\u6d4b")
    @ResponseBody
    public List<String> checkGoods(HttpServletRequest request, String memberCcode, String memberCode) {
        return this.checkGoodsCom(request, this.channelCode, memberCcode, memberCode);
    }

    @RequestMapping(value={"updateGoods.json"}, name="\u95e8\u5e97\u5546\u54c1\u521d\u59cb\u5316")
    @ResponseBody
    public HtmlJsonReBean updateGoods(HttpServletRequest request, String memberCcode, String memberCode) {
        return this.updateGoodsCom(request, this.channelCode, memberCcode, memberCode);
    }

    @RequestMapping(value={"saveOrder.json"}, name="\u62c9\u53d6\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveOrder(HttpServletRequest request, String contractNbillcode, String memberCode) {
        if (StringUtils.isBlank((String)contractNbillcode)) {
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Map<String, Object> params = this.creatParams(contractNbillcode);
        return this.saveSendOrderState(params, this.channelCode, memberCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"saveOrderForPlat.json"}, name="\u8fd0\u8425\u7aef\u62c9\u53d6\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveOrderForPlat(HttpServletRequest request, String contractNbillcode, String memberCode) {
        if (StringUtils.isBlank((String)contractNbillcode)) {
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Map<String, Object> params = this.creatParams(contractNbillcode);
        params.put("channelCode", this.channelCode);
        params.put("memberCode", memberCode);
        params.put("tenantCode", this.getTenantCode(request));
        return this.saveSendOrderState(params, this.channelCode, memberCode, this.getTenantCode(request));
    }

    private Map<String, Object> creatParams(String contractNbillcode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("order_id", contractNbillcode);
        params.put("body", JsonUtil.buildNormalBinder().toJson(body));
        params.put("version", "3");
        params.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        params.remove("secret");
        params.put("cmd", "order.create");
        params.put("encrypt", "");
        params.put("ticket", UUID.randomUUID());
        params.put("secret", "b9b0d0a16d5a723e");
        params.put("source", "37333");
        return params;
    }

    @Override
    protected HtmlJsonReBean updateGoods(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return new HtmlJsonReBean((Object)"error");
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)map.get("rsResourceGoodsReDomain");
        if (null == rsResourceGoodsReDomain) {
            new HtmlJsonReBean((Object)"error");
        }
        this.rsResourceGoodsService.updateGoodsEocode(rsResourceGoodsReDomain.getGoodsCode(), rsResourceGoodsReDomain.getGoodsNo(), tenantCode);
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
            for (RsSkuDomain rsSkuDomain : rsResourceGoodsReDomain.getRsSkuDomainList()) {
                this.rsResourceGoodsService.updateSkuEocode(rsSkuDomain.getSkuCode(), rsSkuDomain.getSkuNo(), tenantCode);
            }
        }
        return new HtmlJsonReBean();
    }

    @Override
    protected void checkComSku(Map<String, RsSkuReDomain> skumap, List<Map<String, Object>> relist, List<String> noList, Map<String, String> skunoMap) {
        if (null == skumap || ListUtil.isEmpty(relist) || null == noList || null == skunoMap) {
            return;
        }
        BigDecimal nprice = BigDecimal.ZERO;
        Object sale_price = null;
        ArrayList<String> classname = null;
        for (Map<String, Object> mapParam : relist) {
            String upc_type;
            String sku_id = (String)mapParam.get("custom_sku_id");
            RsSkuReDomain rsSkuReDomain = skumap.remove(sku_id);
            sale_price = mapParam.get("sale_price");
            List classList = (List)mapParam.get("custom_cat_list");
            if (!ListUtil.isEmpty((Collection)classList)) {
                classname = new ArrayList<String>();
                for (Map map : classList) {
                    classname.add((String)map.get("custom_cat_name"));
                }
            }
            String string = upc_type = null == mapParam.get("upc_type") ? null : String.valueOf(mapParam.get("upc_type"));
            if (StringUtils.isBlank((String)upc_type)) {
                upc_type = "";
            }
            String name = (String)mapParam.get("name");
            if (null != sale_price) {
                nprice = new BigDecimal(sale_price.toString()).divide(new BigDecimal("100"));
            }
            if (null != rsSkuReDomain) {
                if (null == rsSkuReDomain.getPricesetNprice()) {
                    rsSkuReDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                if (StringUtils.isBlank((String)rsSkuReDomain.getClasstreeShopcode()) || StringUtils.isBlank((String)rsSkuReDomain.getGoodsShowname())) {
                    noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u5206\u7c7b\u6216\u663e\u793a\u540d\u79f0\u672a\u8bbe\u7f6e");
                }
                if (StringUtils.isBlank((String)rsSkuReDomain.getGoodsShowname()) || !rsSkuReDomain.getGoodsShowname().equals(name)) {
                    noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u540d\u79f0\u4e0d\u4e00\u81f4(\u4e2d\u53f0\uff1a" + rsSkuReDomain.getGoodsShowname() + "\uff0c\u4e09\u65b9\u5e73\u53f0" + name + ")");
                }
                if (StringUtils.isBlank((String)rsSkuReDomain.getClasstreeShopname()) || null == classname || !classname.contains(rsSkuReDomain.getClasstreeShopname())) {
                    noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u5206\u7c7b\u540d\u79f0\u4e0d\u4e00\u81f4(\u4e2d\u53f0\uff1a" + rsSkuReDomain.getClasstreeShopname() + "\uff0c\u4e09\u65b9\u5e73\u53f0\uff1a" + (null != classname ? ((Object)classname).toString() : "") + ")");
                }
                if (nprice.compareTo(rsSkuReDomain.getPricesetNprice()) != 0) {
                    noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u4ef7\u683c\u4e0d\u4e00\u81f4\u3010\u5e73\u53f0(" + nprice + ")\u3011\u4e2d\u53f0(" + rsSkuReDomain.getPricesetNprice() + ")\u3011");
                }
                if (!upc_type.equals(rsSkuReDomain.getGoodsSp())) {
                    noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u6807\u54c1\u4e0d\u4e00\u81f4\u3010\u5e73\u53f0(" + upc_type + ")\u3011\u4e2d\u53f0(" + rsSkuReDomain.getGoodsSp() + ")\u3011");
                }
            } else if (StringUtils.isNotBlank((String)skunoMap.get(sku_id))) {
                noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u5728\u4e09\u65b9\u5e73\u53f0\u91cd\u590d");
            } else {
                noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u5728\u95e8\u5e97\u6e20\u9053\u4e0d\u5b58\u5728");
            }
            skunoMap.put(sku_id, sku_id);
        }
    }
}

